/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.SpriteContentsExtension;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7766;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_7766.class}, priority=900)
public class SpriteLoaderMixin {
    @Final
    @Shadow
    private class_2960 field_40549;

    @Inject(method={"loadAndStitch(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/ResourceLocation;ILjava/util/concurrent/Executor;Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    private void initializeTextures(class_3300 resourceManager, class_2960 atlas, int i, Executor executor, Collection<?> metadataSections, CallbackInfoReturnable<CompletableFuture<class_7766.class_7767>> ci) {
        ((CompletableFuture)ci.getReturnValue()).thenApply(preparations -> {
            Map textures = preparations.comp_1044();
            for (Map.Entry entry : textures.entrySet()) {
                class_1058 newTexture;
                class_2960 identifier = (class_2960)entry.getKey();
                class_1058 texture = (class_1058)entry.getValue();
                Pair<TextureType<Object>, Object> textureData = ((SpriteContentsExtension)texture.method_45851()).fusionTextureMetadata();
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl((class_7766.class_7767)preparations, this.field_40549, texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    FusionClient.LOGGER.error("Encountered an exception whilst initialising texture '{}' for texture type '{}'!", new Object[]{identifier, TextureTypeRegistryImpl.getIdentifier(textureData.left()), e});
                    continue;
                }
                if (newTexture == null) {
                    FusionClient.LOGGER.error("Received null texture from texture type '{}' for texture '{}'!", (Object)TextureTypeRegistryImpl.getIdentifier(textureData.left()), (Object)identifier);
                    continue;
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.put(identifier, newTexture);
                ((SpriteContentsExtension)texture.method_45851()).clearFusionTextureMetadata();
            }
            return preparations;
        });
    }
}

