/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.deathbackup_common_forge.util;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerLevel;

public class Util {
    public static void writeGearStringToFile(ServerLevel serverworld, String playername, String filename, String gearstring) {
        String deathbackuppath = WorldFunctions.getWorldPath((ServerLevel)serverworld) + File.separator + "data" + File.separator + "deathbackup" + File.separator + playername;
        File dir = new File(deathbackuppath);
        dir.mkdirs();
        try {
            PrintWriter writer = new PrintWriter(deathbackuppath + File.separator + filename + ".txt", StandardCharsets.UTF_8);
            writer.println(gearstring);
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getGearStringFromFile(ServerLevel serverworld, String playername, String filename) {
        String deathbackuppath = WorldFunctions.getWorldPath((ServerLevel)serverworld) + File.separator + "data" + File.separator + "deathbackup" + File.separator + playername;
        File dir = new File(deathbackuppath);
        File file = new File(deathbackuppath + File.separator + filename + ".txt");
        String gearstring = "";
        if (dir.isDirectory() && file.isFile()) {
            try {
                gearstring = new String(Files.readAllBytes(Paths.get(deathbackuppath + File.separator + filename + ".txt", new String[0])));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return gearstring;
    }

    public static List<String> getListOfBackups(ServerLevel serverworld, String playername) {
        ArrayList<String> backups = new ArrayList<String>();
        String deathbackuppath = WorldFunctions.getWorldPath((ServerLevel)serverworld) + File.separator + "data" + File.separator + "deathbackup" + File.separator + playername;
        File folder = new File(deathbackuppath);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return backups;
        }
        for (File listOfFile : listOfFiles) {
            if (!listOfFile.isFile()) continue;
            backups.add(listOfFile.getName().replace(".txt", ""));
        }
        Collections.reverse(backups);
        return backups;
    }
}

