/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class BiomeInfoScreen
extends class_437 {
    private NaturesCompassScreen parentScreen;
    private class_1959 biome;
    private class_4185 searchButton;
    private class_4185 backButton;
    private String source;
    private String tags;
    private String temperature;
    private String rainfall;

    public BiomeInfoScreen(NaturesCompassScreen parentScreen, class_1959 biome) {
        super((class_2561)class_2561.method_43471((String)BiomeUtils.getBiomeNameForDisplay(parentScreen.world, biome)));
        this.parentScreen = parentScreen;
        this.biome = biome;
        this.source = BiomeUtils.getBiomeSource(parentScreen.world, biome);
        this.tags = BiomeUtils.getBiomeTags(parentScreen.world, biome);
        this.temperature = (double)biome.method_8712() <= 0.5 ? class_1074.method_4662((String)"string.naturescompass.cold", (Object[])new Object[0]) : ((double)biome.method_8712() <= 1.5 ? class_1074.method_4662((String)"string.naturescompass.medium", (Object[])new Object[0]) : class_1074.method_4662((String)"string.naturescompass.warm", (Object[])new Object[0]));
        this.rainfall = biome.field_26393.comp_846() <= 0.0f ? class_1074.method_4662((String)"string.naturescompass.none", (Object[])new Object[0]) : ((double)biome.field_26393.comp_846() < 0.2 ? class_1074.method_4662((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : ((double)biome.field_26393.comp_846() < 0.3 ? class_1074.method_4662((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.field_26393.comp_846() < 0.5 ? class_1074.method_4662((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.field_26393.comp_846() < 0.85 ? class_1074.method_4662((String)"string.naturescompass.high", (Object[])new Object[0]) : class_1074.method_4662((String)"string.naturescompass.veryHigh", (Object[])new Object[0])))));
    }

    public void method_25426() {
        this.method_37067();
        this.setupButtons();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(context, mouseX, mouseY, partialTicks);
        context.method_51433(this.field_22793, BiomeUtils.getBiomeNameForDisplay(this.parentScreen.world, this.biome), this.field_22789 / 2 - this.field_22793.method_1727(BiomeUtils.getBiomeNameForDisplay(this.parentScreen.world, this.biome)) / 2, 20, -1, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"string.naturescompass.source"), this.field_22789 / 2 - 100, 40, -1, false);
        context.method_51433(this.field_22793, this.source, this.field_22789 / 2 - 100, 50, -8355712, false);
        int tagsMaxWidth = this.field_22789 / 2 - 50;
        Object tagsLine = this.tags;
        if (this.field_22793.method_1727((String)tagsLine) > tagsMaxWidth) {
            tagsLine = this.field_22793.method_27523((String)tagsLine + "...", tagsMaxWidth) + "...";
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"string.naturescompass.tags"), this.field_22789 / 2 + 40, 40, -1, false);
        context.method_51433(this.field_22793, (String)tagsLine, this.field_22789 / 2 + 40, 50, -8355712, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"string.naturescompass.rainfall"), this.field_22789 / 2 + 40, 70, -1, false);
        context.method_51433(this.field_22793, this.rainfall, this.field_22789 / 2 + 40, 80, -8355712, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"string.naturescompass.temperature"), this.field_22789 / 2 - 100, 100, -1, false);
        context.method_51433(this.field_22793, this.temperature, this.field_22789 / 2 - 100, 110, -8355712, false);
    }

    private void setupButtons() {
        this.backButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, this.field_22790 - 30, 110, 20, (class_2561)class_2561.method_43471((String)"string.naturescompass.back"), button -> this.field_22787.method_1507((class_437)this.parentScreen)));
        this.searchButton = (class_4185)this.method_37063((class_364)new TransparentButton(this.field_22789 - 120, this.field_22790 - 30, 110, 20, (class_2561)class_2561.method_43471((String)"string.naturescompass.search"), button -> this.parentScreen.searchForBiome(this.biome)));
    }
}

