/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import com.supermartijn642.rechiseled.chiseling.PacketChiselingRecipes;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;

public class ChiselingRecipeLoader
implements class_3302,
IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    public static void addListeners() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> ChiselingRecipeLoader.onDataPackSync((class_1657)player));
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ChiselingRecipeLoader());
    }

    public static void onDataPackSync(class_1657 player) {
        if (player == null) {
            Rechiseled.CHANNEL.sendToAllPlayers((BasePacket)new PacketChiselingRecipes(ChiselingRecipes.getAllRecipes()));
        } else {
            Rechiseled.CHANNEL.sendToPlayer(player, (BasePacket)new PacketChiselingRecipes(ChiselingRecipes.getAllRecipes()));
        }
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"rechiseled", (String)"chiseling_recipe_loader");
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, Executor executor, Executor executor2) {
        List<CompletableFuture> recipes = resourceManager.method_14488("chiseling_recipes", r -> r.method_12832().endsWith(".json")).keySet().stream().map(location -> CompletableFuture.supplyAsync(() -> ChiselingRecipeLoader.loadRecipe(resourceManager, location), executor)).toList();
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])recipes.toArray(CompletableFuture[]::new)).thenApplyAsync(o -> ChiselingRecipeLoader.mergeRecipes(recipes.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList())), executor)).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(resolvedRecipes -> {
            Rechiseled.LOGGER.info("Loaded " + resolvedRecipes.size() + " chiseling recipes");
            ChiselingRecipes.setRecipes(resolvedRecipes);
        }, executor2);
    }

    private static ChiselingRecipe loadRecipe(class_3300 resourceManager, class_2960 recipeLocation) {
        class_2960 parentRecipe = null;
        ArrayList<ChiselingEntry> entries = new ArrayList<ChiselingEntry>();
        try {
            for (class_3298 resource : resourceManager.method_14489(recipeLocation)) {
                JsonObject json;
                try (BufferedReader reader = resource.method_43039();){
                    json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                }
                catch (Exception e) {
                    Rechiseled.LOGGER.error("Encountered an exception whilst trying to load chiseling recipe json '" + String.valueOf(recipeLocation) + "' from '" + resource.method_14480() + "'!", (Throwable)e);
                    break;
                }
                ChiselingRecipe recipe = ChiselingRecipe.Serializer.fromJson(recipeLocation, json);
                if (recipe.overwrite) {
                    entries.clear();
                }
                entries.addAll(recipe.getEntries());
                if (recipe.parentRecipeId == null) continue;
                Rechiseled.LOGGER.warn("Chiseling recipe '" + String.valueOf(recipe.getRecipeId()) + "' from '" + resource.method_14480() + "' uses the 'parent' field! This will be removed in Rechiseled 1.2.0. Recipes automatically get merged based on entries!");
                parentRecipe = recipe.parentRecipeId;
                break;
            }
        }
        catch (Exception e) {
            Rechiseled.LOGGER.error("Encountered an exception whilst trying to load chiseling recipe '" + String.valueOf(recipeLocation) + "'!", (Throwable)e);
            return null;
        }
        return new ChiselingRecipe(recipeLocation, parentRecipe, entries);
    }

    /*
     * WARNING - void declaration
     */
    private static List<ChiselingRecipe> mergeRecipes(List<ChiselingRecipe> recipes) {
        void var5_13;
        LinkedHashMap recipeEntries = new LinkedHashMap();
        recipes.stream().sorted(Comparator.comparing(r -> r.getRecipeId().toString())).forEach(recipe -> recipeEntries.put(recipe.getRecipeId(), new LinkedHashSet<ChiselingEntry>(recipe.getEntries())));
        LinkedHashMap<class_2960, ChiselingRecipe> recipesWithParent = new LinkedHashMap<class_2960, ChiselingRecipe>();
        for (ChiselingRecipe chiselingRecipe : recipes) {
            if (chiselingRecipe.parentRecipeId == null) continue;
            recipesWithParent.put(chiselingRecipe.getRecipeId(), chiselingRecipe);
        }
        block1: for (ChiselingRecipe chiselingRecipe : recipesWithParent.values()) {
            HashSet<class_2960> hashSet = new HashSet<class_2960>();
            class_2960 parentRecipe = chiselingRecipe.parentRecipeId;
            while (recipesWithParent.containsKey(parentRecipe)) {
                hashSet.add(parentRecipe);
                if (hashSet.contains(parentRecipe)) {
                    Rechiseled.LOGGER.error("Found circular parent references when trying to load chiseling recipe '" + String.valueOf(chiselingRecipe.getRecipeId()) + "': " + String.valueOf(hashSet));
                    continue block1;
                }
                parentRecipe = ((ChiselingRecipe)recipesWithParent.get((Object)parentRecipe)).parentRecipeId;
            }
            if (parentRecipe == null) {
                Rechiseled.LOGGER.error("Could not find parent '" + String.valueOf(parentRecipe) + "' when trying to load chiseling recipe '" + String.valueOf(chiselingRecipe.getRecipeId()) + "'!");
                continue;
            }
            ((Set)recipeEntries.get(parentRecipe)).addAll(chiselingRecipe.getEntries());
        }
        HashMap itemsPerRecipe = new HashMap();
        for (Map.Entry entry2 : recipeEntries.entrySet()) {
            HashSet items = new HashSet();
            ((Set)entry2.getValue()).forEach(e -> {
                if (e.hasRegularItem()) {
                    items.add(e.getRegularItem());
                }
                if (e.hasConnectingItem()) {
                    items.add(e.getConnectingItem());
                }
            });
            itemsPerRecipe.put((class_2960)entry2.getKey(), items);
        }
        class_2960[] class_2960Array = (class_2960[])recipeEntries.keySet().toArray(class_2960[]::new);
        boolean bl = false;
        while (var5_13 < class_2960Array.length) {
            for (void j = var5_13 + true; j < class_2960Array.length; ++j) {
                if (Collections.disjoint((Collection)itemsPerRecipe.get(class_2960Array[var5_13]), (Collection)itemsPerRecipe.get(class_2960Array[j]))) continue;
                ((Set)recipeEntries.get(class_2960Array[j])).addAll((Collection)recipeEntries.get(class_2960Array[var5_13]));
                recipeEntries.remove(class_2960Array[var5_13]);
                ((Set)itemsPerRecipe.get(class_2960Array[j])).addAll((Collection)itemsPerRecipe.get(class_2960Array[var5_13]));
                itemsPerRecipe.remove(class_2960Array[var5_13]);
                break;
            }
            ++var5_13;
        }
        for (class_2960 location : recipeEntries.keySet()) {
            Set entries = (Set)recipeEntries.get(location);
            HashMap<class_1792, Integer> itemCounts = new HashMap<class_1792, Integer>();
            ((Set)itemsPerRecipe.get(location)).forEach(item -> itemCounts.compute((class_1792)item, (i, c) -> c == null ? 1 : c + 1));
            LinkedList<ChiselingEntry> toRemove = new LinkedList<ChiselingEntry>();
            for (ChiselingEntry entry2 : entries) {
                if (!entry2.hasRegularItem() && (Integer)itemCounts.get(entry2.getConnectingItem()) > 1) {
                    toRemove.add(entry2);
                    itemCounts.compute(entry2.getConnectingItem(), (i, c) -> c - 1);
                    continue;
                }
                if (entry2.hasConnectingItem() || (Integer)itemCounts.get(entry2.getRegularItem()) <= 1) continue;
                toRemove.add(entry2);
                itemCounts.compute(entry2.getRegularItem(), (i, c) -> c - 1);
            }
            toRemove.forEach(entries::remove);
        }
        recipes = recipeEntries.entrySet().stream().map(entry -> new ChiselingRecipe((class_2960)entry.getKey(), null, (Collection)entry.getValue())).collect(Collectors.toList());
        return recipes;
    }
}

