/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10480;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ExplorersCompassAngleState
extends class_10480 {
    private final class_10480.class_10481 wobbler;
    private final class_5819 random = class_5819.method_43047();

    public ExplorersCompassAngleState() {
        super(true);
        this.wobbler = this.method_65660(0.8f);
    }

    protected float method_65654(class_1799 stack, class_638 world, int seed, class_1297 entity) {
        ExplorersCompassItem compassItem;
        class_4208 pos = new class_4208(world.method_27983(), world.method_43126());
        if (stack.method_7909() == ExplorersCompass.EXPLORERS_COMPASS_ITEM && (compassItem = (ExplorersCompassItem)stack.method_7909()).getState(stack) == CompassState.FOUND) {
            pos = new class_4208(world.method_27983(), new class_2338(compassItem.getFoundStructureX(stack), 0, compassItem.getFoundStructureZ(stack)));
        }
        long gameTime = world.method_8510();
        return !ExplorersCompassAngleState.isValidCompassTargetPos(entity, pos) ? this.getRandomlySpinningRotation(seed, gameTime) : this.getRotationTowardsCompassTarget(entity, gameTime, pos.comp_2208());
    }

    private float getRandomlySpinningRotation(int seed, long gameTime) {
        if (this.wobbler.method_65665(gameTime)) {
            this.wobbler.method_65666(gameTime, this.random.method_43057());
        }
        float f = this.wobbler.method_65664() + (float)ExplorersCompassAngleState.hash(seed) / 2.1474836E9f;
        return class_3532.method_15341((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(class_1297 entity, long gameTime, class_2338 pos) {
        class_1657 playerEntity;
        float f = (float)ExplorersCompassAngleState.getAngleFromEntityToPos(entity, pos);
        float f1 = ExplorersCompassAngleState.getWrappedVisualRotationY(entity);
        if (entity instanceof class_1657 && (playerEntity = (class_1657)entity).method_7340() && playerEntity.method_37908().method_54719().method_54751()) {
            if (this.wobbler.method_65665(gameTime)) {
                this.wobbler.method_65666(gameTime, 0.5f - (f1 - 0.25f));
            }
            float f3 = f + this.wobbler.method_65664();
            return class_3532.method_15341((float)f3, (float)1.0f);
        }
        float f2 = 0.5f - (f1 - 0.25f - f);
        return class_3532.method_15341((float)f2, (float)1.0f);
    }

    private static boolean isValidCompassTargetPos(class_1297 entity, @Nullable class_4208 pos) {
        return pos != null && pos.comp_2207() == entity.method_37908().method_27983() && !(pos.comp_2208().method_19770((class_2374)entity.method_19538()) < (double)1.0E-5f);
    }

    private static double getAngleFromEntityToPos(class_1297 entity, class_2338 pos) {
        class_243 vec3d = class_243.method_24953((class_2382)pos);
        return Math.atan2(vec3d.method_10215() - entity.method_23321(), vec3d.method_10216() - entity.method_23317()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(class_1297 entity) {
        return class_3532.method_15341((float)(entity.method_43078() / 360.0f), (float)1.0f);
    }

    private static int hash(int seed) {
        return seed * 1327217883;
    }
}

