/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Dim2iExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.FlatButtonWidgetExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Point2i;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components.ScrollBarComponent;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.tab.Tab;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.FlatButtonWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class TabFrame
extends AbstractFrame {
    private final boolean tabSectionCanScroll;
    private final Dim2i tabSection;
    private final Dim2i frameSection;
    private final List<Tab<?>> tabs = new ArrayList();
    private final Runnable onSetTab;
    private final AtomicReference<class_2561> tabSectionSelectedTab;
    private ScrollBarComponent tabSectionScrollBar = null;
    private Optional<Tab<?>> selectedTab = Optional.empty();
    private AbstractFrame selectedFrame;

    public TabFrame(Dim2i dim, boolean renderOutline, List<Tab<?>> tabs, Runnable onSetTab, AtomicReference<class_2561> tabSectionSelectedTab, AtomicReference<Integer> tabSectionScrollBarOffset) {
        super(dim, renderOutline);
        this.tabs.addAll(tabs);
        int tabSectionY = this.tabs.size() * 18;
        this.tabSectionCanScroll = tabSectionY > this.dim.height();
        Optional<Integer> result = tabs.stream().map(tab -> this.getStringWidth((class_5348)tab.title())).max(Integer::compareTo);
        this.tabSection = new Dim2i(this.dim.x(), this.dim.y(), result.map(integer -> integer + (this.tabSectionCanScroll ? 32 : 24)).orElseGet(() -> (int)((double)this.dim.width() * 0.35)).intValue(), this.dim.height());
        this.frameSection = new Dim2i(this.tabSection.getLimitX(), this.dim.y(), this.dim.width() - this.tabSection.width(), this.dim.height());
        this.onSetTab = onSetTab;
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar = new ScrollBarComponent(new Dim2i(this.tabSection.getLimitX() - 11, this.tabSection.y(), 10, this.tabSection.height()), ScrollBarComponent.ScrollDirection.VERTICAL, tabSectionY, this.dim.height(), offset -> {
                tabSectionScrollBarOffset.set((Integer)offset);
                ((Dim2iExtended)this.tabSection).setY(this.dim.y() - this.tabSectionScrollBar.getOffset());
            }, this.dim);
            this.tabSectionScrollBar.setOffset(tabSectionScrollBarOffset.get());
        }
        this.tabSectionSelectedTab = tabSectionSelectedTab;
        if (this.tabSectionSelectedTab.get() != null) {
            this.selectedTab = this.tabs.stream().filter(tab -> tab.getTitle().getString().equals(this.tabSectionSelectedTab.get().getString())).findAny();
        }
        this.buildFrame();
        this.tabs.stream().filter(tab -> this.selectedTab.filter(value -> value != tab).isPresent()).forEach(tab -> tab.getFrameFunction().apply(this.frameSection));
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setTab(Optional<Tab<?>> tab) {
        this.selectedTab = tab;
        this.selectedTab.ifPresent(value -> this.tabSectionSelectedTab.set(value.getTitle()));
        if (this.onSetTab != null) {
            this.onSetTab.run();
        }
        this.buildFrame();
    }

    @Override
    public void buildFrame() {
        this.children.clear();
        this.controlElements.clear();
        if (this.selectedTab.isEmpty() && !this.tabs.isEmpty()) {
            this.selectedTab = Optional.ofNullable(this.tabs.getFirst());
        }
        this.rebuildTabs();
        this.rebuildTabFrame();
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar.updateThumbLocation();
            this.children.add(this.tabSectionScrollBar);
        }
        super.buildFrame();
        this.registerFocusListener(element -> {
            if (element instanceof FlatButtonWidgetExtended) {
                FlatButtonWidgetExtended flatButtonWidget = (FlatButtonWidgetExtended)element;
                if (this.tabSectionCanScroll) {
                    Dim2i dim = flatButtonWidget.getDimensions();
                    int inputOffset = this.tabSectionScrollBar.getOffset();
                    if (dim.y() <= this.dim.y()) {
                        inputOffset += dim.y() - this.dim.y();
                    } else if (dim.getLimitY() >= this.dim.getLimitY()) {
                        inputOffset += dim.getLimitY() - this.dim.getLimitY();
                    }
                    this.tabSectionScrollBar.setOffset(inputOffset);
                }
            }
        });
    }

    private void rebuildTabs() {
        int offsetY = 0;
        for (Tab<?> tab : this.tabs) {
            int width = this.tabSection.width() - (this.tabSectionCanScroll ? 12 : 4);
            int height = 18;
            Dim2i tabDim = new Dim2i(0, offsetY, width, height);
            ((Dim2iExtended)tabDim).setPoint2i((Point2i)this.tabSection);
            FlatButtonWidget button = new FlatButtonWidget(tabDim, tab.getTitle(), () -> this.setTab(Optional.of(tab)));
            button.setSelected(this.selectedTab.isPresent() && this.selectedTab.get() == tab);
            ((FlatButtonWidgetExtended)button).setLeftAligned(true);
            this.children.add(button);
            offsetY += 18;
        }
    }

    private void rebuildTabFrame() {
        if (this.selectedTab.isEmpty()) {
            return;
        }
        AbstractFrame frame = (AbstractFrame)((Object)this.selectedTab.get().getFrameFunction().apply(this.frameSection));
        if (frame != null) {
            this.selectedFrame = frame;
            frame.buildFrame();
            this.children.add(frame);
        }
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.applyScissor(guiGraphics, this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height(), () -> {
            for (AbstractWidget widget : this.children) {
                if (widget == this.selectedFrame) continue;
                widget.method_25394(guiGraphics, mouseX, mouseY, delta);
            }
        });
        this.selectedFrame.method_25394(guiGraphics, mouseX, mouseY, delta);
        if (this.tabSectionCanScroll) {
            this.tabSectionScrollBar.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.dim.containsCursor(mouseX, mouseY) && super.method_25402(mouseX, mouseY, button) || this.tabSectionCanScroll && this.tabSectionScrollBar.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY) || this.tabSectionCanScroll && this.tabSectionScrollBar.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button) || this.tabSectionCanScroll && this.tabSectionScrollBar.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount) || this.tabSectionCanScroll && this.tabSectionScrollBar.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public List<Tab<?>> getTabs() {
        return this.tabs;
    }

    public AbstractFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public Optional<Tab<?>> getSelectedTab() {
        return this.selectedTab;
    }

    public static class Builder {
        private final List<Tab<?>> functions = new ArrayList();
        private Dim2i dim;
        private boolean renderOutline;
        private Runnable onSetTab;
        private AtomicReference<class_2561> tabSectionSelectedTab = new AtomicReference<Object>(null);
        private AtomicReference<Integer> tabSectionScrollBarOffset = new AtomicReference<Integer>(0);

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder addTabs(Consumer<List<Tab<?>>> tabs) {
            tabs.accept(this.functions);
            return this;
        }

        public Builder onSetTab(Runnable onSetTab) {
            this.onSetTab = onSetTab;
            return this;
        }

        public Builder setTabSectionSelectedTab(AtomicReference<class_2561> tabSectionSelectedTab) {
            this.tabSectionSelectedTab = tabSectionSelectedTab;
            return this;
        }

        public Builder setTabSectionScrollBarOffset(AtomicReference<Integer> tabSectionScrollBarOffset) {
            this.tabSectionScrollBarOffset = tabSectionScrollBarOffset;
            return this;
        }

        public TabFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            return new TabFrame(this.dim, this.renderOutline, this.functions, this.onSetTab, this.tabSectionSelectedTab, this.tabSectionScrollBarOffset);
        }
    }
}

