/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.biome.v1;

import fuzs.puzzleslib.api.biome.v1.MobSpawnSettingsContext;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_5483;
import net.minecraft.class_6010;
import org.apache.commons.lang3.math.Fraction;

public final class SpawnerDataBuilder {
    private final MobSpawnSettingsContext context;
    private final class_1299<?> entityType;
    private IntUnaryOperator weightMapper = IntUnaryOperator.identity();
    private ToIntFunction<class_5483.class_1964> minCountMapper = class_5483.class_1964::comp_3489;
    private ToIntFunction<class_5483.class_1964> maxCountMapper = class_5483.class_1964::comp_3490;

    private SpawnerDataBuilder(MobSpawnSettingsContext context, class_1299<?> entityType) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(entityType, "entity type is null");
        this.context = context;
        this.entityType = entityType;
    }

    public static SpawnerDataBuilder create(MobSpawnSettingsContext context, class_1299<?> entityType) {
        return new SpawnerDataBuilder(context, entityType);
    }

    public SpawnerDataBuilder setWeight(int weight) {
        return this.setWeight((int oldWeight) -> weight);
    }

    public SpawnerDataBuilder setWeight(Fraction weight) {
        Objects.requireNonNull(weight, "weight is null");
        return this.setWeight((int oldWeight) -> weight.multiplyBy(Fraction.getFraction((int)oldWeight, (int)1)).intValue());
    }

    public SpawnerDataBuilder setWeight(IntUnaryOperator weight) {
        Objects.requireNonNull(weight, "weight is null");
        this.weightMapper = oldWeight -> Math.max(1, weight.applyAsInt(oldWeight));
        return this;
    }

    public SpawnerDataBuilder setMinCount(int minCount) {
        return this.setMinCount((class_5483.class_1964 spawnerData) -> minCount);
    }

    public SpawnerDataBuilder setMinCount(Fraction minCount) {
        Objects.requireNonNull(minCount, "min count is null");
        return this.setMinCount((class_5483.class_1964 spawnerData) -> minCount.multiplyBy(Fraction.getFraction((int)spawnerData.comp_3489(), (int)1)).intValue());
    }

    public SpawnerDataBuilder setMinCount(ToIntFunction<class_5483.class_1964> minCount) {
        Objects.requireNonNull(minCount, "min count is null");
        this.minCountMapper = spawnerData -> Math.max(1, minCount.applyAsInt((class_5483.class_1964)spawnerData));
        return this;
    }

    public SpawnerDataBuilder setMaxCount(int maxCount) {
        return this.setMaxCount((class_5483.class_1964 spawnerData) -> maxCount);
    }

    public SpawnerDataBuilder setMaxCount(Fraction maxCount) {
        Objects.requireNonNull(maxCount, "max count is null");
        return this.setMaxCount((class_5483.class_1964 spawnerData) -> maxCount.multiplyBy(Fraction.getFraction((int)spawnerData.comp_3490(), (int)1)).intValue());
    }

    public SpawnerDataBuilder setMaxCount(ToIntFunction<class_5483.class_1964> maxCount) {
        Objects.requireNonNull(maxCount, "max count is null");
        this.maxCountMapper = spawnerData -> Math.max(1, maxCount.applyAsInt((class_5483.class_1964)spawnerData));
        return this;
    }

    public void apply(class_1299<?> entityType) {
        for (class_1311 mobCategory : this.context.getMobCategoriesWithSpawns()) {
            this.getSpawnerDataForType(this.context, mobCategory, this.entityType).ifPresent(spawnerData -> {
                int weight = this.weightMapper.applyAsInt(spawnerData.comp_2543());
                int minCount = this.minCountMapper.applyAsInt((class_5483.class_1964)spawnerData.comp_2542());
                int maxCount = this.maxCountMapper.applyAsInt((class_5483.class_1964)spawnerData.comp_2542());
                this.context.addSpawn(mobCategory, weight, new class_5483.class_1964(entityType, Math.min(minCount, maxCount), maxCount));
            });
        }
    }

    private Optional<class_6010<class_5483.class_1964>> getSpawnerDataForType(MobSpawnSettingsContext context, class_1311 mobCategory, class_1299<?> entityType) {
        return context.getSpawnerData(mobCategory).stream().filter(spawnerData -> ((class_5483.class_1964)spawnerData.comp_2542()).comp_3488() == entityType).findAny();
    }
}

