/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import dev.architectury.event.events.client.ClientGuiEvent;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends class_465<X> {
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container, ((BaseContainer)((Object)container)).player.method_31548(), (class_2561)TextComponents.empty().get());
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void method_25426() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.field_2792 = this.widget.width();
        this.field_2779 = this.widget.height();
        super.method_25426();
    }

    public void method_25419() {
        this.widget.discard();
        super.method_25419();
    }

    protected void method_37432() {
        this.widget.update();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.widgetRenderContext.update(guiGraphics, partialTicks, this.field_22793, this.field_22787);
        GuiGraphicsHelper helper = GuiGraphicsHelper.of(guiGraphics);
        if (CoreLib.isArchitecturyLoaded) {
            ((ClientGuiEvent.ContainerScreenRenderBackground)ClientGuiEvent.RENDER_CONTAINER_BACKGROUND.invoker()).render((class_465)this, guiGraphics, mouseX, mouseY, partialTicks);
        }
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        int offsetY = (this.field_22790 - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)offsetX, (float)offsetY);
        this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        this.widget.renderBackground(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (class_1735 slot : ((BaseContainer)((Object)this.container)).field_7761) {
                helper.submitDefaultSlot(slot.field_7873 - 1, slot.field_7872 - 1);
            }
        }
        this.widget.render(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        this.field_2787 = null;
        for (class_1735 slot : ((BaseContainer)((Object)this.container)).field_7761) {
            if (!slot.method_7682()) continue;
            if (this.method_2378(slot.field_7873, slot.field_7872, 16, 16, mouseX, mouseY)) {
                this.field_2787 = slot;
                helper.submitSprite(class_465.field_54268, (float)(slot.field_7873 - 4), (float)(slot.field_7872 - 4), 24.0f, 24.0f);
            }
            this.method_2385(guiGraphics, slot);
            if (this.field_2787 != slot) continue;
            helper.submitSprite(class_465.field_54269, (float)(slot.field_7873 - 4), (float)(slot.field_7872 - 4), 24.0f, 24.0f);
        }
        this.widget.renderForeground(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        guiGraphics.method_51448().popMatrix();
        this.method_2380(guiGraphics, mouseX, mouseY);
        if (CoreLib.isArchitecturyLoaded) {
            ((ClientGuiEvent.ContainerScreenRenderForeground)ClientGuiEvent.RENDER_CONTAINER_FOREGROUND.invoker()).render((class_465)this, guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.method_71083(guiGraphics, mouseX, mouseY);
        this.method_71084(guiGraphics);
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)offsetX, (float)offsetY);
        this.widget.renderOverlay(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        guiGraphics.method_51448().popMatrix();
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        return this.widget.mousePressed((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_22790 - this.widget.height()) / 2), button, false) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        int offsetY;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        return this.widget.mouseReleased((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_22790 - this.widget.height()) / 2), button, false) || super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.field_22789 - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)mouseX - offsetX, (int)mouseY - (offsetY = (this.field_22790 - this.widget.height()) / 2), horizontalAmount, false) || super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.widget.keyPressed(keyCode, false)) {
            return true;
        }
        if (ClientUtils.getMinecraft().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.widget.keyReleased(keyCode, false) || super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char character, int modifiers) {
        return this.widget.charTyped(character, false) || super.method_25400(character, modifiers);
    }

    public boolean method_25421() {
        return this.isPauseScreen;
    }

    public class_2561 method_25435() {
        class_2561 message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

