/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_314;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.class_9887;

public final class ConditionalRecipeSerializer
implements class_1865<class_1860<?>> {
    private static final class_3956<DummyRecipe> DUMMY_RECIPE_TYPE = (class_3956)class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)class_2960.method_60655((String)"supermartijn642corelib", (String)"dummy"), (Object)new class_3956<DummyRecipe>(){

        public String toString() {
            return "supermartijn642corelib:dummy";
        }
    });
    public static final class_1860<?> DUMMY_RECIPE = new DummyRecipe();
    public static final ConditionalRecipeSerializer INSTANCE = new ConditionalRecipeSerializer();
    private static final MapCodec<class_1860<?>> CODEC = new MapCodec<class_1860<?>>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.empty();
        }

        public <T> DataResult<class_1860<?>> decode(DynamicOps<T> ops, MapLike<T> input) {
            JsonObject json = new JsonObject();
            input.entries().map(entry -> {
                DataResult key = ops.getStringValue(entry.getFirst());
                return key.isSuccess() ? Pair.of((Object)((String)key.getOrThrow()), (Object)entry.getSecond()) : null;
            }).filter(Objects::nonNull).forEach(entry -> json.add((String)entry.getFirst(), (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, entry.getSecond())));
            JsonElement recipeJson = ConditionalRecipeSerializer.unwrapRecipe(null, json);
            if (recipeJson == null) {
                return DataResult.success(DUMMY_RECIPE);
            }
            Object t = JsonOps.INSTANCE.convertTo(ops, recipeJson);
            return class_1860.field_47319.parse(ops, t);
        }

        public <T> RecordBuilder<T> encode(class_1860<?> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return (RecordBuilder)class_1860.field_47319.encodeStart(ops, input).flatMap(output -> {
                JsonElement element = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, output);
                if (element.isJsonObject()) {
                    RecordBuilder map = ops.mapBuilder();
                    for (String key : element.getAsJsonObject().keySet()) {
                        map.add(key, JsonOps.INSTANCE.convertTo(ops, element.getAsJsonObject().get(key)));
                    }
                    return DataResult.success((Object)map);
                }
                return DataResult.error(() -> "Expected object but got " + String.valueOf(element) + " from recipe codec!");
            }).getOrThrow();
        }
    };

    public static JsonObject wrapRecipe(JsonObject recipe, Collection<ResourceCondition> conditions) {
        JsonObject json = new JsonObject();
        json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(INSTANCE).toString());
        JsonArray conditionsJson = new JsonArray();
        for (ResourceCondition condition : conditions) {
            JsonObject conditionJson = new JsonObject();
            conditionJson.addProperty("type", Registries.RESOURCE_CONDITION_SERIALIZERS.getIdentifier(condition.getSerializer()).toString());
            condition.getSerializer().serialize(conditionJson, condition);
            conditionsJson.add((JsonElement)conditionJson);
        }
        json.add("conditions", (JsonElement)conditionsJson);
        json.add("recipe", (JsonElement)recipe);
        return json;
    }

    private ConditionalRecipeSerializer() {
    }

    public static JsonElement unwrapRecipe(class_2960 location, JsonObject json) {
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new RuntimeException("Conditional recipe '" + String.valueOf(location) + "' must have 'conditions' array!");
        }
        if (!json.has("recipe") || !json.get("recipe").isJsonObject()) {
            throw new RuntimeException("Conditional recipe '" + String.valueOf(location) + "' must have 'recipe' object!");
        }
        JsonArray conditions = json.getAsJsonArray("conditions");
        for (JsonElement conditionElement : conditions) {
            Object condition;
            if (!conditionElement.isJsonObject()) {
                throw new RuntimeException("Conditions array for recipe '" + String.valueOf(location) + "' must only contain objects!");
            }
            JsonObject conditionJson = conditionElement.getAsJsonObject();
            if (!(conditionJson.has("type") && conditionJson.get("type").isJsonPrimitive() && conditionJson.get("type").getAsJsonPrimitive().isString())) {
                throw new RuntimeException("Condition for recipe '" + String.valueOf(location) + "' is missing 'type' key!");
            }
            String type = conditionJson.get("type").getAsString();
            if (!RegistryUtil.isValidIdentifier(type)) {
                throw new RuntimeException("Condition for recipe '" + String.valueOf(location) + "' has invalid type '" + type + "'!");
            }
            ResourceConditionSerializer<?> serializer = Registries.RESOURCE_CONDITION_SERIALIZERS.getValue(class_2960.method_60654((String)type));
            if (serializer == null) {
                throw new RuntimeException("Condition for recipe '" + String.valueOf(location) + "' has unknown type '" + String.valueOf(class_2960.method_60654((String)type)) + "'!");
            }
            try {
                condition = serializer.deserialize(conditionJson);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered exception whilst testing condition '" + String.valueOf(class_2960.method_60654((String)type)) + "' for recipe '" + String.valueOf(location) + "'!");
            }
            if (condition.test(ResourceConditionContext.EMPTY)) continue;
            return null;
        }
        return json.getAsJsonObject("recipe");
    }

    public MapCodec<class_1860<?>> method_53736() {
        return CODEC;
    }

    public class_9139<class_9129, class_1860<?>> method_56104() {
        return class_9139.method_56431(null);
    }

    private static class DummyRecipe
    implements class_1860<class_9695> {
        private DummyRecipe() {
        }

        public boolean method_8115(class_9695 container, class_1937 level) {
            return false;
        }

        public class_1799 method_8116(class_9695 container, class_7225.class_7874 provider) {
            return class_1799.field_8037;
        }

        public class_1865<DummyRecipe> method_8119() {
            return null;
        }

        public class_3956<DummyRecipe> method_17716() {
            return DUMMY_RECIPE_TYPE;
        }

        public class_9887 method_61671() {
            return class_9887.field_52597;
        }

        public class_10355 method_64668() {
            return class_314.field_1810;
        }
    }
}

