/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.spyglass_astronomy.commands.admin_subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.nettakrim.spyglass_astronomy.Constellation;
import com.nettakrim.spyglass_astronomy.SpaceDataManager;
import com.nettakrim.spyglass_astronomy.SpyglassAstronomyClient;
import com.nettakrim.spyglass_astronomy.StarLine;
import com.nettakrim.spyglass_astronomy.commands.admin_subcommands.ConstellationsCommand;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class StarCountCommand {
    public static final ArrayList<Constellation> invalidatedConstellations = new ArrayList();

    public static LiteralCommandNode<FabricClientCommandSource> getCommandNode() {
        LiteralCommandNode starCountNode = ClientCommandManager.literal((String)"starcount").build();
        LiteralCommandNode queryNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"query").executes(StarCountCommand::queryStarCount)).build();
        LiteralCommandNode resetNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reset").executes(StarCountCommand::resetStarCount)).build();
        LiteralCommandNode setNode = ((LiteralArgumentBuilder)ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4095)).executes(StarCountCommand::setStarCount))).build();
        starCountNode.addChild((CommandNode)queryNode);
        starCountNode.addChild((CommandNode)resetNode);
        starCountNode.addChild((CommandNode)setNode);
        return starCountNode;
    }

    private static int setStarCount(CommandContext<FabricClientCommandSource> context) {
        return StarCountCommand.setStarCount(IntegerArgumentType.getInteger(context, (String)"amount"));
    }

    private static int resetStarCount(CommandContext<FabricClientCommandSource> context) {
        return StarCountCommand.setStarCount(1024);
    }

    private static int setStarCount(int amount) {
        boolean reducedStars = amount < SpyglassAstronomyClient.getStarCount();
        SpyglassAstronomyClient.say("commands.admin.starcount.set", Integer.toString(amount), Integer.toString(SpyglassAstronomyClient.getStarCount()));
        SpyglassAstronomyClient.setStarCount(amount);
        SpyglassAstronomyClient.generateStars(null, true, false);
        if (reducedStars) {
            ArrayList<Constellation> validConstellations = new ArrayList<Constellation>(SpyglassAstronomyClient.constellations.size());
            for (Constellation constellation : SpyglassAstronomyClient.constellations) {
                boolean bl = true;
                for (StarLine line : constellation.getLines()) {
                    int star;
                    int max = Math.max(line.getOtherStar(star = line.getOtherStar(-1)), star);
                    if (max < amount) continue;
                    invalidatedConstellations.add(constellation);
                    bl = false;
                    break;
                }
                if (!bl) continue;
                validConstellations.add(constellation);
            }
            int difference = SpyglassAstronomyClient.constellations.size() - validConstellations.size();
            if (difference != 0) {
                SpyglassAstronomyClient.say("commands.admin.starcount.set.invalidate", difference);
            }
            SpyglassAstronomyClient.constellations.clear();
            for (Constellation constellation : validConstellations) {
                ConstellationsCommand.addConstellation(constellation, false, false);
            }
            SpyglassAstronomyClient.spaceRenderingManager.scheduleConstellationsUpdate();
        } else {
            ArrayList<Constellation> validConstellations = new ArrayList<Constellation>(invalidatedConstellations.size());
            for (Constellation constellation : invalidatedConstellations) {
                boolean bl = true;
                for (StarLine line : constellation.getLines()) {
                    int star;
                    int max = Math.max(line.getOtherStar(star = line.getOtherStar(-1)), star);
                    if (max < amount) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                validConstellations.add(constellation);
            }
            if (validConstellations.size() != 0) {
                int validated = 0;
                for (Constellation constellation : validConstellations) {
                    if (ConstellationsCommand.addConstellation(constellation, false, false) != 1) continue;
                    invalidatedConstellations.remove(constellation);
                    ++validated;
                }
                if (validated > 0) {
                    SpyglassAstronomyClient.say("commands.admin.starcount.set.validate", validated);
                    SpyglassAstronomyClient.spaceRenderingManager.scheduleConstellationsUpdate();
                }
            }
        }
        SpaceDataManager.makeChange();
        return 1;
    }

    private static int queryStarCount(CommandContext<FabricClientCommandSource> context) {
        SpyglassAstronomyClient.say("commands.admin.starcount.query", Integer.toString(SpyglassAstronomyClient.getStarCount()));
        return 1;
    }
}

