/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.resource;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.metadata.layer.LBGLayerType;
import dev.lambdaurora.lambdabettergrass.metadata.layer.LBGLayerTypeData;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LBGLayerTypeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambdaBetterGrass|LBGLayerTypeManager");
    private static final String PREFIX = "bettergrass/layer_types";
    private static final String EXTENSION = ".json";
    private final Map<class_2960, LBGLayerType> types = new HashMap<class_2960, LBGLayerType>();

    @NotNull
    public Optional<LBGLayerType> get(String rawId) {
        class_2960 id = class_2960.method_60654((String)rawId);
        return this.get(id).or(() -> {
            if (!rawId.contains(":") && id.method_12836().equals("minecraft")) {
                return this.get(LambdaBetterGrass.id(id.method_12832()));
            }
            return Optional.empty();
        });
    }

    @NotNull
    public Optional<LBGLayerType> get(class_2960 id) {
        return Optional.ofNullable(this.types.get(id));
    }

    public void forEach(Consumer<LBGLayerType> consumer) {
        this.types.values().forEach(consumer);
    }

    public void load(class_3300 resourceManager) {
        this.types.clear();
        Map layerTypes = resourceManager.method_14488(PREFIX, path -> path.method_12832().endsWith(EXTENSION));
        layerTypes.forEach(this::loadLayerType);
    }

    private void loadLayerType(class_2960 resourceId, class_3298 resource) {
        class_2960 id = this.getIdFromResource(resourceId);
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonElement rawJson = JsonParser.parseReader((Reader)reader);
            DataResult loaded = LBGLayerTypeData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)rawJson);
            loaded.result().ifPresentOrElse(data -> this.types.put(id, new LBGLayerType(id, (LBGLayerTypeData)data)), () -> LambdaBetterGrass.warn(LOGGER, "Failed to load layer type \"{}\" due to error: {}", id, ((DataResult.Error)loaded.error().orElseThrow()).message()));
        }
        catch (Exception e) {
            LambdaBetterGrass.warn(LOGGER, "Failed to load layer type \"{}\".", id);
        }
    }

    private class_2960 getIdFromResource(class_2960 resourceId) {
        String path = resourceId.method_12832();
        return resourceId.method_45136(path.substring(PREFIX.length() + 1, path.length() - EXTENSION.length()));
    }
}

