/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.storagemod.components.WorldPos;
import com.tom.storagemod.inventory.IInventoryLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_10741;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_4844;
import net.minecraft.class_5321;

public class RemoteConnections
extends class_18 {
    private static final String ID = "toms_storage_rc";
    public static final Codec<RemoteConnections> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Codec.list(Connection.CODEC).fieldOf("connections").forGetter(RemoteConnections::connections)).apply((Applicative)b, RemoteConnections::new)).codec();
    private static final class_10741<RemoteConnections> FACTORY = new class_10741("toms_storage_rc", RemoteConnections::new, __ -> CODEC, class_4284.field_19212);
    private Map<UUID, Channel> connections = new HashMap<UUID, Channel>();

    private RemoteConnections(class_18.class_10740 ctx) {
    }

    private RemoteConnections(List<Connection> conns) {
        for (Connection connection : conns) {
            this.connections.put(connection.channelId(), new Channel(connection));
        }
    }

    private List<Connection> connections() {
        return this.connections.entrySet().stream().map(Connection::new).toList();
    }

    public static RemoteConnections get(class_1937 world) {
        class_3218 sw = (class_3218)world;
        return (RemoteConnections)sw.method_8503().method_30002().method_17983().method_17924(FACTORY);
    }

    public Channel getChannel(UUID connection) {
        return this.connections.get(connection);
    }

    public UUID makeChannel(String name, boolean isPublic, class_1657 owner) {
        UUID id = UUID.randomUUID();
        if (((String)name).isEmpty() || ((String)name).length() > 50) {
            name = "Channel " + System.currentTimeMillis();
        }
        this.connections.put(id, new Channel(owner.method_7334().getId(), owner.method_7334().getName(), isPublic, (String)name));
        this.method_80();
        return id;
    }

    public void removeChannel(UUID id, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            this.connections.remove(id);
            this.method_80();
        }
    }

    public void editChannel(UUID id, boolean pub, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            c.publicChannel = pub;
            this.method_80();
        }
    }

    public void invalidateCache(UUID id) {
        Channel c = this.connections.get(id);
        if (c != null) {
            c.connectors.clear();
        }
    }

    public Stream<Map.Entry<UUID, Channel>> streamChannels(class_1657 player) {
        return this.connections.entrySet().stream().filter(c -> ((Channel)c.getValue()).canAccess(player));
    }

    private record Connection(UUID channelId, UUID owner, String ownerName, String displayName, boolean isPublic) {
        public static final Codec<Connection> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)class_4844.field_25122.fieldOf("id").forGetter(Connection::channelId), (App)class_4844.field_25122.fieldOf("owner").forGetter(Connection::owner), (App)Codec.STRING.fieldOf("owner_name").forGetter(Connection::ownerName), (App)Codec.STRING.fieldOf("name").forGetter(Connection::displayName), (App)Codec.BOOL.fieldOf("public").forGetter(Connection::isPublic)).apply((Applicative)b, Connection::new)).codec();

        public Connection(Map.Entry<UUID, Channel> e) {
            this(e.getKey(), e.getValue().owner, e.getValue().ownerName, e.getValue().displayName, e.getValue().publicChannel);
        }
    }

    public static class Channel {
        public Set<WorldPos> connectors = new HashSet<WorldPos>();
        public UUID owner;
        public String ownerName;
        public boolean publicChannel;
        public String displayName;

        public Channel(UUID owner, String ownerName, boolean publicChannel, String displayName) {
            this.owner = owner;
            this.ownerName = ownerName;
            this.publicChannel = publicChannel;
            this.displayName = displayName;
        }

        private Channel(Connection t) {
            this(t.owner(), t.ownerName(), t.isPublic(), t.displayName());
        }

        public void register(class_3218 world, class_2338 blockPos) {
            WorldPos pos = new WorldPos((class_5321<class_1937>)world.method_27983(), blockPos);
            this.connectors.add(pos);
        }

        public Set<IInventoryLink> findOthers(class_3218 world, class_2338 blockPos, int lvl) {
            WorldPos pos = new WorldPos((class_5321<class_1937>)world.method_27983(), blockPos);
            this.connectors.add(pos);
            HashSet<IInventoryLink> found = new HashSet<IInventoryLink>();
            Iterator<WorldPos> posItr = this.connectors.iterator();
            while (posItr.hasNext()) {
                WorldPos dimPos = posItr.next();
                if (dimPos.equals(pos)) continue;
                class_2586 te = dimPos.getBlockEntity(world);
                if (te instanceof IInventoryLink) {
                    IInventoryLink link = (IInventoryLink)te;
                    if (!link.isAccessibleFrom(world, blockPos, lvl)) continue;
                    found.add(link);
                    continue;
                }
                posItr.remove();
            }
            return found;
        }

        public boolean canAccess(class_1657 player) {
            return this.publicChannel || this.owner.equals(player.method_5667());
        }
    }
}

