/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10802;
import net.minecraft.class_10820;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_785;
import net.minecraft.class_793;
import org.apache.commons.io.IOUtils;
import org.joml.Vector3fc;

public class DrawerModelGeometry {
    private static boolean geometryDataLoaded = false;

    public static void loadGeometryData() {
        if (geometryDataLoaded) {
            return;
        }
        geometryDataLoaded = true;
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_1.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_drawers_icon_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_count_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_ind_area_4.json"), ModConstants.loc("models/block/geometry/full_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_1.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_1.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 1, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_drawers_icon_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_count_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_ind_area_4.json"), ModConstants.loc("models/block/geometry/half_drawers_indbase_area_4.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockDrawers.class, 4, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_comp_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/full_comp_drawers_icon_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_count_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_ind_area_3.json"), ModConstants.loc("models/block/geometry/full_comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, false).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_comp_drawers_icon_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_count_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_ind_area_2.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_indbase_area_2.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 2, true).toArray(BlockDrawers[]::new));
        DrawerModelGeometry.populateGeometryData(ModConstants.loc("models/block/geometry/half_comp_drawers_icon_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_count_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_ind_area_3.json"), ModConstants.loc("models/block/geometry/half_comp_drawers_indbase_area_3.json"), (BlockDrawers[])ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockCompDrawers.class, 3, true).toArray(BlockDrawers[]::new));
    }

    private static void populateGeometryData(class_2960 locationIcon, class_2960 locationCount, class_2960 locationInd, class_2960 locationIndBase, BlockDrawers ... blocks) {
        List<class_785> slotGeo = DrawerModelGeometry.getElements(DrawerModelGeometry.getBlockModel(locationIcon));
        List<class_785> countGeo = DrawerModelGeometry.getElements(DrawerModelGeometry.getBlockModel(locationCount));
        List<class_785> indicatorGeo = DrawerModelGeometry.getElements(DrawerModelGeometry.getBlockModel(locationInd));
        List<class_785> indicatorBaseGeo = DrawerModelGeometry.getElements(DrawerModelGeometry.getBlockModel(locationIndBase));
        for (BlockDrawers block : blocks) {
            if (block == null) continue;
            DrawerModelGeometry.populateGeometryData(block, slotGeo, BlockDrawers.GeometryType.Label);
            DrawerModelGeometry.populateGeometryData(block, countGeo, BlockDrawers.GeometryType.Count);
            DrawerModelGeometry.populateGeometryData(block, indicatorGeo, BlockDrawers.GeometryType.Indicator);
            DrawerModelGeometry.populateGeometryData(block, indicatorBaseGeo, BlockDrawers.GeometryType.IndicatorBase);
        }
    }

    private static void populateGeometryData(BlockDrawers block, List<class_785> info, BlockDrawers.GeometryType type) {
        if (block == null || info == null) {
            return;
        }
        int drawerCount = block.getDrawerCount();
        if (drawerCount > info.size()) {
            return;
        }
        block7: for (int i = 0; i < drawerCount; ++i) {
            Vector3fc from = info.get(i).comp_3727();
            Vector3fc to = info.get(i).comp_3728();
            class_238 bound = new class_238((double)from.x(), (double)from.y(), (double)from.z(), (double)to.x(), (double)to.y(), (double)to.z());
            switch (type) {
                case Slot: {
                    block.slotGeometry[i] = bound;
                    continue block7;
                }
                case Count: {
                    block.countGeometry[i] = bound;
                    continue block7;
                }
                case Label: {
                    block.labelGeometry[i] = bound;
                    continue block7;
                }
                case Indicator: {
                    block.indGeometry[i] = bound;
                    continue block7;
                }
                case IndicatorBase: {
                    block.indBaseGeometry[i] = bound;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_793 getBlockModel(class_2960 location) {
        class_3298 iresource = null;
        InputStreamReader reader = null;
        try {
            iresource = class_310.method_1551().method_1478().getResourceOrThrow(location);
            reader = new InputStreamReader(iresource.method_14482(), StandardCharsets.UTF_8);
            class_793 class_7932 = class_793.method_3437((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            return class_7932;
        }
        catch (IOException e) {
            class_793 class_7933 = null;
            return class_7933;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private static List<class_785> getElements(class_793 model) {
        if (model == null) {
            return new ArrayList<class_785>();
        }
        class_10820 class_108202 = model.comp_3739();
        if (class_108202 instanceof class_10802) {
            class_10802 geo = (class_10802)class_108202;
            return geo.comp_3753();
        }
        return new ArrayList<class_785>();
    }
}

