/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfig;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public abstract class FaceSlotBlock
extends class_2383
implements INetworked,
class_2343 {
    private long ignoreEventTime;
    private long ignoreEventThresh = 2L;

    protected FaceSlotBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public class_1269 rightAction(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hit) {
        Optional<class_1269> useResult;
        boolean altAction;
        if (!SecurityManager.canInteract(player, class_1268.field_5808, pos)) {
            return class_1269.field_5811;
        }
        int slot = this.getFaceSlot(state, hit);
        InteractContext context = new InteractContext(state, level, pos, player, hit, slot);
        boolean bl = altAction = PlayerConfig.getInvertShift(player) != player.method_5715();
        if (!PlayerConfig.getInvertClick(player) && (useResult = this.useSlotInvertible(context)).isPresent()) {
            return useResult.get();
        }
        useResult = this.useSlot(context);
        if (useResult.isPresent()) {
            return useResult.get();
        }
        if (slot < 0) {
            return class_1269.field_5811;
        }
        if (PlayerConfig.getInvertClick(player)) {
            return this.takeSlot(context, altAction);
        }
        return this.putSlot(context, altAction);
    }

    public class_1269 leftAction(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hit) {
        Optional<class_1269> useResult;
        boolean altAction;
        if (!SecurityManager.canInteract(player, class_1268.field_5808, pos)) {
            return class_1269.field_5811;
        }
        int slot = this.getFaceSlot(state, hit);
        InteractContext context = new InteractContext(state, level, pos, player, hit, slot);
        boolean bl = altAction = PlayerConfig.getInvertShift(player) != player.method_5715();
        if (PlayerConfig.getInvertClick(player) && (useResult = this.useSlotInvertible(context)).isPresent()) {
            return useResult.get();
        }
        if (slot < 0) {
            return class_1269.field_5811;
        }
        if (PlayerConfig.getInvertClick(player)) {
            return this.putSlot(context, altAction);
        }
        return this.takeSlot(context, altAction);
    }

    public class_1269 method_55766(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hit) {
        return this.rightAction(state, level, pos, player, hit);
    }

    public void method_9606(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player) {
        class_3965 hit = WorldUtils.rayTraceEyes(level, player, pos);
        if (hit.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        if (!hit.method_17777().equals((Object)pos)) {
            return;
        }
        this.leftAction(state, level, pos, player, hit);
    }

    public Optional<class_1269> useSlot(InteractContext context) {
        return Optional.of(class_1269.field_5811);
    }

    public Optional<class_1269> useSlotInvertible(InteractContext context) {
        return Optional.of(class_1269.field_5811);
    }

    public class_1269 putSlot(InteractContext context, boolean altAction) {
        return class_1269.field_5811;
    }

    public class_1269 takeSlot(InteractContext context, boolean altAction) {
        return class_1269.field_5811;
    }

    public final int getFaceSlot(@NotNull class_2680 state, @NotNull class_3965 hit) {
        class_2350 side = hit.method_17780();
        if (state.method_11654((class_2769)field_11177) != side) {
            return -1;
        }
        return this.getFaceSlot(hit.method_17780(), FaceSlotBlock.normalizeHitVec(hit.method_17784()));
    }

    @NotNull
    private static class_243 normalizeHitVec(@NotNull class_243 hit) {
        return new class_243((hit.field_1352 < 0.0 ? hit.field_1352 - Math.floor(hit.field_1352) : hit.field_1352) % 1.0, (hit.field_1351 < 0.0 ? hit.field_1351 - Math.floor(hit.field_1351) : hit.field_1351) % 1.0, (hit.field_1350 < 0.0 ? hit.field_1350 - Math.floor(hit.field_1350) : hit.field_1350) % 1.0);
    }

    protected int getFaceSlot(class_2350 correctSide, @NotNull class_243 normalizedHit) {
        return -1;
    }

    protected boolean hitWithinArea(class_2350 side, class_243 normalizedHit, float min, float max) {
        return this.hitWithinX(side, normalizedHit, min, max) && this.hitWithinY(normalizedHit, min, max);
    }

    protected boolean hitWithinY(@NotNull class_243 normalizedHit, float min, float max) {
        return normalizedHit.field_1351 > (double)min && normalizedHit.field_1351 < (double)max;
    }

    protected boolean hitWithinX(class_2350 side, @NotNull class_243 normalizedHit, float min, float max) {
        return switch (side) {
            case class_2350.field_11043 -> {
                if (normalizedHit.field_1352 > (double)(1.0f - max) && normalizedHit.field_1352 < (double)(1.0f - min)) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11035 -> {
                if (normalizedHit.field_1352 > (double)min && normalizedHit.field_1352 < (double)max) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11039 -> {
                if (normalizedHit.field_1350 > (double)min && normalizedHit.field_1350 < (double)max) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11034 -> {
                if (normalizedHit.field_1350 > (double)(1.0f - max) && normalizedHit.field_1350 < (double)(1.0f - min)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public static class InteractContext {
        public class_2680 state;
        public class_1937 level;
        public class_2338 pos;
        public class_1657 player;
        public class_3965 hit;
        public int slot;

        public InteractContext(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit, int slot) {
            this.state = state;
            this.level = level;
            this.pos = pos;
            this.player = player;
            this.hit = hit;
            this.slot = slot;
        }

        public <BE extends class_2586> BE getCheckedEntity(Class<BE> type) {
            if (this.level.method_8320(this.pos) != this.state) {
                return null;
            }
            return WorldUtils.getBlockEntity((class_1922)this.level, this.pos, type);
        }

        public <BE extends class_2586, B extends class_2248> BE getCheckedEntity(Class<BE> type, Class<B> blockType) {
            if (!blockType.isInstance(this.state.method_26204())) {
                return null;
            }
            return this.getCheckedEntity(type);
        }
    }
}

