/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.util;

import github.meloweh.wolfcompanion.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9334;

public class WolfInventoryHelper {
    private static boolean hasLifesavingEffects(class_1309 entity) {
        return WolfInventoryHelper.getLifeSavingEffects(true).stream().anyMatch(arg_0 -> ((class_1309)entity).method_6059(arg_0));
    }

    public static boolean hasFittingLifesavingEffect(class_1309 entity) {
        boolean isLow = entity.method_6032() <= 7.0f;
        boolean isHot = entity.method_5809() || entity.method_5771();
        boolean hasAnyEffect = WolfInventoryHelper.hasLifesavingEffects(entity);
        boolean hasFireResistance = entity.method_6059(class_1294.field_5918);
        if (isHot && !hasFireResistance) {
            return false;
        }
        if (isLow) {
            return hasAnyEffect && !hasFireResistance;
        }
        return true;
    }

    public static boolean hasFittingLifesavingEffect(class_1309 entity, List<class_1799> inventoryContents) {
        boolean hasFireResistance = entity.method_6059(class_1294.field_5918);
        boolean isHot = entity.method_5809() || entity.method_5771();
        boolean isLow = entity.method_6032() <= 7.0f;
        boolean hasAnyEffect = WolfInventoryHelper.hasLifesavingEffects(entity);
        boolean hasAnyPotion = !((class_1799)WolfInventoryHelper.findLifesavingPotions(inventoryContents, (class_1309)entity).first).method_7960();
        boolean hasFirePotion = !((class_1799)WolfInventoryHelper.findPotion(inventoryContents, (class_6880<class_1291>)class_1294.field_5918).first).method_7960();
        boolean hasArmor = false;
        if (entity instanceof class_1493) {
            class_1493 w = (class_1493)entity;
            hasArmor = w.method_56677();
        }
        if (entity instanceof class_1657) {
            class_1657 p = (class_1657)entity;
            boolean isOk = true;
            for (class_1304 equipmentSlot : class_9274.field_49224) {
                class_1799 e;
                if (equipmentSlot.method_5925() != class_1304.class_1305.field_6178 || (e = entity.method_6118(equipmentSlot)).method_31574(class_1802.field_22030) || e.method_31574(class_1802.field_22029) || e.method_31574(class_1802.field_22028) || e.method_31574(class_1802.field_22027)) continue;
                isOk = false;
                break;
            }
            hasArmor = isOk;
        }
        if (entity.method_5771() && !hasFireResistance && (hasAnyPotion && !hasArmor || hasFirePotion)) {
            return false;
        }
        if (isLow) {
            return !hasAnyPotion || hasAnyEffect && !hasFireResistance;
        }
        return true;
    }

    private static List<class_6880<class_1291>> getLifeSavingEffects(boolean withFire) {
        ArrayList<class_6880<class_1291>> acceptableStatusEffects = new ArrayList<class_6880<class_1291>>();
        if (withFire) {
            acceptableStatusEffects.add(class_1294.field_5918);
        }
        acceptableStatusEffects.add(class_1294.field_5915);
        acceptableStatusEffects.add(class_1294.field_5924);
        return acceptableStatusEffects;
    }

    private static class_6880<class_1842> getPotion(class_6880<class_1291> effect, int ampl, int duration) {
        if (((class_1842)class_1847.field_8969.comp_349()).method_8049().stream().anyMatch(a -> a.method_5578() == ampl && a.method_5584() == duration && a.method_5579() == effect)) {
            return class_1847.field_8969;
        }
        if (((class_1842)class_1847.field_8987.comp_349()).method_8049().stream().anyMatch(a -> a.method_5578() == ampl && a.method_5584() == duration && a.method_5579() == effect)) {
            return class_1847.field_8987;
        }
        if (((class_1842)class_1847.field_8963.comp_349()).method_8049().stream().anyMatch(a -> a.method_5578() == ampl && a.method_5584() == duration && a.method_5579() == effect)) {
            return class_1847.field_8963;
        }
        if (((class_1842)class_1847.field_8980.comp_349()).method_8049().stream().anyMatch(a -> a.method_5578() == ampl && a.method_5584() == duration && a.method_5579() == effect)) {
            return class_1847.field_8980;
        }
        if (((class_1842)class_1847.field_8986.comp_349()).method_8049().stream().anyMatch(a -> a.method_5578() == ampl && a.method_5584() == duration && a.method_5579() == effect)) {
            return class_1847.field_8986;
        }
        if (((class_1842)class_1847.field_8992.comp_349()).method_8049().stream().anyMatch(a -> a.method_5578() == ampl && a.method_5584() == duration && a.method_5579() == effect)) {
            return class_1847.field_8992;
        }
        if (((class_1842)class_1847.field_9003.comp_349()).method_8049().stream().anyMatch(a -> a.method_5578() == ampl && a.method_5584() == duration && a.method_5579() == effect)) {
            return class_1847.field_9003;
        }
        return class_1847.field_8999;
    }

    public static Pair<class_1799, class_6880<class_1842>> findLifesavingPotions(List<class_1799> inventoryContents, class_1309 entity) {
        boolean withFire = (entity.method_5809() || entity.method_5771()) && !entity.method_6059(class_1294.field_5918);
        List<class_6880<class_1291>> acceptableEffects = WolfInventoryHelper.getLifeSavingEffects(withFire);
        Set actives = entity.method_6026().stream().map(class_1293::method_5579).collect(Collectors.toSet());
        List<class_6880<class_1291>> filtered = acceptableEffects.stream().filter(e -> actives.stream().noneMatch(a -> a.method_40225((class_5321)e.method_40230().get()))).toList();
        return WolfInventoryHelper.findPotions(inventoryContents, filtered);
    }

    private static Pair<class_1799, class_6880<class_1842>> findPotions(List<class_1799> inventoryContents, List<class_6880<class_1291>> statusEffects) {
        for (class_6880<class_1291> statusEffect : statusEffects) {
            Pair<class_1799, class_6880<class_1842>> potion = WolfInventoryHelper.findPotion(inventoryContents, statusEffect);
            if (((class_1799)potion.first).method_7960()) continue;
            return potion;
        }
        return Pair.of(class_1799.field_8037, class_1847.field_8999);
    }

    public static class_6880<class_1842> getPotionOfStack(class_1799 stack, class_6880<class_1291> statusEffect) {
        if (stack.method_7960()) {
            return class_1847.field_8999;
        }
        class_1844 potion_ = (class_1844)stack.method_58694(class_9334.field_49651);
        int ampl = 0;
        int duration = 0;
        for (class_1293 instance : potion_.method_57397()) {
            ampl = instance.method_5578();
            duration = instance.method_5584();
        }
        return WolfInventoryHelper.getPotion(statusEffect, ampl, duration);
    }

    private static Pair<class_1799, class_6880<class_1842>> findPotion(List<class_1799> inventoryContents, class_6880<class_1291> statusEffect) {
        class_1799 stack = inventoryContents.stream().filter(itemStack -> !itemStack.method_7960() && itemStack.method_57826(class_9334.field_49651)).filter(itemStack -> {
            class_1844 potion = (class_1844)itemStack.method_58694(class_9334.field_49651);
            return StreamSupport.stream(potion.method_57397().spliterator(), false).anyMatch(effect -> effect.method_5579() == statusEffect);
        }).max(Comparator.comparing(itemStack -> {
            class_1844 potion = (class_1844)itemStack.method_58694(class_9334.field_49651);
            return StreamSupport.stream(potion.method_57397().spliterator(), false).filter(effect -> effect.method_5579() == statusEffect).mapToInt(class_1293::method_5578).max().orElse(0);
        })).orElse(class_1799.field_8037);
        class_6880<class_1842> actualPotion = WolfInventoryHelper.getPotionOfStack(stack, statusEffect);
        return Pair.of(stack, actualPotion);
    }
}

