/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import github.meloweh.wolfcompanion.WolfCompanion;
import github.meloweh.wolfcompanion.util.WolfConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "wolf_config.json");
    private static final Set<class_1299<?>> TYPES = new HashSet();
    private static final Set<class_6862<class_1299<?>>> TAGS = new HashSet();
    public static WolfConfig config = new WolfConfig();

    public static void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            try (InputStream input = WolfCompanion.class.getResourceAsStream("/wolf_config.json");){
                Files.copy(input, CONFIG_FILE.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (WolfConfig)GSON.fromJson((Reader)reader, WolfConfig.class);
                System.out.println("Config loaded: " + String.valueOf(config));
            }
            catch (IOException e) {
                e.printStackTrace();
                ConfigManager.saveConfig();
            }
        } else {
            ConfigManager.saveConfig();
        }
        ConfigManager.reload(ConfigManager.config.doNotAttackMobs);
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
            System.out.println("Config saved: " + String.valueOf(config));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload(List<String> entries) {
        TYPES.clear();
        TAGS.clear();
        for (String s : entries) {
            class_2960 id;
            if (s.startsWith("#")) {
                id = class_2960.method_12829((String)s.substring(1));
                if (id == null) continue;
                TAGS.add(class_6862.method_40092((class_5321)class_7923.field_41177.method_46765(), (class_2960)id));
                continue;
            }
            id = class_2960.method_12829((String)s);
            if (id == null) continue;
            TYPES.add((class_1299)class_7923.field_41177.method_63535(id));
        }
    }

    public static boolean isBlacklisted(class_1297 attacker) {
        class_1299 t = attacker.method_5864();
        if (TYPES.contains(t)) {
            return true;
        }
        for (class_6862<class_1299<?>> tag : TAGS) {
            if (!t.method_20210(tag)) continue;
            return true;
        }
        return false;
    }
}

