/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion.mixin;

import github.meloweh.wolfcompanion.accessor.EntityAccessor;
import github.meloweh.wolfcompanion.accessor.MobEntityAccessor;
import github.meloweh.wolfcompanion.accessor.ServerPlayerAccessor;
import github.meloweh.wolfcompanion.accessor.WolfEntityMixinProvider;
import github.meloweh.wolfcompanion.accessor.WolfEntityProvider;
import github.meloweh.wolfcompanion.accessor.WolfXpProvider;
import github.meloweh.wolfcompanion.goals.EatFoodGoal;
import github.meloweh.wolfcompanion.goals.PickUpFoodGoal;
import github.meloweh.wolfcompanion.goals.RescueOwnerFromLavaGoal;
import github.meloweh.wolfcompanion.goals.RescueSelfFromLavaGoal;
import github.meloweh.wolfcompanion.goals.WolfMeleeAttackGoal;
import github.meloweh.wolfcompanion.init.InitItem;
import github.meloweh.wolfcompanion.network.UuidPayload;
import github.meloweh.wolfcompanion.screenhandler.WolfInventoryScreenHandler;
import github.meloweh.wolfcompanion.util.ConfigManager;
import github.meloweh.wolfcompanion.util.LineScan;
import github.meloweh.wolfcompanion.util.NBTHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_10209;
import net.minecraft.class_10583;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1493;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3908;
import net.minecraft.class_5134;
import net.minecraft.class_5218;
import net.minecraft.class_6025;
import net.minecraft.class_7225;
import net.minecraft.class_7248;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import net.minecraft.class_9331;
import net.minecraft.class_9381;
import net.minecraft.class_9699;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1493.class})
public abstract class WolfEntityMixin
implements class_1265,
class_7248,
class_6025,
WolfEntityProvider,
EntityAccessor,
MobEntityAccessor,
ExtendedScreenHandlerFactory<UuidPayload>,
WolfXpProvider,
WolfEntityMixinProvider {
    @Unique
    protected class_1277 items;
    @Unique
    private class_1493 self;
    @Unique
    private Optional<class_1542> targetPickup = Optional.empty();
    @Shadow
    private boolean field_6944;
    @Shadow
    private boolean field_6951;
    @Shadow
    private float field_6947;
    @Shadow
    private float field_6945;
    @Unique
    private static final class_2940<Boolean> CHEST = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> DROP_CHEST = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> RELEASE_WOLF = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Byte> SHAKE_REASON = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13319);
    @Unique
    private static final class_2940<Integer> XP = class_2945.method_12791(class_1493.class, (class_2941)class_2943.field_13327);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructor(CallbackInfo info) {
        this.self = (class_1493)this;
        this.onChestedStatusChanged();
    }

    @Override
    public void setTargetPickup__(class_1542 entity) {
        this.targetPickup = entity == null ? Optional.empty() : Optional.of(entity);
    }

    @Override
    public Optional<class_1542> getTargetPickup__() {
        return this.targetPickup;
    }

    @ModifyArg(method={"initGoals"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/GoalSelector;add(ILnet/minecraft/entity/ai/goal/Goal;)V", ordinal=5), index=1)
    private class_1352 f(class_1352 goal) {
        if (this.self == null) {
            this.self = (class_1493)this;
        }
        return new WolfMeleeAttackGoal(this.self, 1.5, true);
    }

    @Inject(method={"initGoals"}, at={@At(value="TAIL")})
    private void onInitGoals(CallbackInfo info) {
        if (this.self == null) {
            this.self = (class_1493)this;
        }
        ((MobEntityAccessor)this.self).getGoalSelector().method_6277(1, (class_1352)new RescueOwnerFromLavaGoal(this.self, 1.75, 2.5f, 7.0f));
        ((MobEntityAccessor)this.self).getGoalSelector().method_6277(1, (class_1352)new RescueSelfFromLavaGoal(this.self));
        ((MobEntityAccessor)this.self).getGoalSelector().method_6277(2, (class_1352)new EatFoodGoal(this.self));
        ((MobEntityAccessor)this.self).getGoalSelector().method_6277(9, (class_1352)new PickUpFoodGoal(this.self));
    }

    @Unique
    private void doWolfShake() {
        this.field_6944 = true;
        if (!this.self.method_37908().field_9236) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    public void writeToPlayerSaveFile(File playerDataFolder, UUID playerUUID, class_2487 wolfNbt) {
        File playerFile = new File(playerDataFolder, playerUUID.toString() + ".dat");
        if (playerFile.exists()) {
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileInputStream = new FileInputStream(playerFile);
                class_2487 nbt = class_2507.method_10629((InputStream)fileInputStream, (class_2505)class_2505.method_53898());
                int i = 0;
                while (nbt.method_10545("SavedWolfData" + i)) {
                    ++i;
                }
                nbt.method_10566("SavedWolfData" + i, (class_2520)wolfNbt);
                fileOutputStream = new FileOutputStream(playerFile);
                class_2507.method_10634((class_2487)nbt, (OutputStream)fileOutputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            System.out.println("File does not exist");
        }
    }

    @ModifyArg(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;addParticleClient(Lnet/minecraft/particle/ParticleEffect;DDDDDD)V"))
    private class_2394 changeType(class_2394 parameters) {
        byte shakeReason = this.getShakeReason();
        return switch (shakeReason) {
            case 1 -> class_9381.method_58255((class_2396)class_2398.field_11226, (float)0.529f, (float)0.639f, (float)0.388f);
            case 2 -> class_2398.field_11251;
            default -> class_2398.field_11202;
        };
    }

    @Unique
    public boolean isPoisoned(class_1493 wolf) {
        Map effects = wolf.method_6088();
        return effects.keySet().stream().anyMatch(effect -> effect == class_1294.field_5899);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void shakeConditions(CallbackInfo ci) {
        if (this.self.method_5805() && !this.self.method_37908().field_9236) {
            int shakeReason = 0;
            if (!this.field_6944 && this.getShakeReason() == 0) {
                if (ConfigManager.config.canShakeOffPoison && this.isPoisoned(this.self)) {
                    shakeReason = 1;
                }
                if (ConfigManager.config.canShakeOffFire && this.self.method_5809() && !this.self.method_5771() && this.self.method_24828()) {
                    shakeReason = 2;
                }
                if (this.getShakeReason() > 0) {
                    this.setShakeReason((byte)0);
                }
                if (shakeReason > 0) {
                    this.doWolfShake();
                    this.setShakeReason((byte)shakeReason);
                }
            }
            if (this.getShakeReason() > 0 && this.field_6945 >= 1.8f) {
                this.setShakeReason((byte)0);
                if (this.isPoisoned(this.self)) {
                    this.self.method_6016(class_1294.field_5899);
                } else if (this.self.method_5809()) {
                    this.self.method_20803(0);
                }
            }
        }
        if (this.self.method_5968() != null && this.self.method_6065() == null && !this.self.method_24828() && !this.self.method_6510() && LineScan.hasFloorLava((class_1309)this.self)) {
            this.self.method_5980((class_1309)null);
            this.self.method_18799(this.self.method_18798().method_18805(-1.0, this.self.method_18798().method_10214(), -1.0));
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void cancelDeath(class_1282 damageSource, CallbackInfo ci) {
        if (this.self.method_6181() && !this.self.method_37908().field_9236 && ConfigManager.config.canRespawn) {
            class_11362 writeView = class_11362.method_71458((class_8942)class_8942.field_60348);
            this.self.method_5647((class_11372)writeView);
            class_2487 wolfNbt = writeView.method_71475();
            class_11368 nbtReadView = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)this.self.method_56673(), (class_2487)wolfNbt);
            this.wolfcompanion_template_1_21_1$dropInventoryByButton();
            if (this.self.method_35057() != null) {
                ServerPlayerAccessor playerAccessor = (ServerPlayerAccessor)this.self.method_35057();
                playerAccessor.queueRescuedWolfNbt__(wolfNbt);
            } else if (wolfNbt.method_10545("Owner")) {
                class_10583 lazyEntityReference = class_10583.method_66260((class_11368)nbtReadView, (String)"Owner", (class_1937)this.method_37908());
                if (lazyEntityReference == null) {
                    System.out.println("ERROR: Could not retrieve lazyEntityReference for wolf.");
                } else {
                    UUID ownerUUID = lazyEntityReference.method_66263();
                    if (this.self.method_5682() == null) {
                        System.out.println("ERROR: Server for cancelling wolf deletion not found");
                    } else {
                        File worldDirectory = this.self.method_5682().method_27050(class_5218.field_24188).toFile();
                        File playerDatFolder = new File(worldDirectory, "playerdata");
                        this.writeToPlayerSaveFile(playerDatFolder, ownerUUID, wolfNbt);
                    }
                }
            } else {
                System.out.println("What happened? A wolves owner got obscured. Good bye, you have been a good companion :(");
            }
        }
    }

    @Override
    public class_1277 wolfcompanion_template_1_21_1$getItemsInventory() {
        return this.items;
    }

    @Unique
    public final int getInventorySize() {
        return WolfEntityMixin.getInventorySize(this.getInventoryColumns());
    }

    @Unique
    private static int getInventorySize(int columns) {
        return columns * 3 + 1;
    }

    @Unique
    protected void onChestedStatusChanged() {
        class_1277 simpleInventory = this.items;
        this.items = new class_1277(this.getInventorySize());
        if (simpleInventory != null) {
            simpleInventory.method_5488((class_1265)this);
            int i = org.joml.Math.min((int)simpleInventory.method_5439(), (int)this.items.method_5439());
            for (int j = 0; j < i; ++j) {
                class_1799 itemStack = simpleInventory.method_5438(j);
                if (itemStack.method_7960()) continue;
                this.items.method_5447(j, itemStack.method_7972());
            }
        }
        this.items.method_5489((class_1265)this);
        this.items.method_5431();
    }

    @Override
    public class_1277 getInventory() {
        return this.items;
    }

    public void method_5453(class_1263 sender) {
    }

    @Unique
    public WolfEntityMixin getThis() {
        return this;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new WolfInventoryScreenHandler(syncId, playerInventory, this.self, NBTHelper.getWolfNBT(this.self));
    }

    public UuidPayload getScreenOpeningData(class_3222 player) {
        return new UuidPayload(this.self.method_5667(), NBTHelper.getWolfNBT(this.self));
    }

    @Unique
    public void openWolfInventory(class_3222 player, WolfEntityMixin wolfEntityMixin, class_1263 inventory) {
        player.method_17355((class_3908)this);
    }

    public void method_6722(class_1657 player) {
        if (!this.self.method_37908().field_9236) {
            this.openWolfInventory((class_3222)player, this, (class_1263)player.method_31548());
        }
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    protected void injectInitDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(CHEST, (Object)false);
        builder.method_56912(DROP_CHEST, (Object)false);
        builder.method_56912(RELEASE_WOLF, (Object)false);
        builder.method_56912(SHAKE_REASON, (Object)0);
        builder.method_56912(XP, (Object)0);
    }

    @Unique
    private float getKnockbackAgainst(class_1297 target, class_1282 damageSource) {
        float f = (float)this.self.method_45325(class_5134.field_23722);
        class_1937 var5 = this.self.method_37908();
        if (var5 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)var5;
            return class_1890.method_60175((class_3218)serverWorld, (class_1799)this.self.method_59958(), (class_1297)target, (class_1282)damageSource, (float)f);
        }
        return f;
    }

    @Override
    public boolean tryAttack__(class_3218 world, class_1297 target) {
        boolean bl;
        float f = (float)this.self.method_45325(class_5134.field_23721) + (float)this.getLevel() * 0.5f;
        class_1799 itemStack = this.self.method_59958();
        class_1282 damageSource = Optional.ofNullable(itemStack.method_7909().method_64193((class_1309)this.self)).orElse(this.self.method_48923().method_48812((class_1309)this.self));
        f = class_1890.method_60120((class_3218)world, (class_1799)itemStack, (class_1297)target, (class_1282)damageSource, (float)f);
        if (bl = target.method_64397(world, damageSource, f += itemStack.method_7909().method_58403(target, f, damageSource))) {
            class_1309 livingEntity;
            float g = this.getKnockbackAgainst(target, damageSource);
            if (g > 0.0f && target instanceof class_1309) {
                livingEntity = (class_1309)target;
                livingEntity.method_6005((double)(g * 0.5f), (double)class_3532.method_15374((float)(this.self.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.self.method_36454() * ((float)Math.PI / 180)))));
                this.self.method_18799(this.self.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            if (target instanceof class_1309) {
                livingEntity = (class_1309)target;
                itemStack.method_7979(livingEntity, (class_1309)this.self);
            }
            class_1890.method_60107((class_3218)world, (class_1297)target, (class_1282)damageSource);
            this.self.method_6114(target);
        }
        return bl;
    }

    @Unique
    private class_2945 getDataTracker(class_1493 wolf) {
        return this.self.method_5841();
    }

    @Unique
    public boolean hasChest() {
        return (Boolean)this.getDataTracker(this.self).method_12789(CHEST);
    }

    @Override
    public boolean shouldDropChest() {
        return (Boolean)this.getDataTracker(this.self).method_12789(DROP_CHEST);
    }

    @Override
    public boolean shouldReleaseWolf() {
        return (Boolean)this.getDataTracker(this.self).method_12789(RELEASE_WOLF);
    }

    @Override
    public boolean hasChestEquipped() {
        return this.hasChest();
    }

    @Unique
    public void setHasChest(boolean hasChest) {
        this.getDataTracker(this.self).method_12778(CHEST, (Object)hasChest);
    }

    @Override
    public void setShouldDropChest(boolean yes) {
        this.getDataTracker(this.self).method_12778(DROP_CHEST, (Object)yes);
    }

    @Override
    public void setShouldReleaseWolf(boolean yes) {
        this.getDataTracker(this.self).method_12778(RELEASE_WOLF, (Object)yes);
    }

    @Unique
    public void setShakeReason(byte value) {
        this.getDataTracker(this.self).method_12778(SHAKE_REASON, (Object)value);
    }

    @Unique
    public byte getShakeReason() {
        return (Byte)this.getDataTracker(this.self).method_12789(SHAKE_REASON);
    }

    @Override
    public void setXp(int value) {
        this.getDataTracker(this.self).method_12778(XP, (Object)value);
    }

    @Override
    public int getXp() {
        return (Integer)this.getDataTracker(this.self).method_12789(XP);
    }

    @Override
    public int getLevel() {
        int xp = this.getXp();
        float level = 0.5f * (org.joml.Math.sqrt((float)(2 * xp + 1)) - 1.0f);
        return (int)level;
    }

    @Override
    public int getNextLevelXpRequirement(int level) {
        return 2 * level * level + 2 * level;
    }

    @Override
    public int getDeltaXp() {
        int xp = this.getXp();
        int level = this.getLevel();
        int requiredXp = this.getNextLevelXpRequirement(level + 1);
        return requiredXp - xp;
    }

    @Override
    @Unique
    public void addXp(int value) {
        this.getDataTracker(this.self).method_12778(XP, (Object)(this.getXp() + value));
    }

    @Override
    public int repairGear(int amount) {
        Optional optional = class_1890.method_8204((class_9331)class_9701.field_51652, (class_1309)this.self, class_1799::method_7986);
        if (optional.isPresent()) {
            int k;
            class_1799 itemStack = ((class_9699)optional.get()).comp_2682();
            int i = class_1890.method_60168((class_3218)((class_3218)this.self.method_37908()), (class_1799)itemStack, (int)amount);
            int j = Math.min(i, itemStack.method_7919());
            itemStack.method_7974(itemStack.method_7919() - j);
            if (j > 0 && (k = amount - j * amount / i) > 0) {
                return this.repairGear(k);
            }
            return 0;
        }
        return amount;
    }

    @Override
    public void releaseWolfButton() {
        this.setShouldDropChest(true);
        this.wolfcompanion_template_1_21_1$dropInventoryByButton();
        if (this.self.method_35057() != null) {
            this.self.method_6173(false, true);
            this.self.method_6174((class_1309)null);
        }
    }

    @Override
    public void wolfcompanion_template_1_21_1$dropInventoryByButton() {
        if (this.shouldDropChest() || !ConfigManager.config.keepWolfInventory) {
            if (this.items != null) {
                for (int i = this.items.method_5439(); i >= 0; --i) {
                    class_1799 itemStack = this.items.method_5438(i);
                    if (itemStack.method_7960() || this.self.method_6118(class_1304.field_48824) == itemStack) continue;
                    this.items.method_5441(i);
                    this.self.method_5775((class_3218)this.self.method_37908(), itemStack);
                }
            }
            if (this.hasChest() && (this.shouldDropChest() || !ConfigManager.config.keepWolfBag)) {
                if (!this.self.method_37908().field_9236) {
                    this.self.method_5706((class_3218)this.self.method_37908(), (class_1935)InitItem.ITEM_WOLF_BAG);
                }
                this.setHasChest(false);
            }
            this.setShouldDropChest(false);
        }
    }

    public void dropInventory() {
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelPlayerDamage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_5529() instanceof class_1657 && this.self.method_6181()) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    private void injectWriteCustomDataToNbt(class_11372 view, CallbackInfo ci) {
        view.method_71472("ChestedWolf", this.hasChest());
        if (this.hasChest()) {
            class_11372.class_11373 listAppender = view.method_71467("Items", class_11343.field_60354);
            for (int i = 0; i < this.items.method_5439(); ++i) {
                class_1799 itemStack = this.items.method_5438(i);
                if (itemStack.method_7960()) continue;
                listAppender.method_71484((Object)new class_11343(i, itemStack));
            }
        }
        view.method_71477("CustomName", class_8824.field_46597, (Object)this.self.method_5797());
        if (this.self.method_5807()) {
            view.method_71472("CustomNameVisible", this.self.method_5807());
        }
        view.method_71465("XP", this.getXp());
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(class_11368 view, CallbackInfo ci) {
        this.setHasChest(view.method_71433("ChestedWolf", false));
        this.onChestedStatusChanged();
        if (this.hasChest()) {
            for (class_11343 stackWithSlot : view.method_71437("Items", class_11343.field_60354)) {
                if (!stackWithSlot.method_71368(this.items.method_5439())) continue;
                this.items.method_5447(stackWithSlot.comp_4211(), stackWithSlot.comp_4212());
            }
        }
        this.self.method_5665((class_2561)view.method_71426("CustomName", class_8824.field_46597).orElse(null));
        this.self.method_5880(view.method_71433("CustomNameVisible", false));
        this.setXp(view.method_71424("XP", 0));
    }

    @Unique
    private void addChest(class_1657 player, class_1799 chest) {
        this.setHasChest(true);
        this.playAddChestSound();
        chest.method_57008(1, (class_1309)player);
        this.onChestedStatusChanged();
    }

    @Unique
    protected void playAddChestSound() {
        this.self.method_5783(class_3417.field_14598, 1.0f, (this.self.method_59922().method_43057() - this.self.method_59922().method_43057()) * 0.2f + 1.0f);
    }

    @Unique
    public int getInventoryColumns() {
        return 5;
    }

    @Unique
    private class_1277 getReducedInventory() {
        class_1277 inv = new class_1277(15);
        for (int i = 1; i < this.items.method_5439(); ++i) {
            inv.method_5447(i - 1, this.items.method_5438(i));
        }
        return inv;
    }

    @Unique
    private void transferReducedInventory(class_1277 inv) {
        for (int i = 1; i < this.items.method_5439(); ++i) {
            this.items.method_5447(i, inv.method_5438(i - 1));
        }
    }

    @Unique
    private void dropItem(class_1799 stack) {
        class_1542 itemEntity = new class_1542(this.self.method_37908(), this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), stack);
        this.self.method_37908().method_8649((class_1297)itemEntity);
    }

    @Override
    public void spit__(class_1799 stack) {
        if (!stack.method_7960() && !this.self.method_37908().field_9236) {
            class_1542 itemEntity = new class_1542(this.self.method_37908(), this.self.method_23317() + this.self.method_5720().field_1352, this.self.method_23318() + 1.0, this.self.method_23321() + this.self.method_5720().field_1350, stack);
            itemEntity.method_6982(40);
            itemEntity.method_6981((class_1297)this.self);
            this.self.method_5783(class_3417.field_18054, 1.0f, 1.0f);
            this.self.method_37908().method_8649((class_1297)itemEntity);
        }
    }

    @Unique
    private void loot__(class_1542 item) {
        class_1799 itemStack = item.method_6983();
        if (!itemStack.method_7960()) {
            if (this.hasChestEquipped()) {
                if (this.items.method_27070(itemStack)) {
                    this.self.method_29499(item);
                    class_1277 reducedInventory = this.getReducedInventory();
                    class_1799 itemStack2 = reducedInventory.method_5491(itemStack);
                    this.transferReducedInventory(reducedInventory);
                    int transfered = itemStack.method_7947() - itemStack2.method_7947();
                    this.self.method_6103((class_1297)item, transfered);
                    itemStack.method_7934(transfered);
                    if (itemStack.method_7960()) {
                        item.method_31472();
                    }
                    this.items.method_5488((class_1265)this);
                    this.items.method_5489((class_1265)this);
                    this.items.method_5431();
                }
            } else {
                int i = itemStack.method_7947();
                if (i > 1) {
                    this.dropItem(itemStack.method_7971(i - 1));
                }
                this.spit__(this.self.method_6118(class_1304.field_6173));
                this.self.method_29499(item);
                this.self.method_5673(class_1304.field_6173, itemStack.method_7971(1));
                this.self.method_6103((class_1297)item, itemStack.method_7947());
                item.method_31472();
            }
        }
    }

    @Inject(method={"tickMovement"}, at={@At(value="TAIL")})
    private void onTickMovement(CallbackInfo ci) {
        if (this.targetPickup.isPresent() && !this.self.method_37908().field_9236 && this.self.method_5805() && !this.self.method_29504() && ((class_3218)this.self.method_37908()).method_64395().method_8355(class_1928.field_19388)) {
            class_3695 profiler = class_10209.method_64146();
            profiler.method_15396("looting");
            class_2382 vec3i = ((MobEntityAccessor)this.self).getItemPickUpRangeExpander__();
            List<class_1542> list = this.method_37908().method_18467(class_1542.class, this.self.method_5829().method_1009((double)vec3i.method_10263(), (double)vec3i.method_10264(), (double)vec3i.method_10260())).stream().filter(e -> e == this.targetPickup.get()).toList();
            for (class_1542 itemEntity : list) {
                if (itemEntity.method_31481() || itemEntity.method_6983().method_7960() || itemEntity.method_6977() || !this.self.method_20820((class_3218)this.self.method_37908(), itemEntity.method_6983())) continue;
                this.loot__(itemEntity);
            }
            profiler.method_15407();
        }
    }

    @Unique
    private class_241 vecFromYaw(float yaw) {
        float rad = org.joml.Math.toRadians((float)yaw);
        return new class_241(-class_3532.method_15374((float)rad), class_3532.method_15362((float)rad));
    }

    @Inject(method={"handleStatus"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleStatus(byte status, CallbackInfo ci) {
        if (status == 45) {
            class_1799 itemStack = this.self.method_6118(class_1304.field_6173);
            class_241 vec = this.vecFromYaw(this.self.field_6283).method_35581();
            if (!itemStack.method_7960()) {
                for (int i = 0; i < 8; ++i) {
                    class_243 vec3d = new class_243(((double)this.self.method_59922().method_43057() - 0.5) * 0.1, org.joml.Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.self.method_36455() * ((float)Math.PI / 180)).method_1024(-this.self.method_36454() * ((float)Math.PI / 180));
                    this.self.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, itemStack), this.self.method_23317() + (double)vec.field_1343 * 0.6, this.self.method_23318() + 0.6, this.self.method_23321() + (double)vec.field_1342 * 0.6, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
                }
            }
            ci.cancel();
        }
    }

    @Inject(method={"interactMob"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRightClick(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (!player.method_37908().method_8608() && hand == class_1268.field_5808 && this.self.method_6181() && this.self.method_6171((class_1309)player) && !this.self.method_6109()) {
            class_1799 itemStack = player.method_5998(hand);
            if (!this.hasChest() && itemStack.method_31574(InitItem.ITEM_WOLF_BAG)) {
                this.addChest(player, itemStack);
                class_1269.class_9860 result = this.self.method_37908().field_9236 ? class_1269.field_5812 : class_1269.field_52422;
                cir.setReturnValue((Object)result);
                cir.cancel();
            } else if (player.method_5715()) {
                this.method_6722(player);
                class_1269.class_9860 result = this.self.method_37908().field_9236 ? class_1269.field_5812 : class_1269.field_52422;
                cir.setReturnValue((Object)result);
                cir.cancel();
            }
        }
    }
}

