/*
 * Decompiled with CFR 0.152.
 */
package github.meloweh.wolfcompanion;

import github.meloweh.wolfcompanion.accessor.WolfEntityProvider;
import github.meloweh.wolfcompanion.events.WolfEventHandler;
import github.meloweh.wolfcompanion.init.InitBlock;
import github.meloweh.wolfcompanion.init.InitItem;
import github.meloweh.wolfcompanion.init.InitSound;
import github.meloweh.wolfcompanion.init.ScreenHandlerTypeInit;
import github.meloweh.wolfcompanion.network.DropWolfChestC2SPayload;
import github.meloweh.wolfcompanion.network.ReleaseWolfC2SPayload;
import github.meloweh.wolfcompanion.util.ConfigManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WolfCompanion
implements ModInitializer {
    public static final String MOD_ID = "wolfcompanion";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wolfcompanion");
    public static final String CUSTOM_INVENTORY_UPDATE_ID = "custom_inventory_update";
    public static class_5455 dynamicRegistryManager;

    public void onInitialize() {
        LOGGER.info("Loading...");
        ConfigManager.loadConfig();
        InitItem.load();
        InitBlock.load();
        InitSound.load();
        ScreenHandlerTypeInit.load();
        WolfEventHandler.init();
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            dynamicRegistryManager = minecraftServer.method_30611();
        });
        PayloadTypeRegistry.playC2S().register(DropWolfChestC2SPayload.ID, DropWolfChestC2SPayload.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(ReleaseWolfC2SPayload.ID, ReleaseWolfC2SPayload.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(DropWolfChestC2SPayload.ID, (payload, context) -> context.server().execute(() -> context.server().method_3738().forEach(serverWorld -> {
            class_1297 entity = serverWorld.method_66347(payload.wolfUUID());
            if (entity != null) {
                class_1493 wolf = (class_1493)entity;
                WolfEntityProvider provider = (WolfEntityProvider)wolf;
                provider.setShouldDropChest(true);
                class_1309 owner = wolf.method_35057();
                if (owner instanceof class_3222) {
                    ((class_3222)owner).method_7346();
                }
                provider.wolfcompanion_template_1_21_1$dropInventoryByButton();
            }
        })));
        ServerPlayNetworking.registerGlobalReceiver(ReleaseWolfC2SPayload.ID, (payload, context) -> context.server().execute(() -> context.server().method_3738().forEach(serverWorld -> {
            class_1297 entity = serverWorld.method_66347(payload.wolfUUID());
            if (entity != null) {
                class_1493 wolf = (class_1493)entity;
                WolfEntityProvider provider = (WolfEntityProvider)wolf;
                provider.setShouldReleaseWolf(true);
                class_1309 owner = wolf.method_35057();
                if (owner instanceof class_3222) {
                    ((class_3222)owner).method_7346();
                }
                provider.releaseWolfButton();
            }
        })));
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static boolean isSameEnchantment(class_1887 enchantment, class_5321<class_1887> enchantmentRegistryKey) {
        if (dynamicRegistryManager == null) {
            System.out.println("ERROR: dynamic registry manager was null");
            return false;
        }
        class_2378 enchantmentRegistry = dynamicRegistryManager.method_30530(class_7924.field_41265);
        class_6880 enchantmentEntry = enchantmentRegistry.method_47983((Object)enchantment);
        return enchantmentEntry != null && enchantmentEntry.method_40225(enchantmentRegistryKey);
    }
}

