/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.parsers;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.blancworks.figura.FiguraMod;
import net.minecraft.class_1160;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class FiguraAvatarSerializer {
    public static final HashMap<String, class_1160> PLAYER_MODEL_OFFSETS = new HashMap<String, class_1160>(){
        {
            this.put("Head", new class_1160(0.0f, 24.0f, 0.0f));
            this.put("Body", new class_1160(0.0f, 24.0f, 0.0f));
            this.put("LeftArm", new class_1160(-5.0f, 22.0f, 0.0f));
            this.put("RightArm", new class_1160(5.0f, 22.0f, 0.0f));
            this.put("LeftLeg", new class_1160(-2.0f, 12.0f, 0.0f));
            this.put("RightLeg", new class_1160(2.0f, 12.0f, 0.0f));
        }
    };

    public static String serialize(class_2487 nbt) {
        try {
            int success;
            int stuff;
            block32: {
                String fileName = "avatar-" + new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss").format(new Date());
                Path rootFolder = FiguraMod.getModContentDirectory().resolve("model_files/[\u00a79Figura\u00a7r] Saved Avatars");
                Path dest = rootFolder.resolve(Path.of(fileName, new String[0]));
                if (!Files.exists(dest, new LinkOption[0])) {
                    Files.createDirectories(dest, new FileAttribute[0]);
                }
                boolean hasTexture = false;
                stuff = 0;
                success = 0;
                try {
                    if (nbt.method_10545("script")) {
                        String source;
                        ++stuff;
                        Path script = dest.resolve("script.lua");
                        class_2487 tag = nbt.method_10562("script");
                        Set keys = tag.method_10541();
                        if (keys.size() <= 1) {
                            source = tag.method_10558("src");
                        } else {
                            StringBuilder src = new StringBuilder();
                            for (int i = 0; i < keys.size(); ++i) {
                                src.append(tag.method_10558("src_" + i));
                            }
                            source = src.toString();
                        }
                        Files.writeString(script, (CharSequence)source, new OpenOption[0]);
                        ++success;
                    }
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error((Object)e);
                }
                try {
                    if (nbt.method_10545("sounds")) {
                        ++stuff;
                        Path sounds = dest.resolve("sounds.json");
                        Path soundFolder = dest.resolve("sounds");
                        class_2487 tag = nbt.method_10562("sounds");
                        JsonArray soundsList = new JsonArray();
                        if (!Files.exists(soundFolder, new LinkOption[0])) {
                            Files.createDirectories(soundFolder, new FileAttribute[0]);
                        }
                        Set keys = tag.method_10541();
                        for (String s : keys) {
                            soundsList.add(s);
                            Path sound = soundFolder.resolve(s + ".ogg");
                            Files.write(sound, tag.method_10547(s), new OpenOption[0]);
                        }
                        String jsonString = new GsonBuilder().create().toJson((JsonElement)soundsList);
                        Files.writeString(sounds, (CharSequence)jsonString, new OpenOption[0]);
                        ++success;
                    }
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error((Object)e);
                }
                try {
                    if (nbt.method_10545("texture")) {
                        ++stuff;
                        class_2487 tag = nbt.method_10562("texture");
                        Object type = tag.method_10558("type");
                        if (((String)type).equals("color")) {
                            type = "";
                        }
                        Path texture = dest.resolve("texture" + (String)type + ".png");
                        Files.write(texture, tag.method_10547("img2"), new OpenOption[0]);
                        hasTexture = true;
                        ++success;
                    }
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error((Object)e);
                }
                try {
                    if (nbt.method_10545("exTexs")) {
                        ++stuff;
                        class_2499 list = nbt.method_10554("exTexs", 10);
                        for (class_2487 tag : list) {
                            String type = tag.method_10558("type");
                            if (type.equals("color")) {
                                type = "";
                            }
                            Path texture = dest.resolve("texture" + type + ".png");
                            Files.write(texture, tag.method_10547("img2"), new OpenOption[0]);
                        }
                        ++success;
                    }
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error((Object)e);
                }
                try {
                    if (!nbt.method_10545("model")) break block32;
                    ++stuff;
                    JsonObject model = new JsonObject();
                    class_2499 list = nbt.method_10562("model").method_10554("parts", 10);
                    JsonObject meta = new JsonObject();
                    meta.addProperty("format_version", "4.0");
                    meta.addProperty("creation_time", (Number)System.currentTimeMillis());
                    meta.addProperty("model_format", "free");
                    meta.addProperty("box_uv", Boolean.valueOf(false));
                    model.add("meta", (JsonElement)meta);
                    model.addProperty("name", "");
                    model.addProperty("geometry_name", "");
                    JsonArray box = new JsonArray();
                    box.add((Number)1);
                    box.add((Number)1);
                    box.add((Number)0);
                    model.add("visible_box", (JsonElement)box);
                    if (hasTexture) {
                        JsonArray textures = new JsonArray();
                        JsonObject texture = new JsonObject();
                        byte[] data = nbt.method_10562("texture").method_10547("img2");
                        texture.addProperty("path", dest.resolve("texture.png").toString());
                        texture.addProperty("name", "texture.png");
                        texture.addProperty("folder", fileName);
                        texture.addProperty("namespace", "");
                        texture.addProperty("id", "0");
                        texture.addProperty("particle", Boolean.valueOf(false));
                        texture.addProperty("render_mode", "normal");
                        texture.addProperty("visible", Boolean.valueOf(true));
                        texture.addProperty("mode", "bitmap");
                        texture.addProperty("saved", Boolean.valueOf(true));
                        texture.addProperty("uuid", UUID.randomUUID().toString());
                        texture.addProperty("relative_path", "../texture.png");
                        texture.addProperty("source", "data:image/png;base64," + Base64.getEncoder().encodeToString(data));
                        textures.add((JsonElement)texture);
                        model.add("textures", (JsonElement)textures);
                    }
                    JsonObject resolution = new JsonObject();
                    class_2499 uv = nbt.method_10562("model").method_10554("uv", 5);
                    resolution.addProperty("width", (Number)Float.valueOf(uv.method_10604(0)));
                    resolution.addProperty("height", (Number)Float.valueOf(uv.method_10604(1)));
                    model.add("resolution", (JsonElement)resolution);
                    JsonArray animations = new JsonArray();
                    class_2520 animNbt = nbt.method_10562("model").method_10580("anim");
                    try {
                        if (animNbt != null) {
                            ++stuff;
                            for (class_2520 element : (class_2499)animNbt) {
                                class_2487 anim = (class_2487)element;
                                Iterator animObj = new JsonObject();
                                animObj.addProperty("name", anim.method_10558("nm"));
                                animObj.addProperty("loop", anim.method_10558("loop"));
                                animObj.addProperty("length", Float.valueOf(anim.method_10583("len")));
                                animObj.addProperty("anim_time_update", (String)(anim.method_10545("time") ? "" + anim.method_10583("time") : ""));
                                animObj.addProperty("blend_weight", (String)(anim.method_10545("bld") ? "" + anim.method_10583("bld") : ""));
                                animObj.addProperty("start_delay", (String)(anim.method_10545("sdel") ? "" + anim.method_10583("sdel") : ""));
                                animObj.addProperty("loop_delay", (String)(anim.method_10545("ldel") ? "" + anim.method_10583("ldel") : ""));
                                animObj.addProperty("uuid", UUID.randomUUID().toString());
                                animObj.addProperty("override", anim.method_10545("ovr") && anim.method_10577("ovr"));
                                animObj.addProperty("snapping", Float.valueOf(500.0f));
                                animObj.addProperty("selected", false);
                                animObj.add("animators", (JsonElement)new JsonObject());
                                animations.add((JsonElement)animObj);
                            }
                            ++success;
                        }
                    }
                    catch (Exception e) {
                        FiguraMod.LOGGER.error((Object)e);
                    }
                    boolean isPlayer = false;
                    JsonArray outliner = new JsonArray();
                    JsonArray elements = new JsonArray();
                    for (class_2520 tagElement : list) {
                        isPlayer = FiguraAvatarSerializer.parseModelPart((class_2487)tagElement, elements, outliner, animations, class_1160.field_29501.method_23850()) || isPlayer;
                    }
                    model.add("elements", (JsonElement)elements);
                    model.add("outliner", (JsonElement)outliner);
                    if (animNbt != null) {
                        model.add("animations", (JsonElement)animations);
                    }
                    String jsonString = new GsonBuilder().serializeNulls().create().toJson((JsonElement)model);
                    Files.writeString(dest.resolve((isPlayer ? "player_model" : "model") + ".bbmodel"), (CharSequence)jsonString, new OpenOption[0]);
                    ++success;
                }
                catch (Exception e) {
                    FiguraMod.LOGGER.error((Object)e);
                }
            }
            return success + " / " + stuff;
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error((Object)e);
            return null;
        }
    }

    public static boolean parseModelPart(class_2487 tag, JsonArray elements, JsonArray outliner, JsonArray animations, class_1160 offset) {
        String pt;
        boolean player = false;
        JsonObject part = new JsonObject();
        String name = tag.method_10545("nm") ? tag.method_10558("nm") : "element";
        part.addProperty("name", name);
        part.addProperty("rescale", Boolean.valueOf(false));
        part.addProperty("locked", Boolean.valueOf(false));
        part.addProperty("autouv", (Number)0);
        part.addProperty("color", (Number)((int)(Math.random() * 7.0) + 1));
        part.addProperty("visibility", Boolean.valueOf(!tag.method_10545("vb") || tag.method_10577("vb")));
        if (tag.method_10545("piv")) {
            JsonArray pivot = FiguraAvatarSerializer.nbtFloatListToJson(tag.method_10554("piv", 5));
            pivot.set(2, (JsonElement)new JsonPrimitive((Number)Float.valueOf(-pivot.get(2).getAsFloat())));
            FiguraAvatarSerializer.applyArrayOffset(pivot, offset);
            part.add("origin", (JsonElement)pivot);
        }
        if (tag.method_10545("rot")) {
            part.add("rotation", (JsonElement)FiguraAvatarSerializer.nbtFloatListToJson(tag.method_10554("rot", 5)));
        }
        String uuid = UUID.randomUUID().toString();
        part.addProperty("uuid", uuid);
        switch (pt = tag.method_10545("pt") ? tag.method_10558("pt") : "na") {
            case "cub": {
                class_2487 props = tag.method_10562("props");
                JsonObject faces = new JsonObject();
                if (props.method_10545("inf")) {
                    part.addProperty("inflate", (Number)Float.valueOf(props.method_10583("inf")));
                }
                JsonArray from = FiguraAvatarSerializer.nbtFloatListToJson(props.method_10554("f", 5));
                FiguraAvatarSerializer.applyArrayOffset(from, offset);
                part.add("from", (JsonElement)from);
                JsonArray to = FiguraAvatarSerializer.nbtFloatListToJson(props.method_10554("t", 5));
                FiguraAvatarSerializer.applyArrayOffset(to, offset);
                part.add("to", (JsonElement)to);
                faces.add("north", (JsonElement)FiguraAvatarSerializer.buildFaceData(props.method_10562("n")));
                faces.add("south", (JsonElement)FiguraAvatarSerializer.buildFaceData(props.method_10562("s")));
                faces.add("west", (JsonElement)FiguraAvatarSerializer.buildFaceData(props.method_10562("w")));
                faces.add("east", (JsonElement)FiguraAvatarSerializer.buildFaceData(props.method_10562("e")));
                faces.add("up", (JsonElement)FiguraAvatarSerializer.buildFaceData(props.method_10562("u")));
                faces.add("down", (JsonElement)FiguraAvatarSerializer.buildFaceData(props.method_10562("d")));
                part.add("faces", (JsonElement)faces);
                elements.add((JsonElement)part);
                outliner.add(uuid);
                break;
            }
            case "msh": {
                class_2487 props = tag.method_10562("props");
                part.addProperty("type", "mesh");
                JsonObject vertices = new JsonObject();
                class_2487 vertList = props.method_10562("vertices");
                for (String s : vertList.method_10541()) {
                    JsonArray vertex = FiguraAvatarSerializer.nbtFloatListToJson(vertList.method_10554(s, 5));
                    vertex.set(0, (JsonElement)new JsonPrimitive((Number)Float.valueOf(-vertex.get(0).getAsFloat())));
                    vertex.set(1, (JsonElement)new JsonPrimitive((Number)Float.valueOf(-vertex.get(1).getAsFloat())));
                    vertices.add(s, (JsonElement)vertex);
                }
                JsonObject faces = new JsonObject();
                class_2499 faceList = props.method_10554("faces", 9);
                int i = 0;
                for (class_2520 faceNbt : faceList) {
                    JsonObject face = new JsonObject();
                    face.addProperty("texture", (Number)Float.valueOf(0.0f));
                    JsonArray vert = new JsonArray();
                    JsonObject uv = new JsonObject();
                    for (class_2520 vertexNbt : (class_2499)faceNbt) {
                        class_2487 vertex = (class_2487)vertexNbt;
                        String id = vertex.method_10558("id");
                        uv.add(id, (JsonElement)FiguraAvatarSerializer.nbtFloatListToJson(vertex.method_10554("uv", 5)));
                        vert.add(id);
                    }
                    face.add("vertices", (JsonElement)vert);
                    face.add("uv", (JsonElement)uv);
                    faces.add("" + i++, (JsonElement)face);
                }
                part.add("vertices", (JsonElement)vertices);
                part.add("faces", (JsonElement)faces);
                elements.add((JsonElement)part);
                outliner.add(uuid);
                break;
            }
            case "na": {
                class_1160 newOffset = offset.method_23850();
                for (Map.Entry<String, class_1160> entry : PLAYER_MODEL_OFFSETS.entrySet()) {
                    JsonArray pivot;
                    if (!name.contains(entry.getKey())) continue;
                    newOffset = (class_1160)entry.getValue();
                    if (tag.method_10545("piv")) {
                        pivot = FiguraAvatarSerializer.nbtFloatListToJson(tag.method_10554("piv", 5));
                        pivot.set(2, (JsonElement)new JsonPrimitive((Number)Float.valueOf(-pivot.get(2).getAsFloat())));
                        FiguraAvatarSerializer.applyArrayOffset(pivot, newOffset);
                    } else {
                        pivot = new JsonArray();
                        pivot.add((Number)Float.valueOf(newOffset.method_4943()));
                        pivot.add((Number)Float.valueOf(newOffset.method_4945()));
                        pivot.add((Number)Float.valueOf(newOffset.method_4947()));
                    }
                    part.add("origin", (JsonElement)pivot);
                    player = true;
                    break;
                }
                class_2499 anims = tag.method_10554("anims", 10);
                for (class_2520 nbtElement : anims) {
                    class_2487 anim = (class_2487)nbtElement;
                    String animName = anim.method_10558("id");
                    JsonObject animation = null;
                    for (JsonElement element : animations) {
                        JsonObject animObj = element.getAsJsonObject();
                        if (!animObj.get("name").getAsString().equals(animName)) continue;
                        animation = animObj;
                        break;
                    }
                    if (animation == null) continue;
                    JsonObject animators = animation.get("animators").getAsJsonObject();
                    JsonObject stuff = new JsonObject();
                    stuff.addProperty("name", name);
                    stuff.addProperty("type", "bone");
                    JsonArray keyframes = new JsonArray();
                    class_2499 kfList = anim.method_10554("keyf", 10);
                    for (class_2520 element : kfList) {
                        class_2487 keyframeNbt = (class_2487)element;
                        JsonObject keyframe = new JsonObject();
                        keyframe.addProperty("channel", keyframeNbt.method_10558("type"));
                        keyframe.addProperty("uuid", UUID.randomUUID().toString());
                        keyframe.addProperty("time", (Number)Float.valueOf(keyframeNbt.method_10583("time")));
                        keyframe.addProperty("interpolation", keyframeNbt.method_10558("int"));
                        JsonArray data = new JsonArray();
                        JsonObject dataObj = new JsonObject();
                        class_2499 dataList = keyframeNbt.method_10554("data", 5);
                        dataObj.addProperty("x", (Number)Float.valueOf(dataList.method_10604(0)));
                        dataObj.addProperty("y", (Number)Float.valueOf(dataList.method_10604(1)));
                        dataObj.addProperty("z", (Number)Float.valueOf(dataList.method_10604(2)));
                        data.add((JsonElement)dataObj);
                        keyframe.add("data_points", (JsonElement)data);
                        keyframes.add((JsonElement)keyframe);
                    }
                    stuff.add("keyframes", (JsonElement)keyframes);
                    animators.add(uuid, (JsonElement)stuff);
                }
                part.addProperty("export", Boolean.valueOf(true));
                part.addProperty("isOpen", Boolean.valueOf(true));
                JsonArray children = new JsonArray();
                if (tag.method_10545("chld")) {
                    class_2499 childList = tag.method_10554("chld", 10);
                    for (class_2520 nbtElement : childList) {
                        player = FiguraAvatarSerializer.parseModelPart((class_2487)nbtElement, elements, children, animations, newOffset) || player;
                    }
                }
                part.add("children", (JsonElement)children);
                outliner.add((JsonElement)part);
            }
        }
        return player;
    }

    public static void applyArrayOffset(JsonArray array, class_1160 offset) {
        array.set(0, (JsonElement)new JsonPrimitive((Number)Float.valueOf(array.get(0).getAsFloat() + offset.method_4943())));
        array.set(1, (JsonElement)new JsonPrimitive((Number)Float.valueOf(array.get(1).getAsFloat() + offset.method_4945())));
        array.set(2, (JsonElement)new JsonPrimitive((Number)Float.valueOf(array.get(2).getAsFloat() + offset.method_4947())));
    }

    public static JsonArray nbtFloatListToJson(class_2499 list) {
        JsonArray json = new JsonArray();
        for (class_2520 nbtElement : list) {
            float val = ((class_2494)nbtElement).method_10700();
            json.add((Number)Float.valueOf(val));
        }
        return json;
    }

    public static JsonObject buildFaceData(class_2487 nbt) {
        JsonObject face = new JsonObject();
        JsonArray uv = FiguraAvatarSerializer.nbtFloatListToJson(nbt.method_10554("uv", 5));
        if (nbt.method_10545("texture")) {
            face.addProperty("texture", (Number)Float.valueOf(0.0f));
        } else {
            face.add("texture", null);
        }
        if (nbt.method_10545("rotation")) {
            face.addProperty("rotation", (Number)Float.valueOf(nbt.method_10583("rotation")));
        }
        face.add("uv", (JsonElement)uv);
        return face;
    }
}

