/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.network.messages.user;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.UUID;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.network.messages.MessageHandler;
import net.minecraft.class_2487;
import net.minecraft.class_2507;

public class UserAvatarProvideResponseHandler
extends MessageHandler {
    public UUID targetUser;

    @Override
    public void handleMessage(LittleEndianDataInputStream stream) throws Exception {
        super.handleMessage(stream);
        this.targetUser = this.readUUID(stream);
        try {
            int avatarLength = stream.readInt();
            byte[] allAvatarData = new byte[avatarLength];
            stream.read(allAvatarData, 0, avatarLength);
            ByteArrayInputStream bis = new ByteArrayInputStream(allAvatarData);
            DataInputStream dis = new DataInputStream(bis);
            class_2487 tag = class_2507.method_10629((InputStream)dis);
            dis.close();
            AvatarData pData = AvatarDataManager.getDataForPlayer(this.targetUser);
            if (pData == null) {
                return;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = md.digest(allAvatarData);
            String hashString = new String(hashBytes, StandardCharsets.UTF_8);
            pData.loadFromNbt((Boolean)ConfigManager.Config.EASTER_EGGS.value != false && FiguraMod.IS_CHEESE ? FiguraMod.cheese : tag);
            pData.isLocalAvatar = false;
            pData.lastHash = hashString;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getProtocolName() {
        return "figura_v1:user_avatar_provide";
    }
}

