/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.network.messages.pings;

import com.google.common.io.LittleEndianDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.network.LuaNetworkReadWriter;
import net.blancworks.figura.network.messages.MessageSender;

public class PingMessageSender
extends MessageSender {
    public Queue<CustomScript.LuaPing> pingSet = new LinkedList<CustomScript.LuaPing>();

    public PingMessageSender(Queue<CustomScript.LuaPing> pings) {
        this.pingSet.addAll(pings);
        pings.clear();
    }

    @Override
    protected void write(LittleEndianDataOutputStream stream) throws IOException {
        super.write(stream);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        LittleEndianDataOutputStream outWriter = new LittleEndianDataOutputStream((OutputStream)outStream);
        int setSize = this.pingSet.size();
        outWriter.writeShort(setSize);
        for (int i = 0; i < setSize; ++i) {
            CustomScript.LuaPing p = this.pingSet.poll();
            if (p == null) continue;
            try {
                outWriter.writeShort((int)p.functionID());
                LuaNetworkReadWriter.writeLuaValue(p.args(), outWriter);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        byte[] outData = outStream.toByteArray();
        stream.writeInt(outData.length);
        stream.write(outData);
    }

    @Override
    public String getProtocolName() {
        return "figura_v1:ping";
    }
}

