/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.network.messages;

import com.google.common.io.LittleEndianDataOutputStream;
import com.neovisionaries.ws.client.WebSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.blancworks.figura.network.NewFiguraNetworkManager;

public abstract class MessageSender {
    public byte[] message;

    public void sendMessage(WebSocket socket) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            LittleEndianDataOutputStream outWriter = new LittleEndianDataOutputStream((OutputStream)outStream);
            String pcName = this.getProtocolName();
            try {
                outWriter.write((int)NewFiguraNetworkManager.msgRegistry.getMessageId(pcName));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.write(outWriter);
            this.message = outStream.toByteArray();
            outStream.close();
            socket.sendBinary(this.message, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.message = null;
    }

    public abstract String getProtocolName();

    protected void write(LittleEndianDataOutputStream stream) throws IOException {
    }

    public void writeString(String str, LittleEndianDataOutputStream stream) throws IOException {
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        stream.writeInt(data.length);
        stream.write(data);
    }

    public void writeUUID(UUID id, LittleEndianDataOutputStream stream) throws IOException {
        this.writeString(id.toString(), stream);
    }
}

