/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.network;

import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.network.FiguraNetworkMessageHandler;
import net.blancworks.figura.network.IFiguraNetwork;
import net.blancworks.figura.network.NaiveSSLContext;
import net.blancworks.figura.network.messages.MessageRegistry;
import net.blancworks.figura.network.messages.avatar.AvatarUploadMessageSender;
import net.blancworks.figura.network.messages.pings.PingMessageSender;
import net.blancworks.figura.network.messages.pubsub.SubscribeToUsersMessageSender;
import net.blancworks.figura.network.messages.user.UserDeleteCurrentAvatarMessageSender;
import net.blancworks.figura.network.messages.user.UserGetCurrentAvatarHashMessageSender;
import net.blancworks.figura.network.messages.user.UserGetCurrentAvatarMessageSender;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2889;
import net.minecraft.class_2915;
import net.minecraft.class_310;
import net.minecraft.class_635;

public class NewFiguraNetworkManager
implements IFiguraNetwork {
    public static CompletableFuture<?> networkTasks;
    public static final int PROTOCOL_VERSION = 0;
    private static boolean lastNetworkState;
    public static byte connectionStatus;
    public static WebSocketFactory socketFactory;
    public static WebSocket currWebSocket;
    public static MessageRegistry msgRegistry;
    public static Object authWaitObject;
    public static class_2535 authConnection;
    public static String jwtToken;
    public static Date tokenReceivedTime;
    public static int tokenReauthCooldown;
    public static final int TOKEN_LIFETIME = 1200000;
    public static final int TOKEN_REAUTH_WAIT_TIME = 200;
    public static final int TIMEOUT_SECONDS = 1;
    private static boolean hasInited;
    private static final ArrayList<UUID> allSubscriptions;
    private static final ArrayList<UUID> newSubscriptions;
    private static boolean localLastCheck;

    private static CompletableFuture<?> doTask(Runnable toRun) {
        if (networkTasks == null || networkTasks.isDone()) {
            networkTasks = CompletableFuture.runAsync(toRun);
        } else {
            networkTasks.thenRun(toRun);
        }
        return networkTasks;
    }

    private static CompletableFuture<?> doTask(Supplier<CompletableFuture<?>> toRun) {
        if (networkTasks == null || networkTasks.isDone()) {
            networkTasks = toRun.get();
        } else {
            networkTasks.thenCompose(x -> (CompletionStage)toRun.get());
        }
        return networkTasks;
    }

    private static <T> CompletableFuture<?> doTaskSupply(Supplier<T> toRun) {
        if (networkTasks == null || networkTasks.isDone()) {
            networkTasks = CompletableFuture.supplyAsync(toRun);
        } else {
            CompletableFuture.supplyAsync(toRun);
        }
        return networkTasks;
    }

    public static void subscribe(UUID playerID) {
        if (!allSubscriptions.contains(playerID) && !newSubscriptions.contains(playerID)) {
            newSubscriptions.add(playerID);
        }
    }

    @Override
    public void tickNetwork() {
        if ((Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value != lastNetworkState && currWebSocket != null) {
            currWebSocket.disconnect();
            lastNetworkState = (Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value;
        }
        if (jwtToken == null) {
            connectionStatus = 1;
        }
        if (authConnection != null && !authConnection.method_10758()) {
            authConnection.method_10768();
        }
        if (currWebSocket != null && currWebSocket.isOpen() && !msgRegistry.isEmpty()) {
            connectionStatus = (byte)3;
            if (newSubscriptions.size() > 0) {
                allSubscriptions.addAll(newSubscriptions);
                UUID[] ids = new UUID[newSubscriptions.size()];
                newSubscriptions.toArray(ids);
                newSubscriptions.clear();
                NewFiguraNetworkManager.doTask(() -> new SubscribeToUsersMessageSender(ids).sendMessage(currWebSocket));
            }
        } else if (allSubscriptions.size() > 0) {
            newSubscriptions.addAll(allSubscriptions);
            allSubscriptions.clear();
        }
        Date currTime = new Date();
        if (tokenReauthCooldown > 0) {
            --tokenReauthCooldown;
        } else if (tokenReceivedTime != null && currTime.getTime() - tokenReceivedTime.getTime() > 1200000L) {
            tokenReauthCooldown = 200;
            NewFiguraNetworkManager.doTask(() -> {
                try {
                    this.authUser(true).get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    @Override
    public CompletableFuture<?> getAvatarData(UUID id) {
        NewFiguraNetworkManager.doTask(this::ensureConnection);
        return NewFiguraNetworkManager.doTask(() -> {
            try {
                if (currWebSocket != null && currWebSocket.isOpen()) {
                    new UserGetCurrentAvatarMessageSender(id).sendMessage(currWebSocket);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<?> postAvatar() {
        NewFiguraNetworkManager.doTask(this::ensureConnection);
        return NewFiguraNetworkManager.doTask(() -> {
            if (currWebSocket != null && currWebSocket.isOpen()) {
                LocalAvatarData data = AvatarDataManager.localPlayer;
                data.isLocalAvatar = false;
                class_2487 nbt = new class_2487();
                data.writeNbt(nbt);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream nbtDataStream = new DataOutputStream(baos);
                    class_2507.method_10634((class_2487)nbt, (OutputStream)nbtDataStream);
                    byte[] result = baos.toByteArray();
                    new AvatarUploadMessageSender(result).sendMessage(currWebSocket);
                    nbtDataStream.close();
                    baos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public CompletableFuture<?> setCurrentUserAvatar(UUID avatarID) {
        return null;
    }

    @Override
    public CompletableFuture<?> deleteAvatar() {
        NewFiguraNetworkManager.doTask(this::ensureConnection);
        return NewFiguraNetworkManager.doTask(() -> {
            try {
                if (currWebSocket != null && currWebSocket.isOpen()) {
                    new UserDeleteCurrentAvatarMessageSender().sendMessage(currWebSocket);
                    AvatarDataManager.clearLocalPlayer();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public CompletableFuture<?> checkAvatarHash(UUID playerID, String lastHash) {
        NewFiguraNetworkManager.doTask(this::ensureConnection);
        return NewFiguraNetworkManager.doTask(() -> {
            try {
                if (currWebSocket != null && currWebSocket.isOpen()) {
                    new UserGetCurrentAvatarHashMessageSender(playerID).sendMessage(currWebSocket);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void parseKickAuthMessage(class_2561 reason) {
        if (reason.getString().equals("This is the Figura Auth Server V2.0!\n")) {
            class_2561 tokenText = (class_2561)reason.method_10855().get(1);
            jwtToken = tokenText.getString();
            tokenReceivedTime = new Date();
        }
    }

    @Override
    public void onClose() {
        if (currWebSocket != null && currWebSocket.isOpen()) {
            currWebSocket.sendClose();
            currWebSocket.disconnect();
        }
    }

    public void sendPing(Queue<CustomScript.LuaPing> pings) {
        PingMessageSender pms = new PingMessageSender(pings);
        NewFiguraNetworkManager.doTask(() -> {
            try {
                if (msgRegistry.isEmpty()) {
                    return;
                }
                if (currWebSocket != null && currWebSocket.isOpen()) {
                    pms.sendMessage(currWebSocket);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public String authServerURL() {
        if (((Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value).booleanValue()) {
            return "localhost";
        }
        return (String)ConfigManager.Config.BACKEND_PATH.value;
    }

    public String mainServerURL() {
        if (((Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value).booleanValue()) {
            return "http://localhost:6050";
        }
        return "https://" + ConfigManager.Config.BACKEND_PATH.value;
    }

    public CompletableFuture<Void> ensureConnection() {
        if (localLastCheck != (Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value || socketFactory == null) {
            localLastCheck = (Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value;
            socketFactory = new WebSocketFactory();
            if (localLastCheck) {
                SSLContext ctx;
                try {
                    ctx = NaiveSSLContext.getInstance("TLS");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                socketFactory.setSSLContext(ctx);
                socketFactory.setVerifyHostname(false);
            }
            socketFactory.setServerName((String)ConfigManager.Config.BACKEND_PATH.value);
        }
        if (currWebSocket == null || !currWebSocket.isOpen()) {
            try {
                lastNetworkState = (Boolean)ConfigManager.Config.USE_LOCAL_SERVER.value;
                return this.openNewConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> openNewConnection() {
        return this.authUser(false).thenComposeAsync(unused -> {
            try {
                this.closeSocketConnection();
                String connectionString = String.format("%s/connect/", this.mainServerURL());
                FiguraMod.LOGGER.info("Connecting to websocket server " + connectionString);
                connectionStatus = (byte)2;
                WebSocket newSocket = socketFactory.createSocket(connectionString, 1000);
                newSocket.setPingInterval(15000L);
                currWebSocket = newSocket;
                msgRegistry = new MessageRegistry();
                FiguraNetworkMessageHandler messageHandler = new FiguraNetworkMessageHandler(this);
                newSocket.addListener((WebSocketListener)messageHandler);
                newSocket.connect();
                newSocket.sendText(jwtToken);
                messageHandler.sendClientRegistry(newSocket);
                return messageHandler.initializedFuture;
            }
            catch (Exception e) {
                connectionStatus = 1;
                e.printStackTrace();
                return CompletableFuture.completedFuture(null);
            }
        });
    }

    private void closeSocketConnection() {
        if (currWebSocket == null) {
            return;
        }
        if (!currWebSocket.isOpen()) {
            currWebSocket = null;
            return;
        }
        currWebSocket.sendClose(0);
        currWebSocket = null;
    }

    public CompletableFuture<Void> authUser(boolean force) {
        if (!force && jwtToken != null) {
            return CompletableFuture.completedFuture(null);
        }
        if (authConnection != null && !authConnection.method_10758()) {
            authConnection.method_10768();
            if (authConnection != null) {
                return CompletableFuture.completedFuture(null);
            }
        }
        try {
            FiguraMod.LOGGER.info("Authenticating with Figura server");
            connectionStatus = (byte)2;
            String address = this.authServerURL();
            InetSocketAddress inetAddress = new InetSocketAddress(address, 25565);
            final class_2535 connection = class_2535.method_10753((InetSocketAddress)inetAddress, (boolean)true);
            final CompletableFuture<Void> disconnectedFuture = new CompletableFuture<Void>();
            connection.method_10763((class_2547)new class_635(connection, class_310.method_1551(), null, text -> FiguraMod.LOGGER.info(text.getString())){

                public void method_10839(class_2561 reason) {
                    try {
                        class_2561 dcReason = connection.method_10748();
                        if (dcReason != null) {
                            NewFiguraNetworkManager.this.parseKickAuthMessage(dcReason);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    authConnection = null;
                    disconnectedFuture.complete(null);
                }
            });
            connection.method_10743((class_2596)new class_2889(address, 25565, class_2539.field_20593));
            connection.method_10743((class_2596)new class_2915(class_310.method_1551().method_1548().method_1676(), class_310.method_1551().method_43590().method_43784()));
            authConnection = connection;
            return disconnectedFuture;
        }
        catch (Exception e) {
            connectionStatus = 1;
            e.printStackTrace();
            return CompletableFuture.completedFuture(null);
        }
    }

    static {
        lastNetworkState = false;
        connectionStatus = 0;
        authWaitObject = new Object();
        tokenReauthCooldown = 0;
        hasInited = false;
        allSubscriptions = new ArrayList();
        newSubscriptions = new ArrayList();
        localLastCheck = false;
    }
}

