/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.network;

import com.google.common.io.ByteSource;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketFrame;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.network.NewFiguraNetworkManager;
import net.blancworks.figura.network.messages.MessageHandler;
import net.blancworks.figura.network.messages.avatar.AvatarProvideResponseHandler;
import net.blancworks.figura.network.messages.avatar.AvatarUploadResponseHandler;
import net.blancworks.figura.network.messages.pings.PingMessageHandler;
import net.blancworks.figura.network.messages.pubsub.ChannelAvatarUpdateHandler;
import net.blancworks.figura.network.messages.user.UserAvatarHashProvideResponseHandler;
import net.blancworks.figura.network.messages.user.UserAvatarProvideResponseHandler;
import net.blancworks.figura.network.messages.utility.ErrorMessageHandler;

public class FiguraNetworkMessageHandler
extends WebSocketAdapter {
    private final NewFiguraNetworkManager manager;
    private final List<Supplier<MessageHandler>> allMessageHandlers = new ArrayList<Supplier<MessageHandler>>(){
        {
            this.add(AvatarProvideResponseHandler::new);
            this.add(AvatarUploadResponseHandler::new);
            this.add(UserAvatarProvideResponseHandler::new);
            this.add(UserAvatarHashProvideResponseHandler::new);
            this.add(ChannelAvatarUpdateHandler::new);
            this.add(PingMessageHandler::new);
            this.add(ErrorMessageHandler::new);
        }
    };
    private boolean skipNext = false;
    public final CompletableFuture<Void> initializedFuture = new CompletableFuture();

    public FiguraNetworkMessageHandler(NewFiguraNetworkManager manager) {
        this.manager = manager;
    }

    public void sendClientRegistry(WebSocket socket) {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();
             LittleEndianDataOutputStream outWriter = new LittleEndianDataOutputStream((OutputStream)outStream);){
            outWriter.writeInt(this.allMessageHandlers.size());
            for (Supplier<MessageHandler> handler : this.allMessageHandlers) {
                byte[] data = handler.get().getProtocolName().getBytes(StandardCharsets.UTF_8);
                outWriter.writeInt(data.length);
                outWriter.write(data);
            }
            socket.sendBinary(outStream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
        super.onConnected(websocket, headers);
    }

    public void onBinaryMessage(WebSocket websocket, byte[] binary) throws Exception {
        block11: {
            super.onBinaryMessage(websocket, binary);
            if (this.skipNext) {
                this.skipNext = false;
                return;
            }
            try (LittleEndianDataInputStream dis = new LittleEndianDataInputStream(ByteSource.wrap((byte[])binary).openStream());){
                if (NewFiguraNetworkManager.msgRegistry.isEmpty()) {
                    NewFiguraNetworkManager.msgRegistry.readRegistryMessage(dis);
                    FiguraMod.LOGGER.info("Connection fully initialized.");
                    this.initializedFuture.complete(null);
                    return;
                }
                int handlerID = dis.readByte() - -128 - 1;
                if (this.allMessageHandlers.size() > handlerID) {
                    MessageHandler handler = this.allMessageHandlers.get(handlerID).get();
                    handler.handleMessage(dis);
                    break block11;
                }
                FiguraMod.LOGGER.error("INVALID MESSAGE HANDLER ID " + handlerID);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onCloseFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
        super.onCloseFrame(websocket, frame);
    }

    public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
        super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
        NewFiguraNetworkManager.currWebSocket = null;
        this.initializedFuture.complete(null);
        if (closedByServer) {
            FiguraMod.LOGGER.warn("Disconnected from Figura Server with reason '" + serverCloseFrame.getCloseReason() + "'");
            if (serverCloseFrame.getCloseReason().equals("Invalid Authentication")) {
                NewFiguraNetworkManager.jwtToken = null;
                NewFiguraNetworkManager.tokenReceivedTime = null;
            }
        }
    }
}

