/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models.shaders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.models.shaders.FiguraRenderLayer;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class FiguraVertexConsumerProvider
implements class_4597 {
    private final ArrayList<FiguraRenderLayer> sortedLayers = new ArrayList();
    private final HashMap<FiguraRenderLayer, class_287> bufferBuilders = new HashMap();
    private final Map<String, FiguraRenderLayer> stringLayerMap = new HashMap<String, FiguraRenderLayer>();
    private final Set<class_287> activeConsumers = new HashSet<class_287>();
    public FiguraRenderLayer overrideLayer = null;
    public final int maxSize;
    private static final List<class_1921> VANILLA_GLINT_LAYERS = Arrays.asList(class_1921.method_27948(), class_1921.method_27949(), class_1921.method_30676(), class_1921.method_23590(), class_1921.method_29706(), class_1921.method_23591(), class_1921.method_29707());
    public static boolean isUsingLastFramebuffer = false;
    private static final class_4588 DO_NOTHING_CONSUMER = new class_4588(){

        public class_4588 method_22912(double x, double y, double z) {
            return this;
        }

        public class_4588 method_1336(int red, int green, int blue, int alpha) {
            return this;
        }

        public class_4588 method_22913(float u, float v) {
            return this;
        }

        public class_4588 method_22917(int u, int v) {
            return this;
        }

        public class_4588 method_22921(int u, int v) {
            return this;
        }

        public class_4588 method_22914(float x, float y, float z) {
            return this;
        }

        public void method_1344() {
        }

        public void method_22901(int red, int green, int blue, int alpha) {
        }

        public void method_35666() {
        }
    };

    public FiguraVertexConsumerProvider(int maxSize) {
        this.maxSize = maxSize;
    }

    public FiguraVertexConsumerProvider() {
        this(32);
    }

    public boolean canAddLayer() {
        return this.bufferBuilders.size() < this.maxSize;
    }

    public void addLayer(FiguraRenderLayer layer) {
        if (!this.canAddLayer()) {
            System.out.println("Warning: Adding new render layer when you're not supposed to be able to!");
        }
        class_287 bufferBuilder = new class_287(layer.method_22722());
        this.sortedLayers.add(layer);
        Collections.sort(this.sortedLayers);
        this.bufferBuilders.put(layer, bufferBuilder);
        this.stringLayerMap.put(layer.toString(), layer);
    }

    public void setPriority(FiguraRenderLayer layer, int newPriority) {
        layer.priority = newPriority;
        Collections.sort(this.sortedLayers);
    }

    public FiguraRenderLayer getLayer(String name) {
        return this.stringLayerMap.get(name);
    }

    public boolean hasLayers() {
        return !this.sortedLayers.isEmpty();
    }

    public class_4588 getBuffer(class_1921 layer) {
        if (this.overrideLayer != null) {
            if (VANILLA_GLINT_LAYERS.contains(layer)) {
                return DO_NOTHING_CONSUMER;
            }
            layer = this.overrideLayer;
        }
        if (layer instanceof FiguraRenderLayer && this.bufferBuilders.containsKey(layer)) {
            class_287 bufferBuilder = this.bufferBuilders.get(layer);
            if (this.activeConsumers.add(bufferBuilder)) {
                bufferBuilder.method_1328(layer.method_23033(), layer.method_23031());
            }
            return (class_4588)this.bufferBuilders.get(layer);
        }
        AvatarData data = AvatarData.currentRenderingData;
        if (data != null && data.vertexConsumerProvider != null) {
            return data.vertexConsumerProvider.getBuffer(layer);
        }
        return null;
    }

    public void draw() {
        for (FiguraRenderLayer layer : this.sortedLayers) {
            this.draw(layer);
        }
    }

    public void draw(FiguraRenderLayer layer) {
        class_287 bufferBuilder = this.bufferBuilders.get(layer);
        if (this.activeConsumers.remove(bufferBuilder)) {
            layer.method_23012(bufferBuilder, 0, 0, 0);
        }
    }
}

