/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models.animations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.blancworks.figura.models.CustomModelPartGroup;
import net.blancworks.figura.models.animations.KeyFrame;
import net.blancworks.figura.utils.MathUtils;
import net.minecraft.class_1160;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_3532;

public class Animation {
    public final String name;
    public float length;
    public LoopMode loopMode;
    public float startOffset;
    public float blendWeight;
    public float startDelay;
    public float loopDelay;
    public boolean override;
    public float blendTime = 0.05f;
    public boolean replace = false;
    public int priority = 0;
    public HashMap<CustomModelPartGroup, List<TreeMap<Float, KeyFrame>>> keyFrames = new HashMap();
    public float speed = 1.0f;
    public boolean inverted = false;
    public PlayState playState = PlayState.STOPPED;
    private PlayState lastState = PlayState.STOPPED;
    private boolean wasStarting = false;
    public float time = 0.0f;
    private float newTime = 0.0f;
    private float lastTime = 0.0f;

    public Animation(String name, float length, LoopMode loopMode, float startOffset, float blendWeight, float startDelay, float loopDelay, boolean override) {
        this.name = name;
        this.length = length;
        this.loopMode = loopMode;
        this.startOffset = startOffset;
        this.blendWeight = blendWeight;
        this.startDelay = startDelay;
        this.loopDelay = loopDelay;
        this.override = override;
    }

    public int render(int renderCount, int renderLimit) {
        if (this.playState == PlayState.STARTING || this.playState == PlayState.STOPPING || this.playState == PlayState.PAUSED && (this.lastState == PlayState.STARTING || this.lastState == PlayState.STOPPING)) {
            return this.renderBlend(this.playState == PlayState.STOPPING || this.playState == PlayState.PAUSED && this.lastState == PlayState.STOPPING, renderCount, renderLimit);
        }
        if (this.playState != PlayState.PAUSED && this.playState != PlayState.ENDED) {
            this.newTime = class_156.method_658();
        }
        float kfTime = (this.newTime - this.time) / 1000.0f * this.speed;
        if ((kfTime += this.startOffset) >= this.length) {
            switch (this.loopMode) {
                case HOLD: {
                    this.playState = PlayState.ENDED;
                    break;
                }
                case ONCE: {
                    this.stop();
                    break;
                }
                case LOOP: {
                    if (!(kfTime >= this.length + this.loopDelay)) break;
                    this.cease();
                    this.start();
                }
            }
        }
        this.lastTime = this.inverted ? this.length - kfTime : kfTime;
        for (Map.Entry<CustomModelPartGroup, List<TreeMap<Float, KeyFrame>>> entry : this.keyFrames.entrySet()) {
            CustomModelPartGroup group = entry.getKey();
            List<TreeMap<Float, KeyFrame>> data = entry.getValue();
            if (this.priority < group.lastPriority) continue;
            boolean replace = this.priority > group.lastPriority;
            class_1160 pos = this.processKeyFrame(data.get(0), this.lastTime);
            class_1160 rot = this.processKeyFrame(data.get(1), this.lastTime);
            class_1160 scale = this.processKeyFrame(data.get(2), this.lastTime);
            if (pos != null) {
                if (this.override) {
                    if (replace) {
                        group.animPosOverride = pos;
                    } else {
                        group.animPosOverride.method_23846(pos);
                    }
                } else if (replace) {
                    group.animPos = pos;
                } else {
                    group.animPos.method_23846(pos);
                }
                ++renderCount;
            }
            if (rot != null) {
                if (replace) {
                    group.animRot = rot;
                } else {
                    group.animRot.method_23846(rot);
                }
                ++renderCount;
            }
            if (scale != null) {
                if (replace) {
                    group.animScale = scale;
                } else {
                    group.animScale.method_23849(scale.method_4943(), scale.method_4945(), scale.method_4947());
                }
                ++renderCount;
            }
            group.wasAnimated = true;
            group.replaced = group.replaced || this.replace;
            group.lastPriority = this.priority;
            if (renderCount <= renderLimit) continue;
            break;
        }
        return renderCount;
    }

    private int renderBlend(boolean ending, int renderCount, int renderLimit) {
        if (this.playState != PlayState.PAUSED) {
            this.newTime = class_156.method_658();
        }
        float kfTime = (this.newTime - this.time) / 1000.0f * this.speed;
        if (!ending && (kfTime -= this.startDelay) < 0.0f) {
            return renderCount;
        }
        if (kfTime >= this.blendTime) {
            if (ending) {
                this.cease();
            } else {
                this.start();
            }
        }
        if (!ending) {
            this.lastTime = kfTime;
        }
        for (Map.Entry<CustomModelPartGroup, List<TreeMap<Float, KeyFrame>>> entry : this.keyFrames.entrySet()) {
            CustomModelPartGroup group = entry.getKey();
            List<TreeMap<Float, KeyFrame>> data = entry.getValue();
            if (this.priority < group.lastPriority) continue;
            boolean replace = this.priority > group.lastPriority;
            class_1160 pos = ending && !this.wasStarting ? this.processKeyFrame(data.get(0), this.lastTime) : this.getKeyFrameData(data.get(0), this.startOffset, this.inverted);
            class_1160 rot = ending && !this.wasStarting ? this.processKeyFrame(data.get(1), this.lastTime) : this.getKeyFrameData(data.get(1), this.startOffset, this.inverted);
            class_1160 scale = ending && !this.wasStarting ? this.processKeyFrame(data.get(2), this.lastTime) : this.getKeyFrameData(data.get(2), this.startOffset, this.inverted);
            float delta = class_3532.method_15363((float)(kfTime / this.blendTime), (float)0.0f, (float)1.0f);
            if (pos != null) {
                if (ending) {
                    if (this.wasStarting) {
                        pos = MathUtils.lerpVec3f(class_1160.field_29501, pos, this.lastTime / this.blendTime);
                    }
                    pos = MathUtils.lerpVec3f(pos, class_1160.field_29501, delta);
                } else {
                    pos = MathUtils.lerpVec3f(class_1160.field_29501, pos, delta);
                }
                if (this.override) {
                    if (replace) {
                        group.animPosOverride = pos;
                    } else {
                        group.animPosOverride.method_23846(pos);
                    }
                } else if (replace) {
                    group.animPos = pos;
                } else {
                    group.animPos.method_23846(pos);
                }
                ++renderCount;
            }
            if (rot != null) {
                if (ending) {
                    if (this.wasStarting) {
                        rot = MathUtils.lerpVec3f(class_1160.field_29501, rot, this.lastTime / this.blendTime);
                    }
                    rot = MathUtils.lerpVec3f(rot, class_1160.field_29501, delta);
                } else {
                    rot = MathUtils.lerpVec3f(class_1160.field_29501, rot, delta);
                }
                if (replace) {
                    group.animRot = rot;
                } else {
                    group.animRot.method_23846(rot);
                }
                ++renderCount;
            }
            if (scale != null) {
                if (ending) {
                    if (this.wasStarting) {
                        scale = MathUtils.lerpVec3f(MathUtils.Vec3f_ONE, scale, this.lastTime / this.blendTime);
                    }
                    scale = MathUtils.lerpVec3f(scale, MathUtils.Vec3f_ONE, delta);
                } else {
                    scale = MathUtils.lerpVec3f(MathUtils.Vec3f_ONE, scale, delta);
                }
                if (replace) {
                    group.animScale = scale;
                } else {
                    group.animScale.method_23849(scale.method_4943(), scale.method_4945(), scale.method_4947());
                }
                ++renderCount;
            }
            group.wasAnimated = true;
            group.replaced = group.replaced || this.replace;
            group.lastPriority = this.priority;
            if (renderCount <= renderLimit) continue;
            break;
        }
        return renderCount;
    }

    public void play() {
        if (this.playState == PlayState.ENDED || this.playState == PlayState.STOPPING) {
            this.cease();
        }
        long offset = class_156.method_658();
        if (this.playState == PlayState.PAUSED) {
            offset = (long)((float)offset - (this.newTime - this.time));
            this.playState = this.lastState;
        }
        if (this.playState == PlayState.STOPPED) {
            this.playState = PlayState.STARTING;
        }
        this.time = offset;
    }

    public void start() {
        this.time = class_156.method_658();
        this.playState = PlayState.PLAYING;
    }

    public void stop() {
        if (this.playState != PlayState.STOPPED && this.playState != PlayState.STOPPING) {
            this.time = class_156.method_658();
            this.wasStarting = this.playState == PlayState.STARTING;
            this.playState = PlayState.STOPPING;
        }
    }

    public void cease() {
        this.time = 0.0f;
        this.playState = PlayState.STOPPED;
    }

    public void pause() {
        if (this.playState != PlayState.ENDED && this.playState != PlayState.PAUSED && this.playState != PlayState.STOPPED) {
            this.lastState = this.playState;
            this.playState = PlayState.PAUSED;
        }
    }

    public boolean isPlaying() {
        return this.playState == PlayState.PLAYING || this.playState == PlayState.STARTING || this.playState == PlayState.STOPPING;
    }

    public void clearAnimData() {
        for (CustomModelPartGroup group : this.keyFrames.keySet()) {
            if (!group.wasAnimated) continue;
            group.animRot = class_1160.field_29501.method_23850();
            group.animPos = class_1160.field_29501.method_23850();
            group.animPosOverride = class_1160.field_29501.method_23850();
            group.animScale = MathUtils.Vec3f_ONE.method_23850();
            group.wasAnimated = false;
            group.replaced = false;
            group.lastPriority = 0;
        }
    }

    public class_1160 processKeyFrame(TreeMap<Float, KeyFrame> map, float time) {
        try {
            Map.Entry<Float, KeyFrame> floor = map.floorEntry(Float.valueOf(time));
            Map.Entry<Float, KeyFrame> ceil = map.ceilingEntry(Float.valueOf(time));
            if (floor == null && ceil == null) {
                return null;
            }
            KeyFrame curr = Objects.requireNonNullElse(floor, ceil).getValue();
            KeyFrame next = Objects.requireNonNullElse(ceil, floor).getValue();
            class_1160 start = curr.data.method_23850();
            class_1160 end = next.data.method_23850();
            start.method_4942(this.blendWeight);
            end.method_4942(this.blendWeight);
            float delta = next.time == curr.time ? 1.0f : class_3532.method_15363((float)((time - curr.time) / (next.time - curr.time)), (float)0.0f, (float)1.0f);
            switch (curr.interpolation) {
                case LINEAR: {
                    return MathUtils.lerpVec3f(start, end, delta);
                }
                case CATMULLROM: {
                    Map.Entry<Float, KeyFrame> beforeFloor = map.lowerEntry(Float.valueOf(curr.time));
                    Map.Entry<Float, KeyFrame> afterCeil = map.higherEntry(Float.valueOf(next.time));
                    class_1160 bef = beforeFloor != null ? beforeFloor.getValue().data.method_23850() : curr.data.method_23850();
                    class_1160 aft = afterCeil != null ? afterCeil.getValue().data.method_23850() : next.data.method_23850();
                    bef.method_4942(this.blendWeight);
                    aft.method_4942(this.blendWeight);
                    return MathUtils.catmullRomVec3f(bef, start, end, aft, delta);
                }
            }
            return start;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public class_1160 getKeyFrameData(TreeMap<Float, KeyFrame> map, float offset, boolean inverted) {
        Map.Entry<Float, KeyFrame> floor = map.floorEntry(Float.valueOf(offset));
        Map.Entry<Float, KeyFrame> ceil = map.ceilingEntry(Float.valueOf(offset));
        if (floor == null && ceil == null) {
            return null;
        }
        KeyFrame curr = Objects.requireNonNullElse(floor, ceil).getValue();
        KeyFrame next = Objects.requireNonNullElse(ceil, floor).getValue();
        class_1160 ret = inverted ? next.data.method_23850() : curr.data.method_23850();
        ret.method_4942(this.blendWeight);
        return ret;
    }

    public static Animation fromNbt(class_2487 animTag) {
        String name = animTag.method_10558("nm");
        float length = animTag.method_10583("len");
        LoopMode loopMode = LoopMode.valueOf(animTag.method_10558("loop").toUpperCase());
        float startOffset = animTag.method_10545("time") ? animTag.method_10583("time") : 0.0f;
        float blendWeight = animTag.method_10545("bld") ? animTag.method_10583("bld") : 1.0f;
        float startDelay = animTag.method_10545("sdel") ? animTag.method_10583("sdel") : 0.0f;
        float loopDelay = animTag.method_10545("ldel") ? animTag.method_10583("ldel") : 0.0f;
        boolean override = animTag.method_10545("ovr") && animTag.method_10577("ovr");
        return new Animation(name, length, loopMode, startOffset, blendWeight, startDelay, loopDelay, override);
    }

    public static enum PlayState {
        STOPPED,
        PLAYING,
        PAUSED,
        ENDED,
        STOPPING,
        STARTING;

    }

    public static enum LoopMode {
        HOLD,
        LOOP,
        ONCE;

    }
}

