/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Map;
import java.util.function.Function;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarData;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.apache.commons.io.IOUtils;
import org.lwjgl.system.MemoryUtil;

public class FiguraTexture
extends class_1049 {
    public static final Map<TextureType, Function<class_2960, class_1921>> EXTRA_TEXTURE_TO_RENDER_LAYER = new ImmutableMap.Builder().put((Object)TextureType._emission, class_1921::method_23026).build();
    public byte[] data;
    public Path filePath;
    public class_2960 id;
    public TextureType type = TextureType.color;
    public boolean isDone = false;
    public static final class_2960 DEFAULT_ID = new class_2960("figura", "cheese/cheese.png");
    public static final class_2960 ELYTRA_ID = new class_2960("minecraft", "textures/entity/elytra.png");

    public FiguraTexture() {
        super(DEFAULT_ID);
        this.id = DEFAULT_ID;
    }

    public void loadFromDisk(Path targetPath) {
        try {
            this.filePath = targetPath;
            this.loadFromStream(Files.newInputStream(targetPath, new OpenOption[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFromStream(InputStream stream) {
        try {
            this.data = IOUtils.toByteArray((InputStream)stream);
            stream.close();
            this.uploadUsingData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerTexture() {
        AvatarData.getTextureManager().method_4616(this.id, (class_1044)this);
    }

    private void uploadTexture(class_1011 image) {
        TextureUtil.prepareImage((int)this.method_4624(), (int)image.method_4307(), (int)image.method_4323());
        image.method_4301(0, 0, 0, true);
        this.isDone = true;
    }

    public void writeNbt(class_2487 nbt) {
        try {
            if (this.data == null) {
                nbt.method_10582("note", "Texture has no data, cannot save : " + this.id);
                return;
            }
            nbt.method_10570("img2", this.data);
            nbt.method_10566("type", (class_2520)class_2519.method_23256((String)this.type.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readNbt(class_2487 nbt) {
        if (nbt.method_10545("img2")) {
            try {
                this.data = nbt.method_10547("img2");
                this.uploadUsingData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (nbt.method_10545("img")) {
            try {
                String dataString = nbt.method_10558("img");
                this.data = Base64.getDecoder().decode(dataString);
                this.uploadUsingData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (nbt.method_10545("type")) {
            this.type = TextureType.valueOf(nbt.method_10580("type").method_10714());
        }
    }

    public void uploadUsingData() {
        this.registerTexture();
        FiguraMod.doTask(() -> {
            try {
                ByteBuffer wrapper = MemoryUtil.memAlloc((int)this.data.length);
                wrapper.put(this.data);
                wrapper.rewind();
                class_1011 image = class_1011.method_4324((ByteBuffer)wrapper);
                RenderSystem.recordRenderCall(() -> {
                    this.uploadTexture(image);
                    this.isDone = true;
                    FiguraMod.LOGGER.info("Texture Loading Finished");
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static enum TextureType {
        color,
        _emission;

    }
}

