/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.ArrayList;
import net.blancworks.figura.models.CustomModelPart;
import net.minecraft.class_1160;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_4587;

public class CustomModelPartMesh
extends CustomModelPart {
    public class_2487 meshProperties;

    @Override
    public void rebuild(class_241 newTexSize) {
        if (newTexSize == null) {
            newTexSize = new class_241(this.meshProperties.method_10583("tw"), this.meshProperties.method_10583("th"));
        }
        super.rebuild(newTexSize);
        FloatArrayList vertexData = new FloatArrayList();
        int vertexCount = 0;
        class_2487 verticesNbt = this.meshProperties.method_10562("vertices");
        class_2499 facesNbt = this.meshProperties.method_10554("faces", 9);
        if (facesNbt == null || verticesNbt == null || facesNbt.size() == 0 || verticesNbt.method_10546() == 0) {
            return;
        }
        for (class_2520 faceElement : facesNbt) {
            class_2499 faceData = (class_2499)faceElement;
            int size = faceData.size();
            if (size > 3) {
                ArrayList<class_1160> vectors = new ArrayList<class_1160>();
                for (int i = 0; i < size; ++i) {
                    vectors.add(CustomModelPartMesh.vec3fFromNbt(verticesNbt.method_10554(faceData.method_10602(i).method_10558("id"), 5)));
                }
                if (CustomModelPartMesh.testOppositeSides((class_1160)vectors.get(1), (class_1160)vectors.get(2), (class_1160)vectors.get(0), (class_1160)vectors.get(3))) {
                    class_2520 temp = faceData.method_10534(2);
                    faceData.method_10536(2);
                    faceData.method_10531(0, temp);
                } else if (CustomModelPartMesh.testOppositeSides((class_1160)vectors.get(0), (class_1160)vectors.get(1), (class_1160)vectors.get(2), (class_1160)vectors.get(3))) {
                    class_2520 temp = faceData.method_10534(1);
                    faceData.method_10606(1, faceData.method_10534(2));
                    faceData.method_10606(2, temp);
                }
            }
            for (int i = 0; i < 4; ++i) {
                class_2487 vertexNbt = faceData.method_10602(i % size);
                String vertexName = vertexNbt.method_10558("id");
                class_241 uv = CustomModelPartMesh.v2fFromNbtList(vertexNbt.method_10554("uv", 5));
                class_1160 vertex = CustomModelPartMesh.vec3fFromNbt(verticesNbt.method_10554(vertexName, 5));
                class_1160 previous = CustomModelPartMesh.vec3fFromNbt(verticesNbt.method_10554(faceData.method_10602((i - 1 + size) % size).method_10558("id"), 5));
                class_1160 next = CustomModelPartMesh.vec3fFromNbt(verticesNbt.method_10554(faceData.method_10602((i + 1) % size).method_10558("id"), 5));
                class_1160 normal = previous.method_23850();
                normal.method_4944(vertex);
                class_1160 normalTwo = next.method_23850();
                normalTwo.method_4944(vertex);
                normal.method_4951(normalTwo);
                normal.method_4952();
                vertex.method_4944(this.pivot);
                this.addVertex(vertex, uv.field_1343 / this.texSize.field_1343, uv.field_1342 / this.texSize.field_1342, normal, (FloatList)vertexData);
            }
            vertexCount += 4;
        }
        this.vertexData = vertexData;
        this.vertexCount = vertexCount;
    }

    @Override
    public void rotate(class_4587 stack, class_1160 rot) {
        stack.method_22907(class_1160.field_20703.method_23214(-rot.method_4943()));
        stack.method_22907(class_1160.field_20705.method_23214(-rot.method_4945()));
        stack.method_22907(class_1160.field_20707.method_23214(rot.method_4947()));
    }

    @Override
    public void vanillaRotate(class_4587 stack, class_1160 rot) {
        stack.method_22907(class_1160.field_20703.method_23214(rot.method_4943()));
        stack.method_22907(class_1160.field_20705.method_23214(rot.method_4945()));
        stack.method_22907(class_1160.field_20707.method_23214(rot.method_4947()));
    }

    @Override
    public void readNbt(class_2487 partNbt) {
        super.readNbt(partNbt);
        this.meshProperties = partNbt.method_10562("props");
    }

    @Override
    public CustomModelPart.PartType getPartType() {
        return CustomModelPart.PartType.MESH;
    }

    private static boolean testOppositeSides(class_1160 linePoint1, class_1160 linePoint2, class_1160 point1, class_1160 point2) {
        linePoint1 = linePoint1.method_23850();
        linePoint2 = linePoint2.method_23850();
        point1 = point1.method_23850();
        point2 = point2.method_23850();
        linePoint2.method_4944(linePoint1);
        point1.method_4944(linePoint1);
        point2.method_4944(linePoint1);
        class_1160 crossProduct1 = linePoint2.method_23850();
        crossProduct1.method_4951(point1);
        linePoint2.method_4951(point2);
        return crossProduct1.method_4950(linePoint2) < 0.0f;
    }
}

