/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.lua.api.model.ElytraModelAPI;
import net.blancworks.figura.lua.api.model.ItemModelAPI;
import net.blancworks.figura.lua.api.model.ParrotModelAPI;
import net.blancworks.figura.lua.api.model.RenderTaskAPI;
import net.blancworks.figura.lua.api.model.SpyglassModelAPI;
import net.blancworks.figura.lua.api.model.VanillaModelPartCustomization;
import net.blancworks.figura.models.CustomModel;
import net.blancworks.figura.models.CustomModelPartCuboid;
import net.blancworks.figura.models.CustomModelPartGroup;
import net.blancworks.figura.models.CustomModelPartMesh;
import net.blancworks.figura.models.FiguraTexture;
import net.blancworks.figura.models.shaders.FiguraRenderLayer;
import net.blancworks.figura.models.shaders.FiguraVertexConsumerProvider;
import net.blancworks.figura.trust.TrustContainer;
import net.blancworks.figura.utils.MathUtils;
import net.minecraft.class_1047;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4618;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;

public class CustomModelPart {
    public String name = "NULL";
    public CustomModel model;
    public class_1160 pivot = class_1160.field_29501.method_23850();
    public class_1160 pos = class_1160.field_29501.method_23850();
    public class_1160 rot = class_1160.field_29501.method_23850();
    public class_1160 scale = MathUtils.Vec3f_ONE.method_23850();
    public class_1160 color = MathUtils.Vec3f_ONE.method_23850();
    public Map<UV, uvData> UVCustomizations = new HashMap<UV, uvData>();
    public class_241 texSize = new class_241(64.0f, 64.0f);
    public class_241 uvOffset = new class_241(0.0f, 0.0f);
    public boolean visible = true;
    public ParentType parentType = ParentType.Model;
    public boolean isMimicMode = false;
    public ShaderType shaderType = ShaderType.None;
    public FiguraRenderLayer customLayer = null;
    public TextureType textureType = TextureType.Custom;
    public class_2960 textureVanilla = FiguraTexture.DEFAULT_ID;
    public boolean extraTex = true;
    public boolean cull = false;
    public float alpha = 1.0f;
    public class_241 light = null;
    public class_241 overlay = null;
    public FloatList vertexData = new FloatArrayList();
    public int vertexCount = 0;
    public class_1159 lastModelMatrix = new class_1159();
    public class_4581 lastNormalMatrix = new class_4581();
    public class_1159 lastModelMatrixInverse = new class_1159();
    public class_4581 lastNormalMatrixInverse = new class_4581();
    public final HashMap<String, RenderTaskAPI.RenderTaskTable> renderTasks = new LinkedHashMap<String, RenderTaskAPI.RenderTaskTable>();
    public static boolean canRenderHitBox = false;
    public static boolean canRenderTasks = true;
    private static final class_1162 FULL_VERT = new class_1162();
    private static final class_1160 NORMAL_VERT = new class_1160();
    public static final Map<String, Supplier<CustomModelPart>> MODEL_PART_TYPES = new ImmutableMap.Builder().put((Object)"na", CustomModelPartGroup::new).put((Object)"cub", CustomModelPartCuboid::new).put((Object)"msh", CustomModelPartMesh::new).build();

    public int render(AvatarData data, class_4587 matrices, class_4587 transformStack, class_4597 vcp, int light, int overlay, float alpha) {
        if (data.model == null || data.vanillaModel == null || vcp == null || !data.isAvatarLoaded() || data.model.leftToRender <= 0) {
            return 0;
        }
        boolean applyHiddenTransforms = data.model.applyHiddenTransforms;
        ParentType renderOnly = data.model.renderOnly;
        int ret = data.model.leftToRender;
        data.model.renderOnly = null;
        Function<class_2960, class_1921> layerFunction = class_1921::method_23580;
        ret = this.renderTextures(data, ret, matrices, transformStack, vcp, null, light, overlay, 0.0f, 0.0f, MathUtils.Vec3f_ONE, alpha, false, this.getTexture(data), layerFunction, false, applyHiddenTransforms, renderOnly);
        for (FiguraTexture figuraTexture : data.extraTextures) {
            Function<class_2960, class_1921> renderLayerGetter = FiguraTexture.EXTRA_TEXTURE_TO_RENDER_LAYER.get((Object)figuraTexture.type);
            if (renderLayerGetter == null) continue;
            this.renderTextures(data, ret, matrices, transformStack, vcp, null, light, overlay, 0.0f, 0.0f, MathUtils.Vec3f_ONE, alpha, false, figuraTexture.id, renderLayerGetter, true, applyHiddenTransforms, renderOnly);
        }
        this.draw(vcp);
        ret = this.renderShaders(data, ret, matrices, vcp, light, overlay, 0.0f, 0.0f, MathUtils.Vec3f_ONE, alpha, false, (byte)0, applyHiddenTransforms, renderOnly);
        this.draw(vcp);
        ret = this.renderExtraParts(data, ret, matrices, vcp, light, overlay, false, applyHiddenTransforms, renderOnly);
        this.draw(vcp);
        return ret;
    }

    public int renderTextures(AvatarData data, int leftToRender, class_4587 matrices, class_4587 transformStack, class_4597 vcp, class_1921 layer, int light, int overlay, float u, float v, class_1160 prevColor, float alpha, boolean canRender, class_2960 texture, Function<class_2960, class_1921> layerFunction, boolean isExtraTex, boolean applyHiddenTransforms, ParentType renderOnly) {
        Object object;
        if (!this.visible || isExtraTex && !this.extraTex) {
            return leftToRender;
        }
        matrices.method_22903();
        transformStack.method_22903();
        if (applyHiddenTransforms) {
            this.applyVanillaTransforms(data, matrices, transformStack);
            this.applyTransforms(matrices);
            this.applyTransforms(transformStack);
            this.updateModelMatrices(transformStack);
        } else if (canRender) {
            this.applyTransforms(matrices);
            this.applyTransforms(transformStack);
        }
        if (renderOnly == null || this.parentType == renderOnly) {
            canRender = true;
        }
        u += this.uvOffset.field_1343;
        v += this.uvOffset.field_1342;
        class_1160 color = this.color.method_23850();
        color.method_23849(prevColor.method_4943(), prevColor.method_4945(), prevColor.method_4947());
        alpha = this.alpha * alpha;
        if (this.light != null) {
            light = class_765.method_23687((int)((int)this.light.field_1343), (int)((int)this.light.field_1342));
        }
        if (this.overlay != null) {
            overlay = class_4608.method_23625((int)((int)this.overlay.field_1343), (int)((int)this.overlay.field_1342));
        }
        if (!isExtraTex && this.cull) {
            layerFunction = class_1921::method_23689;
        }
        if (this.textureType != TextureType.Custom) {
            texture = this.getTexture(data);
        }
        if (canRender) {
            class_4588 consumer;
            if (this.customLayer != null && data.getTrustContainer().getTrust(TrustContainer.Trust.CUSTOM_RENDER_LAYER) == 1) {
                consumer = vcp.getBuffer((class_1921)this.customLayer);
                layer = this.customLayer;
            } else {
                consumer = layer instanceof FiguraRenderLayer ? vcp.getBuffer(layer) : vcp.getBuffer(layerFunction.apply(texture));
            }
            leftToRender = this.renderCube(leftToRender, matrices, consumer, light, overlay, u, v, color, alpha);
        }
        if ((object = this) instanceof CustomModelPartGroup) {
            CustomModelPartGroup group = (CustomModelPartGroup)object;
            for (CustomModelPart child : group.children) {
                if (leftToRender <= 0) break;
                if (child.isSpecial()) continue;
                leftToRender = child.renderTextures(data, leftToRender, matrices, transformStack, vcp, layer, light, overlay, u, v, color, alpha, canRender, texture, layerFunction, isExtraTex, applyHiddenTransforms, renderOnly);
            }
        }
        matrices.method_22909();
        transformStack.method_22909();
        return leftToRender;
    }

    public int renderShaders(AvatarData data, int leftToRender, class_4587 matrices, class_4597 vcp, int light, int overlay, float u, float v, class_1160 prevColor, float alpha, boolean canRender, byte shadersToRender, boolean applyHiddenTransforms, ParentType renderOnly) {
        Object object;
        if (!this.visible) {
            return leftToRender;
        }
        matrices.method_22903();
        if (applyHiddenTransforms) {
            this.applyVanillaTransforms(data, matrices, new class_4587());
            this.applyTransforms(matrices);
        } else if (canRender) {
            this.applyTransforms(matrices);
        }
        if (renderOnly == null || this.parentType == renderOnly) {
            canRender = true;
        }
        u += this.uvOffset.field_1343;
        v += this.uvOffset.field_1342;
        class_1160 color = this.color.method_23850();
        color.method_23849(prevColor.method_4943(), prevColor.method_4945(), prevColor.method_4947());
        alpha = this.alpha * alpha;
        if (this.light != null) {
            light = class_765.method_23687((int)((int)this.light.field_1343), (int)((int)this.light.field_1342));
        }
        if (this.overlay != null) {
            overlay = class_4608.method_23625((int)((int)this.overlay.field_1343), (int)((int)this.overlay.field_1342));
        }
        byte shaders = shadersToRender;
        if (this.shaderType != ShaderType.None) {
            shaders = (byte)(shaders | this.shaderType.id);
        }
        if (canRender) {
            if (ShaderType.EndPortal.isShader(shaders)) {
                leftToRender = this.renderCube(leftToRender, matrices, vcp.getBuffer(class_1921.method_34571()), light, overlay, u, v, color, alpha);
            }
            if (ShaderType.Glint.isShader(shaders)) {
                leftToRender = this.renderCube(leftToRender, matrices, vcp.getBuffer(class_1921.method_29707()), light, overlay, u, v, color, alpha);
            }
        }
        if ((object = this) instanceof CustomModelPartGroup) {
            CustomModelPartGroup group = (CustomModelPartGroup)object;
            for (CustomModelPart child : group.children) {
                if (leftToRender <= 0) break;
                if (child.isSpecial()) continue;
                leftToRender = child.renderShaders(data, leftToRender, matrices, vcp, light, overlay, u, v, color, alpha, canRender, shaders, applyHiddenTransforms, renderOnly);
            }
        }
        matrices.method_22909();
        return leftToRender;
    }

    public int renderExtraParts(AvatarData data, int leftToRender, class_4587 matrices, class_4597 vcp, int light, int overlay, boolean canRender, boolean applyHiddenTransforms, ParentType renderOnly) {
        Object object;
        if (!this.visible) {
            return leftToRender;
        }
        matrices.method_22903();
        if (applyHiddenTransforms) {
            this.applyVanillaTransforms(data, matrices, new class_4587());
            this.applyTransforms(matrices);
        } else if (canRender) {
            this.applyTransforms(matrices);
        }
        if (renderOnly == null || this.parentType == renderOnly) {
            canRender = true;
        }
        if (this.light != null) {
            light = class_765.method_23687((int)((int)this.light.field_1343), (int)((int)this.light.field_1342));
        }
        if (this.overlay != null) {
            overlay = class_4608.method_23625((int)((int)this.overlay.field_1343), (int)((int)this.overlay.field_1342));
        }
        if (canRender) {
            if (canRenderTasks) {
                leftToRender = this.renderExtras(leftToRender, data, matrices, vcp, light, overlay);
            }
            if (canRenderHitBox) {
                this.renderHitBox(matrices, vcp.getBuffer((class_1921)class_1921.field_21695));
            }
        }
        if ((object = this) instanceof CustomModelPartGroup) {
            CustomModelPartGroup group = (CustomModelPartGroup)object;
            for (CustomModelPart child : group.children) {
                if (leftToRender <= 0) break;
                if (child.isSpecial()) continue;
                leftToRender = child.renderExtraParts(data, leftToRender, matrices, vcp, light, overlay, canRender, applyHiddenTransforms, renderOnly);
            }
        }
        matrices.method_22909();
        return leftToRender;
    }

    public void draw(class_4597 vcp) {
        if (vcp instanceof FiguraVertexConsumerProvider) {
            FiguraVertexConsumerProvider customVCP = (FiguraVertexConsumerProvider)vcp;
            customVCP.draw();
        } else if (vcp instanceof class_4597.class_4598) {
            class_4597.class_4598 immediate = (class_4597.class_4598)vcp;
            immediate.method_22993();
        } else if (vcp instanceof class_4618) {
            class_4618 outline = (class_4618)vcp;
            outline.method_23285();
        }
    }

    public class_2960 getTexture(AvatarData data) {
        class_2960 textureId = null;
        if (this.textureType == TextureType.Resource) {
            textureId = class_310.method_1551().method_1478().method_14486(this.textureVanilla).isPresent() ? this.textureVanilla : class_1047.method_4539();
        } else if (this.textureType == TextureType.Elytra) {
            if (data.playerListEntry != null) {
                textureId = data.playerListEntry.method_2957();
            }
            if (textureId == null) {
                textureId = FiguraTexture.ELYTRA_ID;
            }
        } else if (data.playerListEntry != null && this.textureType != TextureType.Custom) {
            textureId = this.textureType == TextureType.Cape ? data.playerListEntry.method_2979() : data.playerListEntry.method_2968();
        } else if (data.texture != null) {
            textureId = data.texture.id;
        } else if (data.lastEntity != null) {
            textureId = class_310.method_1551().method_1561().method_3953(data.lastEntity).method_3931(data.lastEntity);
        }
        return textureId == null ? FiguraTexture.DEFAULT_ID : textureId;
    }

    public int renderCube(int leftToRender, class_4587 matrices, class_4588 vertices, int light, int overlay, float u, float v, class_1160 color, float alpha) {
        class_1159 modelMatrix = matrices.method_23760().method_23761();
        class_4581 normalMatrix = matrices.method_23760().method_23762();
        for (int i = 1; i <= this.vertexCount; ++i) {
            int startIndex = (i - 1) * 8;
            FULL_VERT.method_23851(this.vertexData.getFloat(startIndex++), this.vertexData.getFloat(startIndex++), this.vertexData.getFloat(startIndex++), 1.0f);
            float vertU = this.vertexData.getFloat(startIndex++);
            float vertV = this.vertexData.getFloat(startIndex++);
            NORMAL_VERT.method_4949(this.vertexData.getFloat(startIndex++), this.vertexData.getFloat(startIndex++), this.vertexData.getFloat(startIndex));
            FULL_VERT.method_22674(modelMatrix);
            NORMAL_VERT.method_23215(normalMatrix);
            vertices.method_23919(FULL_VERT.method_4953(), FULL_VERT.method_4956(), FULL_VERT.method_4957(), color.method_4943(), color.method_4945(), color.method_4947(), alpha, vertU + u, vertV + v, overlay, light, NORMAL_VERT.method_4943(), NORMAL_VERT.method_4945(), NORMAL_VERT.method_4947());
            if (i % 4 == 0 && (leftToRender -= 4) <= 0) break;
        }
        return leftToRender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int renderExtras(int leftToRender, AvatarData data, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        HashMap<String, RenderTaskAPI.RenderTaskTable> hashMap = this.renderTasks;
        synchronized (hashMap) {
            for (RenderTaskAPI.RenderTaskTable tbl : this.renderTasks.values()) {
                if (!tbl.task.enabled || (leftToRender -= tbl.task.render(data, matrices, vcp, light, overlay)) > 0) continue;
                break;
            }
        }
        return leftToRender;
    }

    public void renderHitBox(class_4587 matrices, class_4588 vertices) {
        float boxSize;
        class_1160 color;
        if (this.getPartType() == PartType.CUBE) {
            color = FiguraMod.FRAN_PINK;
            boxSize = 0.020833334f;
        } else {
            color = FiguraMod.MAYA_BLUE;
            boxSize = 0.041666668f;
        }
        class_761.method_22980((class_4587)matrices, (class_4588)vertices, (double)(-boxSize), (double)(-boxSize), (double)(-boxSize), (double)boxSize, (double)boxSize, (double)boxSize, (float)color.method_4943(), (float)color.method_4945(), (float)color.method_4947(), (float)1.0f);
    }

    public void clearExtraRendering() {
        this.renderTasks.clear();
    }

    public int getComplexity() {
        return this.visible ? this.vertexCount : 0;
    }

    public void updateModelMatrices(class_4587 stack) {
        this.lastModelMatrix = stack.method_23760().method_23761().method_22673();
        this.lastNormalMatrix = stack.method_23760().method_23762().method_23296();
        this.lastModelMatrixInverse = this.lastModelMatrix.method_22673();
        this.lastModelMatrixInverse.method_22870();
        this.lastNormalMatrixInverse = this.lastNormalMatrix.method_23296();
        this.lastNormalMatrixInverse.method_23732();
    }

    public void applyVanillaTransforms(AvatarData data, final class_4587 matrices, final class_4587 transformStack) {
        if (this.parentType == ParentType.Model) {
            return;
        }
        try {
            class_630 part = null;
            class_583<?> class_5832 = data.vanillaModel;
            if (class_5832 instanceof class_591) {
                class_591 model = (class_591)class_5832;
                part = CustomModelPart.getModelPart(model, this.parentType);
            }
            if (part != null) {
                if (this.isMimicMode) {
                    this.rot = new class_1160(part.field_3654, part.field_3675, part.field_3674);
                    this.rot.method_4942(57.295776f);
                } else {
                    part.method_22703(matrices);
                    part.method_22703(transformStack);
                }
            } else if (this.parentType == ParentType.Camera) {
                class_1158 rot = class_310.method_1551().method_1561().method_24197().method_23695();
                class_1160 euler = MathUtils.quaternionToEulerXYZ(rot);
                this.rotate(matrices, euler);
                this.rotate(transformStack, euler);
            } else {
                HashMap<class_2960, VanillaModelPartCustomization> oriModifications = data.model.originModifications;
                VanillaModelPartCustomization cust = new VanillaModelPartCustomization(){
                    {
                        matrices.method_22903();
                        if (CustomModelPart.this.parentType == ParentType.LeftItemOrigin || CustomModelPart.this.parentType == ParentType.RightItemOrigin) {
                            CustomModelPart.this.applyTransformsAsItem(matrices);
                            CustomModelPart.this.applyTransformsAsItem(transformStack);
                        } else {
                            CustomModelPart.this.applyOriginTransforms(matrices);
                            CustomModelPart.this.applyOriginTransforms(transformStack);
                        }
                        this.stackReference = matrices.method_23760();
                        this.part = CustomModelPart.this;
                        this.visible = true;
                        matrices.method_22909();
                    }
                };
                switch (this.parentType) {
                    case LeftItemOrigin: {
                        oriModifications.put(ItemModelAPI.VANILLA_LEFT_HAND_ID, cust);
                        break;
                    }
                    case RightItemOrigin: {
                        oriModifications.put(ItemModelAPI.VANILLA_RIGHT_HAND_ID, cust);
                        break;
                    }
                    case LeftElytraOrigin: {
                        oriModifications.put(ElytraModelAPI.VANILLA_LEFT_WING_ID, cust);
                        break;
                    }
                    case RightElytraOrigin: {
                        oriModifications.put(ElytraModelAPI.VANILLA_RIGHT_WING_ID, cust);
                        break;
                    }
                    case LeftParrotOrigin: {
                        oriModifications.put(ParrotModelAPI.VANILLA_LEFT_PARROT_ID, cust);
                        break;
                    }
                    case RightParrotOrigin: {
                        oriModifications.put(ParrotModelAPI.VANILLA_RIGHT_PARROT_ID, cust);
                        break;
                    }
                    case LeftSpyglass: {
                        oriModifications.put(SpyglassModelAPI.VANILLA_LEFT_SPYGLASS_ID, cust);
                        break;
                    }
                    case RightSpyglass: {
                        oriModifications.put(SpyglassModelAPI.VANILLA_RIGHT_SPYGLASS_ID, cust);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class_630 getModelPart(class_591<?> model, ParentType parent) {
        return switch (parent) {
            case ParentType.Head -> model.field_3398;
            case ParentType.Torso -> model.field_3391;
            case ParentType.LeftArm -> model.field_27433;
            case ParentType.LeftLeg -> model.field_3397;
            case ParentType.RightArm -> model.field_3401;
            case ParentType.RightLeg -> model.field_3392;
            default -> null;
        };
    }

    public void applyTransforms(class_4587 stack) {
        stack.method_22904((double)(this.pos.method_4943() / 16.0f), (double)(this.pos.method_4945() / 16.0f), (double)(this.pos.method_4947() / 16.0f));
        stack.method_22904((double)(-this.pivot.method_4943() / 16.0f), (double)(-this.pivot.method_4945() / 16.0f), (double)(-this.pivot.method_4947() / 16.0f));
        if (this.isMimicMode) {
            this.vanillaRotate(stack, this.rot);
        } else {
            this.rotate(stack, this.rot);
        }
        stack.method_22905(this.scale.method_4943(), this.scale.method_4945(), this.scale.method_4947());
        stack.method_22904((double)(this.pivot.method_4943() / 16.0f), (double)(this.pivot.method_4945() / 16.0f), (double)(this.pivot.method_4947() / 16.0f));
    }

    public void applyTransformsAsItem(class_4587 stack) {
        stack.method_22907(class_1160.field_20703.method_23214(-90.0f));
        stack.method_22907(class_1160.field_20705.method_23214(180.0f));
        stack.method_22904((double)(this.pivot.method_4943() / 16.0f), (double)(this.pivot.method_4947() / 16.0f), (double)(this.pivot.method_4945() / 16.0f));
        this.rotate(stack, this.rot);
        stack.method_22904((double)(this.pos.method_4943() / 16.0f), (double)(this.pos.method_4945() / 16.0f), (double)(this.pos.method_4947() / 16.0f));
    }

    public void applyOriginTransforms(class_4587 stack) {
        stack.method_22904((double)(-this.pivot.method_4943() / 16.0f), (double)(-this.pivot.method_4945() / 16.0f), (double)(-this.pivot.method_4947() / 16.0f));
        this.rotate(stack, this.rot);
        stack.method_22904((double)(this.pos.method_4943() / 16.0f), (double)(this.pos.method_4945() / 16.0f), (double)(this.pos.method_4947() / 16.0f));
    }

    public void rebuild(class_241 newTexSize) {
        this.texSize = newTexSize;
    }

    public void rotate(class_4587 stack, class_1160 rot) {
        stack.method_22907(class_1160.field_20707.method_23214(rot.method_4947()));
        stack.method_22907(class_1160.field_20705.method_23214(-rot.method_4945()));
        stack.method_22907(class_1160.field_20703.method_23214(-rot.method_4943()));
    }

    public void vanillaRotate(class_4587 stack, class_1160 rot) {
        stack.method_22907(class_1160.field_20707.method_23214(rot.method_4947()));
        stack.method_22907(class_1160.field_20705.method_23214(rot.method_4945()));
        stack.method_22907(class_1160.field_20703.method_23214(rot.method_4943()));
    }

    public void addVertex(class_1160 vert, float u, float v, class_1160 normal, FloatList vertexData) {
        vertexData.add(vert.method_4943() / 16.0f);
        vertexData.add(vert.method_4945() / 16.0f);
        vertexData.add(vert.method_4947() / 16.0f);
        vertexData.add(u);
        vertexData.add(v);
        vertexData.add(-normal.method_4943());
        vertexData.add(-normal.method_4945());
        vertexData.add(-normal.method_4947());
    }

    public void readNbt(class_2487 partNbt) {
        class_2499 list;
        this.name = partNbt.method_10545("nm") ? partNbt.method_10558("nm") : "NULL";
        if (partNbt.method_10545("vb")) {
            this.visible = partNbt.method_10577("vb");
        }
        if (partNbt.method_10545("pos")) {
            list = (class_2499)partNbt.method_10580("pos");
            this.pos = CustomModelPart.vec3fFromNbt(list);
        }
        if (partNbt.method_10545("rot")) {
            list = (class_2499)partNbt.method_10580("rot");
            this.rot = CustomModelPart.vec3fFromNbt(list);
        }
        if (partNbt.method_10545("scl")) {
            list = (class_2499)partNbt.method_10580("scl");
            this.scale = CustomModelPart.vec3fFromNbt(list);
        }
        if (partNbt.method_10545("piv")) {
            list = (class_2499)partNbt.method_10580("piv");
            this.pivot = CustomModelPart.vec3fFromNbt(list);
        }
        if (partNbt.method_10545("stype")) {
            try {
                this.shaderType = ShaderType.valueOf(partNbt.method_10558("stype"));
            }
            catch (Exception ignored) {
                this.shaderType = ShaderType.None;
            }
        }
    }

    public PartType getPartType() {
        return null;
    }

    public boolean isSpecial() {
        return this.parentType.special;
    }

    public void applyUVMods(class_241 v) {
        this.rebuild(v);
    }

    public static CustomModelPart fromNbt(class_2487 nbt, CustomModel model) {
        String partType;
        class_2520 pt = nbt.method_10580("pt");
        String string = partType = pt == null ? "na" : pt.method_10714();
        if (!MODEL_PART_TYPES.containsKey(partType)) {
            return null;
        }
        Supplier<CustomModelPart> sup = MODEL_PART_TYPES.get(partType);
        CustomModelPart part = sup.get();
        part.model = model;
        part.readNbt(nbt);
        return part;
    }

    public static class_1160 vec3fFromNbt(@Nullable class_2499 nbt) {
        if (nbt == null || nbt.method_10601() != 5) {
            return new class_1160(0.0f, 0.0f, 0.0f);
        }
        return new class_1160(nbt.method_10604(0), nbt.method_10604(1), nbt.method_10604(2));
    }

    public static class_1162 v4fFromNbtList(class_2499 list) {
        return new class_1162(list.method_10604(0), list.method_10604(1), list.method_10604(2), list.method_10604(3));
    }

    public static class_241 v2fFromNbtList(class_2499 list) {
        return new class_241(list.method_10604(0), list.method_10604(1));
    }

    public static enum ParentType {
        Model,
        Head,
        LeftArm,
        RightArm,
        LeftLeg,
        RightLeg,
        Torso,
        WORLD(true),
        LeftItemOrigin,
        RightItemOrigin,
        LeftElytraOrigin,
        RightElytraOrigin,
        LeftParrotOrigin,
        RightParrotOrigin,
        LeftElytra(true),
        RightElytra(true),
        LeftSpyglass,
        RightSpyglass,
        Camera,
        Skull(true),
        Hud(true);

        private final boolean special;

        private ParentType(boolean special) {
            this.special = special;
        }

        private ParentType() {
            this.special = false;
        }
    }

    public static enum ShaderType {
        None(0),
        EndPortal(1),
        Glint(2);

        public final int id;

        private ShaderType(int id) {
            this.id = id;
        }

        public boolean isShader(int shader) {
            return (this.id & shader) == this.id;
        }
    }

    public static enum TextureType {
        Custom,
        Skin,
        Cape,
        Elytra,
        Resource;

    }

    public static enum PartType {
        GROUP("na"),
        CUBE("cub"),
        MESH("msh");

        public final String val;

        private PartType(String value) {
            this.val = value;
        }
    }

    public static class uvData {
        public class_241 uvOffset;
        public class_241 uvSize;

        public void setUVOffset(class_241 uvOffset) {
            this.uvOffset = uvOffset;
        }

        public void setUVSize(class_241 uvSize) {
            this.uvSize = uvSize;
        }
    }

    public static enum UV {
        ALL,
        NORTH,
        SOUTH,
        WEST,
        EAST,
        UP,
        DOWN;

    }
}

