/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.blancworks.figura.assets.FiguraAsset;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.lua.api.model.VanillaModelPartCustomization;
import net.blancworks.figura.models.CustomModelPart;
import net.blancworks.figura.models.CustomModelPartGroup;
import net.blancworks.figura.models.animations.Animation;
import net.blancworks.figura.trust.TrustContainer;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;

public class CustomModel
extends FiguraAsset {
    public final AvatarData owner;
    public final class_2487 modelNbt;
    public final ArrayList<CustomModelPart> allParts = new ArrayList();
    public final Map<CustomModelPart.ParentType, ArrayList<CustomModelPart>> specialParts = new ConcurrentHashMap<CustomModelPart.ParentType, ArrayList<CustomModelPart>>();
    public final Map<String, Animation> animations = new HashMap<String, Animation>();
    public class_241 defaultTextureSize;
    public int leftToRender = 0;
    public int animRendered = 0;
    public int animMaxRender = 0;
    public boolean applyHiddenTransforms = true;
    public CustomModelPart.ParentType renderOnly = null;
    public HashMap<class_2960, VanillaModelPartCustomization> originModifications = new HashMap();

    public CustomModel(class_2487 nbt, AvatarData data) {
        this.readNbt(nbt);
        this.modelNbt = nbt;
        this.owner = data;
        this.isDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CustomModelPart> getSpecialParts(CustomModelPart.ParentType type) {
        Map<CustomModelPart.ParentType, ArrayList<CustomModelPart>> map = this.specialParts;
        synchronized (map) {
            ArrayList<CustomModelPart> list = this.specialParts.get((Object)type);
            return list == null ? new ArrayList<CustomModelPart>() : list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpecialPart(CustomModelPart part) {
        Map<CustomModelPart.ParentType, ArrayList<CustomModelPart>> map = this.specialParts;
        synchronized (map) {
            this.getSpecialParts(part.parentType).remove(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpecialPart(CustomModelPart part) {
        Map<CustomModelPart.ParentType, ArrayList<CustomModelPart>> map = this.specialParts;
        synchronized (map) {
            ArrayList<CustomModelPart> list = this.getSpecialParts(part.parentType);
            list.add(part);
            this.specialParts.put(part.parentType, list);
        }
    }

    public int getMaxRenderAmount() {
        if (this.owner == null) {
            return 0;
        }
        TrustContainer tc = this.owner.getTrustContainer();
        return tc != null ? tc.getTrust(TrustContainer.Trust.COMPLEXITY) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(class_583<?> entity_model, class_4587 matrices, class_4587 transformStack, class_4597 vcp, int light, int overlay, float alpha) {
        if (this.owner == null) {
            return;
        }
        if (this.owner.script != null) {
            this.owner.script.render(this.owner.deltaTime);
        }
        this.leftToRender = this.getMaxRenderAmount();
        ArrayList<CustomModelPart> arrayList = this.allParts;
        synchronized (arrayList) {
            for (CustomModelPart part : this.allParts) {
                if (part.isSpecial() || !part.visible) continue;
                matrices.method_22903();
                try {
                    if (entity_model instanceof class_591) {
                        class_591 player_model = (class_591)entity_model;
                        player_model.method_2805(false);
                    }
                    if (this.owner.lastEntity != null && this.owner.lastEntity.method_7325()) {
                        this.renderOnly = CustomModelPart.ParentType.Head;
                    }
                    CustomModelPart.canRenderHitBox = (Boolean)ConfigManager.Config.RENDER_DEBUG_PARTS_PIVOT.value != false && class_310.method_1551().method_1561().method_3958();
                    this.leftToRender = part.render(this.owner, matrices, transformStack, vcp, light, overlay, alpha);
                    CustomModelPart.canRenderHitBox = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                matrices.method_22909();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderArm(class_4587 matrices, class_4597 vertexConsumers, int light, class_630 arm, class_591<?> model, float alpha) {
        if (this.owner.script != null) {
            this.owner.script.render(this.owner.deltaTime);
        }
        this.leftToRender = this.getMaxRenderAmount();
        ArrayList<CustomModelPart> arrayList = this.allParts;
        synchronized (arrayList) {
            matrices.method_22903();
            if (((Boolean)ConfigManager.Config.FIX_HANDS.value).booleanValue()) {
                arm.method_22703(matrices);
                this.applyHiddenTransforms = false;
            }
            for (CustomModelPart part : this.allParts) {
                if (part.isSpecial() || !part.visible) continue;
                this.renderOnly = arm == model.field_27433 ? CustomModelPart.ParentType.LeftArm : CustomModelPart.ParentType.RightArm;
                this.leftToRender = part.render(this.owner, matrices, new class_4587(), vertexConsumers, light, class_4608.field_21444, alpha);
            }
            this.applyHiddenTransforms = true;
            matrices.method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderSkull(class_4587 matrices, class_4597 vertexConsumers, int light) {
        this.leftToRender = this.getMaxRenderAmount();
        ArrayList<CustomModelPart> skullParts = this.getSpecialParts(CustomModelPart.ParentType.Skull);
        if (!skullParts.isEmpty()) {
            CustomModelPart.canRenderTasks = false;
            for (CustomModelPart modelPart : skullParts) {
                this.leftToRender = modelPart.render(this.owner, matrices, new class_4587(), vertexConsumers, light, class_4608.field_21444, 1.0f);
                if (this.leftToRender > 0) continue;
                break;
            }
            CustomModelPart.canRenderTasks = true;
            return true;
        }
        ArrayList<CustomModelPart> arrayList = this.allParts;
        synchronized (arrayList) {
            this.applyHiddenTransforms = false;
            CustomModelPart.canRenderTasks = false;
            for (CustomModelPart modelPart : this.allParts) {
                this.renderOnly = CustomModelPart.ParentType.Head;
                this.leftToRender = modelPart.render(this.owner, matrices, new class_4587(), vertexConsumers, light, class_4608.field_21444, 1.0f);
                if (this.leftToRender > 0) continue;
                break;
            }
            this.applyHiddenTransforms = true;
            CustomModelPart.canRenderTasks = true;
        }
        if (this.owner.script != null) {
            VanillaModelPartCustomization customization = this.owner.script.allCustomizations.get("HEAD");
            return customization != null && customization.visible != null && customization.visible == false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderWorldParts(double cameraX, double cameraY, double cameraZ, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, float alpha) {
        CustomModelPart.canRenderHitBox = (Boolean)ConfigManager.Config.RENDER_DEBUG_PARTS_PIVOT.value != false && class_310.method_1551().method_1561().method_3958();
        matrices.method_22904(-cameraX, -cameraY, -cameraZ);
        matrices.method_22905(-1.0f, -1.0f, 1.0f);
        Map<CustomModelPart.ParentType, ArrayList<CustomModelPart>> map = this.specialParts;
        synchronized (map) {
            for (CustomModelPart part : this.getSpecialParts(CustomModelPart.ParentType.WORLD)) {
                this.leftToRender = part.render(this.owner, matrices, new class_4587(), vertexConsumers, light, overlay, alpha);
                if (this.leftToRender > 0) continue;
                break;
            }
        }
        CustomModelPart.canRenderHitBox = false;
    }

    public void renderFirstPersonWorldParts(class_4587 matrices, class_4184 camera, float tickDelta) {
        if (this.owner.lastEntity == null || this.owner.vertexConsumerProvider == null) {
            return;
        }
        matrices.method_22903();
        try {
            class_243 cameraPos = camera.method_19326();
            this.renderWorldParts(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, matrices, this.owner.getVCP(), class_310.method_1551().method_1561().method_23839(this.owner.lastEntity, tickDelta), class_4608.field_21444, 1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        matrices.method_22909();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderHudParts(class_4587 matrices) {
        class_310 client = class_310.method_1551();
        float scale = 40.0f;
        float w = (float)client.method_22683().method_4486() / 2.0f;
        float h = (float)client.method_22683().method_4502() / 2.0f;
        matrices.method_22903();
        matrices.method_22904((double)w, (double)h, 0.0);
        matrices.method_22905(scale, scale, -scale);
        class_308.method_24210();
        this.leftToRender = this.getMaxRenderAmount();
        Map<CustomModelPart.ParentType, ArrayList<CustomModelPart>> map = this.specialParts;
        synchronized (map) {
            for (CustomModelPart part : this.getSpecialParts(CustomModelPart.ParentType.Hud)) {
                this.leftToRender = part.render(this.owner, matrices, new class_4587(), this.owner.getVCP(), 0xF000F0, class_4608.field_21444, 1.0f);
                if (this.leftToRender > 0) continue;
                break;
            }
        }
        class_308.method_24211();
        matrices.method_22909();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNbt(class_2487 tag) {
        class_2499 partList;
        class_2499 uv;
        class_2499 animList = tag.method_10554("anim", 10);
        if (animList != null) {
            for (class_2520 nbtElement : animList) {
                class_2487 animTag = (class_2487)nbtElement;
                Animation anim = Animation.fromNbt(animTag);
                this.animations.put(anim.name, anim);
            }
        }
        if ((uv = tag.method_10554("uv", 5)).size() > 0) {
            this.defaultTextureSize = new class_241(uv.method_10604(0), uv.method_10604(1));
        }
        if ((partList = tag.method_10554("parts", 10)) != null) {
            for (class_2520 nbtElement : partList) {
                class_2487 partTag = (class_2487)nbtElement;
                CustomModelPart part = CustomModelPart.fromNbt(partTag, this);
                if (part == null) continue;
                part.rebuild(this.defaultTextureSize);
                this.allParts.add(part);
            }
        }
        ArrayList<CustomModelPart> arrayList = this.allParts;
        synchronized (arrayList) {
            this.specialParts.clear();
            this.allParts.forEach(this::sortPart);
        }
    }

    public void sortPart(CustomModelPart part) {
        if (part.isSpecial()) {
            this.addSpecialPart(part);
        }
        if (part instanceof CustomModelPartGroup) {
            CustomModelPartGroup group = (CustomModelPartGroup)part;
            for (CustomModelPart child : group.children) {
                this.sortPart(child);
            }
        }
    }
}

