/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.UUID;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.gui.PlayerPopup;
import net.blancworks.figura.lua.api.nameplate.NamePlateCustomization;
import net.blancworks.figura.trust.TrustContainer;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_355;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_355.class})
public class PlayerListHudMixin {
    @Unique
    private class_1657 playerEntity;

    @Inject(at={@At(value="RETURN")}, method={"getPlayerName"}, cancellable=true)
    private void getPlayerName(class_640 entry, CallbackInfoReturnable<class_2561> cir) {
        class_2561 badges;
        if (!((Boolean)ConfigManager.Config.PLAYERLIST_MODIFICATIONS.value).booleanValue()) {
            return;
        }
        UUID uuid = entry.method_2966().getId();
        AvatarData data = AvatarDataManager.getDataForPlayer(uuid);
        if (data == null) {
            return;
        }
        class_2561 text = (class_2561)cir.getReturnValue();
        NamePlateCustomization custom = data.script == null ? null : data.script.nameplateCustomizations.get("LIST");
        Object replacement = custom != null && custom.text != null && data.getTrustContainer().getTrust(TrustContainer.Trust.NAMEPLATE_EDIT) == 1 ? NamePlateCustomization.applyCustomization(custom.text) : class_2561.method_43470((String)entry.method_2966().getName());
        if (((Boolean)ConfigManager.Config.BADGES.value).booleanValue() && (badges = NamePlateCustomization.getBadges(data)) != null) {
            replacement.method_10852(badges);
        }
        text = TextUtils.replaceInText(text, "\\b" + entry.method_2966().getName() + "\\b", (class_2561)replacement);
        cir.setReturnValue((Object)text);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawableHelper;drawTexture(Lnet/minecraft/client/util/math/MatrixStack;IIIIFFIIII)V", shift=At.Shift.BEFORE)}, method={"render"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void render(class_4587 matrices, int scaledWindowWidth, class_269 scoreboard, class_266 objective, CallbackInfo ci, class_634 clientPlayNetworkHandler, List<?> list, int i, int j, int l, int m, int n, boolean bl, int q, int r, int s, int t, int u, List<?> list2, int w, int x, int y, int z, int aa, int ab, class_640 playerListEntry2, GameProfile gameProfile, class_1657 playerEntity, boolean bl2, int ae, int af) {
        this.playerEntity = playerEntity;
        if (!AvatarDataManager.panic && PlayerPopup.miniEnabled && x == PlayerPopup.miniSelected) {
            PlayerPopup.data = AvatarDataManager.getDataForPlayer(playerListEntry2.method_2966().getId());
            PlayerPopup.miniSize = list.size();
            matrices.method_22903();
            matrices.method_22904((double)aa, (double)ab, 0.0);
            PlayerPopup.renderMini(matrices);
            matrices.method_22909();
            RenderSystem.setShaderTexture((int)0, (class_2960)playerListEntry2.method_2968());
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawableHelper;drawTexture(Lnet/minecraft/client/util/math/MatrixStack;IIIIFFIIII)V"), method={"render"})
    private void render(class_4587 matrices, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        AvatarData data;
        AvatarData avatarData = data = this.playerEntity == null ? null : AvatarDataManager.getDataForPlayer(this.playerEntity.method_5667());
        if (!((Boolean)ConfigManager.Config.CUSTOM_PLAYER_HEADS.value).booleanValue() || data == null || data.model == null || data.getTrustContainer().getTrust(TrustContainer.Trust.VANILLA_MODEL_EDIT) == 0) {
            class_332.method_25293((class_4587)matrices, (int)x, (int)y, (int)width, (int)height, (float)u, (float)v, (int)regionWidth, (int)regionHeight, (int)textureWidth, (int)textureHeight);
            return;
        }
        class_1041 w = class_310.method_1551().method_22683();
        double guiScale = w.method_4495();
        RenderSystem.enableScissor((int)((int)((double)x * guiScale)), (int)(w.method_4507() - (int)((double)(regionHeight + y) * guiScale)), (int)((int)((double)regionWidth * guiScale)), (int)((int)((double)regionHeight * guiScale)));
        class_308.method_24210();
        class_4587 stack = new class_4587();
        stack.method_22903();
        stack.method_22904((double)(x + 4), (double)(y + 8), 0.0);
        stack.method_22905(-16.0f, 16.0f, 16.0f);
        stack.method_22907(class_1160.field_20705.method_23214(180.0f));
        if (!data.model.renderSkull(stack, data.tryGetImmediate(), 0xF000F0)) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 4.0);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderTexture((int)0, (class_2960)class_310.method_1551().method_1562().method_2871(this.playerEntity.method_5667()).method_2968());
            class_332.method_25293((class_4587)matrices, (int)x, (int)y, (int)width, (int)height, (float)u, (float)v, (int)regionWidth, (int)regionHeight, (int)textureWidth, (int)textureHeight);
            matrices.method_22909();
        }
        stack.method_22909();
        RenderSystem.disableScissor();
        class_308.method_24211();
    }
}

