/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.blancworks.figura.access.ModelPartAccess;
import net.blancworks.figura.access.PlayerEntityRendererAccess;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.lua.api.model.VanillaModelAPI;
import net.blancworks.figura.lua.api.model.VanillaModelPartCustomization;
import net.blancworks.figura.lua.api.nameplate.NamePlateCustomization;
import net.blancworks.figura.trust.TrustContainer;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_1007;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1007.class})
public abstract class PlayerEntityRendererMixin
extends class_922<class_742, class_591<class_742>>
implements PlayerEntityRendererAccess {
    @Unique
    private final ArrayList<class_630> figura$customizedParts = new ArrayList();

    public PlayerEntityRendererMixin(class_5617.class_5618 ctx, class_591<class_742> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"})
    public void onRender(class_742 entity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        AvatarData data = AvatarDataManager.getDataForPlayer(entity.method_5667());
        AvatarData.setRenderingData(data, vertexConsumerProvider, this.method_4038(), class_310.method_1551().method_1488());
        this.field_4673 = 0.5f;
        if (data != null && data.script != null && data.getTrustContainer().getTrust(TrustContainer.Trust.VANILLA_MODEL_EDIT) == 1) {
            class_591 model = (class_591)this.method_4038();
            this.figura$applyPartCustomization("HEAD", model.field_3398, entity);
            this.figura$applyPartCustomization("TORSO", model.field_3391, entity);
            this.figura$applyPartCustomization("LEFT_ARM", model.field_27433, entity);
            this.figura$applyPartCustomization("RIGHT_ARM", model.field_3401, entity);
            this.figura$applyPartCustomization("LEFT_LEG", model.field_3397, entity);
            this.figura$applyPartCustomization("RIGHT_LEG", model.field_3392, entity);
            this.figura$applyPartCustomization("HAT", model.field_3394, entity);
            this.figura$applyPartCustomization("JACKET", model.field_3483, entity);
            this.figura$applyPartCustomization("LEFT_SLEEVE", model.field_3484, entity);
            this.figura$applyPartCustomization("RIGHT_SLEEVE", model.field_3486, entity);
            this.figura$applyPartCustomization("LEFT_PANTS_LEG", model.field_3482, entity);
            this.figura$applyPartCustomization("RIGHT_PANTS_LEG", model.field_3479, entity);
            if (data.script.customShadowSize != null) {
                this.field_4673 = data.script.customShadowSize.floatValue();
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"})
    public void postRender(class_742 entity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        AvatarData data = AvatarDataManager.getDataForPlayer(entity.method_5667());
        if (data != null && data.script != null && data.script.isDone) {
            for (VanillaModelAPI.ModelPartTable partTable : data.script.vanillaModelPartTables) {
                if (VanillaModelAPI.isPartSpecial(partTable.accessor)) continue;
                partTable.updateFromPart();
            }
        }
        this.figura$clearAllPartCustomizations();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderArm"})
    private void onRenderArm(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 entity, class_630 arm, class_630 sleeve, CallbackInfo ci) {
        AvatarData data = AvatarDataManager.getDataForPlayer(entity.method_5667());
        AvatarData.setRenderingData(data, vertexConsumers, this.method_4038(), class_310.method_1551().method_1488());
        if (data == null) {
            return;
        }
        class_591 model = (class_591)this.method_4038();
        this.figura$applyPartCustomization("HEAD", model.field_3398, entity);
        this.figura$applyPartCustomization("TORSO", model.field_3391, entity);
        this.figura$applyPartCustomization("LEFT_ARM", model.field_27433, entity);
        this.figura$applyPartCustomization("RIGHT_ARM", model.field_3401, entity);
        this.figura$applyPartCustomization("LEFT_LEG", model.field_3397, entity);
        this.figura$applyPartCustomization("RIGHT_LEG", model.field_3392, entity);
        this.figura$applyPartCustomization("HAT", model.field_3394, entity);
        this.figura$applyPartCustomization("JACKET", model.field_3483, entity);
        this.figura$applyPartCustomization("LEFT_SLEEVE", model.field_3484, entity);
        this.figura$applyPartCustomization("RIGHT_SLEEVE", model.field_3486, entity);
        this.figura$applyPartCustomization("LEFT_PANTS_LEG", model.field_3482, entity);
        this.figura$applyPartCustomization("RIGHT_PANTS_LEG", model.field_3479, entity);
    }

    @Inject(at={@At(value="RETURN")}, method={"renderArm"})
    private void postRenderArm(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 entity, class_630 arm, class_630 sleeve, CallbackInfo ci) {
        class_1007 realRenderer = (class_1007)this;
        class_591 model = (class_591)realRenderer.method_4038();
        AvatarData data = AvatarDataManager.getDataForPlayer(entity.method_5667());
        if (data != null && data.model != null) {
            arm.field_3654 = 0.0f;
            data.model.renderArm(matrices, data.getVCP(), light, arm, model, 1.0f);
        }
        this.figura$clearAllPartCustomizations();
    }

    @Inject(method={"renderLabelIfPresent(Lnet/minecraft/client/network/AbstractClientPlayerEntity;Lnet/minecraft/text/Text;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderFiguraLabelIfPresent(class_742 entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        float y;
        float x;
        class_269 scoreboard;
        class_266 scoreboardObjective;
        class_2561 badges;
        NamePlateCustomization custom;
        AvatarData data = AvatarDataManager.getDataForPlayer(entity.method_5667());
        if (data == null || !((Boolean)ConfigManager.Config.NAMEPLATE_MODIFICATIONS.value).booleanValue()) {
            return;
        }
        if (this.field_4676.method_23168((class_1297)entity) > 4096.0) {
            return;
        }
        NamePlateCustomization namePlateCustomization = custom = data.script == null ? null : data.script.nameplateCustomizations.get("ENTITY");
        if (custom != null && custom.enabled != null && !custom.enabled.booleanValue()) {
            ci.cancel();
            return;
        }
        boolean trust = data.getTrustContainer().getTrust(TrustContainer.Trust.NAMEPLATE_EDIT) == 1;
        matrices.method_22903();
        class_1160 pos = new class_1160(0.0f, entity.method_17682() + 0.5f, 0.0f);
        if (custom != null && custom.position != null && trust) {
            pos.method_23846(custom.position);
        }
        matrices.method_22904((double)pos.method_4943(), (double)pos.method_4945(), (double)pos.method_4947());
        matrices.method_22907(this.field_4676.method_24197());
        float scale = 0.025f;
        class_1160 scaleVec = new class_1160(-scale, -scale, scale);
        if (custom != null && custom.scale != null && trust) {
            scaleVec.method_23849(custom.scale.method_4943(), custom.scale.method_4945(), custom.scale.method_4947());
        }
        matrices.method_22905(scaleVec.method_4943(), scaleVec.method_4945(), scaleVec.method_4947());
        Object replacement = custom != null && custom.text != null && trust ? NamePlateCustomization.applyCustomization(custom.text) : class_2561.method_43470((String)entity.method_5477().getString());
        if (((Boolean)ConfigManager.Config.BADGES.value).booleanValue() && (badges = NamePlateCustomization.getBadges(data)) != null) {
            replacement.method_10852(badges);
        }
        text = TextUtils.replaceInText(text, "\\b" + entity.method_5477().getString() + "\\b", (class_2561)replacement);
        boolean isSneaking = entity.method_21751();
        boolean deadmau = "deadmau5".equals(text.getString());
        float bgOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int bgColor = (int)(bgOpacity * 255.0f) << 24;
        class_1159 matrix4f = matrices.method_23760().method_23761();
        class_327 textRenderer = this.method_3932();
        boolean hasScore = false;
        if (this.field_4676.method_23168((class_1297)entity) < 100.0 && (scoreboardObjective = (scoreboard = entity.method_7327()).method_1189(2)) != null) {
            hasScore = true;
            class_267 scoreboardPlayerScore = scoreboard.method_1180(entity.method_5820(), scoreboardObjective);
            class_5250 text1 = class_2561.method_43470((String)Integer.toString(scoreboardPlayerScore.method_1126())).method_27693(" ").method_10852(scoreboardObjective.method_1114());
            x = (float)(-textRenderer.method_27525((class_5348)text1)) / 2.0f;
            y = deadmau ? -10.0f : 0.0f;
            textRenderer.method_30882((class_2561)text1, x, y, 0x20FFFFFF, false, matrix4f, vertexConsumers, !isSneaking, bgColor, light);
            if (!isSneaking) {
                textRenderer.method_30882((class_2561)text1, x, y, -1, false, matrix4f, vertexConsumers, false, 0, light);
            }
        }
        List<class_2561> textList = TextUtils.splitText(text, "\n");
        for (int i = 0; i < textList.size(); ++i) {
            class_2561 text1 = textList.get(i);
            int line = i - textList.size() + (hasScore ? 0 : 1);
            x = (float)(-textRenderer.method_27525((class_5348)text1)) / 2.0f;
            float f = deadmau ? -10.0f : 0.0f;
            Objects.requireNonNull(textRenderer);
            y = f + (9.0f + 1.5f) * (float)line;
            textRenderer.method_30882(text1, x, y, 0x20FFFFFF, false, matrix4f, vertexConsumers, !isSneaking, bgColor, light);
            if (isSneaking) continue;
            textRenderer.method_30882(text1, x, y, -1, false, matrix4f, vertexConsumers, false, 0, light);
        }
        matrices.method_22909();
        ci.cancel();
    }

    public void figura$applyPartCustomization(String id, class_630 part, class_742 entity) {
        VanillaModelPartCustomization customization;
        AvatarData data = AvatarDataManager.getDataForPlayer(entity.method_5667());
        if (data != null && data.script != null && data.script.allCustomizations != null && (customization = data.script.allCustomizations.get(id)) != null) {
            ((ModelPartAccess)part).figura$setPartCustomization(customization);
            this.figura$customizedParts.add(part);
        }
    }

    public void figura$clearAllPartCustomizations() {
        for (class_630 part : this.figura$customizedParts) {
            ((ModelPartAccess)part).figura$setPartCustomization(null);
        }
        this.figura$customizedParts.clear();
    }

    @Override
    public void figura$setupTransformsPublic(class_742 abstractClientPlayerEntity, class_4587 matrixStack, float f, float g, float h) {
        this.method_4058((class_1309)abstractClientPlayerEntity, matrixStack, f, g, h);
    }
}

