/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.mixin;

import java.util.ArrayList;
import net.blancworks.figura.access.ModelPartAccess;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.api.model.VanillaModelAPI;
import net.blancworks.figura.lua.api.model.VanillaModelPartCustomization;
import net.blancworks.figura.trust.TrustContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4840;
import net.minecraft.class_4842;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_922;
import net.minecraft.class_927;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_927.class})
public abstract class MobEntityRendererMixin<T extends class_1308, M extends class_583<T>>
extends class_922<T, M> {
    @Unique
    private final ArrayList<class_630> figura$customizedParts = new ArrayList();

    public MobEntityRendererMixin(class_5617.class_5618 ctx, M model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/entity/mob/MobEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"})
    public void onRender(T entity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        class_927 mob = (class_927)this;
        AvatarData data = AvatarDataManager.getDataForEntity(entity);
        AvatarData.setRenderingData(data, vertexConsumerProvider, mob.method_4038(), class_310.method_1551().method_1488());
        if (mob instanceof class_4842) {
            class_4842 renderer = (class_4842)mob;
            if (data != null && data.script != null && data.getTrustContainer().getTrust(TrustContainer.Trust.VANILLA_MODEL_EDIT) == 1) {
                this.figura$applyPartCustomization("HEAD", ((class_4840)renderer.method_4038()).field_3398, (class_1297)entity);
                this.figura$applyPartCustomization("TORSO", ((class_4840)renderer.method_4038()).field_3391, (class_1297)entity);
                this.figura$applyPartCustomization("LEFT_ARM", ((class_4840)renderer.method_4038()).field_27433, (class_1297)entity);
                this.figura$applyPartCustomization("RIGHT_ARM", ((class_4840)renderer.method_4038()).field_3401, (class_1297)entity);
                this.figura$applyPartCustomization("LEFT_LEG", ((class_4840)renderer.method_4038()).field_3397, (class_1297)entity);
                this.figura$applyPartCustomization("RIGHT_LEG", ((class_4840)renderer.method_4038()).field_3392, (class_1297)entity);
                this.figura$applyPartCustomization("HAT", ((class_4840)renderer.method_4038()).field_3394, (class_1297)entity);
                this.figura$applyPartCustomization("JACKET", ((class_4840)renderer.method_4038()).field_3483, (class_1297)entity);
                this.figura$applyPartCustomization("LEFT_SLEEVE", ((class_4840)renderer.method_4038()).field_3484, (class_1297)entity);
                this.figura$applyPartCustomization("RIGHT_SLEEVE", ((class_4840)renderer.method_4038()).field_3486, (class_1297)entity);
                this.figura$applyPartCustomization("LEFT_PANTS_LEG", ((class_4840)renderer.method_4038()).field_3482, (class_1297)entity);
                this.figura$applyPartCustomization("RIGHT_PANTS_LEG", ((class_4840)renderer.method_4038()).field_3479, (class_1297)entity);
                if (data.script.customShadowSize != null) {
                    this.field_4673 = data.script.customShadowSize.floatValue();
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"render(Lnet/minecraft/entity/mob/MobEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"})
    public void postRender(T entity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        AvatarData data = AvatarDataManager.getDataForEntity(entity);
        if (data != null && data.script != null && data.script.isDone) {
            for (VanillaModelAPI.ModelPartTable partTable : data.script.vanillaModelPartTables) {
                if (VanillaModelAPI.isPartSpecial(partTable.accessor)) continue;
                partTable.updateFromPart();
            }
        }
        this.figura$clearAllPartCustomizations();
    }

    public void figura$applyPartCustomization(String id, class_630 part, class_1297 entity) {
        VanillaModelPartCustomization customization;
        AvatarData data = AvatarDataManager.getDataForEntity(entity);
        if (data != null && data.script != null && data.script.allCustomizations != null && (customization = data.script.allCustomizations.get(id)) != null) {
            ((ModelPartAccess)part).figura$setPartCustomization(customization);
            this.figura$customizedParts.add(part);
        }
    }

    public void figura$clearAllPartCustomizations() {
        for (class_630 part : this.figura$customizedParts) {
            ((ModelPartAccess)part).figura$setPartCustomization(null);
        }
        this.figura$customizedParts.clear();
    }
}

