/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.mixin;

import java.util.Map;
import java.util.UUID;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.gui.ActionWheel;
import net.blancworks.figura.gui.NewActionWheel;
import net.blancworks.figura.gui.PlayerPopup;
import net.blancworks.figura.lua.api.RenderLayerAPI;
import net.blancworks.figura.lua.api.keybind.FiguraKeybind;
import net.blancworks.figura.lua.api.sound.FiguraSoundManager;
import net.blancworks.figura.mixin.PlayerListHudAccessorMixin;
import net.blancworks.figura.models.CustomModel;
import net.blancworks.figura.models.animations.Animation;
import net.blancworks.figura.models.shaders.FiguraVertexConsumerProvider;
import net.blancworks.figura.trust.TrustContainer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_315;
import net.minecraft.class_317;
import net.minecraft.class_329;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public class MinecraftClientMixin {
    @Shadow
    @Final
    public class_312 field_1729;
    @Shadow
    @Final
    public class_329 field_1705;
    @Shadow
    @Final
    public class_315 field_1690;
    @Shadow
    @Final
    private class_317 field_1728;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_1297 field_1719;
    @Unique
    private boolean wasMouseScriptUnlocked = false;
    @Unique
    private boolean wereIrisShadersEnabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void preRender(boolean tick, CallbackInfo ci) {
        Map<UUID, AvatarData> map = AvatarDataManager.LOADED_PLAYER_DATA;
        synchronized (map) {
            for (AvatarData data : AvatarDataManager.LOADED_PLAYER_DATA.values()) {
                if (data == null || data.model == null || !data.model.isDone) continue;
                CustomModel model = data.model;
                model.animRendered = 0;
                model.animMaxRender = data.getTrustContainer().getTrust(TrustContainer.Trust.BB_ANIMATIONS);
                if (model.animMaxRender <= 0) continue;
                for (Animation anim : model.animations.values()) {
                    if (anim.playState == Animation.PlayState.STOPPED) continue;
                    model.animRendered = anim.render(model.animRendered, model.animMaxRender);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(at={@At(value="RETURN")}, method={"render"})
    public void afterRender(boolean tick, CallbackInfo ci) {
        if (RenderLayerAPI.areIrisShadersEnabled() != this.wereIrisShadersEnabled) {
            class_310.method_1551().method_15993();
        }
        this.wereIrisShadersEnabled = RenderLayerAPI.areIrisShadersEnabled();
        if (FiguraVertexConsumerProvider.isUsingLastFramebuffer) {
            RenderLayerAPI.blitMainFramebuffer(RenderLayerAPI.lastFramebufferCopy);
            FiguraVertexConsumerProvider.isUsingLastFramebuffer = false;
        }
        Map<UUID, AvatarData> map = AvatarDataManager.LOADED_PLAYER_DATA;
        synchronized (map) {
            for (AvatarData data : AvatarDataManager.LOADED_PLAYER_DATA.values()) {
                if (data == null || data.model == null || !data.model.isDone) continue;
                for (Animation anim : data.model.animations.values()) {
                    anim.clearAnimData();
                }
            }
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;clear(IZ)V"), index=0)
    public int clearMask(int defaultMask) {
        return defaultMask | 0x100 | 0x4000 | 0x400;
    }

    @Inject(at={@At(value="HEAD")}, method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"})
    public void disconnect(class_437 screen, CallbackInfo ci) {
        try {
            FiguraSoundManager.getChannel().stopAllSounds();
            AvatarDataManager.clearCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    @Inject(at={@At(value="RETURN")}, method={"handleInputEvents"})
    public void handleInputEvents(CallbackInfo ci) {
        block15: {
            block14: {
                block16: {
                    if (FiguraMod.PANIC_BUTTON.method_1436()) {
                        RenderLayerAPI.restoreDefaults();
                        FiguraSoundManager.getChannel().stopAllSounds();
                        AvatarData.currentRenderingData = null;
                        AvatarDataManager.panic = AvatarDataManager.panic == false;
                        return;
                    }
                    if (AvatarDataManager.panic) {
                        return;
                    }
                    if (FiguraMod.ACTION_WHEEL_BUTTON.method_1434()) {
                        this.field_1729.method_1610();
                    } else if (ActionWheel.enabled || NewActionWheel.enabled) {
                        if (((Boolean)ConfigManager.Config.ACTION_WHEEL_EXECUTE_ON_CLOSE.value).booleanValue()) {
                            ActionWheel.play();
                            NewActionWheel.play();
                        }
                        ActionWheel.enabled = false;
                        NewActionWheel.enabled = false;
                        this.field_1729.method_1612();
                    }
                    if (!FiguraMod.PLAYER_POPUP_BUTTON.method_1434()) break block14;
                    if (PlayerPopup.data != null) break block15;
                    target = this.getTargetedEntity();
                    if (!((PlayerListHudAccessorMixin)this.field_1705.method_1750()).isVisible()) break block16;
                    PlayerPopup.miniEnabled = true;
                    break block15;
                }
                if (!(target instanceof class_1657)) ** GOTO lbl-1000
                player = (class_1657)target;
                if (!target.method_5756((class_1657)this.field_1724)) {
                    PlayerPopup.data = AvatarDataManager.getDataForPlayer(player.method_5667());
                } else if (!this.field_1690.method_31044().method_31034()) {
                    PlayerPopup.data = AvatarDataManager.localPlayer;
                }
                break block15;
            }
            if (PlayerPopup.enabled || PlayerPopup.miniEnabled) {
                PlayerPopup.execute();
            }
        }
        for (i = 0; i < PlayerPopup.BUTTONS.size(); ++i) {
            if (!this.field_1690.field_1852[i].method_1434()) continue;
            PlayerPopup.hotbarKeyPressed(i);
        }
        data = AvatarDataManager.localPlayer;
        if (data != null && data.script != null && data.script.unlockCursor) {
            this.field_1729.method_1610();
            this.wasMouseScriptUnlocked = true;
        } else if (this.wasMouseScriptUnlocked) {
            this.field_1729.method_1612();
            this.wasMouseScriptUnlocked = false;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"setScreen"})
    public void setScreen(class_437 screen, CallbackInfo ci) {
        if (ActionWheel.enabled || NewActionWheel.enabled) {
            if (((Boolean)ConfigManager.Config.ACTION_WHEEL_EXECUTE_ON_CLOSE.value).booleanValue()) {
                ActionWheel.play();
                NewActionWheel.play();
            }
            ActionWheel.enabled = false;
            NewActionWheel.enabled = false;
        }
        FiguraKeybind.unpressAll();
    }

    @Unique
    private class_1297 getTargetedEntity() {
        class_238 box;
        if (this.field_1719 == null) {
            return null;
        }
        float maxDistance = 16.0f;
        float tickDelta = this.field_1728.field_1970;
        class_243 vec3d = this.field_1719.method_5836(tickDelta);
        double raycastDistance = this.field_1719.method_5745((double)maxDistance, tickDelta, false).method_17784().method_1025(vec3d);
        class_243 vec3d2 = this.field_1719.method_5828(1.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * (double)maxDistance, vec3d2.field_1351 * (double)maxDistance, vec3d2.field_1350 * (double)maxDistance);
        class_3966 entityHitResult = class_1675.method_18075((class_1297)this.field_1719, (class_243)vec3d, (class_243)vec3d3, (class_238)(box = this.field_1719.method_5829().method_18804(vec3d2.method_1021((double)maxDistance)).method_1009(1.0, 1.0, 1.0)), entity -> !entity.method_7325() && entity.method_5863(), (double)raycastDistance);
        if (entityHitResult != null) {
            class_1297 entity2 = entityHitResult.method_17782();
            class_243 vec3d4 = entityHitResult.method_17784();
            double g = vec3d.method_1025(vec3d4);
            if (g < raycastDistance && entity2 instanceof class_1309) {
                return entity2;
            }
        }
        return null;
    }
}

