/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.mixin;

import java.util.UUID;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.access.InGameHudAccess;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.gui.ActionWheel;
import net.blancworks.figura.gui.NewActionWheel;
import net.blancworks.figura.gui.PlayerPopup;
import net.blancworks.figura.lua.api.nameplate.NamePlateCustomization;
import net.blancworks.figura.trust.TrustContainer;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_329.class})
public class InGameHudMixin
implements InGameHudAccess {
    @Shadow
    private class_2561 field_2016;
    @Shadow
    private class_2561 field_2039;
    @Shadow
    private class_2561 field_2018;
    @Shadow
    @Final
    private class_310 field_2035;

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void preRender(class_4587 matrices, float tickDelta, CallbackInfo ci) {
        if (!AvatarDataManager.panic && FiguraMod.PLAYER_POPUP_BUTTON.method_1434()) {
            PlayerPopup.render(matrices);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    public void postRender(class_4587 matrices, float tickDelta, CallbackInfo ci) {
        class_1297 entity;
        if (!AvatarDataManager.panic && FiguraMod.ACTION_WHEEL_BUTTON.method_1434()) {
            ActionWheel.render(matrices);
        }
        if ((entity = class_310.method_1551().method_1560()) != null) {
            AvatarData data;
            AvatarData avatarData = data = entity instanceof class_1657 ? AvatarDataManager.getDataForPlayer(entity.method_5667()) : AvatarDataManager.getDataForEntity(entity);
            if (data != null && data.model != null) {
                data.model.renderHudParts(matrices);
            }
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/option/KeyBinding;isPressed()Z"))
    private boolean onPlayerListRender(class_304 keyPlayerList) {
        return keyPlayerList.method_1434() || PlayerPopup.miniEnabled;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderCrosshair"}, cancellable=true)
    private void renderCrosshair(class_4587 matrices, CallbackInfo ci) {
        LocalAvatarData currentData;
        if (AvatarDataManager.panic) {
            return;
        }
        if (FiguraMod.ACTION_WHEEL_BUTTON.method_1434() && (ActionWheel.enabled || NewActionWheel.enabled)) {
            ci.cancel();
        }
        if ((currentData = AvatarDataManager.localPlayer) != null && currentData.script != null && !currentData.script.crossHairEnabled) {
            ci.cancel();
        }
    }

    @ModifyArgs(method={"renderCrosshair"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/InGameHud;drawTexture(Lnet/minecraft/client/util/math/MatrixStack;IIIIII)V", ordinal=0))
    private void renderCrosshairDrawTexture(Args args) {
        LocalAvatarData currentData = AvatarDataManager.localPlayer;
        if (!AvatarDataManager.panic && currentData != null && currentData.script != null && currentData.script.crossHairPos != null) {
            args.set(1, (Object)((int)((float)((Integer)args.get(1)).intValue() + currentData.script.crossHairPos.field_1343)));
            args.set(2, (Object)((int)((float)((Integer)args.get(2)).intValue() + currentData.script.crossHairPos.field_1342)));
        }
    }

    @ModifyArgs(method={"onChatMessage"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/ClientChatListener;onChatMessage(Lnet/minecraft/network/message/MessageType;Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSender;)V"))
    private void onChatMessage(Args args) {
        if (this.field_2035.field_1724 == null || !((Boolean)ConfigManager.Config.CHAT_MODIFICATIONS.value).booleanValue()) {
            return;
        }
        for (UUID uuid : this.field_2035.field_1724.field_3944.method_31363()) {
            class_2561 badges;
            class_640 player = this.field_2035.field_1724.field_3944.method_2871(uuid);
            if (player == null) continue;
            AvatarData data = AvatarDataManager.getDataForPlayer(uuid);
            if (data == null) {
                return;
            }
            class_2561 message = (class_2561)args.get(1);
            NamePlateCustomization custom = data.script == null ? null : data.script.nameplateCustomizations.get("CHAT");
            Object replacement = custom != null && custom.text != null && data.getTrustContainer().getTrust(TrustContainer.Trust.NAMEPLATE_EDIT) == 1 ? NamePlateCustomization.applyCustomization(custom.text.replaceAll("\n|\\\\n", "")) : class_2561.method_43470((String)player.method_2966().getName());
            if (((Boolean)ConfigManager.Config.BADGES.value).booleanValue() && (badges = NamePlateCustomization.getBadges(data)) != null) {
                replacement.method_10852(badges);
            }
            args.set(1, (Object)TextUtils.replaceInText(message, "\\b" + player.method_2966().getName() + "\\b", (class_2561)replacement));
        }
    }

    @Override
    public class_2561 getTitle() {
        return this.field_2016;
    }

    @Override
    public class_2561 getSubtitle() {
        return this.field_2039;
    }

    @Override
    public class_2561 getOverlayMessage() {
        return this.field_2018;
    }
}

