/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.network;

import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.CustomScript;
import net.minecraft.class_2960;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class PingsAPI {
    public static class_2960 getID() {
        return new class_2960("default", "ping");
    }

    public static LuaTable getForScript(CustomScript script) {
        return new PingsAPILuaTable(script);
    }

    private static class PingsAPILuaTable
    extends LuaTable {
        private final CustomScript targetScript;

        private PingsAPILuaTable(CustomScript script) {
            this.targetScript = script;
        }

        public void rawset(LuaValue key, LuaValue value) {
            if (!key.isstring() || !value.isfunction()) {
                throw new LuaError("Error while registering ping");
            }
            LuaTable tbl = new LuaTable();
            tbl.set("key", key);
            tbl.set("value", value);
            this.targetScript.registerPing(tbl);
            super.rawset(key, (LuaValue)new PingFunction(this.targetScript, tbl));
        }
    }

    private static class PingFunction
    extends LuaFunction {
        private final CustomScript targetScript;
        private final LuaTable func;

        public PingFunction(CustomScript script, LuaTable func) {
            this.targetScript = script;
            this.func = func;
        }

        public LuaValue call() {
            return this.call(NIL);
        }

        public LuaValue call(LuaValue arg) {
            if (this.targetScript.avatarData != AvatarDataManager.localPlayer) {
                return NIL;
            }
            if (this.targetScript.functionMap.isEmpty()) {
                throw new LuaError("Ping cannot be sent before it's registered!");
            }
            try {
                short id = (Short)this.targetScript.functionMap.inverse().get((Object)this.func);
                CustomScript.LuaPing ping = this.targetScript.handlePing(id, arg, null);
                if (ping != null && !this.targetScript.avatarData.isLocalAvatar) {
                    this.targetScript.outgoingPingQueue.add(ping);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new LuaError("Something went wrong while sending ping!");
            }
            return NIL;
        }

        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            return this.call(arg1);
        }

        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            return this.call(arg1);
        }

        public Varargs invoke(Varargs args) {
            LuaValue[] val = new LuaValue[]{this.call(args.arg(1))};
            return PingFunction.varargsOf((LuaValue[])val);
        }
    }
}

