/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.network;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import net.blancworks.figura.lua.api.math.LuaVector;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class LuaNetworkReadWriter {
    public static final byte TABLE_ID = 0;
    public static final byte INT_ID = 1;
    public static final byte FLOAT_ID = 2;
    public static final byte BOOL_ID = 3;
    public static final byte STRING_ID = 4;
    public static final byte NIL_ID = 5;
    public static final byte VECTOR_ID = 6;

    public static void writeLuaValue(LuaValue val, LittleEndianDataOutputStream stream) throws Exception {
        if (val instanceof LuaVector) {
            LuaVector vec = (LuaVector)val;
            LuaNetworkReadWriter.writeLuaValue(vec, stream);
        } else if (val.isint()) {
            LuaNetworkReadWriter.writeLuaValue(val.checkinteger(), stream);
        } else if (val.isnumber()) {
            LuaNetworkReadWriter.writeLuaValue(val.checkdouble(), stream);
        } else if (val.isboolean()) {
            LuaNetworkReadWriter.writeLuaValue(val.checkboolean(), stream);
        } else if (val.isstring()) {
            LuaNetworkReadWriter.writeLuaValue(val.checkstring(), stream);
        } else if (val.istable()) {
            LuaNetworkReadWriter.writeLuaValue(val.checktable(), stream);
        } else {
            stream.writeByte(5);
        }
    }

    public static LuaValue readLuaValue(LittleEndianDataInputStream stream) throws IOException {
        byte type = stream.readByte();
        if (type == 6) {
            return LuaNetworkReadWriter.readLuaVector(stream);
        }
        if (type == 0) {
            return LuaNetworkReadWriter.readLuaTable(stream);
        }
        if (type == 1) {
            return LuaNetworkReadWriter.readLuaInt(stream);
        }
        if (type == 2) {
            return LuaNetworkReadWriter.readLuaDouble(stream);
        }
        if (type == 3) {
            return LuaNetworkReadWriter.readLuaBool(stream);
        }
        if (type == 4) {
            return LuaNetworkReadWriter.readLuaString(stream);
        }
        return LuaValue.NIL;
    }

    public static void writeLuaValue(LuaVector vec, LittleEndianDataOutputStream stream) throws Exception {
        stream.writeByte(6);
        LuaTable tbl = vec.asTable();
        LuaNetworkReadWriter.writeLuaValue(tbl, stream);
    }

    public static void writeLuaValue(LuaTable val, LittleEndianDataOutputStream stream) throws Exception {
        stream.writeByte(0);
        LinkedList<LuaValue> keys = new LinkedList<LuaValue>();
        LinkedList<LuaValue> values = new LinkedList<LuaValue>();
        Varargs n = val.next(LuaValue.NIL);
        while (!n.arg1().isnil()) {
            LuaValue key = n.arg1();
            LuaValue value = n.arg(2);
            if (!key.istable()) {
                keys.add(key);
                values.add(value);
            }
            n = val.next(n.arg1());
        }
        stream.writeShort(keys.size());
        while (keys.size() > 0) {
            LuaNetworkReadWriter.writeLuaValue((LuaValue)keys.poll(), stream);
            LuaNetworkReadWriter.writeLuaValue((LuaValue)values.poll(), stream);
        }
    }

    public static void writeLuaValue(LuaInteger val, LittleEndianDataOutputStream stream) throws IOException {
        stream.writeByte(1);
        stream.writeInt(val.v);
    }

    public static void writeLuaValue(double val, LittleEndianDataOutputStream stream) throws IOException {
        stream.writeByte(2);
        stream.writeFloat((float)val);
    }

    public static void writeLuaValue(boolean val, LittleEndianDataOutputStream stream) throws IOException {
        stream.writeByte(3);
        stream.writeBoolean(val);
    }

    public static void writeLuaValue(LuaString val, LittleEndianDataOutputStream stream) throws Exception {
        String js = val.checkjstring();
        byte[] data = js.getBytes(StandardCharsets.US_ASCII);
        if (data.length > 1019) {
            throw new Exception("String is too large to send! Max string size is 1016 characters.");
        }
        stream.writeByte(4);
        stream.writeShort(data.length);
        stream.write(data);
    }

    public static LuaVector readLuaVector(LittleEndianDataInputStream stream) throws IOException {
        LuaTable tbl = (LuaTable)LuaNetworkReadWriter.readLuaValue(stream);
        return (LuaVector)LuaVector.of(tbl);
    }

    public static LuaTable readLuaTable(LittleEndianDataInputStream stream) throws IOException {
        int count = stream.readShort();
        LuaTable table = new LuaTable();
        table.presize(count);
        for (int i = 0; i < count; ++i) {
            LuaValue key = LuaNetworkReadWriter.readLuaValue(stream);
            LuaValue value = LuaNetworkReadWriter.readLuaValue(stream);
            table.set(key, value);
        }
        return table;
    }

    public static LuaInteger readLuaInt(LittleEndianDataInputStream stream) throws IOException {
        return LuaInteger.valueOf((int)stream.readInt());
    }

    public static LuaNumber readLuaDouble(LittleEndianDataInputStream stream) throws IOException {
        return LuaDouble.valueOf((double)stream.readFloat());
    }

    public static LuaBoolean readLuaBool(LittleEndianDataInputStream stream) throws IOException {
        return LuaBoolean.valueOf((boolean)stream.readBoolean());
    }

    public static LuaString readLuaString(LittleEndianDataInputStream stream) throws IOException {
        short count = stream.readShort();
        byte[] data = new byte[count];
        stream.read(data);
        return LuaString.valueOf((String)new String(data, StandardCharsets.US_ASCII));
    }
}

