/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.nameplate;

import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_2960;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class NamePlateAPI {
    public static final String ENTITY = "ENTITY";
    public static final String CHAT = "CHAT";
    public static final String TABLIST = "LIST";

    public static class_2960 getID() {
        return new class_2960("default", "nameplate");
    }

    public static LuaTable getForScript(final CustomScript script) {
        return new LuaTable(){
            {
                this.set(NamePlateAPI.ENTITY, (LuaValue)NamePlateAPI.getTableForPart(NamePlateAPI.ENTITY, script));
                this.set(NamePlateAPI.CHAT, (LuaValue)NamePlateAPI.getTableForPart(NamePlateAPI.CHAT, script));
                this.set(NamePlateAPI.TABLIST, (LuaValue)NamePlateAPI.getTableForPart(NamePlateAPI.TABLIST, script));
            }
        };
    }

    public static LuaTable getTableForPart(final String accessor, final CustomScript targetScript) {
        return new LuaTable(){
            {
                this.set("getPos", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(targetScript.getOrMakeNameplateCustomization((String)accessor).position);
                    }
                });
                this.set("setPos", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        targetScript.getOrMakeNameplateCustomization((String)accessor).position = arg1.isnil() ? null : LuaVector.checkOrNew(arg1).asV3f();
                        return NIL;
                    }
                });
                this.set("getEnabled", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        Boolean enabled = targetScript.getOrMakeNameplateCustomization((String)accessor).enabled;
                        return enabled == null ? NIL : LuaValue.valueOf((boolean)enabled);
                    }
                });
                this.set("setEnabled", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        targetScript.getOrMakeNameplateCustomization((String)accessor).enabled = arg.isnil() ? null : Boolean.valueOf(arg.checkboolean());
                        return NIL;
                    }
                });
                this.set("getScale", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaVector.of(targetScript.getOrMakeNameplateCustomization((String)accessor).scale);
                    }
                });
                this.set("setScale", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg1) {
                        targetScript.getOrMakeNameplateCustomization((String)accessor).scale = arg1.isnil() ? null : LuaVector.checkOrNew(arg1).asV3f();
                        return NIL;
                    }
                });
                this.set("setText", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        String string = null;
                        if (!arg.isnil()) {
                            string = TextUtils.noBadges4U(arg.checkjstring());
                            if (!accessor.equals(NamePlateAPI.ENTITY)) {
                                string = string.replaceAll("[\n\r]", " ");
                            }
                            if (string.length() > 65535) {
                                throw new LuaError("Nameplate too long - oopsie!");
                            }
                        }
                        targetScript.getOrMakeNameplateCustomization((String)accessor).text = string;
                        return NIL;
                    }
                });
                this.set("getText", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        String text = targetScript.getOrMakeNameplateCustomization((String)accessor).text;
                        return text == null ? NIL : LuaValue.valueOf((String)text);
                    }
                });
            }
        };
    }
}

