/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.model;

import java.util.HashMap;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.lua.api.model.RenderTaskAPI;
import net.blancworks.figura.models.CustomModel;
import net.blancworks.figura.models.CustomModelPart;
import net.blancworks.figura.models.CustomModelPartGroup;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class CustomModelAPI {
    public static class_2960 getID() {
        return new class_2960("default", "model");
    }

    public static LuaTable getForScript(final CustomScript script) {
        return new LuaTable(){
            {
                if (script.avatarData.model != null) {
                    for (CustomModelPart part : script.avatarData.model.allParts) {
                        this.set(part.name, (LuaValue)CustomModelAPI.getTableForPart(part, script));
                    }
                }
            }
        };
    }

    public static LuaTable getTableForPart(final CustomModelPart targetPart, final CustomScript targetScript) {
        LuaTable ret = new LuaTable();
        if (targetPart instanceof CustomModelPartGroup) {
            final CustomModelPartGroup group = (CustomModelPartGroup)targetPart;
            for (CustomModelPart child : group.children) {
                ret.set(child.name, (LuaValue)CustomModelAPI.getTableForPart(child, targetScript));
            }
            ret.set("getChildren", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    LuaTable tbl = new LuaTable();
                    for (CustomModelPart child : group.children) {
                        tbl.set(child.name, (LuaValue)CustomModelAPI.getTableForPart(child, targetScript));
                    }
                    return tbl;
                }
            });
            ret.set("getAnimPos", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    class_1160 pos = group.animPos.method_23850();
                    pos.method_23846(group.animPosOverride);
                    return LuaVector.of(pos);
                }
            });
            ret.set("getAnimRot", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaVector.of(group.animRot);
                }
            });
            ret.set("getAnimScale", (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaVector.of(group.animScale);
                }
            });
        }
        ret.set("getPos", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaVector.of(targetPart.pos);
            }
        });
        ret.set("setPos", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.pos = LuaVector.checkOrNew(arg1).asV3f();
                return NIL;
            }
        });
        ret.set("getPivot", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaVector.of(targetPart.pivot);
            }
        });
        ret.set("setPivot", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.pivot = LuaVector.checkOrNew(arg1).asV3f();
                return NIL;
            }
        });
        ret.set("getColor", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaVector.of(targetPart.color);
            }
        });
        ret.set("setColor", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.color = LuaVector.checkOrNew(arg1).asV3f();
                return NIL;
            }
        });
        ret.set("getScale", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaVector.of(targetPart.scale);
            }
        });
        ret.set("setScale", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.scale = LuaVector.checkOrNew(arg1).asV3f();
                return NIL;
            }
        });
        ret.set("getRot", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaVector.of(targetPart.rot);
            }
        });
        ret.set("setRot", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.rot = LuaVector.checkOrNew(arg1).asV3f();
                return NIL;
            }
        });
        ret.set("getUVData", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                try {
                    CustomModelPart.UV uv = CustomModelPart.UV.valueOf(arg1.checkjstring());
                    if (uv == CustomModelPart.UV.ALL) {
                        throw new LuaError("Cannot get UV data for ALL faces at once");
                    }
                    CustomModelPart.uvData data = targetPart.UVCustomizations.get((Object)uv);
                    if (data == null) {
                        return NIL;
                    }
                    class_241 offset = data.uvOffset;
                    class_241 size = data.uvSize;
                    return new LuaVector(offset.field_1343, offset.field_1342, size.field_1343 - offset.field_1343, size.field_1342 - offset.field_1342);
                }
                catch (Exception ignored) {
                    throw new LuaError("UV Face not found!");
                }
            }
        });
        ret.set("setUVData", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                try {
                    CustomModelPart.UV uv = CustomModelPart.UV.valueOf(arg1.checkjstring());
                    LuaVector vec = LuaVector.checkOrNew(arg2);
                    class_241 offset = new class_241(vec.x(), vec.y());
                    class_241 size = new class_241(vec.z() + vec.x(), vec.w() + vec.y());
                    if (uv == CustomModelPart.UV.ALL) {
                        CustomModelPart.UV[] uvs;
                        for (CustomModelPart.UV uvPart : uvs = CustomModelPart.UV.values()) {
                            CustomModelPart.uvData data = targetPart.UVCustomizations.get((Object)uvPart);
                            if (data == null) {
                                data = new CustomModelPart.uvData();
                                targetPart.UVCustomizations.put(uvPart, data);
                            }
                            data.setUVOffset(offset);
                            data.setUVSize(size);
                        }
                    } else {
                        CustomModelPart.uvData data = targetPart.UVCustomizations.get((Object)uv);
                        if (data == null) {
                            data = new CustomModelPart.uvData();
                            targetPart.UVCustomizations.put(uv, data);
                        }
                        data.setUVOffset(offset);
                        data.setUVSize(size);
                    }
                    targetPart.applyUVMods(targetPart.texSize);
                }
                catch (Exception ignored) {
                    throw new LuaError("UV Face not found!");
                }
                return NIL;
            }
        });
        ret.set("getTextureSize", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                class_241 uv = targetPart.texSize;
                return LuaVector.of(uv);
            }
        });
        ret.set("setTextureSize", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                targetPart.applyUVMods(LuaVector.checkOrNew(arg).asV2f());
                return NIL;
            }
        });
        ret.set("getUV", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                class_241 uv = targetPart.uvOffset;
                return LuaVector.of(uv);
            }
        });
        ret.set("setUV", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                LuaVector vec = LuaVector.checkOrNew(arg);
                targetPart.uvOffset = new class_241(vec.x() % 1.0f, vec.y() % 1.0f);
                return NIL;
            }
        });
        ret.set("getParentType", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaString.valueOf((String)targetPart.parentType.toString());
            }
        });
        ret.set("setParentType", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                CustomModel model = targetPart.model;
                if (targetPart.isSpecial()) {
                    model.removeSpecialPart(targetPart);
                }
                try {
                    targetPart.parentType = CustomModelPart.ParentType.valueOf(arg1.checkjstring());
                    if (targetPart.isSpecial()) {
                        model.addSpecialPart(targetPart);
                    }
                }
                catch (Exception ignored) {
                    targetPart.parentType = CustomModelPart.ParentType.Model;
                }
                return NIL;
            }
        });
        ret.set("getMimicMode", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaBoolean.valueOf((boolean)targetPart.isMimicMode);
            }
        });
        ret.set("setMimicMode", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.isMimicMode = arg1.checkboolean();
                return NIL;
            }
        });
        ret.set("getEnabled", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaBoolean.valueOf((boolean)targetPart.visible);
            }
        });
        ret.set("setEnabled", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                targetPart.visible = arg.checkboolean();
                return NIL;
            }
        });
        ret.set("getShader", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaString.valueOf((String)targetPart.shaderType.toString());
            }
        });
        ret.set("setShader", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                try {
                    targetPart.shaderType = CustomModelPart.ShaderType.valueOf(arg1.checkjstring());
                }
                catch (Exception ignored) {
                    targetPart.shaderType = CustomModelPart.ShaderType.None;
                }
                return NIL;
            }
        });
        ret.set("setRenderLayer", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.customLayer = targetScript.getCustomLayer(arg1);
                return NIL;
            }
        });
        ret.set("getTexture", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaString.valueOf((String)targetPart.textureType.toString());
            }
        });
        ret.set("setTexture", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                try {
                    targetPart.textureType = CustomModelPart.TextureType.valueOf(arg1.checkjstring());
                    if (targetPart.textureType == CustomModelPart.TextureType.Resource) {
                        targetPart.textureVanilla = new class_2960(arg2.checkjstring());
                    }
                }
                catch (Exception ignored) {
                    targetPart.textureType = CustomModelPart.TextureType.Custom;
                }
                return NIL;
            }
        });
        ret.set("getExtraTexEnabled", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaBoolean.valueOf((boolean)targetPart.extraTex);
            }
        });
        ret.set("setExtraTexEnabled", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                targetPart.extraTex = arg.checkboolean();
                return NIL;
            }
        });
        ret.set("getCullEnabled", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaBoolean.valueOf((boolean)targetPart.cull);
            }
        });
        ret.set("setCullEnabled", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                targetPart.cull = arg.checkboolean();
                return NIL;
            }
        });
        ret.set("partToWorldPos", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                LuaVector v = LuaVector.checkOrNew(arg1);
                class_1162 v4f = new class_1162(v.x() / 16.0f, v.y() / -16.0f, v.z() / 16.0f, 1.0f);
                v4f.method_22674(targetPart.lastModelMatrix);
                return LuaVector.of(new class_1160(v4f.method_4953(), v4f.method_4956(), v4f.method_4957()));
            }
        });
        ret.set("partToWorldDir", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                LuaVector v = LuaVector.checkOrNew(arg1);
                class_1160 v3f = new class_1160(v.x(), -v.y(), v.z());
                v3f.method_23215(targetPart.lastNormalMatrix);
                return LuaVector.of(v3f);
            }
        });
        ret.set("worldToPartPos", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                LuaVector v = LuaVector.checkOrNew(arg1);
                class_1162 v4f = new class_1162(v.x(), v.y(), v.z(), 1.0f);
                v4f.method_22674(targetPart.lastModelMatrixInverse);
                return LuaVector.of(new class_1160(v4f.method_4953() * 16.0f, v4f.method_4956() * -16.0f, v4f.method_4957() * 16.0f));
            }
        });
        ret.set("worldToPartDir", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                LuaVector v = LuaVector.checkOrNew(arg1);
                class_1160 v3f = new class_1160(v.x(), v.y(), v.z());
                v3f.method_23215(targetPart.lastNormalMatrixInverse);
                return LuaVector.of(new class_1160(v3f.method_4943(), -v3f.method_4945(), v3f.method_4947()));
            }
        });
        ret.set("getOpacity", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaNumber.valueOf((double)targetPart.alpha);
            }
        });
        ret.set("setOpacity", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.alpha = Math.max(0.0f, Math.min(arg1.checknumber().tofloat(), 1.0f));
                return NIL;
            }
        });
        ret.set("getType", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaValue.valueOf((String)targetPart.getPartType().toString());
            }
        });
        ret.set("getName", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return LuaValue.valueOf((String)targetPart.name);
            }
        });
        ret.set("addRenderTask", (LuaValue)new VarArgFunction(){

            public Varargs onInvoke(Varargs args) {
                return RenderTaskAPI.addTask(targetPart, targetScript, args);
            }
        });
        ret.set("getRenderTask", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                RenderTaskAPI.RenderTaskTable tbl = targetPart.renderTasks.get(arg1.checkjstring());
                if (tbl == null) {
                    return NIL;
                }
                return tbl.getTable(targetScript);
            }
        });
        ret.set("removeRenderTask", (LuaValue)new OneArgFunction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public LuaValue call(LuaValue arg1) {
                HashMap<String, RenderTaskAPI.RenderTaskTable> hashMap = targetPart.renderTasks;
                synchronized (hashMap) {
                    targetPart.renderTasks.remove(arg1.checkjstring());
                    return NIL;
                }
            }
        });
        ret.set("clearAllRenderTasks", (LuaValue)new ZeroArgFunction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public LuaValue call() {
                HashMap<String, RenderTaskAPI.RenderTaskTable> hashMap = targetPart.renderTasks;
                synchronized (hashMap) {
                    targetPart.renderTasks.clear();
                    return NIL;
                }
            }
        });
        ret.set("getLight", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return targetPart.light == null ? NIL : LuaVector.of(targetPart.light);
            }
        });
        ret.set("setLight", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.light = arg1.isnil() ? null : LuaVector.checkOrNew(arg1).asV2f();
                return NIL;
            }
        });
        ret.set("getOverlay", (LuaValue)new ZeroArgFunction(){

            public LuaValue call() {
                return targetPart.overlay == null ? NIL : LuaVector.of(targetPart.overlay);
            }
        });
        ret.set("setOverlay", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg1) {
                targetPart.overlay = arg1.isnil() ? null : LuaVector.checkOrNew(arg1).asV2f();
                return NIL;
            }
        });
        return ret;
    }
}

