/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.math;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class LuaVector
extends LuaValue
implements Iterable<Float> {
    public static final int TYPE = 9;
    private final float[] values;
    private final Map<String, LuaValue> luaValues = new ImmutableMap.Builder().put((Object)"distanceTo", (Object)new OneArgFunction(){

        public LuaValue call(LuaValue arg1) {
            return LuaNumber.valueOf((double)LuaVector.this._distanceTo(arg1));
        }
    }).put((Object)"getLength", (Object)new ZeroArgFunction(){

        public LuaValue call() {
            return LuaNumber.valueOf((double)LuaVector.this._length());
        }
    }).put((Object)"normalized", (Object)new ZeroArgFunction(){

        public LuaValue call() {
            return LuaVector.this._normalized();
        }
    }).put((Object)"dot", (Object)new OneArgFunction(){

        public LuaValue call(LuaValue arg) {
            return LuaValue.valueOf((double)LuaVector.this._dot(arg));
        }
    }).put((Object)"cross", (Object)new OneArgFunction(){

        public LuaValue call(LuaValue arg) {
            return LuaVector.this._cross(arg);
        }
    }).put((Object)"angleTo", (Object)new OneArgFunction(){

        public LuaValue call(LuaValue arg) {
            return LuaValue.valueOf((double)LuaVector.this._angleTo(arg));
        }
    }).put((Object)"toRad", (Object)new ZeroArgFunction(){

        public LuaValue call() {
            return LuaVector.this._toRad();
        }
    }).put((Object)"toDeg", (Object)new ZeroArgFunction(){

        public LuaValue call() {
            return LuaVector.this._toDeg();
        }
    }).put((Object)"asTable", (Object)new ZeroArgFunction(){

        public LuaValue call() {
            return LuaVector.this.asTable();
        }
    }).build();

    public LuaVector(float ... values) {
        if (values.length > 6) {
            throw new IllegalArgumentException("LuaVector cannot have more than 6 fields!");
        }
        this.values = values;
    }

    public static LuaValue of(class_1162 vec) {
        if (vec == null) {
            return NIL;
        }
        return new LuaVector(vec.method_4953(), vec.method_4956(), vec.method_4957(), vec.method_23853());
    }

    public static LuaValue of(class_1160 vec) {
        if (vec == null) {
            return NIL;
        }
        return new LuaVector(vec.method_4943(), vec.method_4945(), vec.method_4947());
    }

    public static LuaValue of(class_243 vec) {
        if (vec == null) {
            return NIL;
        }
        return new LuaVector((float)vec.field_1352, (float)vec.field_1351, (float)vec.field_1350);
    }

    public static LuaValue of(class_2382 vec) {
        if (vec == null) {
            return NIL;
        }
        return new LuaVector(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public static LuaValue of(class_241 vec) {
        if (vec == null) {
            return NIL;
        }
        return new LuaVector(vec.field_1343, vec.field_1342);
    }

    public static LuaValue of(LuaTable t) {
        FloatArrayList fal = new FloatArrayList();
        Varargs entry = t.next(LuaValue.NIL);
        for (int i = 0; i < 6 && !entry.arg1().isnil(); ++i) {
            LuaValue l = entry.arg(2);
            if (l.isnil()) {
                fal.add(0.0f);
            } else if (l.isnumber()) {
                fal.add(l.tofloat());
            } else if (l.istable() || l instanceof LuaVector) {
                LuaVector v = LuaVector.checkOrNew(l);
                fal.addElements(fal.size(), v.values);
            } else {
                LuaValue numb = l.tonumber();
                if (numb.isnil()) {
                    fal.add(0.0f);
                } else {
                    fal.add(numb.tofloat());
                }
            }
            entry = t.next(entry.arg1());
        }
        if (fal.size() > 6) {
            fal.size(6);
        }
        return new LuaVector(fal.toFloatArray());
    }

    public static LuaVector check(LuaValue val) {
        if (val instanceof LuaVector) {
            return (LuaVector)val;
        }
        throw new LuaError("Not a Vector table!");
    }

    public static LuaVector checkOrNew(LuaValue val) {
        if (val instanceof LuaVector) {
            return (LuaVector)val;
        }
        if (val.istable()) {
            return (LuaVector)LuaVector.of((LuaTable)val);
        }
        throw new LuaError("Not a Vector table!");
    }

    public class_1162 asV4f() {
        return new class_1162(this.x(), this.y(), this.z(), this.w());
    }

    public class_1160 asV3f() {
        return new class_1160(this.x(), this.y(), this.z());
    }

    public class_243 asV3d() {
        return new class_243((double)this.x(), (double)this.y(), (double)this.z());
    }

    public class_2382 asV3iFloored() {
        return new class_2382(Math.floor(this.x()), Math.floor(this.y()), Math.floor(this.z()));
    }

    public class_2382 asV3iCeiled() {
        return new class_2382(Math.ceil(this.x()), Math.ceil(this.y()), Math.ceil(this.z()));
    }

    public class_2382 asV3iRounded() {
        return new class_2382(Math.round(this.x()), Math.round(this.y()), Math.round(this.z()));
    }

    public class_241 asV2f() {
        return new class_241(this.x(), this.y());
    }

    public class_2338 asBlockPos() {
        return new class_2338((double)this.x(), (double)this.y(), (double)this.z());
    }

    public LuaTable asTable() {
        LuaTable tbl = new LuaTable();
        for (int i = 1; i < 7; ++i) {
            tbl.insert(i, (LuaValue)LuaValue.valueOf((double)this._get(i).floatValue()));
        }
        return tbl;
    }

    public int type() {
        return 9;
    }

    public String typename() {
        return "vector";
    }

    public LuaValue add(LuaValue rhs) {
        if (rhs.isnumber()) {
            return this._add(rhs.tofloat());
        }
        return this._add(LuaVector.check(rhs));
    }

    public LuaValue sub(LuaValue rhs) {
        if (rhs.isnumber()) {
            return this._sub(rhs.tofloat());
        }
        return this._sub(LuaVector.check(rhs));
    }

    public LuaValue mul(LuaValue rhs) {
        if (rhs.isnumber()) {
            return this._mul(rhs.tofloat());
        }
        return this._mul(LuaVector.check(rhs));
    }

    public LuaValue div(LuaValue rhs) {
        if (rhs.isnumber()) {
            return this._div(rhs.tofloat());
        }
        return this._div(LuaVector.check(rhs));
    }

    public LuaValue get(int key) {
        Float f = this._get(key);
        if (f == null) {
            return NIL;
        }
        return LuaNumber.valueOf((double)f.floatValue());
    }

    public LuaValue get(LuaValue key) {
        return this.rawget(key);
    }

    public LuaValue rawget(LuaValue key) {
        if (key.isnumber()) {
            return this.get(key.checkint());
        }
        return this.get(key.tojstring());
    }

    public LuaValue get(String key) {
        Float f = this._get(key);
        if (f == null) {
            return this._functions(key);
        }
        return LuaNumber.valueOf((double)f.floatValue());
    }

    public void set(LuaValue key, LuaValue value) {
        float f = value.checknumber().tofloat();
        if (key.isnumber()) {
            int index = key.checkint();
            if (index > 6 || index < 1) {
                throw new LuaError("Index out of bounds");
            }
            if (index <= this._size()) {
                this.values[index - 1] = f;
            }
        } else {
            this.values[this._getIndex((String)key.tojstring()).intValue() - 1] = f;
        }
    }

    public LuaValue tostring() {
        return LuaString.valueOf((String)this.toString());
    }

    public float x() {
        return this._get(1).floatValue();
    }

    public float y() {
        return this._get(2).floatValue();
    }

    public float z() {
        return this._get(3).floatValue();
    }

    public float w() {
        return this._get(4).floatValue();
    }

    public float t() {
        return this._get(5).floatValue();
    }

    public float h() {
        return this._get(6).floatValue();
    }

    public LuaVector _add(LuaVector vec) {
        int n = Math.max(this._size(), vec._size());
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this._get(i + 1).floatValue() + vec._get(i + 1).floatValue();
        }
        return new LuaVector(vals);
    }

    public LuaVector _add(float f) {
        int n = this._size();
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this._get(i + 1).floatValue() + f;
        }
        return new LuaVector(vals);
    }

    public LuaVector _sub(LuaVector vec) {
        int n = Math.max(this._size(), vec._size());
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this._get(i + 1).floatValue() - vec._get(i + 1).floatValue();
        }
        return new LuaVector(vals);
    }

    public LuaVector _sub(float f) {
        int n = this._size();
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this._get(i + 1).floatValue() - f;
        }
        return new LuaVector(vals);
    }

    public LuaVector _mul(LuaVector vec) {
        int n = Math.max(this._size(), vec._size());
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this._get(i + 1).floatValue() * vec._get(i + 1).floatValue();
        }
        return new LuaVector(vals);
    }

    public LuaVector _mul(float f) {
        int n = this._size();
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this._get(i + 1).floatValue() * f;
        }
        return new LuaVector(vals);
    }

    public LuaVector _div(LuaVector vec) {
        int n = Math.max(this._size(), vec._size());
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this._get(i + 1).floatValue() / vec._get(i + 1).floatValue();
        }
        return new LuaVector(vals);
    }

    public LuaVector _div(float f) {
        int n = this._size();
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = this._get(i + 1).floatValue() / f;
        }
        return new LuaVector(vals);
    }

    public LuaValue _functions(String name) {
        LuaValue v = this.luaValues.get(name);
        if (v == null) {
            return NIL;
        }
        return v;
    }

    public double _distanceTo(LuaValue vector) {
        LuaVector vec = LuaVector.check(vector);
        int n = Math.max(this._size(), vec._size());
        float s = 0.0f;
        for (int i = 1; i <= n; ++i) {
            float a = this._get(i).floatValue();
            float b = vec._get(i).floatValue();
            if (a == 0.0f && b == 0.0f) continue;
            if (a == 0.0f) {
                s += b * b;
                continue;
            }
            if (b == 0.0f) {
                s += a * a;
                continue;
            }
            s = (float)((double)s + Math.pow(b - a, 2.0));
        }
        return Math.sqrt(s);
    }

    public double _dot(LuaValue vector) {
        LuaVector vec = LuaVector.check(vector);
        int n = Math.max(this._size(), vec._size());
        double s = 0.0;
        for (int i = 1; i <= n; ++i) {
            s += (double)(this._get(i).floatValue() * vec._get(i).floatValue());
        }
        return s;
    }

    public LuaVector _cross(LuaValue vector) {
        LuaVector vec = LuaVector.check(vector);
        int n = Math.max(this._size(), vec._size());
        float[] vals = new float[n];
        for (int i = 0; i < n; ++i) {
            int j = (i + 1) % n + 1;
            int k = (i + 2) % n + 1;
            vals[i] = this._get(j).floatValue() * vec._get(k).floatValue() - this._get(k).floatValue() * vec._get(j).floatValue();
        }
        return new LuaVector(vals);
    }

    public double _angleTo(LuaValue vector) {
        LuaVector other = LuaVector.check(vector);
        return Math.acos(this._dot(other) / (this._length() * other._length()));
    }

    public double _lengthSqr() {
        int n = this._size();
        float s = 0.0f;
        for (int i = 1; i <= n; ++i) {
            float v = this._get(i).floatValue();
            if (v == 0.0f) continue;
            s += v * v;
        }
        return s;
    }

    public double _length() {
        return Math.sqrt(this._lengthSqr());
    }

    public LuaVector _normalized() {
        int n = this._size();
        float s = 0.0f;
        float[] vals = new float[n];
        for (int i = 1; i <= n; ++i) {
            float v = this._get(i).floatValue();
            if (v == 0.0f) continue;
            s += v * v;
        }
        float r = class_3532.method_22858((float)s);
        for (int j = 0; j < n; ++j) {
            float v = this._get(j + 1).floatValue();
            if (v == 0.0f) continue;
            vals[j] = v * r;
        }
        return new LuaVector(vals);
    }

    public LuaVector _toRad() {
        int n = this._size();
        float[] vals = new float[n];
        for (int i = 1; i <= n; ++i) {
            float v = this._get(i).floatValue();
            vals[i - 1] = (float)Math.toRadians(v);
        }
        return new LuaVector(vals);
    }

    public LuaVector _toDeg() {
        int n = this._size();
        float[] vals = new float[n];
        for (int i = 1; i <= n; ++i) {
            float v = this._get(i).floatValue();
            vals[i - 1] = (float)Math.toDegrees(v);
        }
        return new LuaVector(vals);
    }

    public int _size() {
        return this.values.length;
    }

    public Float _get(Integer index) {
        if (index == null || index > 6 || index < 1) {
            return null;
        }
        if (index <= this._size()) {
            return Float.valueOf(this.values[index - 1]);
        }
        return Float.valueOf(0.0f);
    }

    public Float _get(String name) {
        return this._get(this._getIndex(name));
    }

    public Integer _getIndex(String name) {
        return switch (name) {
            case "x", "r", "u", "pitch" -> 1;
            case "y", "g", "v", "yaw", "volume" -> 2;
            case "z", "b", "roll" -> 3;
            case "w", "a" -> 4;
            case "t" -> 5;
            case "h" -> 6;
            default -> null;
        };
    }

    @Override
    @NotNull
    public Iterator<Float> iterator() {
        return new Iter(this);
    }

    public String toString() {
        return String.format("vec: {x=%f, y=%f, z=%f, w=%f, t=%f, h=%f}", Float.valueOf(this.x()), Float.valueOf(this.y()), Float.valueOf(this.z()), Float.valueOf(this.w()), Float.valueOf(this.t()), Float.valueOf(this.h()));
    }

    public class_2561 toJsonText(UnaryOperator<class_2583> keyColor, UnaryOperator<class_2583> valColor) {
        return class_2561.method_43473().method_27693("vec: {").method_10852((class_2561)class_2561.method_43470((String)"\n  x").method_27694(keyColor)).method_27693(" = ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.x())).method_27694(valColor)).method_10852((class_2561)class_2561.method_43470((String)",\n  y").method_27694(keyColor)).method_27693(" = ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.y())).method_27694(valColor)).method_10852((class_2561)class_2561.method_43470((String)",\n  z").method_27694(keyColor)).method_27693(" = ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.z())).method_27694(valColor)).method_10852((class_2561)class_2561.method_43470((String)",\n  w").method_27694(keyColor)).method_27693(" = ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.w())).method_27694(valColor)).method_10852((class_2561)class_2561.method_43470((String)",\n  t").method_27694(keyColor)).method_27693(" = ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.t())).method_27694(valColor)).method_10852((class_2561)class_2561.method_43470((String)",\n  h").method_27694(keyColor)).method_27693(" = ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.h())).method_27694(valColor)).method_27693("\n}");
    }

    public static class Iter
    implements Iterator<Float> {
        private final LuaVector vector;
        private int index;

        public Iter(LuaVector vector) {
            this.vector = vector;
        }

        @Override
        public boolean hasNext() {
            return this.index < 6;
        }

        @Override
        public Float next() {
            Float r = this.vector._get(this.index);
            ++this.index;
            if (r == null) {
                throw new IllegalStateException("Iterator at invalid index!");
            }
            return r;
        }
    }
}

