/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api.block;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.NBTAPI;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.mixin.AbstractBlockAccessorMixin;
import net.minecraft.class_1160;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2257;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7157;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class BlockStateAPI {
    public static class_2960 getID() {
        return new class_2960("default", "block_state");
    }

    public static LuaTable getForScript(CustomScript script) {
        return new LuaTable(){
            {
                this.set("createBlock", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        class_2680 block = BlockStateAPI.checkOrCreateBlockState(arg1);
                        class_2338 pos = arg2.isnil() ? ((LuaVector)LuaVector.of(class_1160.field_29501)).asBlockPos() : LuaVector.checkOrNew(arg2).asBlockPos();
                        return BlockStateAPI.getTable(block, (class_1937)class_310.method_1551().field_1687, pos);
                    }
                });
            }
        };
    }

    public static LuaTable getTable(class_2680 state, class_1937 world, class_2338 pos) {
        return new BlockStateTable(state, world, pos).getTable();
    }

    private static LuaValue voxelShapeToTable(class_265 shape) {
        LuaTable shapes = new LuaTable();
        List boxes = shape.method_1090();
        for (int i = 0; i < boxes.size(); ++i) {
            class_238 box = (class_238)boxes.get(i);
            shapes.set(i + 1, (LuaValue)new LuaVector((float)box.field_1323, (float)box.field_1322, (float)box.field_1321, (float)box.field_1320, (float)box.field_1325, (float)box.field_1324));
        }
        return shapes;
    }

    public static class_2680 checkOrCreateBlockState(LuaValue arg1) {
        class_2680 block = (class_2680)arg1.get("figura$block_state").touserdata(class_2680.class);
        if (block != null) {
            return block;
        }
        try {
            return class_2257.method_9653((class_7157)new class_7157((class_5455)class_5455.field_26733.get())).method_9654(new StringReader(arg1.checkjstring())).method_9494();
        }
        catch (CommandSyntaxException e) {
            throw new LuaError("Could not create block state\n" + e.getMessage());
        }
    }

    private static class BlockStateTable
    extends LuaTable {
        private final class_2680 state;
        private final class_1937 world;
        private class_2338 blockPos;

        public BlockStateTable(class_2680 state, class_1937 world, class_2338 blockPos) {
            this.state = state;
            this.world = world;
            this.blockPos = blockPos;
        }

        public LuaTable getTable() {
            LuaTable tbl = (LuaTable)NBTAPI.fromTag((class_2520)class_2512.method_10686((class_2680)this.state));
            tbl.set((LuaValue)LuaValue.valueOf((String)"figura$block_state"), (LuaValue)LuaValue.userdataOf((Object)this.state));
            tbl.set((LuaValue)LuaValue.valueOf((String)"setPos"), (LuaValue)new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    blockPos = LuaVector.checkOrNew(arg).asBlockPos();
                    return NIL;
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getBlockTags"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    LuaTable table = new LuaTable();
                    class_2378 blockRegistry = world.method_30349().method_30530(class_2378.field_25105);
                    Optional key = blockRegistry.method_29113((Object)state.method_26204());
                    for (class_6862 blockTagKey : blockRegistry.method_40290((class_5321)key.get()).method_40228().toList()) {
                        table.insert(0, (LuaValue)LuaValue.valueOf((String)blockTagKey.comp_327().toString()));
                    }
                    return table;
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getMaterial"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    for (Field field : class_3614.class.getFields()) {
                        try {
                            if (field.get(null) != state.method_26207()) continue;
                            return LuaValue.valueOf((String)field.getName());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return NIL;
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getMapColor"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((int)state.method_26204().method_26403().field_16011);
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"isSolidBlock"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)state.method_26212((class_1922)world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"isFullCube"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)state.method_26234((class_1922)world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"hasBlockEntity"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)state.method_31709());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"isOpaque"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)state.method_26225());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"hasEmissiveLighting"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)state.method_26208((class_1922)world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"isTranslucent"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)state.method_26167((class_1922)world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"emitsRedstonePower"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)state.method_26219());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getOpacity"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((int)state.method_26193((class_1922)world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getLuminance"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((int)state.method_26213());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getHardness"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((double)state.method_26214((class_1922)world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getComparatorOutput"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((int)state.method_26176(world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getSlipperiness"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((double)state.method_26204().method_9499());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getVelocityMultiplier"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((double)state.method_26204().method_23349());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getJumpVelocityMultiplier"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((double)state.method_26204().method_23350());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getBlastResistance"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((double)state.method_26204().method_9520());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"isCollidable"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return LuaValue.valueOf((boolean)((AbstractBlockAccessorMixin)state.method_26204()).isCollidable());
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getCollisionShape"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return BlockStateAPI.voxelShapeToTable(state.method_26220((class_1922)world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getOutlineShape"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    return BlockStateAPI.voxelShapeToTable(state.method_26218((class_1922)world, blockPos));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getSoundGroup"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    LuaTable stateGroup = new LuaTable();
                    class_2498 snd = state.method_26231();
                    stateGroup.set((LuaValue)LuaValue.valueOf((String)"pitch"), (LuaValue)LuaValue.valueOf((double)snd.method_10599()));
                    stateGroup.set((LuaValue)LuaValue.valueOf((String)"volume"), (LuaValue)LuaValue.valueOf((double)snd.method_10597()));
                    stateGroup.set((LuaValue)LuaValue.valueOf((String)"break"), (LuaValue)LuaValue.valueOf((String)snd.method_10595().method_14833().toString()));
                    stateGroup.set((LuaValue)LuaValue.valueOf((String)"fall"), (LuaValue)LuaValue.valueOf((String)snd.method_10593().method_14833().toString()));
                    stateGroup.set((LuaValue)LuaValue.valueOf((String)"hit"), (LuaValue)LuaValue.valueOf((String)snd.method_10596().method_14833().toString()));
                    stateGroup.set((LuaValue)LuaValue.valueOf((String)"plate"), (LuaValue)LuaValue.valueOf((String)snd.method_10598().method_14833().toString()));
                    stateGroup.set((LuaValue)LuaValue.valueOf((String)"step"), (LuaValue)LuaValue.valueOf((String)snd.method_10594().method_14833().toString()));
                    return stateGroup;
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"getEntityData"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    class_2586 entity = world.method_8321(blockPos);
                    return NBTAPI.fromTag((class_2520)(entity != null ? entity.method_38244() : new class_2487()));
                }
            });
            tbl.set((LuaValue)LuaValue.valueOf((String)"toStateString"), (LuaValue)new ZeroArgFunction(){

                public LuaValue call() {
                    class_2586 entity = world.method_8321(blockPos);
                    class_2487 tag = entity != null ? entity.method_38244() : new class_2487();
                    return LuaValue.valueOf((String)(class_2259.method_9685((class_2680)state) + tag));
                }
            });
            return tbl;
        }
    }
}

