/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.models.FiguraTexture;
import net.blancworks.figura.models.shaders.FiguraRenderLayer;
import net.blancworks.figura.models.shaders.FiguraShader;
import net.blancworks.figura.models.shaders.FiguraVertexConsumerProvider;
import net.blancworks.figura.trust.TrustContainer;
import net.coderbot.iris.Iris;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6364;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class RenderLayerAPI {
    public static boolean canCallGLFunctions = false;
    public static class_276 mainFramebufferCopy;
    public static class_276 lastFramebufferCopy;
    public static final Map<String, class_293> vertexFormatMap;
    public static final Map<String, class_293.class_5596> drawModeMap;

    public static class_2960 getId() {
        return new class_2960("default", "renderlayers");
    }

    public static LuaTable getForScript(final CustomScript script) {
        return new LuaTable(){
            {
                this.set("registerShader", (LuaValue)new VarArgFunction(){

                    public Varargs invoke(Varargs args) {
                        class_293 vertexFormat;
                        if (script.shaders.size() >= 16) {
                            throw new LuaError("You've registered too many (16) shaders. Ignoring further ones.");
                        }
                        String name = args.checkjstring(1);
                        if (args.isnil(2)) {
                            vertexFormat = class_290.field_1580;
                        } else {
                            String formatString = args.checkjstring(2);
                            if (!vertexFormatMap.containsKey(formatString)) {
                                throw new LuaError("Invalid vertex format: " + formatString);
                            }
                            vertexFormat = vertexFormatMap.get(formatString);
                        }
                        String vertexSource = args.checkjstring(3);
                        String fragmentSource = args.checkjstring(4);
                        int numSamplers = args.checkint(5);
                        ArrayList<String> uniformNames = new ArrayList<String>();
                        ArrayList<String> uniformTypes = new ArrayList<String>();
                        if (!args.isnil(6)) {
                            Varargs n;
                            LuaTable customUniforms = args.checktable(6);
                            LuaValue k = LuaValue.NIL;
                            while (!(k = (n = customUniforms.next(k)).arg1()).isnil()) {
                                LuaValue v = n.arg(2);
                                uniformNames.add(k.checkjstring());
                                uniformTypes.add(v.checkjstring());
                            }
                        }
                        RenderSystem.recordRenderCall(() -> {
                            try {
                                FiguraShader newShader = FiguraShader.create(vertexFormat, vertexSource, fragmentSource, numSamplers, uniformNames, uniformTypes);
                                script.shaders.put(name, newShader);
                            }
                            catch (IOException e) {
                                if (script.avatarData.isLocalAvatar) {
                                    CustomScript.sendChatMessage((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061));
                                }
                                e.printStackTrace();
                            }
                            catch (Exception e) {
                                script.handleError(e);
                            }
                        });
                        return NIL;
                    }
                });
                this.set("registerRenderLayer", (LuaValue)new VarArgFunction(){

                    public Varargs invoke(Varargs args) {
                        if (script.customVCP != null && !script.customVCP.canAddLayer()) {
                            throw new LuaError("Cannot add anymore render layers, already reached cap (" + script.customVCP.maxSize + ").");
                        }
                        String name = args.checkjstring(1);
                        LuaTable params = args.checktable(2);
                        LuaFunction startFunc = args.checkfunction(3);
                        LuaFunction endFunc = args.checkfunction(4);
                        class_293 vertexFormat = RenderLayerAPI.luaGetOrDefault(params, (LuaValue)LuaString.valueOf((String)"vertexFormat"), class_290.field_1580, val -> vertexFormatMap.get(val.checkjstring()));
                        class_293.class_5596 drawMode = RenderLayerAPI.luaGetOrDefault(params, (LuaValue)LuaString.valueOf((String)"drawMode"), class_293.class_5596.field_27382, val -> drawModeMap.get(val.checkjstring()));
                        int expectedBufferSize = RenderLayerAPI.luaGetOrDefault(params, (LuaValue)LuaString.valueOf((String)"expectedBufferSize"), 256, LuaValue::checkint);
                        boolean hasCrumbling = RenderLayerAPI.luaGetOrDefault(params, (LuaValue)LuaString.valueOf((String)"hasCrumbling"), true, LuaValue::checkboolean);
                        boolean translucent = RenderLayerAPI.luaGetOrDefault(params, (LuaValue)LuaString.valueOf((String)"translucent"), true, LuaValue::checkboolean);
                        if (vertexFormat == null) {
                            throw new LuaError("Invalid vertex format!");
                        }
                        if (drawMode == null) {
                            throw new LuaError("Invalid draw mode!");
                        }
                        Runnable preDraw = () -> {
                            block2: {
                                canCallGLFunctions = true;
                                script.setInstructionLimitPermission(TrustContainer.Trust.RENDER_INST, script.renderInstructionCount);
                                try {
                                    startFunc.call();
                                }
                                catch (Exception err) {
                                    script.handleError(err);
                                    if (script.customVCP == null || script.customVCP.getLayer(name) == null) break block2;
                                    script.customVCP.getLayer((String)name).disabled = true;
                                }
                            }
                            canCallGLFunctions = false;
                        };
                        Runnable postDraw = () -> {
                            block2: {
                                canCallGLFunctions = true;
                                try {
                                    endFunc.call();
                                }
                                catch (Exception err) {
                                    script.handleError(err);
                                    if (script.customVCP == null || script.customVCP.getLayer(name) == null) break block2;
                                    script.customVCP.getLayer((String)name).disabled = true;
                                }
                            }
                            script.renderInstructionCount += script.scriptGlobals.running.state.bytecodes;
                            canCallGLFunctions = false;
                        };
                        FiguraRenderLayer newLayer = new FiguraRenderLayer(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, preDraw, postDraw);
                        if (script.customVCP == null) {
                            script.customVCP = new FiguraVertexConsumerProvider();
                        }
                        if (script.customVCP.canAddLayer()) {
                            script.customVCP.addLayer(newLayer);
                        }
                        return NIL;
                    }
                });
                this.set("setUniform", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        if (!RenderSystem.isOnRenderThread()) {
                            throw new LuaError("setUniform can only be called inside render() or a renderlayer function!");
                        }
                        FiguraShader shader = script.shaders.get(arg1.checkjstring());
                        if (shader != null) {
                            if (shader.hasUniform(arg2.checkjstring())) {
                                arg3.checknotnil();
                                shader.setUniformFromLua(arg2, arg3);
                            } else {
                                throw new LuaError("No uniform with name: " + arg2.checkjstring());
                            }
                        }
                        return NIL;
                    }
                });
                this.set("setPriority", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        if (script.customVCP != null) {
                            FiguraRenderLayer layer = script.customVCP.getLayer(arg1.checkjstring());
                            script.customVCP.setPriority(layer, arg2.checkint());
                        }
                        return NIL;
                    }
                });
                this.set("getPriority", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        if (script.customVCP != null) {
                            FiguraRenderLayer layer = script.customVCP.getLayer(arg.checkjstring());
                            return LuaNumber.valueOf((int)layer.priority);
                        }
                        return NIL;
                    }
                });
                this.set("isShaderReady", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        return LuaBoolean.valueOf((boolean)script.shaders.containsKey(arg.checkjstring()));
                    }
                });
                this.set("useShader", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        RenderLayerAPI.checkValidCall();
                        FiguraShader shader = script.shaders.get(arg.checkjstring());
                        if (shader != null) {
                            RenderSystem.setShader(() -> shader);
                        }
                        return NIL;
                    }
                });
                this.set("setTexture", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        RenderLayerAPI.checkValidCall();
                        int loc = arg1.checkint();
                        RenderLayerAPI.checkInRange(loc, 0, 7, "Invalid sampler index " + loc + ", must be 0-7.");
                        String textureStr = arg2.checkjstring();
                        RenderSystem.enableTexture();
                        switch (textureStr) {
                            case "MY_TEXTURE": {
                                RenderSystem.setShaderTexture((int)loc, (class_2960)script.avatarData.texture.id);
                                break;
                            }
                            case "MY_TEXTURE_EMISSIVE": {
                                List<FiguraTexture> textureList = script.avatarData.extraTextures;
                                if (textureList.size() > 0) {
                                    RenderSystem.setShaderTexture((int)loc, (class_2960)textureList.get((int)0).id);
                                    break;
                                }
                                throw new LuaError("Emissive texture doesn't exist!");
                            }
                            case "MAIN_FRAMEBUFFER": {
                                RenderLayerAPI.blitMainFramebuffer(mainFramebufferCopy);
                                RenderSystem.setShaderTexture((int)loc, (int)mainFramebufferCopy.method_30277());
                                break;
                            }
                            case "LAST_FRAMEBUFFER": {
                                FiguraVertexConsumerProvider.isUsingLastFramebuffer = true;
                                RenderSystem.setShaderTexture((int)loc, (int)lastFramebufferCopy.method_30277());
                                break;
                            }
                            default: {
                                RenderLayerAPI.checkValidId(textureStr, "Invalid texture name: ");
                                class_2960 id = new class_2960(textureStr);
                                if (class_310.method_1551().method_1531().method_34590(id, null) == null) {
                                    throw new LuaError("Texture " + textureStr + " does not exist.");
                                }
                                RenderSystem.setShaderTexture((int)loc, (class_2960)id);
                            }
                        }
                        return NIL;
                    }
                });
                this.set("enableLightmap", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        class_310.method_1551().field_1773.method_22974().method_3316();
                        return NIL;
                    }
                });
                this.set("disableLightmap", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        class_310.method_1551().field_1773.method_22974().method_3315();
                        return NIL;
                    }
                });
                this.set("enableOverlay", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        class_310.method_1551().field_1773.method_22975().method_23209();
                        return NIL;
                    }
                });
                this.set("disableOverlay", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        class_310.method_1551().field_1773.method_22975().method_23213();
                        return NIL;
                    }
                });
                this.set("enableCull", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.enableCull();
                        return NIL;
                    }
                });
                this.set("disableCull", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.disableCull();
                        return NIL;
                    }
                });
                this.set("enableDepthTest", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.enableDepthTest();
                        return NIL;
                    }
                });
                this.set("disableDepthTest", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.disableDepthTest();
                        return NIL;
                    }
                });
                this.set("depthFunc", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        RenderLayerAPI.checkValidCall();
                        int i = arg.checkint();
                        RenderLayerAPI.checkInRange(i, 512, 519, "Invalid depth flag: " + i);
                        RenderSystem.depthFunc((int)i);
                        return NIL;
                    }
                });
                this.set("depthMask", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        RenderLayerAPI.checkValidCall();
                        boolean b = arg.checkboolean();
                        RenderSystem.depthMask((boolean)b);
                        return NIL;
                    }
                });
                this.set("enableBlend", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.enableBlend();
                        return NIL;
                    }
                });
                this.set("disableBlend", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.disableBlend();
                        return NIL;
                    }
                });
                this.set("blendFunc", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        RenderLayerAPI.checkValidCall();
                        int src = arg1.checkint();
                        int dst = arg2.checkint();
                        RenderLayerAPI.checkArg(src, "Invalid Source Factor: " + src, 0, 1, 768, 769, 774, 775, 770, 771, 772, 773, 32769, 32770, 32771, 32772);
                        RenderLayerAPI.checkArg(dst, "Invalid Dest Factor: " + dst, 0, 1, 768, 769, 774, 775, 770, 771, 772, 773, 32769, 32770, 32771, 32772);
                        RenderSystem.blendFunc((int)src, (int)dst);
                        return NIL;
                    }
                });
                this.set("blendFuncSeparate", (LuaValue)new VarArgFunction(){

                    public LuaValue invoke(Varargs args) {
                        RenderLayerAPI.checkValidCall();
                        int srcRGB = args.checkint(1);
                        int dstRGB = args.checkint(2);
                        int srcAlpha = args.checkint(3);
                        int dstAlpha = args.checkint(4);
                        RenderLayerAPI.checkArg(srcRGB, "Invalid Source RGB Factor: " + srcRGB, 0, 1, 768, 769, 774, 775, 770, 771, 772, 773, 32769, 32770, 32771, 32772);
                        RenderLayerAPI.checkArg(dstRGB, "Invalid Dest RGB Factor: " + dstRGB, 0, 1, 768, 769, 774, 775, 770, 771, 772, 773, 32769, 32770, 32771, 32772);
                        RenderLayerAPI.checkArg(srcAlpha, "Invalid Source Alpha: " + srcAlpha, 0, 1, 768, 769, 774, 775, 770, 771, 772, 773, 32769, 32770, 32771, 32772);
                        RenderLayerAPI.checkArg(dstAlpha, "Invalid Dest Alpha Factor: " + dstAlpha, 0, 1, 768, 769, 774, 775, 770, 771, 772, 773, 32769, 32770, 32771, 32772);
                        RenderSystem.blendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
                        return NIL;
                    }
                });
                this.set("defaultBlendFunc", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.defaultBlendFunc();
                        return NIL;
                    }
                });
                this.set("blendEquation", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        RenderLayerAPI.checkValidCall();
                        int eq = arg.checkint();
                        RenderLayerAPI.checkArg(eq, "Invalid Blend Equation: " + eq, 32774, 32778, 32779, 32776, 32775);
                        RenderSystem.blendEquation((int)arg.checkint());
                        return NIL;
                    }
                });
                this.set("enableColorLogicOp", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.enableColorLogicOp();
                        return NIL;
                    }
                });
                this.set("disableColorLogicOp", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.disableColorLogicOp();
                        return NIL;
                    }
                });
                this.set("logicOp", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        RenderLayerAPI.checkValidCall();
                        int op = arg.checkint();
                        RenderLayerAPI.checkInRange(op, 5376, 5391, "Invalid Logic Op: " + op);
                        GlStateManager._logicOp((int)op);
                        return NIL;
                    }
                });
                this.set("colorMask", (LuaValue)new VarArgFunction(){

                    public Varargs invoke(Varargs args) {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.colorMask((boolean)args.checkboolean(1), (boolean)args.checkboolean(2), (boolean)args.checkboolean(3), (boolean)args.checkboolean(4));
                        return NIL;
                    }
                });
                this.set("enableStencil", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        GL11.glEnable((int)2960);
                        return NIL;
                    }
                });
                this.set("disableStencil", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        GL11.glDisable((int)2960);
                        return NIL;
                    }
                });
                this.set("stencilMask", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        RenderLayerAPI.checkValidCall();
                        int mask = arg.checkint();
                        RenderLayerAPI.checkInRange(mask, 0, 255, "Invalid stencil mask value: " + mask);
                        RenderSystem.stencilMask((int)mask);
                        return NIL;
                    }
                });
                this.set("stencilFunc", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        RenderLayerAPI.checkValidCall();
                        int func = arg1.checkint();
                        int ref = arg2.checkint();
                        int mask = arg3.checkint();
                        RenderLayerAPI.checkInRange(func, 512, 519, "Invalid Function: " + func);
                        RenderLayerAPI.checkInRange(ref, 0, 255, "Invalid Reference Value: " + ref);
                        RenderLayerAPI.checkInRange(mask, 0, 255, "Invalid Mask Value: " + mask);
                        RenderSystem.stencilFunc((int)arg1.checkint(), (int)arg2.checkint(), (int)arg3.checkint());
                        return NIL;
                    }
                });
                this.set("stencilOp", (LuaValue)new ThreeArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                        RenderLayerAPI.checkValidCall();
                        int sfail = arg1.checkint();
                        int dpfail = arg2.checkint();
                        int dppass = arg3.checkint();
                        RenderLayerAPI.checkArg(sfail, "Invalid Stencil Fail Op: " + sfail, 7680, 0, 7681, 7682, 34055, 7683, 34056, 5386);
                        RenderLayerAPI.checkArg(dpfail, "Invalid Depth Fail Op: " + dpfail, 7680, 0, 7681, 7682, 34055, 7683, 34056, 5386);
                        RenderLayerAPI.checkArg(dppass, "Invalid Depth Pass Op: " + dppass, 7680, 0, 7681, 7682, 34055, 7683, 34056, 5386);
                        RenderSystem.stencilOp((int)sfail, (int)dpfail, (int)dppass);
                        return NIL;
                    }
                });
                this.set("enableScissors", (LuaValue)new VarArgFunction(){

                    public LuaValue invoke(Varargs args) {
                        RenderLayerAPI.checkValidCall();
                        int x = args.checkint(1);
                        int y = args.checkint(2);
                        int w = args.checkint(3);
                        int h = args.checkint(4);
                        RenderLayerAPI.checkInRange(w, 0, Integer.MAX_VALUE, "Negative width not allowed");
                        RenderLayerAPI.checkInRange(h, 0, Integer.MAX_VALUE, "Negative height not allowed");
                        RenderSystem.enableScissor((int)x, (int)y, (int)w, (int)h);
                        return NIL;
                    }
                });
                this.set("disableScissors", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.disableScissor();
                        return NIL;
                    }
                });
                this.set("lineWidth", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        RenderLayerAPI.checkValidCall();
                        RenderSystem.lineWidth((float)arg.tofloat());
                        return NIL;
                    }
                });
                this.set("restoreDefaults", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        RenderLayerAPI.checkValidCall();
                        RenderLayerAPI.restoreDefaults();
                        return NIL;
                    }
                });
                this.set("GL_NEVER", 512);
                this.set("GL_LESS", 513);
                this.set("GL_EQUAL", 514);
                this.set("GL_LEQUAL", 515);
                this.set("GL_GREATER", 516);
                this.set("GL_NOTEQUAL", 517);
                this.set("GL_GEQUAL", 518);
                this.set("GL_ALWAYS", 519);
                for (GlStateManager.class_4535 class_45352 : GlStateManager.class_4535.values()) {
                    this.set("GL_" + class_45352.name(), class_45352.value);
                }
                for (GlStateManager.class_4535 class_45353 : GlStateManager.class_4534.values()) {
                    this.set("GL_" + class_45353.name(), class_45353.value);
                }
                for (GlStateManager.class_4535 class_45354 : GlStateManager.class_1030.values()) {
                    this.set("GL_" + class_45354.name(), class_45354.field_5108);
                }
                this.set("GL_FUNC_ADD", 32774);
                this.set("GL_FUNC_SUBTRACT", 32778);
                this.set("GL_FUNC_REVERSE_SUBTRACT", 32779);
                this.set("GL_MAX", 32776);
                this.set("GL_MIN", 32775);
                this.set("GL_KEEP", 7680);
                this.set("GL_REPLACE", 7681);
                this.set("GL_INCR", 7682);
                this.set("GL_INCR_WRAP", 34055);
                this.set("GL_DECR", 7683);
                this.set("GL_DECR_WRAP", 34056);
                this.set("GL_INVERT", 5386);
            }
        };
    }

    public static void restoreDefaults() {
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableCull();
        class_310.method_1551().field_1773.method_22974().method_3315();
        class_310.method_1551().field_1773.method_22975().method_23213();
        RenderSystem.resetTextureMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableColorLogicOp();
        RenderSystem.disableScissor();
        RenderSystem.lineWidth((float)1.0f);
        GL11.glDisable((int)2960);
    }

    private static void checkValidId(String toCheck, String message) {
        try {
            new class_2960(toCheck);
        }
        catch (Exception e) {
            throw new LuaError(message + toCheck + ", possibly because of capitals or spaces");
        }
    }

    private static void checkValidCall() {
        if (!canCallGLFunctions) {
            throw new LuaError("Can only call this function inside a registered renderlayer!");
        }
    }

    private static void checkInRange(int arg, int min, int max, String message) {
        if (arg < min || arg > max) {
            throw new LuaError(message);
        }
    }

    private static void checkArg(int arg, String message, int ... options) {
        for (int option : options) {
            if (arg != option) continue;
            return;
        }
        throw new LuaError(message);
    }

    public static <E> E luaGetOrDefault(LuaTable table, LuaValue key, E defaultVal, Function<LuaValue, E> converter) {
        if (table.get(key).isnil()) {
            return defaultVal;
        }
        return converter.apply(table.get(key));
    }

    public static void blitMainFramebuffer(class_276 target) {
        if (target == null) {
            return;
        }
        int readId = GL30.glGetInteger((int)36010);
        int writeId = GL30.glGetInteger((int)36006);
        class_276 mainFramebuffer = class_310.method_1551().method_1522();
        target.method_1234(mainFramebuffer.field_1482, mainFramebuffer.field_1481, class_310.field_1703);
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._glBindFramebuffer((int)36008, (int)mainFramebuffer.field_1476);
        GlStateManager._glBindFramebuffer((int)36009, (int)target.field_1476);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)mainFramebuffer.field_1482, (int)mainFramebuffer.field_1481, (int)0, (int)0, (int)target.field_1482, (int)target.field_1481, (int)16384, (int)9728);
        GlStateManager._glBindFramebuffer((int)36008, (int)readId);
        GlStateManager._glBindFramebuffer((int)36009, (int)writeId);
    }

    public static boolean areIrisShadersEnabled() {
        return FabricLoader.getInstance().isModLoaded("iris") && Iris.getCurrentPack().isPresent();
    }

    static {
        vertexFormatMap = new HashMap<String, class_293>();
        vertexFormatMap.put("BLIT_SCREEN", class_290.field_29336);
        vertexFormatMap.put("POSITION_COLOR_TEXTURE_LIGHT_NORMAL", class_290.field_1590);
        vertexFormatMap.put("POSITION_COLOR_TEXTURE_OVERLAY_LIGHT_NORMAL", class_290.field_1580);
        vertexFormatMap.put("POSITION_TEXTURE_COLOR_LIGHT", class_290.field_1584);
        vertexFormatMap.put("POSITION", class_290.field_1592);
        vertexFormatMap.put("POSITION_COLOR", class_290.field_1576);
        vertexFormatMap.put("LINES", class_290.field_29337);
        vertexFormatMap.put("POSITION_COLOR_LIGHT", class_290.field_21468);
        vertexFormatMap.put("POSITION_TEXTURE", class_290.field_1585);
        vertexFormatMap.put("POSITION_COLOR_TEXTURE", class_290.field_20887);
        vertexFormatMap.put("POSITION_TEXTURE_COLOR", class_290.field_1575);
        vertexFormatMap.put("POSITION_COLOR_TEXTURE_LIGHT", class_290.field_20888);
        vertexFormatMap.put("POSITION_TEXTURE_LIGHT_COLOR", class_290.field_1586);
        vertexFormatMap.put("POSITION_TEXTURE_COLOR_NORMAL", class_290.field_1577);
        drawModeMap = new HashMap<String, class_293.class_5596>();
        drawModeMap.put("LINES", class_293.class_5596.field_27377);
        drawModeMap.put("LINE_STRIP", class_293.class_5596.field_27378);
        drawModeMap.put("DEBUG_LINES", class_293.class_5596.field_29344);
        drawModeMap.put("DEBUG_LINE_STRIP", class_293.class_5596.field_29345);
        drawModeMap.put("TRIANGLES", class_293.class_5596.field_27379);
        drawModeMap.put("TRIANGLE_STRIP", class_293.class_5596.field_27380);
        drawModeMap.put("TRIANGLE_FAN", class_293.class_5596.field_27381);
        drawModeMap.put("QUADS", class_293.class_5596.field_27382);
        RenderSystem.recordRenderCall(() -> {
            class_276 mainFramebuffer = class_310.method_1551().method_1522();
            mainFramebufferCopy = new class_6364(mainFramebuffer.field_1482, mainFramebuffer.field_1481);
            mainFramebufferCopy.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            lastFramebufferCopy = new class_6364(mainFramebuffer.field_1482, mainFramebuffer.field_1481);
            lastFramebufferCopy.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        });
    }
}

