/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.block.BlockStateAPI;
import net.blancworks.figura.lua.api.item.ItemStackAPI;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5707;
import net.minecraft.class_5716;
import net.minecraft.class_5743;
import net.minecraft.class_5745;
import net.minecraft.class_638;
import net.minecraft.class_7227;
import net.minecraft.class_7290;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.VarArgFunction;

public class ParticleAPI {
    public static HashMap<String, class_2396<?>> particleTypes = new HashMap<String, class_2396<?>>(){
        {
            for (class_2960 id : class_2378.field_11141.method_10235()) {
                class_2396 type = (class_2396)class_2378.field_11141.method_10223(id);
                this.put(id.method_12832(), type);
                this.put(id.toString(), type);
            }
        }
    };

    public static class_2960 getID() {
        return new class_2960("default", "particle");
    }

    public static LuaTable getForScript(final CustomScript script) {
        return new LuaTable(){
            {
                this.set("addParticle", (LuaValue)new VarArgFunction(){

                    public Varargs onInvoke(Varargs args) {
                        class_7290 particle;
                        LuaValue arg1 = args.arg(1);
                        LuaValue arg2 = args.arg(2);
                        LuaValue arg3 = args.arg(3);
                        LuaValue arg4 = args.arg(4);
                        Map.Entry<class_2960, class_2396<?>> particleType = ParticleAPI.particleSetup(script, arg1);
                        if (particleType == null) {
                            return NIL;
                        }
                        switch (particleType.getKey().toString()) {
                            case "minecraft:dust": {
                                LuaVector color = LuaVector.checkOrNew(arg3);
                                particle = new class_2390(color.asV3f(), color.w());
                                break;
                            }
                            case "minecraft:falling_dust": {
                                class_2680 state = BlockStateAPI.checkOrCreateBlockState(arg3);
                                particle = new class_2388(class_2398.field_11206, state);
                                break;
                            }
                            case "minecraft:block": {
                                class_2680 state = BlockStateAPI.checkOrCreateBlockState(arg3);
                                particle = new class_2388(class_2398.field_11217, state);
                                break;
                            }
                            case "minecraft:item": {
                                class_1799 stack = ItemStackAPI.checkOrCreateItemStack(arg3);
                                particle = new class_2392(class_2398.field_11218, stack);
                                break;
                            }
                            case "minecraft:block_marker": {
                                class_2680 state = BlockStateAPI.checkOrCreateBlockState(arg3);
                                particle = new class_2388(class_2398.field_35434, state);
                                break;
                            }
                            case "minecraft:shriek": {
                                int delay = arg3.checkint();
                                particle = new class_7290(delay);
                                break;
                            }
                            case "minecraft:sculk_charge": {
                                float roll = arg3.checknumber().tofloat();
                                particle = new class_7227(roll);
                                break;
                            }
                            case "minecraft:dust_color_transition": {
                                LuaVector fromColor = LuaVector.checkOrNew(arg3);
                                LuaVector toColor = LuaVector.checkOrNew(arg4);
                                particle = new class_5743(fromColor.asV3f(), toColor.asV3f(), fromColor.w());
                                break;
                            }
                            case "minecraft:vibration": {
                                LuaVector dist = LuaVector.checkOrNew(arg3);
                                int speed = arg4.checkint();
                                class_5707 distance = new class_5707(new class_2338(dist.asV3d()));
                                particle = new class_5745((class_5716)distance, speed);
                                break;
                            }
                            default: {
                                class_2396<?> class_23962 = particleType.getValue();
                                if (class_23962 instanceof class_2400) {
                                    class_2400 type = (class_2400)class_23962;
                                    particle = type;
                                    break;
                                }
                                return NIL;
                            }
                        }
                        ParticleAPI.summonParticle((class_2394)particle, LuaVector.checkOrNew(arg2));
                        return NIL;
                    }
                });
            }
        };
    }

    private static Map.Entry<class_2960, class_2396<?>> particleSetup(CustomScript script, LuaValue id) {
        if (!id.isstring() || script.particleSpawnCount < 1.0f) {
            return null;
        }
        script.particleSpawnCount -= 1.0f;
        class_2960 identifier = new class_2960(id.checkjstring());
        class_2396<?> type = particleTypes.get(identifier.toString());
        return type == null ? null : new AbstractMap.SimpleEntry(identifier, type);
    }

    private static void summonParticle(class_2394 particle, LuaVector pos) {
        class_638 w = class_310.method_1551().field_1687;
        if (!class_310.method_1551().method_1493() && w != null) {
            w.method_8406(particle, (double)pos.x(), (double)pos.y(), (double)pos.z(), (double)pos.w(), (double)pos.t(), (double)pos.h());
        }
    }
}

