/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api;

import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.lua.api.math.VectorAPI;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class BiomeAPI {
    public static class_2960 getID() {
        return new class_2960("default", "biome");
    }

    public static LuaTable getForScript(CustomScript script) {
        return new LuaTable(){
            {
                this.set("getBiome", (LuaValue)new TwoArgFunction(){

                    public LuaValue call(LuaValue arg1, LuaValue arg2) {
                        class_638 world = class_310.method_1551().field_1687;
                        if (world == null) {
                            return NIL;
                        }
                        class_2338 pos = LuaVector.checkOrNew(arg2).asBlockPos();
                        class_1959 biome = (class_1959)world.method_30349().method_30530(class_2378.field_25114).method_10223(new class_2960(arg1.checkjstring()));
                        if (biome == null) {
                            throw new LuaError("Biome not found");
                        }
                        return BiomeAPI.getTable((class_1937)world, pos, biome);
                    }
                });
            }
        };
    }

    public static LuaTable getTable(class_1937 world, class_2338 pos) {
        return BiomeAPI.getTable(world, pos, (class_1959)world.method_23753(pos).comp_349());
    }

    public static LuaTable getTable(final class_1937 world, final class_2338 pos, final class_1959 biome) {
        if (world == null) {
            return new LuaTable();
        }
        return new LuaTable(){
            {
                this.set("getID", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        class_2960 identifier = world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
                        return identifier == null ? NIL : LuaValue.valueOf((String)identifier.toString());
                    }
                });
                this.set("getTemperature", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)biome.method_8712());
                    }
                });
                this.set("getPrecipitation", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)biome.method_8694().name());
                    }
                });
                this.set("getSkyColor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return VectorAPI.RGBfromInt(biome.method_8697());
                    }
                });
                this.set("getFoliageColor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return VectorAPI.RGBfromInt(biome.method_8698());
                    }
                });
                this.set("getGrassColor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return VectorAPI.RGBfromInt(biome.method_8711((double)pos.method_10263(), (double)pos.method_10260()));
                    }
                });
                this.set("getFogColor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return VectorAPI.RGBfromInt(biome.method_24376());
                    }
                });
                this.set("getWaterColor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return VectorAPI.RGBfromInt(biome.method_8687());
                    }
                });
                this.set("getWaterFogColor", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return VectorAPI.RGBfromInt(biome.method_8713());
                    }
                });
                this.set("getDownfall", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)biome.method_8715());
                    }
                });
                this.set("isHot", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)biome.method_39929(pos));
                    }
                });
                this.set("isCold", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)biome.method_33599(pos));
                    }
                });
            }
        };
    }
}

