/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua.api;

import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.models.CustomModel;
import net.blancworks.figura.models.animations.Animation;
import net.minecraft.class_2960;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class AnimationAPI {
    public static class_2960 getID() {
        return new class_2960("default", "animation");
    }

    public static LuaTable getForScript(final CustomScript script) {
        return new LuaTable(){
            {
                CustomModel model = script.avatarData.model;
                if (model != null) {
                    model.animations.forEach((name, anim) -> this.set((String)name, (LuaValue)AnimationAPI.getTableForAnimation(anim)));
                }
                this.set("listAnimations", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        CustomModel model = script.avatarData.model;
                        if (model == null) {
                            return NIL;
                        }
                        int i = 1;
                        LuaTable tbl = new LuaTable();
                        for (Animation animation : model.animations.values()) {
                            tbl.set(i, (LuaValue)LuaValue.valueOf((String)animation.name));
                            ++i;
                        }
                        return tbl;
                    }
                });
                this.set("stopAll", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        CustomModel model = script.avatarData.model;
                        if (model == null) {
                            return NIL;
                        }
                        model.animations.values().forEach(Animation::stop);
                        return NIL;
                    }
                });
                this.set("ceaseAll", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        CustomModel model = script.avatarData.model;
                        if (model == null) {
                            return NIL;
                        }
                        model.animations.values().forEach(Animation::cease);
                        return NIL;
                    }
                });
            }
        };
    }

    public static LuaTable getTableForAnimation(final Animation animation) {
        return new LuaTable(){
            {
                this.set("getName", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)animation.name);
                    }
                });
                this.set("start", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        if (!animation.isPlaying()) {
                            animation.play();
                        }
                        return NIL;
                    }
                });
                this.set("play", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        animation.play();
                        return NIL;
                    }
                });
                this.set("pause", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        animation.pause();
                        return NIL;
                    }
                });
                this.set("stop", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        animation.stop();
                        return NIL;
                    }
                });
                this.set("cease", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        animation.cease();
                        return NIL;
                    }
                });
                this.set("isPlaying", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)animation.isPlaying());
                    }
                });
                this.set("setPlayState", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        try {
                            animation.playState = Animation.PlayState.valueOf(arg.checkjstring());
                        }
                        catch (Exception ignored) {
                            throw new LuaError("Invalid playstate type");
                        }
                        return NIL;
                    }
                });
                this.set("getPlayState", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)animation.playState.name());
                    }
                });
                this.set("setLength", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.length = arg.checknumber().tofloat();
                        return NIL;
                    }
                });
                this.set("getLength", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)animation.length);
                    }
                });
                this.set("setSpeed", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        float speed = arg.checknumber().tofloat();
                        animation.speed = Math.abs(speed);
                        animation.inverted = speed < 0.0f;
                        return NIL;
                    }
                });
                this.set("getSpeed", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)(animation.inverted ? (double)(-animation.speed) : (double)animation.speed));
                    }
                });
                this.set("setLoopMode", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        Animation.LoopMode mode;
                        try {
                            mode = Animation.LoopMode.valueOf(arg.checkjstring());
                        }
                        catch (Exception ignored) {
                            mode = Animation.LoopMode.ONCE;
                        }
                        animation.loopMode = mode;
                        return NIL;
                    }
                });
                this.set("getLoopMode", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((String)animation.loopMode.name());
                    }
                });
                this.set("setStartOffset", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.startOffset = arg.checknumber().tofloat();
                        return NIL;
                    }
                });
                this.set("getStartOffset", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)animation.startOffset);
                    }
                });
                this.set("setBlendWeight", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.blendWeight = arg.checknumber().tofloat();
                        return NIL;
                    }
                });
                this.set("getBlendWeight", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)animation.blendWeight);
                    }
                });
                this.set("setStartDelay", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.startDelay = arg.checknumber().tofloat();
                        return NIL;
                    }
                });
                this.set("getStartDelay", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)animation.startDelay);
                    }
                });
                this.set("setLoopDelay", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.loopDelay = arg.checknumber().tofloat();
                        return NIL;
                    }
                });
                this.set("getLoopDelay", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)animation.loopDelay);
                    }
                });
                this.set("setBlendTime", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.blendTime = Math.max(arg.checknumber().tofloat(), 0.0f);
                        return NIL;
                    }
                });
                this.set("getBlendTime", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)animation.blendTime);
                    }
                });
                this.set("setOverride", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.override = arg.checkboolean();
                        return NIL;
                    }
                });
                this.set("getOverride", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)animation.override);
                    }
                });
                this.set("setReplace", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.replace = arg.checkboolean();
                        return NIL;
                    }
                });
                this.set("getReplace", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((boolean)animation.replace);
                    }
                });
                this.set("setPriority", (LuaValue)new OneArgFunction(){

                    public LuaValue call(LuaValue arg) {
                        animation.priority = arg.checkint();
                        return NIL;
                    }
                });
                this.set("getPriority", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((int)animation.priority);
                    }
                });
                this.set("getTime", (LuaValue)new ZeroArgFunction(){

                    public LuaValue call() {
                        return LuaValue.valueOf((double)animation.time);
                    }
                });
            }
        };
    }
}

