/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.lua;

import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.assets.FiguraAsset;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.lua.FiguraLuaManager;
import net.blancworks.figura.lua.LuaEvent;
import net.blancworks.figura.lua.api.RenderLayerAPI;
import net.blancworks.figura.lua.api.actionwheel.ActionWheelCustomization;
import net.blancworks.figura.lua.api.camera.CameraCustomization;
import net.blancworks.figura.lua.api.keybind.FiguraKeybind;
import net.blancworks.figura.lua.api.math.LuaVector;
import net.blancworks.figura.lua.api.model.VanillaModelAPI;
import net.blancworks.figura.lua.api.model.VanillaModelPartCustomization;
import net.blancworks.figura.lua.api.nameplate.NamePlateCustomization;
import net.blancworks.figura.lua.api.sound.FiguraSound;
import net.blancworks.figura.lua.api.sound.FiguraSoundManager;
import net.blancworks.figura.models.shaders.FiguraRenderLayer;
import net.blancworks.figura.models.shaders.FiguraShader;
import net.blancworks.figura.models.shaders.FiguraVertexConsumerProvider;
import net.blancworks.figura.network.NewFiguraNetworkManager;
import net.blancworks.figura.trust.TrustContainer;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.Bit32Lib;
import org.luaj.vm2.lib.DebugLib;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.StringLib;
import org.luaj.vm2.lib.TableLib;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.lib.jse.JseBaseLib;
import org.luaj.vm2.lib.jse.JseMathLib;

public class CustomScript
extends FiguraAsset {
    public AvatarData avatarData;
    public String source;
    public boolean scriptError = false;
    public String scriptName = "main";
    public Globals scriptGlobals = new Globals();
    public LuaValue setHook;
    public LuaValue instructionCapFunction;
    public CompletableFuture<Void> currTask;
    public int initInstructionCount = 0;
    public int tickInstructionCount = 0;
    public int renderInstructionCount = 0;
    public int worldRenderInstructionCount = 0;
    public static int pingSent = 0;
    public static int pingReceived = 0;
    private LuaEvent tickLuaEvent = null;
    private LuaEvent renderLuaEvent = null;
    private CompletableFuture<Void> lastTickFunction = null;
    public Map<String, LuaEvent> allEvents = new HashMap<String, LuaEvent>();
    public Map<String, VanillaModelPartCustomization> allCustomizations = new HashMap<String, VanillaModelPartCustomization>();
    public Map<String, NamePlateCustomization> nameplateCustomizations = new HashMap<String, NamePlateCustomization>();
    public Map<String, CameraCustomization> cameraCustomizations = new HashMap<String, CameraCustomization>();
    public Map<String, ActionWheelCustomization> actionWheelCustomizations = new HashMap<String, ActionWheelCustomization>();
    public Map<String, ActionWheelCustomization> newActionWheelSlots = new HashMap<String, ActionWheelCustomization>();
    public int actionWheelLeftSize = 4;
    public int actionWheelRightSize = 4;
    public ArrayList<FiguraKeybind> keyBindings = new ArrayList();
    public ArrayList<VanillaModelAPI.ModelPartTable> vanillaModelPartTables = new ArrayList();
    public float particleSpawnCount = 0.0f;
    public float soundSpawnCount = 0.0f;
    public Float customShadowSize = null;
    public Boolean shouldRenderFire = null;
    public class_241 crossHairPos = null;
    public boolean crossHairEnabled = true;
    public boolean unlockCursor = false;
    public static double mouseScroll = 0.0;
    public boolean renderMount = true;
    public boolean renderMountShadow = true;
    public boolean renderPlayerHead = true;
    public boolean hasPlayer = false;
    public class_1282 lastDamageSource;
    public String commandPrefix = "\u0000";
    public final LuaTable sharedValues = new LuaTable();
    public boolean canBeTracked = true;
    public HashMap<String, FiguraSound> customSounds = new HashMap();
    public static final UnaryOperator<class_2583> LUA_COLOR = s -> s.method_36139(0x5555FF);
    public static final UnaryOperator<class_2583> PING_COLOR = s -> s.method_36139(0xDD1133);
    public static final class_2561 LOG_PREFIX = class_2561.method_43473().method_27692(class_124.field_1056).method_10852((class_2561)class_5250.method_43477((class_7417)new class_2585("[lua] ")).method_27694(LUA_COLOR));
    public static final class_2561 PING_PREFIX = class_2561.method_43473().method_27692(class_124.field_1056).method_10852((class_2561)class_5250.method_43477((class_7417)new class_2585("[ping] ")).method_27694(PING_COLOR));
    public static final int maxShaders = 16;
    public Map<String, FiguraShader> shaders = new HashMap<String, FiguraShader>();
    public FiguraVertexConsumerProvider customVCP = null;
    @Deprecated
    public BiMap<Short, String> oldFunctionIDMap = HashBiMap.create();
    public BiMap<Short, LuaTable> functionMap = HashBiMap.create();
    private short lastPingID = Short.MIN_VALUE;
    public Queue<LuaPing> incomingPingQueue = new LinkedList<LuaPing>();
    public Queue<LuaPing> outgoingPingQueue = new LinkedList<LuaPing>();

    public CustomScript() {
        this.source = "";
    }

    public CustomScript(AvatarData data, String content) {
        this.load(data, content);
    }

    public void load(final AvatarData data, String src) {
        this.avatarData = data;
        this.source = src;
        if (data == AvatarDataManager.localPlayer && AvatarDataManager.localPlayer != null && AvatarDataManager.localPlayer.loadedName != null) {
            this.scriptName = AvatarDataManager.localPlayer.loadedName;
        }
        this.scriptGlobals.load((LuaValue)new JseBaseLib());
        this.scriptGlobals.load((LuaValue)new PackageLib());
        this.scriptGlobals.load((LuaValue)new Bit32Lib());
        this.scriptGlobals.load((LuaValue)new TableLib());
        this.scriptGlobals.load((LuaValue)new StringLib());
        this.scriptGlobals.load((LuaValue)new JseMathLib());
        this.scriptGlobals.load((LuaValue)new DebugLib());
        this.setHook = this.scriptGlobals.get("debug").get("sethook");
        this.scriptGlobals.set("debug", LuaValue.NIL);
        this.scriptGlobals.set("dofile", LuaValue.NIL);
        this.scriptGlobals.set("loadfile", LuaValue.NIL);
        this.scriptGlobals.set("require", LuaValue.NIL);
        this.scriptGlobals.get("math").set("lerp", (LuaValue)new ThreeArgFunction(){

            public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                return arg1.add(arg2.sub(arg1).mul(arg3));
            }
        });
        this.scriptGlobals.get("math").set("clamp", (LuaValue)new ThreeArgFunction(){

            public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                return LuaNumber.valueOf((double)class_3532.method_15363((float)arg1.checknumber().tofloat(), (float)arg2.checknumber().tofloat(), (float)arg3.checknumber().tofloat()));
            }
        });
        this.setupGlobals();
        this.setupEvents();
        this.scriptGlobals.set("package", LuaValue.NIL);
        this.scriptGlobals.set("loadstring", (LuaValue)new OneArgFunction(){

            public LuaValue call(LuaValue arg) {
                try {
                    return FiguraLuaManager.modGlobals.load(arg.checkjstring(), CustomScript.this.scriptName, (LuaTable)CustomScript.this.scriptGlobals);
                }
                catch (LuaError e) {
                    return e.getMessageObject();
                }
            }
        });
        try {
            LuaValue chunk = FiguraLuaManager.modGlobals.load(this.source, this.scriptName, (LuaTable)this.scriptGlobals);
            this.instructionCapFunction = new ZeroArgFunction(){

                public LuaValue call() {
                    CustomScript.this.scriptError = true;
                    String error = "Script overran resource limits";
                    boolean logOthers = (Boolean)ConfigManager.Config.LOG_OTHERS_SCRIPT.value;
                    if (data != null && (data == AvatarDataManager.localPlayer || logOthers)) {
                        class_5250 message = LOG_PREFIX.method_27661();
                        if (logOthers) {
                            message.method_10852((class_2561)data.name.method_27661().method_27695(new class_124[]{class_124.field_1079, class_124.field_1067})).method_27693(" ");
                        }
                        message.method_10852((class_2561)class_2561.method_43470((String)">> ").method_27694(LUA_COLOR)).method_27693(error).method_27692(class_124.field_1061);
                        CustomScript.sendChatMessage((class_2561)message);
                    }
                    throw new RuntimeException(error);
                }
            };
            this.currTask = CompletableFuture.runAsync(() -> {
                this.initInstructionCount = 0;
                this.setInstructionLimitPermission(TrustContainer.Trust.INIT_INST, 0);
                try {
                    if (data != null) {
                        data.lastEntity = null;
                    }
                    chunk.call();
                }
                catch (Exception error) {
                    this.handleError(error);
                }
                this.initInstructionCount += this.scriptGlobals.running.state.bytecodes;
                this.isDone = true;
                this.currTask = null;
                FiguraMod.LOGGER.info("Script Loading Finished");
            });
        }
        catch (Exception error) {
            this.isDone = true;
            this.handleError(error);
        }
    }

    public void toNBT(class_2487 tag) {
        String script = this.cleanScriptSource(this.source);
        if (script.length() < 60000) {
            tag.method_10582("src", script);
        } else {
            int i = 0;
            for (String substring : Splitter.fixedLength((int)60000).split((CharSequence)script)) {
                tag.method_10582("src_" + i, substring);
                ++i;
            }
        }
    }

    public void fromNBT(AvatarData data, class_2487 tag) {
        Set keys = tag.method_10541();
        if (keys.size() <= 1) {
            this.source = tag.method_10558("src");
        } else {
            StringBuilder script = new StringBuilder();
            for (int i = 0; i < keys.size(); ++i) {
                script.append(tag.method_10558("src_" + i));
            }
            this.source = script.toString();
        }
        this.load(data, this.source);
    }

    public void setPlayerEntity() {
        if (!this.isDone) {
            return;
        }
        if (!this.hasPlayer) {
            this.hasPlayer = true;
            this.queueTask(() -> {
                this.setInstructionLimitPermission(TrustContainer.Trust.INIT_INST, this.initInstructionCount);
                try {
                    this.allEvents.get("player_init").call();
                }
                catch (Exception error) {
                    this.handleError(error);
                }
                this.initInstructionCount += this.scriptGlobals.running.state.bytecodes;
            });
        }
    }

    public void onFiguraChatCommand(String message) {
        if (!this.isDone || this.scriptError || !this.hasPlayer || this.avatarData.lastEntity == null) {
            return;
        }
        this.queueTask(() -> {
            this.setInstructionLimitPermission(TrustContainer.Trust.TICK_INST, this.tickInstructionCount);
            try {
                this.allEvents.get("onCommand").call((LuaValue)LuaString.valueOf((String)message));
            }
            catch (Exception error) {
                this.handleError(error);
            }
            this.tickInstructionCount += this.scriptGlobals.running.state.bytecodes;
        });
    }

    public void runActionWheelFunction(LuaFunction function, LuaValue arg) {
        if (!this.isDone || this.scriptError || !this.hasPlayer || this.avatarData.lastEntity == null) {
            return;
        }
        this.queueTask(() -> {
            this.setInstructionLimitPermission(TrustContainer.Trust.TICK_INST, this.tickInstructionCount);
            try {
                function.call(arg == null ? LuaValue.NIL : arg);
            }
            catch (Exception error) {
                this.handleError(error);
            }
            this.tickInstructionCount += this.scriptGlobals.running.state.bytecodes;
        });
    }

    public void onWorldRender(float deltaTime) {
        if (!this.isDone || this.scriptError || !this.hasPlayer || this.avatarData.lastEntity == null) {
            return;
        }
        this.queueTask(() -> {
            this.renderInstructionCount -= this.worldRenderInstructionCount;
            this.worldRenderInstructionCount = 0;
            this.setInstructionLimitPermission(TrustContainer.Trust.RENDER_INST, this.renderInstructionCount);
            try {
                this.allEvents.get("world_render").call((LuaValue)LuaNumber.valueOf((double)deltaTime));
            }
            catch (Exception error) {
                this.handleError(error);
            }
            this.worldRenderInstructionCount = this.scriptGlobals.running.state.bytecodes;
            this.renderInstructionCount += this.worldRenderInstructionCount;
        });
    }

    public void onDamage(float amount, class_1282 source) {
        if (!this.isDone || this.scriptError || !this.hasPlayer || this.avatarData.lastEntity == null) {
            return;
        }
        this.queueTask(() -> {
            this.setInstructionLimitPermission(TrustContainer.Trust.TICK_INST, this.tickInstructionCount);
            try {
                this.allEvents.get("onDamage").call((LuaValue)LuaNumber.valueOf((double)amount), (LuaValue)LuaString.valueOf((String)source.field_5841));
            }
            catch (Exception error) {
                this.handleError(error);
            }
            this.tickInstructionCount += this.scriptGlobals.running.state.bytecodes;
        });
    }

    public void setupEvents() {
        for (Map.Entry<String, Function<String, LuaEvent>> entry : FiguraLuaManager.registeredEvents.entrySet()) {
            this.allEvents.put(entry.getKey(), entry.getValue().apply(entry.getKey()));
        }
        this.tickLuaEvent = this.allEvents.get("tick");
        this.renderLuaEvent = this.allEvents.get("render");
    }

    public void setupGlobals() {
        this.scriptGlobals.set("log", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue arg, LuaValue arg2) {
                try {
                    if (CustomScript.this.avatarData == AvatarDataManager.localPlayer || ((Boolean)ConfigManager.Config.LOG_OTHERS_SCRIPT.value).booleanValue()) {
                        Object log;
                        class_5250 message = LOG_PREFIX.method_27661();
                        if (((Boolean)ConfigManager.Config.LOG_OTHERS_SCRIPT.value).booleanValue()) {
                            message.method_10852((class_2561)CustomScript.this.avatarData.name.method_27661()).method_27693(" ");
                        }
                        message.method_10852((class_2561)class_2561.method_43470((String)">> ").method_27694(LUA_COLOR));
                        if (arg instanceof LuaVector) {
                            LuaVector logText = (LuaVector)arg;
                            log = logText.toJsonText(LUA_COLOR, FiguraMod.ACCENT_COLOR);
                        } else {
                            log = arg2.isnil() || !arg2.checkboolean() ? class_2561.method_43470((String)arg.toString()) : TextUtils.tryParseJson(arg.toString());
                        }
                        message.method_10852((class_2561)log);
                        int config = (Integer)ConfigManager.Config.SCRIPT_LOG_LOCATION.value;
                        if (config != 2) {
                            FiguraMod.LOGGER.info(message.getString());
                        }
                        if (config != 1) {
                            CustomScript.sendChatMessage((class_2561)message);
                        }
                    }
                }
                catch (Exception error) {
                    if (error instanceof LuaError) {
                        LuaError e = (LuaError)((Object)error);
                        throw e;
                    }
                    CustomScript.this.handleError(error);
                }
                return NIL;
            }
        });
        this.scriptGlobals.set("print", this.scriptGlobals.get("log"));
        this.scriptGlobals.set("logTable", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                try {
                    boolean deep;
                    LuaTable table = arg1.checktable();
                    boolean bl = deep = arg2.isnil() || arg2.checkboolean();
                    if (CustomScript.this.avatarData == AvatarDataManager.localPlayer || ((Boolean)ConfigManager.Config.LOG_OTHERS_SCRIPT.value).booleanValue()) {
                        class_5250 message = LOG_PREFIX.method_27661();
                        if (((Boolean)ConfigManager.Config.LOG_OTHERS_SCRIPT.value).booleanValue()) {
                            message.method_10852((class_2561)CustomScript.this.avatarData.name.method_27661()).method_27693(" ");
                        }
                        message.method_10852((class_2561)class_2561.method_43470((String)">> ").method_27694(LUA_COLOR));
                        message.method_10852((class_2561)CustomScript.tableToText(table, deep, LUA_COLOR, FiguraMod.ACCENT_COLOR, 1, ""));
                        int config = (Integer)ConfigManager.Config.SCRIPT_LOG_LOCATION.value;
                        if (config != 2) {
                            FiguraMod.LOGGER.info(message.getString());
                        }
                        if (config != 1) {
                            CustomScript.sendChatMessage((class_2561)message);
                        }
                    }
                }
                catch (Exception error) {
                    if (error instanceof LuaError) {
                        LuaError e = (LuaError)((Object)error);
                        throw e;
                    }
                    CustomScript.this.handleError(error);
                }
                return NIL;
            }
        });
        this.scriptGlobals.set("logTableContent", this.scriptGlobals.get("logTable"));
        this.scriptGlobals.set("storeValue", (LuaValue)new TwoArgFunction(){

            public LuaValue call(LuaValue arg1, LuaValue arg2) {
                String key = arg1.checkjstring();
                CustomScript.this.sharedValues.set(key, arg2);
                return NIL;
            }
        });
        LuaTable globalMetaTable = new LuaTable();
        globalMetaTable.set("__newindex", (LuaValue)new ThreeArgFunction(){

            public LuaValue call(LuaValue table, LuaValue key, LuaValue value) {
                if (table != CustomScript.this.scriptGlobals) {
                    CustomScript.this.scriptError = true;
                    8.error((String)"Can't use global table metatable on other tables!");
                }
                if (value.isfunction() && key.isstring()) {
                    String funcName = key.checkjstring();
                    LuaFunction func = value.checkfunction();
                    LuaEvent possibleEvent = CustomScript.this.allEvents.get(funcName);
                    if (possibleEvent != null) {
                        possibleEvent.subscribe(func);
                        return NIL;
                    }
                }
                table.rawset(key, value);
                return NIL;
            }
        });
        this.scriptGlobals.setmetatable((LuaValue)globalMetaTable);
        FiguraLuaManager.setupScriptAPI(this);
    }

    public void setInstructionLimitPermission(TrustContainer.Trust permissionID, int subtract) {
        int count = this.avatarData.getTrustContainer().getTrust(permissionID) - subtract;
        this.setInstructionLimit(count);
    }

    public void setInstructionLimit(int count) {
        this.scriptGlobals.running.state.bytecodes = 0;
        this.setHook.invoke(LuaValue.varargsOf((LuaValue[])new LuaValue[]{this.instructionCapFunction, LuaValue.EMPTYSTRING, LuaValue.valueOf((int)Math.max(count, 1))}));
    }

    public void tick() {
        if (this.avatarData != null) {
            float particles = this.avatarData.getTrustContainer().getTrust(TrustContainer.Trust.PARTICLES).intValue();
            float sounds = this.avatarData.getTrustContainer().getTrust(TrustContainer.Trust.SOUNDS).intValue();
            this.particleSpawnCount = class_3532.method_15363((float)(this.particleSpawnCount + 0.05f * particles), (float)0.0f, (float)particles);
            this.soundSpawnCount = class_3532.method_15363((float)(this.soundSpawnCount + 0.05f * sounds), (float)0.0f, (float)sounds);
        }
        if (this.tickLuaEvent != null) {
            if (this.lastTickFunction != null && !this.lastTickFunction.isDone()) {
                return;
            }
            this.lastTickFunction = this.queueTask(this::onTick);
        }
    }

    public void render(float deltaTime) {
        if (this.renderLuaEvent == null || this.scriptError || this.currTask == null || !this.currTask.isDone() || !this.isDone || !this.hasPlayer || this.avatarData.lastEntity == null) {
            return;
        }
        this.onRender(deltaTime);
    }

    public void onTick() {
        if (!this.isDone || this.tickLuaEvent == null || this.scriptError || !this.hasPlayer || this.avatarData.lastEntity == null) {
            return;
        }
        this.tickInstructionCount = 0;
        this.setInstructionLimitPermission(TrustContainer.Trust.TICK_INST, 0);
        try {
            this.tickLuaEvent.call();
            if (FiguraMod.ticksElapsed % 20 == 0) {
                pingSent = 0;
                pingReceived = 0;
            }
            while (this.incomingPingQueue.size() > 0) {
                ++pingReceived;
                LuaPing p = this.incomingPingQueue.poll();
                p.function.call(p.args);
                int config = (Integer)ConfigManager.Config.PINGS_LOG_LOCATION.value;
                if (config == 3) continue;
                CustomScript.logPing(p, config, (class_2561)this.avatarData.name.method_27661());
            }
            if (this.outgoingPingQueue.size() > 0) {
                pingSent += this.outgoingPingQueue.size();
                ((NewFiguraNetworkManager)FiguraMod.networkManager).sendPing(this.outgoingPingQueue);
            }
        }
        catch (Exception error) {
            this.handleError(error);
            error.printStackTrace();
        }
        this.tickInstructionCount += this.scriptGlobals.running.state.bytecodes;
    }

    public void onRender(float deltaTime) {
        this.renderInstructionCount = this.worldRenderInstructionCount;
        this.setInstructionLimitPermission(TrustContainer.Trust.RENDER_INST, 0);
        try {
            this.renderLuaEvent.call((LuaValue)LuaNumber.valueOf((double)deltaTime));
        }
        catch (Exception error) {
            this.handleError(error);
        }
        this.renderInstructionCount += this.scriptGlobals.running.state.bytecodes;
    }

    public void handleError(Exception error) {
        this.scriptError = true;
        this.tickLuaEvent = null;
        this.renderLuaEvent = null;
        if (error instanceof LuaError) {
            LuaError err = (LuaError)((Object)error);
            this.logLuaError(err);
        } else {
            error.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> queueTask(Runnable task) {
        CustomScript customScript = this;
        synchronized (customScript) {
            this.currTask = this.currTask == null || this.currTask.isDone() ? CompletableFuture.runAsync(task) : this.currTask.thenRun(task);
            return this.currTask;
        }
    }

    public String cleanScriptSource(String s) {
        if (!((Boolean)ConfigManager.Config.FORMAT_SCRIPT_ON_UPLOAD.value).booleanValue()) {
            return s;
        }
        StringBuilder ret = new StringBuilder();
        boolean inString = false;
        boolean inChar = false;
        boolean inBlockString = false;
        boolean inComment = s.startsWith("#");
        boolean inBlock = false;
        int blockDepth = 0;
        StringBuilder queue = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char curr = s.charAt(i);
            if (!(inString || inChar || inBlockString || inComment || inBlock)) {
                if (curr == '\"') {
                    inString = true;
                    queue.append(curr);
                } else if (curr == '\'') {
                    inChar = true;
                    queue.append(curr);
                } else if (curr == '[' && i < s.length() - 1) {
                    for (int j = i + 1; j < s.length(); ++j) {
                        if (s.charAt(j) == '=') {
                            ++blockDepth;
                            continue;
                        }
                        if (s.charAt(j) == '[') {
                            inBlockString = true;
                            queue.append(curr);
                        } else {
                            queue.append(curr);
                        }
                        break;
                    }
                } else if (curr == '-' && i < s.length() - 1 && s.charAt(i + 1) == '-') {
                    inComment = true;
                    if (++i < s.length() - 2 && s.charAt(i + 1) == '[') {
                        for (int j = i + 2; j < s.length(); ++j) {
                            if (s.charAt(j) == '=') {
                                ++blockDepth;
                                continue;
                            }
                            if (s.charAt(j) == '[') {
                                inBlock = true;
                                i += 2;
                            }
                            break;
                        }
                    }
                } else {
                    queue.append(curr);
                }
                if (i < s.length() - 1) continue;
            }
            ret.append(queue.toString().replaceAll("\\s+", " "));
            queue = new StringBuilder();
            if (inString) {
                inString = curr != '\"' || s.charAt(i - 1) == '\\';
                ret.append(curr);
                continue;
            }
            if (inChar) {
                inChar = curr != '\'' || s.charAt(i - 1) == '\\';
                ret.append(curr);
                continue;
            }
            if (inBlockString) {
                String append = "=".repeat(blockDepth) + "]";
                boolean bl = inBlockString = curr != ']' || !s.startsWith(append, i + 1);
                if (!inBlockString) {
                    blockDepth = 0;
                    i += append.length();
                    ret.append(curr);
                    ret.append(append);
                    continue;
                }
                ret.append(curr);
                continue;
            }
            if (inBlock) {
                String append = "=".repeat(blockDepth) + "]";
                boolean bl = inBlock = curr != ']' || !s.startsWith(append, i + 1);
                if (inBlock) continue;
                queue.append(" ");
                inComment = false;
                blockDepth = 0;
                i += append.length();
                continue;
            }
            if (curr != '\n') continue;
            queue.append(" ");
            inComment = false;
        }
        return ret.toString();
    }

    public void logLuaError(LuaError error) {
        boolean logOthers = (Boolean)ConfigManager.Config.LOG_OTHERS_SCRIPT.value;
        if (this.avatarData == null || this.avatarData != AvatarDataManager.localPlayer && !logOthers) {
            return;
        }
        String msg = error.getMessage();
        msg = msg.replace("\t", "   ");
        String[] messageParts = msg.split("\n");
        class_5250 message = LOG_PREFIX.method_27661();
        if (logOthers) {
            message.method_10852((class_2561)this.avatarData.name.method_27661()).method_27693(" ");
        }
        message.method_10852((class_2561)class_2561.method_43470((String)">> ").method_27694(LUA_COLOR));
        CustomScript.sendChatMessage((class_2561)message);
        if (this.avatarData == AvatarDataManager.localPlayer && !this.avatarData.isLocalAvatar) {
            CustomScript.sendChatMessage((class_2561)class_2561.method_43470((String)"non-local avatar script!\n").method_27695(new class_124[]{class_124.field_1061, class_124.field_1073}));
        }
        for (String part : messageParts) {
            if (part.trim().equals("[Java]: in ?")) continue;
            CustomScript.sendChatMessage((class_2561)class_2561.method_43470((String)part).method_27692(class_124.field_1061));
        }
        Object location = "?";
        try {
            int lineNumber;
            String[] line = msg.split(Pattern.quote(this.scriptName), 2);
            if (line.length < 2) {
                return;
            }
            Pattern pattern = Pattern.compile("([0-9]+)");
            Matcher matcher = pattern.matcher(line[1]);
            if (matcher.find() && (lineNumber = Integer.parseInt(matcher.group(1))) > 0) {
                String src = this.source.split("\n")[lineNumber - 1].trim();
                String ext = "";
                if (src.length() > 100) {
                    src = src.substring(0, 100);
                    ext = " [...]";
                }
                location = "'" + src + "'" + ext;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomScript.sendChatMessage((class_2561)class_2561.method_43470((String)"script:").method_27692(class_124.field_1061));
        CustomScript.sendChatMessage((class_2561)class_2561.method_43470((String)("   " + (String)location)).method_27692(class_124.field_1061));
        error.printStackTrace();
    }

    public static class_5250 tableToText(LuaTable table, boolean deep, UnaryOperator<class_2583> keyColor, UnaryOperator<class_2583> valColor, int depth, String depthString) {
        String spacing = "  ";
        depthString = spacing.substring(2) + (String)depthString;
        class_5250 back = class_2561.method_43470((String)"{\n").method_27692(class_124.field_1056);
        for (LuaValue key : table.keys()) {
            LuaValue value = table.get(key);
            class_5250 valString = class_2561.method_43473();
            valString.method_10852((class_2561)class_2561.method_43470((String)((String)depthString + spacing + "\"")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false))));
            valString.method_10852((class_2561)class_2561.method_43470((String)key.toString()).method_27694(keyColor)).method_27693("\" : ");
            if (value.istable() && deep) {
                valString.method_10852((class_2561)CustomScript.tableToText(value.checktable(), true, keyColor, valColor, depth + 1, spacing + (String)depthString));
            } else {
                valString.method_10852((class_2561)class_2561.method_43470((String)value.toString()).method_27694(valColor)).method_27693(",\n");
            }
            back.method_10852((class_2561)valString);
        }
        back.method_10852((class_2561)class_2561.method_43470((String)((String)depthString + "},\n")));
        return back;
    }

    public static void logPing(LuaPing p, int config, class_2561 pingOwner) {
        class_5250 arg;
        class_5250 name = class_2561.method_43470((String)p.name);
        LuaValue luaValue = p.args;
        if (luaValue instanceof LuaVector) {
            LuaVector vec = (LuaVector)luaValue;
            arg = (class_5250)vec.toJsonText(PING_COLOR, FiguraMod.ACCENT_COLOR);
        } else {
            luaValue = p.args;
            if (luaValue instanceof LuaTable) {
                LuaTable tbl = (LuaTable)luaValue;
                arg = CustomScript.tableToText(tbl, true, PING_COLOR, FiguraMod.ACCENT_COLOR, 1, "");
            } else {
                arg = class_2561.method_43470((String)p.args.toString()).method_27694(FiguraMod.ACCENT_COLOR);
            }
        }
        class_5250 message = PING_PREFIX.method_27661();
        message.method_10852(pingOwner).method_27693(" ");
        message.method_10852((class_2561)class_2561.method_43470((String)">> ").method_27694(PING_COLOR));
        if (p.size != null) {
            message.method_10852((class_2561)class_2561.method_43470((String)("(" + p.size + "b) ")).method_27694(PING_COLOR));
        }
        message.method_10852((class_2561)name).method_27693(" : ").method_10852((class_2561)arg);
        if (config != 2) {
            FiguraMod.LOGGER.info(message.getString());
        }
        if (config != 1) {
            CustomScript.sendChatMessage((class_2561)message);
        }
    }

    public static void sendChatMessage(class_2561 text) {
        class_310.method_1551().field_1705.method_1743().method_1812(text);
    }

    public VanillaModelPartCustomization getOrMakePartCustomization(String accessor) {
        VanillaModelPartCustomization currCustomization = this.getPartCustomization(accessor);
        if (currCustomization == null) {
            currCustomization = new VanillaModelPartCustomization();
            this.allCustomizations.put(accessor, currCustomization);
        }
        return currCustomization;
    }

    public VanillaModelPartCustomization getPartCustomization(String accessor) {
        return this.allCustomizations.get(accessor);
    }

    public NamePlateCustomization getOrMakeNameplateCustomization(String accessor) {
        NamePlateCustomization currCustomization = this.getNameplateCustomization(accessor);
        if (currCustomization == null) {
            currCustomization = new NamePlateCustomization();
            this.nameplateCustomizations.put(accessor, currCustomization);
        }
        return currCustomization;
    }

    public NamePlateCustomization getNameplateCustomization(String accessor) {
        return this.nameplateCustomizations.get(accessor);
    }

    public CameraCustomization getOrMakeCameraCustomization(String accessor) {
        CameraCustomization currCustomization = this.getCameraCustomization(accessor);
        if (currCustomization == null) {
            currCustomization = new CameraCustomization();
            this.cameraCustomizations.put(accessor, currCustomization);
        }
        return currCustomization;
    }

    public CameraCustomization getCameraCustomization(String accessor) {
        return this.cameraCustomizations.get(accessor);
    }

    public ActionWheelCustomization getOrMakeActionWheelCustomization(String accessor) {
        ActionWheelCustomization currCustomization = this.getActionWheelCustomization(accessor);
        if (currCustomization == null) {
            currCustomization = new ActionWheelCustomization();
            this.actionWheelCustomizations.put(accessor, currCustomization);
        }
        return currCustomization;
    }

    public ActionWheelCustomization getActionWheelCustomization(String accessor) {
        return this.actionWheelCustomizations.get(accessor);
    }

    @Deprecated
    public void registerPingName(String s) {
        short s2 = this.lastPingID;
        this.lastPingID = (short)(s2 + 1);
        this.oldFunctionIDMap.put((Object)s2, (Object)s);
    }

    public void registerPing(LuaTable func) {
        if (!this.functionMap.containsValue((Object)func)) {
            short s = this.lastPingID;
            this.lastPingID = (short)(s + 1);
            this.functionMap.put((Object)s, (Object)func);
        }
    }

    public LuaPing handlePing(short id, LuaValue args, Integer size) {
        try {
            String functionName = (String)this.oldFunctionIDMap.get((Object)id);
            LuaTable function = (LuaTable)this.functionMap.get((Object)id);
            if (function != null) {
                return this.addPing(function.get("value"), args, id, function.get("key").tojstring(), size);
            }
            if (functionName != null) {
                LuaValue func = this.scriptGlobals.get(functionName);
                return this.addPing(func, args, id, functionName, size);
            }
        }
        catch (Exception error) {
            if (error instanceof LuaError) {
                LuaError err = (LuaError)((Object)error);
                this.logLuaError(err);
            }
            error.printStackTrace();
        }
        return null;
    }

    public LuaPing addPing(LuaValue function, LuaValue args, short id, String name, Integer size) {
        LuaPing p = new LuaPing(id, function, args, name, size);
        this.incomingPingQueue.add(p);
        return p;
    }

    public void clearSounds() {
        if (this.avatarData != null) {
            FiguraSoundManager.getChannel().stopSound(this.avatarData.entityId);
        }
        this.customSounds.values().forEach(FiguraSound::close);
    }

    public FiguraRenderLayer getCustomLayer(LuaValue arg) {
        if (!arg.isnil() && !RenderLayerAPI.areIrisShadersEnabled()) {
            if (this.customVCP != null) {
                FiguraRenderLayer customLayer = this.customVCP.getLayer(arg.checkjstring());
                if (customLayer == null) {
                    throw new LuaError("No custom layer named: " + arg.checkjstring());
                }
                return customLayer;
            }
            throw new LuaError("The player has no custom VCP!");
        }
        return null;
    }

    public record LuaPing(short functionID, LuaValue function, LuaValue args, String name, Integer size) {
    }
}

