/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.math.RoundingMode;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.blancworks.figura.avatar.LocalAvatarManager;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.config.ConfigScreen;
import net.blancworks.figura.gui.FiguraKeyBindsScreen;
import net.blancworks.figura.gui.FiguraSoundScreen;
import net.blancworks.figura.gui.FiguraTrustScreen;
import net.blancworks.figura.gui.NewFiguraGuiScreen;
import net.blancworks.figura.gui.widgets.CustomListWidgetState;
import net.blancworks.figura.gui.widgets.CustomTextFieldWidget;
import net.blancworks.figura.gui.widgets.ModelFileListWidget;
import net.blancworks.figura.gui.widgets.TexturedButtonWidget;
import net.blancworks.figura.network.NewFiguraNetworkManager;
import net.blancworks.figura.parsers.FiguraAvatarSerializer;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import net.minecraft.class_757;
import net.minecraft.class_898;

public class FiguraGuiScreen
extends class_437 {
    public class_437 parentScreen;
    public class_2960 uploadTexture = new class_2960("figura", "textures/gui/upload.png");
    public class_2960 reloadTexture = new class_2960("figura", "textures/gui/reload.png");
    public class_2960 deleteTexture = new class_2960("figura", "textures/gui/delete.png");
    public class_2960 expandTexture = new class_2960("figura", "textures/gui/expand.png");
    public class_2960 keybindsTexture = new class_2960("figura", "textures/gui/keybinds.png");
    public class_2960 soundsTexture = new class_2960("figura", "textures/gui/sounds.png");
    public class_2960 playerBackgroundTexture = new class_2960("figura", "textures/gui/player_background.png");
    public class_2960 expandedBackgroundTexture = new class_2960("figura", "textures/gui/expanded_background.png");
    public static final List<class_2583> TEXT_COLORS = List.of(class_2583.field_24360.method_10977(class_124.field_1068), class_2583.field_24360.method_10977(class_124.field_1061), class_2583.field_24360.method_10977(class_124.field_1054), class_2583.field_24360.method_10977(class_124.field_1060));
    public static final List<class_2561> DELETE_TOOLTIP = List.of(class_5250.method_43477((class_7417)new class_2588("figura.gui.button.deleteavatar.tooltip")).method_10862(TEXT_COLORS.get(1)), class_5250.method_43477((class_7417)new class_2588("figura.gui.button.deleteavatartwo.tooltip")).method_10862(TEXT_COLORS.get(1)));
    public static final class_2561 UPLOAD_TOOLTIP = class_5250.method_43477((class_7417)new class_2588("figura.gui.button.upload.tooltip"));
    public static final List<class_2561> UPLOAD_LOCAL_TOOLTIP = List.of(class_5250.method_43477((class_7417)new class_2588("figura.gui.button.uploadlocal.tooltip")).method_10862(TEXT_COLORS.get(1)), class_5250.method_43477((class_7417)new class_2588("figura.gui.button.uploadlocaltwo.tooltip")).method_10862(TEXT_COLORS.get(1)));
    public static final List<class_2561> NO_CONNECTION_TOOLTIP = List.of(class_5250.method_43477((class_7417)new class_2588("figura.gui.button.noconnection.tooltip")).method_10862(TEXT_COLORS.get(1)), class_5250.method_43477((class_7417)new class_2588("figura.gui.button.noconnectiontwo.tooltip")).method_10862(TEXT_COLORS.get(1)));
    public static final class_2561 MODEL_STATUS_TEXT = class_5250.method_43477((class_7417)new class_2588("figura.gui.status.model"));
    public static final class_2561 TEXTURE_STATUS_TEXT = class_5250.method_43477((class_7417)new class_2588("figura.gui.status.texture"));
    public static final class_2561 SCRIPT_STATUS_TEXT = class_5250.method_43477((class_7417)new class_2588("figura.gui.status.script"));
    public static final class_2561 BACKEND_STATUS_TEXT = class_5250.method_43477((class_7417)new class_2588("figura.gui.status.backend"));
    public static final List<class_5250> STATUS_INDICATORS = List.of(class_2561.method_43470((String)"-").method_10862(class_2583.field_24360.method_27704(FiguraMod.FIGURA_FONT)), class_2561.method_43470((String)"*").method_10862(class_2583.field_24360.method_27704(FiguraMod.FIGURA_FONT)), class_2561.method_43470((String)"/").method_10862(class_2583.field_24360.method_27704(FiguraMod.FIGURA_FONT)), class_2561.method_43470((String)"+").method_10862(class_2583.field_24360.method_27704(FiguraMod.FIGURA_FONT)));
    public static final class_2561 RELOAD_TOOLTIP = class_5250.method_43477((class_7417)new class_2588("figura.gui.button.reloadavatar.tooltip"));
    public static final class_2561 KEYBIND_TOOLTIP = class_5250.method_43477((class_7417)new class_2588("figura.gui.button.keybinds.tooltip"));
    public static final class_2561 SOUND_TOOLTIP = class_5250.method_43477((class_7417)new class_2588("figura.gui.button.sounds.tooltip"));
    public static final class_2561 MODEL_FOLDER_TOOLTIP = class_5250.method_43477((class_7417)new class_2588("figura.gui.button.openfolder.tooltip"));
    private static final int[] OvO = new int[]{265, 265, 264, 264, 263, 262, 263, 262, 66, 65, 257};
    private static int ovo = 0;
    public TexturedButtonWidget uploadButton;
    public TexturedButtonWidget reloadButton;
    public TexturedButtonWidget deleteButton;
    public TexturedButtonWidget expandButton;
    public TexturedButtonWidget keybindsButton;
    public TexturedButtonWidget soundsButton;
    public class_4185 openFolderButton;
    public class_4185 exportNbt;
    public class_4185 serializeAvatar;
    public class_5250 nameText;
    public class_5250 fileSizeText;
    public class_5250 modelComplexityText;
    private int modelSizeStatus = 0;
    private int textureStatus = 0;
    private int scriptStatus = 0;
    private int connectionStatus = 0;
    private CustomTextFieldWidget searchBox;
    private int paneY;
    private int paneWidth;
    private int searchBoxX;
    private boolean isHoldingShift = false;
    private static int guiScale;
    private static int modelBgSize;
    private static int modelSize;
    private static float screenScale;
    private boolean canRotate;
    private boolean canDrag;
    private static boolean expand;
    private float anchorX;
    private float anchorY;
    private float anchorAngleX;
    private float anchorAngleY;
    private float angleX;
    private float angleY;
    private float scaledValue;
    private final float SCALE_FACTOR = 1.1f;
    private int modelX;
    private int modelY;
    private float dragDeltaX;
    private float dragDeltaY;
    private float dragAnchorX;
    private float dragAnchorY;
    public static boolean showOwnNametag;
    public static boolean renderFireOverlay;
    public FiguraTrustScreen trustScreen = new FiguraTrustScreen(this);
    public FiguraKeyBindsScreen keyBindsScreen = new FiguraKeyBindsScreen(this);
    public FiguraSoundScreen soundsScreen = new FiguraSoundScreen(this);
    public ConfigScreen configScreen = new ConfigScreen(this);
    public CustomListWidgetState<Object> modelFileListState = new CustomListWidgetState();
    public ModelFileListWidget modelFileList;

    public FiguraGuiScreen(class_437 parentScreen) {
        super((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.menu.title")));
        this.parentScreen = parentScreen;
        this.canRotate = false;
        this.canDrag = false;
        expand = false;
        this.resetModelPos();
    }

    protected void method_25426() {
        super.method_25426();
        guiScale = (int)this.field_22787.method_22683().method_4495();
        screenScale = (float)((double)Math.min(this.field_22789, this.field_22790) / 1018.0);
        modelBgSize = Math.min((int)((float)(512 / guiScale) * (screenScale * (float)guiScale)), 258);
        modelSize = Math.min((int)((float)(192 / guiScale) * (screenScale * (float)guiScale)), 96);
        this.paneY = 48;
        this.paneWidth = this.field_22789 / 3 - 8;
        int searchBoxWidth = this.paneWidth - 5;
        this.searchBoxX = 7;
        this.searchBox = new CustomTextFieldWidget(this.field_22793, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.search")).method_27692(class_124.field_1056));
        this.searchBox.method_1863(string_1 -> this.modelFileList.filter((String)string_1, false));
        this.modelFileList = new ModelFileListWidget(this.field_22787, this.paneWidth, this.field_22790, this.paneY + 19, this.field_22790 - 36, 20, (class_342)this.searchBox, this.modelFileList, (class_437)this, this.modelFileListState);
        this.modelFileList.method_25333(5);
        this.method_25429((class_364)this.modelFileList);
        this.method_25429((class_364)this.searchBox);
        int width = Math.min(this.field_22789 - (this.field_22789 / 2 + modelBgSize / 2 + 38), 140);
        this.openFolderButton = new class_4185(5, this.field_22790 - 20 - 5, 140, 20, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.openfolder")), buttonWidgetx -> {
            Path modelDir = LocalAvatarData.getContentDirectory();
            try {
                if (this.isHoldingShift && AvatarDataManager.localPlayerPath != null) {
                    String path = AvatarDataManager.localPlayerPath;
                    modelDir = Path.of(path, new String[0]);
                    if (path.endsWith(".zip") || path.endsWith(".moon")) {
                        modelDir = modelDir.getParent();
                    }
                }
                if (!Files.exists(modelDir, new LinkOption[0])) {
                    Files.createDirectory(modelDir, new FileAttribute[0]);
                }
                class_156.method_668().method_673(modelDir.toUri());
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error(e.toString());
            }
        });
        this.method_37063((class_364)this.openFolderButton);
        this.serializeAvatar = new class_4185(this.field_22789 - width - 5, this.field_22790 - 75, width, 20, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.save")), buttonWidgetx -> {
            LocalAvatarData local = AvatarDataManager.localPlayer;
            if (local != null && local.hasAvatar()) {
                class_2487 nbt = new class_2487();
                local.writeNbt(nbt);
                String result = FiguraAvatarSerializer.serialize(nbt);
                if (result == null) {
                    FiguraMod.sendToast(class_5250.method_43477((class_7417)new class_2588("figura.gui.button.save.error")), class_5250.method_43477((class_7417)new class_2588("figura.gui.button.save.error.message")));
                } else {
                    FiguraMod.sendToast(class_5250.method_43477((class_7417)new class_2588("figura.gui.button.save.done")), result);
                }
            }
        });
        this.exportNbt = new class_4185(this.field_22789 - width - 5, this.field_22790 - 50, width, 20, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.cache")), buttonWidgetx -> {
            if (AvatarDataManager.localPlayer != null) {
                AvatarDataManager.localPlayer.saveToCache();
                FiguraMod.sendToast(class_5250.method_43477((class_7417)new class_2588("figura.gui.button.cache.done")), "");
            }
        });
        this.method_37063((class_364)this.serializeAvatar);
        this.method_37063((class_364)this.exportNbt);
        this.method_37063((class_364)new class_4185(this.field_22789 - 145, this.field_22790 - 25, 140, 20, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.back")), buttonWidgetx -> {
            this.field_22787.method_1507(this.parentScreen);
            LocalAvatarManager.saveFolderNbt();
        }));
        this.method_37063((class_364)new class_4185(this.field_22789 - width - 5, 15, width, 20, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.trustmenu")), buttonWidgetx -> this.field_22787.method_1507((class_437)this.trustScreen)));
        this.method_37063((class_364)new class_4185(this.field_22789 - width - 5, 40, width, 20, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.configmenu")), buttonWidgetx -> this.field_22787.method_1507((class_437)this.configScreen)));
        this.method_37063((class_364)new class_4185(this.field_22789 - width - 5, 65, width, 20, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.help")), buttonWidgetx -> this.field_22787.method_1507((class_437)new class_407(bl -> {
            if (bl) {
                class_156.method_668().method_670("https://github.com/Blancworks/Figura/wiki/Figura-Panel");
            }
            this.field_22787.method_1507((class_437)this);
        }, "https://github.com/Blancworks/Figura/wiki/Figura-Panel", true))));
        this.keybindsButton = new TexturedButtonWidget(this.field_22789 - width - 30, 15, 20, 20, 0, 0, 20, this.keybindsTexture, 40, 40, bx -> this.field_22787.method_1507((class_437)this.keyBindsScreen));
        this.method_37063((class_364)this.keybindsButton);
        this.keybindsButton.field_22763 = false;
        this.soundsButton = new TexturedButtonWidget(this.field_22789 - width - 55, 15, 20, 20, 0, 0, 20, this.soundsTexture, 40, 40, bx -> this.field_22787.method_1507((class_437)this.soundsScreen));
        this.method_37063((class_364)this.soundsButton);
        this.soundsButton.field_22763 = false;
        this.deleteButton = new TexturedButtonWidget(this.field_22789 / 2 + modelBgSize / 2 + 4, this.field_22790 / 2 - modelBgSize / 2, 25, 25, 0, 0, 25, this.deleteTexture, 50, 50, bx -> {
            if (this.isHoldingShift) {
                FiguraMod.networkManager.deleteAvatar();
            }
        });
        this.method_37063((class_364)this.deleteButton);
        this.deleteButton.field_22763 = false;
        this.uploadButton = new TexturedButtonWidget(this.field_22789 / 2 + modelBgSize / 2 + 4, this.field_22790 / 2 + modelBgSize / 2 - 25, 25, 25, 0, 0, 25, this.uploadTexture, 50, 50, bx -> FiguraMod.networkManager.postAvatar().thenRun(() -> System.out.println("UPLOADED AVATAR")));
        this.method_37063((class_364)this.uploadButton);
        this.reloadButton = new TexturedButtonWidget(this.field_22789 / 2 + modelBgSize / 2 + 4, this.field_22790 / 2 + modelBgSize / 2 - 25 - 30, 25, 25, 0, 0, 25, this.reloadTexture, 25, 50, bx -> AvatarDataManager.clearLocalPlayer());
        this.method_37063((class_364)this.reloadButton);
        this.expandButton = new TexturedButtonWidget(Math.max(this.field_22789 / 2 - modelBgSize / 2, this.paneWidth + 5), this.field_22790 / 2 - modelBgSize / 2 - 15, 15, 15, 0, 0, 15, this.expandTexture, 30, 30, bx -> {
            expand = !expand;
            this.updateExpand();
        });
        this.method_37063((class_364)this.expandButton);
        LocalAvatarManager.loadFolderNbt();
        this.modelFileList.updateAvatarList();
        this.updateAvatarData();
        this.updateExpand();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parentScreen);
        LocalAvatarManager.saveFolderNbt();
    }

    public void method_25393() {
        super.method_25393();
        this.connectionStatus = NewFiguraNetworkManager.connectionStatus;
        if (FiguraMod.ticksElapsed % 20 == 0) {
            this.modelFileList.updateAvatarList();
            this.updateAvatarData();
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        boolean hasLoadedAvatar;
        if (!expand) {
            this.method_25434(0);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.playerBackgroundTexture);
            FiguraGuiScreen.method_25290((class_4587)matrices, (int)(this.field_22789 / 2 - modelBgSize / 2), (int)(this.field_22790 / 2 - modelBgSize / 2), (float)0.0f, (float)0.0f, (int)modelBgSize, (int)modelBgSize, (int)modelBgSize, (int)modelBgSize);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.expandedBackgroundTexture);
            this.renderAsBackground(0);
            this.expandButton.method_25394(matrices, mouseX, mouseY, delta);
        }
        FiguraGuiScreen.drawEntity(this.modelX, this.modelY, (int)((float)modelSize + this.scaledValue), this.angleX, this.angleY, (class_1309)this.field_22787.field_1724);
        if (expand) {
            return;
        }
        this.modelFileList.method_25394(matrices, mouseX, mouseY, delta);
        this.searchBox.method_25394(matrices, mouseX, mouseY, delta);
        class_5250 statusText = class_2561.method_43473().method_10852((class_2561)STATUS_INDICATORS.get(this.modelSizeStatus)).method_27693("  ").method_10852((class_2561)STATUS_INDICATORS.get(this.textureStatus)).method_27693("  ").method_10852((class_2561)STATUS_INDICATORS.get(this.scriptStatus)).method_27693("  ").method_10852((class_2561)STATUS_INDICATORS.get(this.connectionStatus));
        FiguraGuiScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)statusText, (int)(this.field_22789 - 75), (int)89, (int)0xFFFFFF);
        int currY = 90;
        if (this.nameText != null) {
            FiguraGuiScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.nameText, (int)(this.field_22789 - this.field_22793.method_27525((class_5348)this.nameText) - 8), (int)(currY += 12), (int)0xFFFFFF);
        }
        if (this.fileSizeText != null) {
            FiguraGuiScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.fileSizeText, (int)(this.field_22789 - this.field_22793.method_27525((class_5348)this.fileSizeText) - 8), (int)(currY += 12), (int)0xFFFFFF);
        }
        if (this.modelComplexityText != null) {
            FiguraGuiScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.modelComplexityText, (int)(this.field_22789 - this.field_22793.method_27525((class_5348)this.modelComplexityText) - 8), (int)(currY + 12), (int)0xFFFFFF);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (AvatarDataManager.panic) {
            class_5250 panic = class_2561.method_43473().method_10852((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.panic.warning")).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" =").method_10862(class_2583.field_24360.method_27704(FiguraMod.FIGURA_FONT)));
            FiguraGuiScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)panic, (int)(this.field_22789 / 2), (int)(this.field_22790 - 12), (int)0xFFFFFF);
        } else if (FiguraMod.latestVersionStatus == 0) {
            version = class_2561.method_43470((String)("Figura " + FiguraMod.MOD_VERSION)).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
            FiguraGuiScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)version, (int)(this.field_22789 / 2), (int)(this.field_22790 - 12), (int)0xFFFFFF);
        } else if (FiguraMod.latestVersionStatus < 0) {
            version = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("Figura " + FiguraMod.MOD_VERSION)).method_27695(new class_124[]{class_124.field_1054, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" =").method_10862(class_2583.field_24360.method_27704(FiguraMod.FIGURA_FONT)));
            FiguraGuiScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)version, (int)(this.field_22789 / 2), (int)(this.field_22790 - 12), (int)0xFFFFFF);
            int textWidth = this.field_22793.method_27525((class_5348)version);
            if (mouseX >= this.field_22789 / 2 - textWidth / 2 && mouseX < this.field_22789 / 2 + textWidth / 2 && mouseY >= this.field_22790 - 12 && mouseY < this.field_22790 - 1) {
                List<class_5250> tooltipText = List.of(class_2561.method_43473().method_10852((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.newver.tooltip"))).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)FiguraMod.latestVersion).method_27695(new class_124[]{class_124.field_1054, class_124.field_1073})), class_5250.method_43477((class_7417)new class_2588("figura.gui.newver.tooltip2")));
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 599.0);
                this.method_30901(matrices, tooltipText, mouseX, mouseY);
                matrices.method_22909();
            }
        } else {
            String load = Integer.toHexString(Math.abs(FiguraMod.ticksElapsed) % 16);
            class_5250 version = class_2561.method_43470((String)("Figura " + FiguraMod.MOD_VERSION)).method_27695(new class_124[]{class_124.field_1064, class_124.field_1056});
            FiguraGuiScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)version, (int)(this.field_22789 / 2), (int)(this.field_22790 - 12), (int)0xFFFFFF);
            int textWidth = this.field_22793.method_27525((class_5348)version);
            if (mouseX >= this.field_22789 / 2 - textWidth / 2 && mouseX < this.field_22789 / 2 + textWidth / 2 && mouseY >= this.field_22790 - 12 && mouseY < this.field_22790 - 1) {
                List<class_5250> tooltipText = List.of(class_2561.method_43470((String)"Are you a time traveller?").method_27692(class_124.field_1076), class_2561.method_43470((String)"Latest version is: ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)FiguraMod.latestVersion).method_27695(new class_124[]{class_124.field_1075, class_124.field_1073})));
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 599.0);
                this.method_30901(matrices, tooltipText, mouseX, mouseY);
                matrices.method_22909();
            }
        }
        LocalAvatarData local = AvatarDataManager.localPlayer;
        boolean hasBackend = this.connectionStatus == 3;
        this.exportNbt.field_22763 = hasLoadedAvatar = local != null && local.hasAvatar() && local.isAvatarLoaded();
        this.serializeAvatar.field_22763 = hasLoadedAvatar;
        boolean wasUploadActive = this.uploadButton.field_22763 = hasBackend && hasLoadedAvatar && local.isLocalAvatar;
        this.uploadButton.field_22763 = true;
        if (this.uploadButton.method_25405(mouseX, mouseY)) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 599.0);
            if (wasUploadActive) {
                this.method_25424(matrices, UPLOAD_TOOLTIP, mouseX, mouseY);
            } else {
                this.method_30901(matrices, hasBackend ? UPLOAD_LOCAL_TOOLTIP : NO_CONNECTION_TOOLTIP, mouseX, mouseY);
            }
            matrices.method_22909();
        }
        this.uploadButton.field_22763 = wasUploadActive;
        if (this.reloadButton.method_25405(mouseX, mouseY)) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 599.0);
            this.method_25424(matrices, RELOAD_TOOLTIP, mouseX, mouseY);
            matrices.method_22909();
        }
        if (!this.isHoldingShift && this.openFolderButton.method_25405((double)mouseX, (double)mouseY)) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 599.0);
            this.method_25424(matrices, MODEL_FOLDER_TOOLTIP, mouseX, mouseY);
            matrices.method_22909();
        }
        if (mouseY >= 88 && mouseY < 99) {
            List<class_5250> tooltip = null;
            if (mouseX >= this.field_22789 - 77 && mouseX < this.field_22789 - 61) {
                tooltip = List.of(MODEL_STATUS_TEXT, class_2561.method_43473().method_10852((class_2561)STATUS_INDICATORS.get(this.modelSizeStatus)).method_27693(" ").method_10852((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.status.model." + this.modelSizeStatus)).method_10862(TEXT_COLORS.get(this.modelSizeStatus))));
            } else if (mouseX >= this.field_22789 - 58 && mouseX < this.field_22789 - 42) {
                tooltip = List.of(TEXTURE_STATUS_TEXT, class_2561.method_43473().method_10852((class_2561)STATUS_INDICATORS.get(this.textureStatus)).method_27693(" ").method_10852((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.status.texture." + this.textureStatus)).method_10862(TEXT_COLORS.get(this.textureStatus))));
            } else if (mouseX >= this.field_22789 - 39 && mouseX < this.field_22789 - 23) {
                tooltip = List.of(SCRIPT_STATUS_TEXT, class_2561.method_43473().method_10852((class_2561)STATUS_INDICATORS.get(this.scriptStatus)).method_27693(" ").method_10852((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.status.script." + this.scriptStatus)).method_10862(TEXT_COLORS.get(this.scriptStatus))));
            } else if (mouseX >= this.field_22789 - 20 && mouseX < this.field_22789 - 4) {
                tooltip = List.of(BACKEND_STATUS_TEXT, class_2561.method_43473().method_10852((class_2561)STATUS_INDICATORS.get(this.connectionStatus)).method_27693(" ").method_10852((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.status.backend." + this.connectionStatus)).method_10862(TEXT_COLORS.get(this.connectionStatus))));
            }
            if (tooltip != null) {
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 599.0);
                this.method_30901(matrices, tooltip, mouseX, mouseY);
                matrices.method_22909();
            }
        }
        boolean wasKeybindsActive = this.keybindsButton.field_22763 = AvatarDataManager.localPlayer != null && AvatarDataManager.localPlayer.script != null;
        this.keybindsButton.field_22763 = true;
        if (this.keybindsButton.method_25405(mouseX, mouseY)) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 599.0);
            this.method_25424(matrices, KEYBIND_TOOLTIP, mouseX, mouseY);
            matrices.method_22909();
        }
        this.keybindsButton.field_22763 = wasKeybindsActive;
        boolean wasSoundsActive = this.soundsButton.field_22763 = AvatarDataManager.localPlayer != null && AvatarDataManager.localPlayer.script != null;
        this.soundsButton.field_22763 = true;
        if (this.soundsButton.method_25405(mouseX, mouseY)) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 599.0);
            this.method_25424(matrices, SOUND_TOOLTIP, mouseX, mouseY);
            matrices.method_22909();
        }
        this.soundsButton.field_22763 = wasSoundsActive;
        if (!this.deleteButton.field_22763) {
            this.deleteButton.field_22763 = true;
            boolean mouseOver = this.deleteButton.method_25405(mouseX, mouseY);
            this.deleteButton.field_22763 = false;
            if (mouseOver) {
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 599.0);
                this.method_30901(matrices, hasBackend ? DELETE_TOOLTIP : NO_CONNECTION_TOOLTIP, mouseX, mouseY);
                matrices.method_22909();
            }
        }
    }

    public void renderAsBackground(int vOffset) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912(0.0, (double)this.field_22790, 0.0).method_22913(0.0f, (float)this.field_22790 / 32.0f + (float)vOffset).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, (double)this.field_22790, 0.0).method_22913((float)this.field_22789 / 32.0f, (float)this.field_22790 / 32.0f + (float)vOffset).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_22789, 0.0, 0.0).method_22913((float)this.field_22789 / 32.0f, (float)vOffset).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22912(0.0, 0.0, 0.0).method_22913(0.0f, (float)vOffset).method_1336(255, 255, 255, 255).method_1344();
        tessellator.method_1350();
    }

    public void loadLocalAvatar(Object stuff) {
        AvatarDataManager.localPlayer.isLocalAvatar = true;
        if (stuff instanceof String) {
            String str = (String)stuff;
            AvatarDataManager.localPlayer.loadModelFile(str);
        } else if (stuff instanceof class_2487) {
            class_2487 nbt = (class_2487)stuff;
            AvatarDataManager.localPlayer.loadFromNbt(nbt);
        }
    }

    public void updateAvatarData() {
        if (AvatarDataManager.localPlayer != null && AvatarDataManager.localPlayer.hasAvatar()) {
            if (AvatarDataManager.localPlayer.loadedName != null) {
                this.nameText = class_5250.method_43477((class_7417)new class_2588("figura.gui.status.name"));
                int maxWidth = this.field_22789 / 2 - modelBgSize / 2 - 41 - this.field_22793.method_27525((class_5348)this.nameText);
                String toTrim = " " + AvatarDataManager.localPlayer.loadedName;
                if (this.field_22793.method_1727(toTrim) > maxWidth) {
                    toTrim = this.field_22793.method_27523(toTrim, maxWidth - this.field_22793.method_1727("...")) + "...";
                }
                this.nameText.method_10852((class_2561)class_2561.method_43470((String)toTrim).method_27694(FiguraMod.ACCENT_COLOR));
            } else {
                this.nameText = null;
            }
            if (AvatarDataManager.localPlayer.model != null) {
                this.modelComplexityText = class_5250.method_43477((class_7417)new class_2588("figura.gui.status.complexity")).method_10852((class_2561)class_2561.method_43470((String)(" " + AvatarDataManager.localPlayer.getComplexity())).method_27694(FiguraMod.ACCENT_COLOR));
            } else {
                this.modelComplexityText = class_5250.method_43477((class_7417)new class_2588("figura.gui.status.complexity")).method_10852((class_2561)class_2561.method_43470((String)" 0").method_27694(FiguraMod.ACCENT_COLOR));
                this.modelSizeStatus = 0;
            }
            if (AvatarDataManager.localPlayer.hasAvatar()) {
                FiguraMod.doTask(() -> {
                    this.fileSizeText = this.getFileSizeText();
                });
            }
            this.scriptStatus = AvatarDataManager.localPlayer.script != null ? (AvatarDataManager.localPlayer.script.scriptError ? 1 : 3) : 0;
            this.textureStatus = AvatarDataManager.localPlayer.texture != null ? 3 : 0;
        } else {
            this.nameText = null;
            this.modelComplexityText = null;
            this.fileSizeText = null;
            this.textureStatus = 0;
            this.modelSizeStatus = 0;
            this.scriptStatus = 0;
        }
        this.connectionStatus = NewFiguraNetworkManager.connectionStatus;
    }

    public class_5250 getFileSizeText() {
        long fileSize = AvatarDataManager.localPlayer.getFileSize();
        DecimalFormat df = new DecimalFormat("#0.00", new DecimalFormatSymbols(Locale.US));
        df.setRoundingMode(RoundingMode.HALF_UP);
        float size = Float.parseFloat(df.format((float)fileSize / 1000.0f));
        class_5250 fsText = class_5250.method_43477((class_7417)new class_2588("figura.gui.status.filesize")).method_10852((class_2561)class_2561.method_43470((String)(" " + size)).method_27694(FiguraMod.ACCENT_COLOR));
        if (fileSize >= 100000L) {
            fsText.method_10862(TEXT_COLORS.get(1));
            this.modelSizeStatus = 1;
        } else if (fileSize >= 75000L) {
            fsText.method_10862(TEXT_COLORS.get(2));
            this.modelSizeStatus = 2;
        } else {
            fsText.method_10862(TEXT_COLORS.get(0));
            this.modelSizeStatus = 3;
        }
        this.modelSizeStatus = AvatarDataManager.localPlayer.model != null ? this.modelSizeStatus : 0;
        return fsText;
    }

    public void updateExpand() {
        if (expand) {
            this.method_25396().forEach(child -> {
                if (child instanceof class_339) {
                    class_339 widget = (class_339)child;
                    widget.field_22764 = false;
                }
            });
            this.expandButton.setPos(5, 5);
            this.expandButton.setUV(0, 0);
            this.expandButton.field_22764 = true;
            this.modelFileList.method_25323(0, 0, this.field_22790, 0);
        } else {
            this.method_25396().forEach(child -> {
                if (child instanceof class_339) {
                    class_339 widget = (class_339)child;
                    widget.field_22764 = true;
                }
            });
            this.expandButton.setPos(Math.max(this.field_22789 / 2 - modelBgSize / 2, this.paneWidth + 5), this.field_22790 / 2 - modelBgSize / 2 + 1);
            this.expandButton.setUV(15, 0);
            this.modelFileList.method_25323(this.paneWidth, this.field_22790, this.paneY + 19, this.field_22790 - 36);
            this.modelFileList.method_25333(5);
            this.scaledValue = 0.0f;
        }
        this.modelX = this.field_22789 / 2;
        this.modelY = this.field_22790 / 2;
    }

    public void resetModelPos() {
        this.anchorX = 0.0f;
        this.anchorY = 0.0f;
        this.anchorAngleX = 0.0f;
        this.anchorAngleY = 0.0f;
        this.angleX = -15.0f;
        this.angleY = 30.0f;
        this.scaledValue = 0.0f;
        this.modelX = this.field_22789 / 2;
        this.modelY = this.field_22790 / 2;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        switch (button) {
            case 0: {
                if (!(mouseX >= (double)this.field_22789 / 2.0 - (double)modelBgSize / 2.0 && mouseX <= (double)this.field_22789 / 2.0 + (double)modelBgSize / 2.0 && mouseY >= (double)this.field_22790 / 2.0 - (double)modelBgSize / 2.0 && mouseY <= (double)this.field_22790 / 2.0 + (double)modelBgSize / 2.0) && !expand) break;
                this.anchorX = (float)mouseX;
                this.anchorY = (float)mouseY;
                this.anchorAngleX = this.angleX;
                this.anchorAngleY = this.angleY;
                this.canRotate = true;
                break;
            }
            case 1: {
                this.dragDeltaX = (float)mouseX;
                this.dragDeltaY = (float)mouseY;
                this.dragAnchorX = this.modelX;
                this.dragAnchorY = this.modelY;
                this.canDrag = true;
                break;
            }
            case 2: {
                this.canRotate = false;
                this.canDrag = false;
                this.resetModelPos();
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.canRotate = false;
        this.canDrag = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.canRotate) {
            this.angleX = (float)((double)this.anchorAngleX + ((double)this.anchorY - mouseY) / (3.0 / (double)guiScale));
            this.angleY = (float)((double)this.anchorAngleY - ((double)this.anchorX - mouseX) / (3.0 / (double)guiScale));
            if (this.angleX > 90.0f) {
                this.anchorY = (float)mouseY;
                this.anchorAngleX = 90.0f;
                this.angleX = 90.0f;
            } else if (this.angleX < -90.0f) {
                this.anchorY = (float)mouseY;
                this.anchorAngleX = -90.0f;
                this.angleX = -90.0f;
            }
            if (this.angleY >= 360.0f || this.angleY <= -360.0f) {
                this.anchorX = (float)mouseX;
                this.anchorAngleY = 0.0f;
                this.angleY = 0.0f;
            }
        } else if (this.canDrag && expand) {
            float x = (float)(mouseX - (double)this.dragDeltaX);
            float y = (float)(mouseY - (double)this.dragDeltaY);
            if (this.modelX >= 0 && this.modelX <= this.field_22789) {
                this.modelX = (int)(this.dragAnchorX + x);
            }
            if (this.modelY >= 0 && this.modelY <= this.field_22790) {
                this.modelY = (int)(this.dragAnchorY + y);
            }
            this.modelX = this.modelX < 0 ? 0 : Math.min(this.modelX, this.field_22789);
            this.modelY = this.modelY < 0 ? 0 : Math.min(this.modelY, this.field_22790);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        boolean result = super.method_16803(keyCode, scanCode, modifiers);
        if (keyCode == 340) {
            this.isHoldingShift = false;
            this.deleteButton.field_22763 = false;
            this.openFolderButton.method_25355((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.openfolder")));
        }
        return result;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (expand) {
            float scaledir = amount > 0.0 ? 1.1f : 0.9090909f;
            this.scaledValue = ((float)modelSize + this.scaledValue) * scaledir - (float)modelSize;
            if (this.scaledValue <= -35.0f) {
                this.scaledValue = -35.0f;
            }
            if (this.scaledValue >= 250.0f) {
                this.scaledValue = 250.0f;
            }
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == OvO[ovo]) {
            if (++ovo >= OvO.length) {
                ovo = 0;
                this.field_22787.method_1507((class_437)new NewFiguraGuiScreen(this));
            }
        } else if (ovo != 2 || keyCode != 265) {
            ovo = 0;
        }
        if (keyCode == 256 && expand) {
            expand = false;
            this.updateExpand();
            return false;
        }
        boolean result = super.method_25404(keyCode, scanCode, modifiers);
        if (keyCode == 340) {
            this.isHoldingShift = true;
            this.deleteButton.field_22763 = this.connectionStatus == 3;
            this.openFolderButton.method_25355((class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.button.openavatarfolder")));
        }
        return result;
    }

    public void method_29638(List<Path> paths) {
        super.method_29638(paths);
        String string = paths.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining(", "));
        this.field_22787.method_1507((class_437)new class_410(bl -> {
            Path destPath = LocalAvatarData.getContentDirectory();
            if (bl) {
                paths.forEach(path2 -> {
                    try {
                        Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);
                        try {
                            stream.forEach(path3 -> {
                                try {
                                    class_156.method_29775((Path)path2.getParent(), (Path)destPath, (Path)path3);
                                }
                                catch (IOException e) {
                                    FiguraMod.LOGGER.error("Failed to copy model file from {} to {}", path3, (Object)destPath);
                                    e.printStackTrace();
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        stream.close();
                    }
                    catch (Exception e) {
                        FiguraMod.LOGGER.error("Failed to copy model file from {} to {}", path2, (Object)destPath);
                        e.printStackTrace();
                    }
                });
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_5250.method_43477((class_7417)new class_2588("figura.gui.dropconfirm")), (class_2561)class_2561.method_43470((String)string)));
    }

    public static void drawEntity(int x, int y, int size, float rotationX, float rotationY, class_1309 entity) {
        if (entity == null) {
            return;
        }
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 1500.0);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_22904(0.0, 0.0, 1000.0);
        matrixStack2.method_22905((float)size, (float)size, (float)size);
        class_1158 quaternion = class_1160.field_20707.method_23214(180.0f);
        class_1158 quaternion2 = class_1160.field_20703.method_23214(rotationX);
        quaternion.method_4925(quaternion2);
        matrixStack2.method_22907(quaternion);
        float h = entity.field_6283;
        float i = entity.method_36454();
        float j = entity.method_36455();
        float k = entity.field_6259;
        float l = entity.field_6241;
        boolean invisible = entity.method_5767();
        entity.field_6283 = 180.0f - rotationY;
        entity.method_36456(180.0f - rotationY);
        entity.method_36457(0.0f);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        entity.method_5648(false);
        showOwnNametag = (Boolean)ConfigManager.Config.PREVIEW_NAMEPLATE.value;
        renderFireOverlay = false;
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        quaternion2.method_4926();
        entityRenderDispatcher.method_24196(quaternion2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        int box = modelBgSize * guiScale;
        if (!expand) {
            RenderSystem.enableScissor((int)(x * guiScale - box / 2), (int)(y * guiScale - box / 2), (int)box, (int)box);
        }
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, 0.0, -1.0, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0xF000F0));
        RenderSystem.disableScissor();
        immediate.method_22993();
        entityRenderDispatcher.method_3948(true);
        entity.field_6283 = h;
        entity.method_36456(i);
        entity.method_36457(j);
        entity.field_6259 = k;
        entity.field_6241 = l;
        entity.method_5648(invisible);
        showOwnNametag = false;
        renderFireOverlay = true;
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    static {
        showOwnNametag = false;
        renderFireOverlay = true;
    }
}

