/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.blancworks.figura.avatar.AvatarData;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.avatar.LocalAvatarData;
import net.blancworks.figura.config.ConfigManager;
import net.blancworks.figura.lua.api.actionwheel.ActionWheelCustomization;
import net.blancworks.figura.models.FiguraTexture;
import net.blancworks.figura.utils.MathUtils;
import net.blancworks.figura.utils.TextUtils;
import net.minecraft.class_1047;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7417;

public class ActionWheel
extends class_332 {
    private static final class_2960 ACTION_WHEEL = new class_2960("figura", "textures/gui/action_wheel.png");
    private static final class_2960 ACTION_WHEEL_SELECTED = new class_2960("figura", "textures/gui/action_wheel_selected.png");
    private static final class_1160 ERROR_COLOR = new class_1160(1.0f, 0.28f, 0.28f);
    private static final List<class_2561> NO_FUNCTION_MESSAGE = ImmutableList.of((Object)class_5250.method_43477((class_7417)new class_2588("figura.actionwheel.nofunction")));
    public static int selectedSlot = -1;
    public static boolean enabled = false;

    public static void render(class_4587 matrices) {
        class_310 client = class_310.method_1551();
        class_241 screenSize = new class_241((float)client.method_22683().method_4480() / 2.0f, (float)client.method_22683().method_4507() / 2.0f);
        float screenScale = (float)client.method_22683().method_4495();
        class_241 mousePos = new class_241((float)client.field_1729.method_1603() - screenSize.field_1343, (float)client.field_1729.method_1604() - screenSize.field_1342);
        float angle = ActionWheel.getAngle(mousePos.field_1343, mousePos.field_1342);
        float distance = class_3532.method_15355((float)(mousePos.field_1343 * mousePos.field_1343 + mousePos.field_1342 * mousePos.field_1342));
        class_241 wheelPos = new class_241(screenSize.field_1343 / screenScale, screenSize.field_1342 / screenScale);
        int wheelSize = 180;
        class_241 itemOffset = new class_241(wheelPos.field_1343 * 2.0f / 3.0f - 8.0f, wheelPos.field_1342 * 2.0f / 3.0f - 8.0f);
        int itemRadius = 39;
        LocalAvatarData data = AvatarDataManager.localPlayer;
        RenderSystem.enableBlend();
        if (data != null && data.script != null) {
            int leftSegments = data.script.actionWheelLeftSize;
            int rightSegments = data.script.actionWheelRightSize;
            selectedSlot = distance > 28.0f * screenScale ? (angle < 180.0f ? class_3532.method_15375((float)((float)rightSegments / 180.0f * angle)) : class_3532.method_15375((float)((float)leftSegments / 180.0f * (angle - 180.0f))) + rightSegments) : -1;
            ActionWheel.renderWheel(matrices, wheelPos, wheelSize, leftSegments, rightSegments);
            for (int i = 0; i < leftSegments + rightSegments; ++i) {
                ActionWheel.renderOverlay(matrices, wheelPos, wheelSize, leftSegments, rightSegments, data, i);
            }
            ActionWheel.renderTextures(matrices, leftSegments, rightSegments, itemOffset, itemRadius, data);
            if (selectedSlot != -1) {
                ActionWheel.renderText(matrices, wheelPos, wheelSize, screenScale, data, client);
            }
            ActionWheel.renderItems(leftSegments, rightSegments, itemOffset, itemRadius, data, client);
        } else {
            ActionWheel.renderWheel(matrices, wheelPos, wheelSize, 4, 4);
            ActionWheel.method_35719((class_4587)matrices, (class_327)class_310.method_1551().field_1772, (class_5481)class_5250.method_43477((class_7417)new class_2588("figura.actionwheel.warning")).method_27692(class_124.field_1073).method_30937(), (int)((int)wheelPos.field_1343), (int)((int)wheelPos.field_1342 - 4), (int)class_124.field_1061.method_532());
            ActionWheel.method_35719((class_4587)matrices, (class_327)class_310.method_1551().field_1772, (class_5481)class_5250.method_43477((class_7417)new class_2588("figura.actionwheel.warninginfo")).method_30937(), (int)((int)wheelPos.field_1343), (int)((int)Math.max(wheelPos.field_1342 - (float)wheelSize / 2.0f - 10.0f, 4.0f)), (int)class_124.field_1061.method_532());
        }
        RenderSystem.disableBlend();
        enabled = true;
    }

    public static float getAngle(float x, float y) {
        float ang = (float)Math.toDegrees(class_3532.method_15349((double)x, (double)(-y)));
        return ang < 0.0f ? 360.0f + ang : ang;
    }

    public static void renderWheel(class_4587 matrices, class_241 pos, int size, int leftSegments, int rightSegments) {
        RenderSystem.setShaderTexture((int)0, (class_2960)ACTION_WHEEL);
        matrices.method_22903();
        matrices.method_22904((double)Math.round(pos.field_1343), (double)Math.round(pos.field_1342 - (float)size / 2.0f), 0.0);
        ActionWheel.method_25293((class_4587)matrices, (int)0, (int)0, (int)(size / 2), (int)size, (float)(8.0f * (float)(rightSegments - 1)), (float)0.0f, (int)8, (int)16, (int)32, (int)16);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22904((double)Math.round(pos.field_1343), (double)Math.round(pos.field_1342 + (float)size / 2.0f), 0.0);
        class_1158 quaternion = class_1160.field_20707.method_23214(180.0f);
        matrices.method_22907(quaternion);
        ActionWheel.method_25293((class_4587)matrices, (int)0, (int)0, (int)(size / 2), (int)size, (float)(8.0f * (float)(leftSegments - 1)), (float)0.0f, (int)8, (int)16, (int)32, (int)16);
        matrices.method_22909();
    }

    public static void renderOverlay(class_4587 matrices, class_241 pos, int size, int leftSegments, int rightSegments, AvatarData data, int i) {
        int selected;
        int segments;
        ActionWheelCustomization customization = data.script.getActionWheelCustomization("SLOT_" + (i + 1));
        boolean hasFunction = false;
        boolean hasColor = false;
        boolean hasHoverColor = false;
        boolean isSelected = selectedSlot == i;
        int slot = i < rightSegments ? i : i - rightSegments + 4;
        class_1160 overlayColor = MathUtils.Vec3f_ONE;
        if (customization != null) {
            hasFunction = customization.function != null;
            hasColor = customization.color != null;
            boolean bl = hasHoverColor = customization.hoverColor != null;
        }
        if (hasColor) {
            overlayColor = customization.color;
        }
        if (isSelected) {
            if (!hasFunction) {
                overlayColor = ERROR_COLOR;
            } else if (hasHoverColor) {
                overlayColor = customization.hoverColor;
            }
        } else if (!hasColor) {
            return;
        }
        if (slot < 4) {
            segments = rightSegments;
            selected = slot;
        } else {
            segments = leftSegments;
            selected = slot - 4 + leftSegments;
        }
        double y = pos.field_1342;
        float angle = 0.0f;
        int height = size / 2;
        float u = 0.0f;
        float v = 0.0f;
        int regionHeight = 8;
        switch (segments) {
            case 1: {
                y = selected % 2 == 1 ? (double)(pos.field_1342 + (float)size / 2.0f) : (double)(pos.field_1342 - (float)size / 2.0f);
                angle = 180.0f * (float)selected;
                height = size;
                regionHeight = 16;
                break;
            }
            case 2: {
                angle = 90.0f * ((float)selected - 1.0f);
                u = 8.0f;
                break;
            }
            case 3: {
                if (selected % 3 != 2) {
                    y += (double)((float)((selected < 3 ? -1 : 1) * size) / 2.0f);
                    if (selected % 3 == 1) {
                        y += (double)((float)((selected < 3 ? 1 : -1) * size) / 4.0f);
                        v = 8.0f;
                    }
                    u = 16.0f;
                } else {
                    u = 8.0f;
                    v = 8.0f;
                }
                angle = 180.0f * (float)class_3532.method_15375((float)((float)selected / 3.0f));
                break;
            }
            case 4: {
                angle = 90.0f * ((float)class_3532.method_15375((float)((float)selected / 2.0f)) + 3.0f);
                u = 24.0f;
                v = selected % 2 == 1 ? 8.0f : 0.0f;
            }
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)ACTION_WHEEL_SELECTED);
        matrices.method_22903();
        matrices.method_22904((double)Math.round(pos.field_1343), (double)Math.round(y), 0.0);
        class_1158 quaternion = class_1160.field_20707.method_23214(angle);
        matrices.method_22907(quaternion);
        RenderSystem.setShaderColor((float)overlayColor.method_4943(), (float)overlayColor.method_4945(), (float)overlayColor.method_4947(), (float)1.0f);
        ActionWheel.method_25293((class_4587)matrices, (int)0, (int)0, (int)(size / 2), (int)height, (float)u, (float)v, (int)8, (int)regionHeight, (int)32, (int)16);
        matrices.method_22909();
    }

    public static void renderTextures(class_4587 matrices, int leftSegments, int rightSegments, class_241 offset, int radius, AvatarData data) {
        for (int i = 0; i < leftSegments + rightSegments; ++i) {
            float angle;
            if (i < rightSegments) {
                index = i;
                angle = (float)Math.toRadians(180.0f / (float)rightSegments * ((float)index - (float)(rightSegments - 1) * 0.5f));
            } else {
                index = i - rightSegments + 4;
                angle = (float)Math.toRadians(180.0f / (float)leftSegments * ((float)(index - 4) - (float)(leftSegments - 1) * 0.5f + (float)leftSegments));
            }
            class_241 pos = new class_241((float)radius * class_3532.method_15362((float)angle) + offset.field_1343, (float)radius * class_3532.method_15374((float)angle) + offset.field_1342);
            ActionWheelCustomization cust = data.script.getActionWheelCustomization("SLOT_" + (i + 1));
            if (cust == null || cust.texture == ActionWheelCustomization.TextureType.None || cust.uvOffset == null || cust.uvSize == null || data.playerListEntry == null) continue;
            RenderSystem.setShaderTexture((int)0, (class_2960)(switch (cust.texture) {
                case ActionWheelCustomization.TextureType.Cape -> Objects.requireNonNullElse(data.playerListEntry.method_2979(), FiguraTexture.DEFAULT_ID);
                case ActionWheelCustomization.TextureType.Elytra -> Objects.requireNonNullElse(data.playerListEntry.method_2957(), FiguraTexture.ELYTRA_ID);
                case ActionWheelCustomization.TextureType.Resource -> class_310.method_1551().method_1478().method_14486(cust.texturePath).isPresent() ? cust.texturePath : class_1047.method_4539();
                case ActionWheelCustomization.TextureType.Skin -> data.playerListEntry.method_2968();
                case ActionWheelCustomization.TextureType.Custom -> data.texture != null ? data.texture.id : class_1047.method_4539();
                default -> FiguraTexture.DEFAULT_ID;
            }));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22903();
            matrices.method_22905(1.5f, 1.5f, 1.5f);
            class_241 off = cust.uvOffset;
            class_241 len = cust.uvSize;
            class_241 siz = cust.textureSize;
            class_241 scl = cust.textureScale;
            ActionWheel.method_25293((class_4587)matrices, (int)((int)(pos.field_1343 + 8.0f - siz.field_1343 * scl.field_1343 / 2.0f)), (int)((int)(pos.field_1342 + 8.0f - siz.field_1342 * scl.field_1342 / 2.0f)), (int)((int)(siz.field_1343 * scl.field_1343)), (int)((int)(siz.field_1342 * scl.field_1342)), (float)off.field_1343, (float)off.field_1342, (int)((int)len.field_1343), (int)((int)len.field_1342), (int)((int)siz.field_1343), (int)((int)siz.field_1342));
            matrices.method_22909();
        }
    }

    public static void renderText(class_4587 matrices, class_241 pos, int size, float scale, AvatarData data, class_310 client) {
        ActionWheelCustomization customization = data.script.getActionWheelCustomization("SLOT_" + (selectedSlot + 1));
        List<class_2561> lines = NO_FUNCTION_MESSAGE;
        int textColor = class_124.field_1061.method_532();
        if (customization != null && customization.function != null) {
            if (customization.title == null) {
                return;
            }
            class_2561 text = TextUtils.tryParseJson(customization.title);
            lines = TextUtils.splitText(text, "\n");
            textColor = class_124.field_1068.method_532();
        }
        int titleLen = client.field_1772.method_27525((class_5348)lines.get(0)) / 2;
        class_241 textPos = switch ((Integer)ConfigManager.Config.ACTION_WHEEL_TITLE_POS.value) {
            case 1 -> new class_241(pos.field_1343 - (float)titleLen, Math.max(pos.field_1342 - (float)size / 2.0f - 10.0f, 4.0f));
            case 2 -> new class_241(pos.field_1343 - (float)titleLen, Math.min(pos.field_1342 + (float)size / 2.0f + 4.0f, (float)(client.method_22683().method_4507() - 12)));
            case 3 -> new class_241(pos.field_1343 - (float)titleLen, pos.field_1342 - 4.0f);
            default -> new class_241((float)client.field_1729.method_1603() / scale, (float)client.field_1729.method_1604() / scale - 10.0f);
        };
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 599.0);
        int i = 0;
        for (class_2561 text : lines) {
            ActionWheel.method_27535((class_4587)matrices, (class_327)client.field_1772, (class_2561)text, (int)((int)textPos.field_1343), (int)((int)textPos.field_1342 + (i - lines.size() + 1) * 9), (int)textColor);
            ++i;
        }
        matrices.method_22909();
    }

    public static void renderItems(int leftSegments, int rightSegments, class_241 offset, int radius, AvatarData data, class_310 client) {
        for (int i = 0; i < leftSegments + rightSegments; ++i) {
            float angle;
            int index;
            if (i < rightSegments) {
                index = i;
                angle = (float)Math.toRadians(180.0f / (float)rightSegments * ((float)index - (float)(rightSegments - 1) * 0.5f));
            } else {
                index = i - rightSegments + 4;
                angle = (float)Math.toRadians(180.0f / (float)leftSegments * ((float)(index - 4) - (float)(leftSegments - 1) * 0.5f + (float)leftSegments));
            }
            class_241 pos = new class_241((float)radius * class_3532.method_15362((float)angle) + offset.field_1343, (float)radius * class_3532.method_15374((float)angle) + offset.field_1342);
            class_1799 item = class_1802.field_8162.method_7854();
            ActionWheelCustomization cust = data.script.getActionWheelCustomization("SLOT_" + (i + 1));
            if (cust != null) {
                if (cust.texture != ActionWheelCustomization.TextureType.None && cust.uvOffset != null && cust.uvSize != null) continue;
                if (selectedSlot == index && cust.hoverItem != null) {
                    item = cust.hoverItem;
                } else if (cust.item != null) {
                    item = cust.item;
                }
            }
            class_4587 matrixStack = RenderSystem.getModelViewStack();
            matrixStack.method_22903();
            matrixStack.method_22905(1.5f, 1.5f, 1.5f);
            client.method_1480().method_4010(item, (int)pos.field_1343, (int)pos.field_1342);
            matrixStack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public static void play() {
        ActionWheelCustomization customization;
        if (selectedSlot == -1) {
            return;
        }
        LocalAvatarData currentData = AvatarDataManager.localPlayer;
        if (currentData != null && currentData.script != null && (customization = currentData.script.getActionWheelCustomization("SLOT_" + (selectedSlot + 1))) != null && customization.function != null) {
            currentData.script.runActionWheelFunction(customization.function, customization.arg);
        }
        selectedSlot = -1;
    }
}

