/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public final class ConfigManager {
    public static final UnaryOperator<class_2583> ACCENT_COLOR = FiguraMod.ACCENT_COLOR;
    public static final String MOD_NAME = "figura";
    public static final int CONFIG_VERSION = 1;
    private static final Map<Config, String> V0_CONFIG = new HashMap<Config, String>(){
        {
            this.put(Config.PREVIEW_NAMEPLATE, "previewNameTag");
            this.put(Config.FIGURA_BUTTON_LOCATION, "buttonLocation");
            this.put(Config.USE_LOCAL_SERVER, "useLocalServer");
            this.put(Config.SCRIPT_LOG_LOCATION, "scriptLog");
            this.put(Config.PLAYERLIST_MODIFICATIONS, "listMods");
            this.put(Config.CHAT_MODIFICATIONS, "chatMods");
            this.put(Config.NAMEPLATE_MODIFICATIONS, "nameTagMods");
            this.put(Config.BADGE_AS_ICONS, "nameTagIcon");
            this.put(Config.BADGES, "showBadges");
            this.put(Config.RENDER_OWN_NAMEPLATE, "ownNameTag");
            this.put(Config.LOG_OTHERS_SCRIPT, "logOthers");
            this.put(Config.ACTION_WHEEL_BUTTON, "actionWheel");
            this.put(Config.FORMAT_SCRIPT_ON_UPLOAD, "formatScript");
            this.put(Config.ACTION_WHEEL_TITLE_POS, "actionWheelPos");
            this.put(Config.RENDER_DEBUG_PARTS_PIVOT, "partsHitBox");
        }
    };
    private static final File FILE = new File(FabricLoader.getInstance().getConfigDir().resolve("figura.json").toString());
    private static final List<Config> CONFIG_ENTRIES = new ArrayList<Config>(){
        {
            for (Config value : Config.values()) {
                if (value.type == ConfigType.CATEGORY) continue;
                this.add(value);
            }
        }
    };

    public static void initialize() {
        ConfigManager.loadConfig();
        ConfigManager.saveConfig();
    }

    public static void loadConfig() {
        try {
            if (FILE.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(FILE));
                JsonObject json = JsonParser.parseReader((Reader)br).getAsJsonObject();
                JsonElement version = json.get("CONFIG_VERSION");
                if (version == null || version.getAsInt() < 1) {
                    ConfigManager.update(json, version == null ? 0 : version.getAsInt());
                } else {
                    for (Config config : CONFIG_ENTRIES) {
                        JsonElement object = json.get(config.name().toLowerCase());
                        if (object == null) continue;
                        String jsonValue = object.getAsString();
                        config.setValue(jsonValue);
                    }
                }
                br.close();
            }
        }
        catch (Exception e) {
            FiguraMod.LOGGER.warn("Failed to load config file! Generating a new one...");
            e.printStackTrace();
            ConfigManager.setDefaults();
        }
    }

    public static void saveConfig() {
        try {
            JsonObject configJson = new JsonObject();
            for (Config config : CONFIG_ENTRIES) {
                if (config.value instanceof Number) {
                    configJson.addProperty(config.name().toLowerCase(), (Number)config.value);
                }
                if (config.value instanceof Character) {
                    configJson.addProperty(config.name().toLowerCase(), (Character)config.value);
                    continue;
                }
                if (config.value instanceof Boolean) {
                    configJson.addProperty(config.name().toLowerCase(), Boolean.valueOf((Boolean)config.value));
                    continue;
                }
                configJson.addProperty(config.name().toLowerCase(), String.valueOf(config.value));
            }
            configJson.addProperty("CONFIG_VERSION", (Number)1);
            String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)configJson);
            FileWriter fileWriter = new FileWriter(FILE);
            fileWriter.write(jsonString);
            fileWriter.close();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to save config file!");
            e.printStackTrace();
        }
    }

    public static void applyConfig() {
        for (Config config : CONFIG_ENTRIES) {
            boolean change = !config.value.equals(config.configValue);
            config.setValue(String.valueOf(config.configValue));
            if (!change) continue;
            config.runOnChange();
        }
    }

    public static void discardConfig() {
        for (Config config : CONFIG_ENTRIES) {
            config.configValue = config.value;
        }
    }

    public static void setDefaults() {
        for (Config config : CONFIG_ENTRIES) {
            config.value = config.defaultValue;
        }
    }

    public static void update(JsonObject json, int version) {
        Map<Config, String> versionMap = null;
        if (version == 0) {
            versionMap = V0_CONFIG;
        }
        if (versionMap == null) {
            return;
        }
        for (Map.Entry<Config, String> config : versionMap.entrySet()) {
            JsonElement object = json.get(config.getValue());
            if (object == null) continue;
            String jsonValue = object.getAsString();
            Config.valueOf(config.getKey().toString()).setValue(jsonValue);
        }
    }

    public static boolean modmenuButton() {
        return false;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Config {
        NameTag,
        PREVIEW_NAMEPLATE(true),
        NAMEPLATE_MODIFICATIONS(true),
        CHAT_MODIFICATIONS(true),
        PLAYERLIST_MODIFICATIONS(true),
        BADGES(true),
        BADGE_AS_ICONS(true){
            {
                this.tooltip = class_5250.method_43477((class_7417)new class_2588("figura.config.badge_as_icons.tooltip", new Object[]{class_2561.method_43470((String)"\u25b3").method_10862(class_2583.field_24360.method_27704(FiguraMod.FIGURA_FONT))}));
            }
        }
        ,
        Misc,
        FIGURA_BUTTON_LOCATION((Object)4, 5),
        SCRIPT_LOG_LOCATION((Object)0, 3){
            {
                String path = "figura.config.log_location.";
                this.enumList = List.of(class_5250.method_43477((class_7417)new class_2588(path + "1")), class_5250.method_43477((class_7417)new class_2588(path + "2")), class_5250.method_43477((class_7417)new class_2588(path + "3")));
            }
        }
        ,
        PLAYER_POPUP_BUTTON((Object)82, FiguraMod.PLAYER_POPUP_BUTTON),
        ACCENT_COLOR((Object)0x55FFFF, InputType.HEX_COLOR),
        RELEASE_CHANNEL((Object)0, 3){

            @Override
            public void runOnChange() {
                FiguraMod.getLatestModVersion();
            }
        }
        ,
        CUSTOM_PLAYER_HEADS(true),
        FIX_HANDS(true),
        EASTER_EGGS(true),
        ActionWheel,
        ACTION_WHEEL_BUTTON((Object)66, FiguraMod.ACTION_WHEEL_BUTTON),
        ACTION_WHEEL_TITLE_POS((Object)0, 4),
        ACTION_WHEEL_EXECUTE_ON_CLOSE(true),
        Dev{
            {
                this.name = class_5250.method_43477((class_7417)new class_2588("figura.config.dev")).method_27692(class_124.field_1061);
            }
        }
        ,
        USE_LOCAL_SERVER(false),
        FORMAT_SCRIPT_ON_UPLOAD(true){

            @Override
            public void runOnChange() {
                if (AvatarDataManager.localPlayer != null && AvatarDataManager.localPlayer.isLocalAvatar) {
                    AvatarDataManager.localPlayer.reloadAvatar();
                }
            }
        }
        ,
        LOG_OTHERS_SCRIPT(false),
        RENDER_DEBUG_PARTS_PIVOT(true){
            {
                String tooltip = "figura.config.render_debug_parts_pivot.tooltip";
                this.tooltip = class_5250.method_43477((class_7417)new class_2588(tooltip, new Object[]{class_5250.method_43477((class_7417)new class_2588(tooltip + ".cubes")).method_10862(class_2583.field_24360.method_36139(16741047)), class_5250.method_43477((class_7417)new class_2588(tooltip + ".groups")).method_10862(class_2583.field_24360.method_36139(843982))}));
            }
        }
        ,
        RENDER_OWN_NAMEPLATE(false),
        MODEL_FOLDER_PATH((Object)"", InputType.FOLDER_PATH),
        PANIC_BUTTON((Object)-1, FiguraMod.PANIC_BUTTON),
        PINGS_LOG_LOCATION((Object)3, 4){
            {
                String path = "figura.config.log_location.";
                this.enumList = List.of(class_5250.method_43477((class_7417)new class_2588(path + "1")), class_5250.method_43477((class_7417)new class_2588(path + "2")), class_5250.method_43477((class_7417)new class_2588(path + "3")), class_5250.method_43477((class_7417)new class_2588(path + "4")));
            }
        }
        ,
        BACKEND_PATH((Object)"figuranew.blancworks.org", InputType.ANY);

        public Object value;
        public Object configValue;
        public class_2561 name;
        public class_2561 tooltip;
        public List<class_2561> enumList;
        public final ConfigType type;
        public final Object defaultValue;
        public final Integer length;
        public class_304 keyBind;
        public final InputType inputType;

        private Config() {
            this(ConfigType.CATEGORY, null, null, null, null);
        }

        private Config(Object value) {
            this(ConfigType.BOOLEAN, value, null, null, null);
        }

        private Config(Object value, Integer length) {
            this(ConfigType.ENUM, value, length, null, null);
        }

        private Config(Object value, InputType inputType) {
            this(ConfigType.INPUT, value, null, null, inputType);
        }

        private Config(Object value, class_304 keyBind) {
            this(ConfigType.KEYBIND, value, null, keyBind, null);
        }

        private Config(ConfigType type, Object value, Integer length, class_304 keyBind, InputType inputType) {
            this.type = type;
            this.value = value;
            this.defaultValue = value;
            this.configValue = value;
            this.length = length;
            this.keyBind = keyBind;
            this.inputType = inputType;
            String name = "figura.config." + this.name().toLowerCase();
            this.name = class_5250.method_43477((class_7417)new class_2588(name));
            this.tooltip = class_5250.method_43477((class_7417)new class_2588(name + ".tooltip"));
            if (length != null) {
                ArrayList<class_2561> enumList = new ArrayList<class_2561>();
                for (int i = 1; i <= length; ++i) {
                    enumList.add((class_2561)class_5250.method_43477((class_7417)new class_2588(name + "." + i)));
                }
                this.enumList = enumList;
            }
        }

        public void setValue(String text) {
            try {
                if (this.value instanceof String) {
                    this.value = text;
                } else if (this.value instanceof Boolean) {
                    this.value = Boolean.valueOf(text);
                } else if (this.value instanceof Integer) {
                    this.value = Integer.valueOf(text);
                } else if (this.value instanceof Float) {
                    this.value = Float.valueOf(text);
                } else if (this.value instanceof Long) {
                    this.value = Long.valueOf(text);
                } else if (this.value instanceof Double) {
                    this.value = Double.valueOf(text);
                } else if (this.value instanceof Byte) {
                    this.value = Byte.valueOf(text);
                } else if (this.value instanceof Short) {
                    this.value = Short.valueOf(text);
                }
                if (this.length != null) {
                    this.value = (Integer.parseInt(text) % this.length + this.length) % this.length;
                }
            }
            catch (Exception e) {
                this.value = this.defaultValue;
            }
            this.configValue = this.value;
        }

        public void runOnChange() {
        }
    }

    public static class ConfigKeyBind
    extends class_304 {
        private final Config config;

        public ConfigKeyBind(String translationKey, int code, String category, Config config) {
            super(translationKey, code, category);
            this.config = config;
            config.keyBind = this;
        }

        public void method_1422(class_3675.class_306 boundKey) {
            super.method_1422(boundKey);
            this.config.value = boundKey.method_1444();
            ConfigManager.saveConfig();
        }
    }

    public static enum InputType {
        ANY(s -> true),
        INT(s -> s.matches("^[\\-+]?[0-9]*$")),
        FLOAT(s -> s.matches("[\\-+]?[0-9]*(\\.[0-9]+)?") || s.endsWith(".") || s.isEmpty()),
        HEX_COLOR(s -> s.matches("^[#]?[0-9A-Fa-f]{0,6}$")),
        FOLDER_PATH(s -> {
            if (!s.isBlank()) {
                try {
                    return Path.of(s.trim(), new String[0]).toFile().isDirectory();
                }
                catch (Exception ignored) {
                    return false;
                }
            }
            return true;
        });

        public final Predicate<String> validator;

        private InputType(Predicate<String> predicate) {
            this.validator = predicate;
        }
    }

    public static enum ConfigType {
        CATEGORY,
        BOOLEAN,
        ENUM,
        INPUT,
        KEYBIND;

    }
}

