/*
 * Decompiled with CFR 0.152.
 */
package net.blancworks.figura.avatar;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.blancworks.figura.FiguraMod;
import net.blancworks.figura.avatar.AvatarDataManager;
import net.blancworks.figura.lua.CustomScript;
import net.blancworks.figura.lua.api.sound.FiguraSoundManager;
import net.blancworks.figura.models.CustomModel;
import net.blancworks.figura.models.CustomModelPart;
import net.blancworks.figura.models.FiguraTexture;
import net.blancworks.figura.network.NewFiguraNetworkManager;
import net.blancworks.figura.trust.PlayerTrustManager;
import net.blancworks.figura.trust.TrustContainer;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_640;

public class AvatarData {
    private static class_1060 textureManager;
    public final UUID entityId;
    public CustomModel model;
    public FiguraTexture texture;
    public CustomScript script;
    public class_583<?> vanillaModel;
    public final List<FiguraTexture> extraTextures = new ArrayList<FiguraTexture>();
    public class_1297 lastEntity;
    public class_640 playerListEntry;
    public String lastHash = "";
    public boolean isInvalidated = false;
    private class_2960 trustIdentifier;
    public boolean trustIssues = false;
    public class_2561 name;
    public boolean isLocalAvatar = true;
    public boolean hasPopup = false;
    public class_4597 vertexConsumerProvider;
    public class_4597.class_4598 immediate;
    public float deltaTime = 1.0f;
    public static AvatarData currentRenderingData;
    public static final int FILESIZE_WARNING_THRESHOLD = 75000;
    public static final int FILESIZE_LARGE_THRESHOLD = 100000;

    public AvatarData(UUID id) {
        this.entityId = id;
    }

    public class_4597 getVCP() {
        if (this.script != null && this.script.customVCP != null) {
            return this.script.customVCP;
        }
        if (this.vertexConsumerProvider != null) {
            return this.vertexConsumerProvider;
        }
        return class_310.method_1551().method_22940().method_23000();
    }

    public class_4597 tryGetImmediate() {
        return this.immediate == null ? this.vertexConsumerProvider : this.immediate;
    }

    public class_2960 getTrustIdentifier() {
        if (this.trustIdentifier == null) {
            this.trustIdentifier = new class_2960("player", this.entityId.toString());
        }
        return this.trustIdentifier;
    }

    public static class_1060 getTextureManager() {
        if (textureManager == null) {
            textureManager = class_310.method_1551().method_1531();
        }
        return textureManager;
    }

    public static void setRenderingData(AvatarData data, class_4597 vcp, class_583<?> mdl, float dt) {
        if (data == null) {
            return;
        }
        data.vanillaModel = mdl;
        data.vertexConsumerProvider = vcp;
        if (vcp.getClass() == class_4597.class_4598.class) {
            data.immediate = (class_4597.class_4598)vcp;
        }
        data.deltaTime = dt;
        currentRenderingData = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getComplexity() {
        if (this.model == null) {
            return 0;
        }
        int lastComplexity = 0;
        try {
            ArrayList<CustomModelPart> arrayList = this.model.allParts;
            synchronized (arrayList) {
                for (CustomModelPart part : this.model.allParts) {
                    lastComplexity += part.getComplexity();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return lastComplexity;
    }

    public boolean writeNbt(class_2487 nbt) {
        if (!this.hasAvatar()) {
            return false;
        }
        nbt.method_25927("id", this.entityId);
        if (this.model != null) {
            nbt.method_10566("model", (class_2520)this.model.modelNbt);
        }
        if (this.texture != null) {
            class_2487 textureNbt = new class_2487();
            this.texture.writeNbt(textureNbt);
            nbt.method_10566("texture", (class_2520)textureNbt);
        }
        if (this.script != null) {
            class_2487 scriptNbt = new class_2487();
            this.script.toNBT(scriptNbt);
            nbt.method_10566("script", (class_2520)scriptNbt);
            try {
                if (!this.script.customSounds.isEmpty()) {
                    nbt.method_10566("sounds", this.writeCustomSoundsNBT());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.extraTextures.isEmpty()) {
            class_2499 texList = new class_2499();
            for (FiguraTexture extraTexture : this.extraTextures) {
                class_2487 extraTextureNbt = new class_2487();
                extraTexture.writeNbt(extraTextureNbt);
                texList.add((Object)extraTextureNbt);
            }
            nbt.method_10566("exTexs", (class_2520)texList);
        }
        return true;
    }

    private void readNbt(class_2487 nbt) {
        this.model = null;
        this.texture = null;
        this.script = null;
        this.extraTextures.clear();
        try {
            class_2487 modelNbt = (class_2487)nbt.method_10580("model");
            if (modelNbt != null) {
                FiguraMod.doTask(() -> {
                    try {
                        this.model = new CustomModel(modelNbt, this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            class_2487 textureNbt = (class_2487)nbt.method_10580("texture");
            if (textureNbt != null) {
                this.texture = new FiguraTexture();
                this.texture.id = new class_2960("figura", this.entityId.toString());
                AvatarData.getTextureManager().method_4616(this.texture.id, (class_1044)this.texture);
                FiguraMod.doTask(() -> this.texture.readNbt(textureNbt));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            class_2487 scriptNbt;
            if (nbt.method_10545("script") && (scriptNbt = (class_2487)nbt.method_10580("script")) != null) {
                FiguraMod.doTask(() -> {
                    try {
                        this.script = new CustomScript();
                        this.script.fromNBT(this, scriptNbt);
                        if (nbt.method_10545("sounds")) {
                            this.readCustomSoundsNBT(nbt.method_10562("sounds"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            class_2499 textureList;
            if (nbt.method_10545("exTexs") && (textureList = (class_2499)nbt.method_10580("exTexs")) != null) {
                for (class_2520 element : textureList) {
                    FiguraTexture newTexture = new FiguraTexture();
                    newTexture.id = new class_2960("figura", this.entityId.toString() + newTexture.type.toString());
                    AvatarData.getTextureManager().method_4616(newTexture.id, (class_1044)newTexture);
                    this.extraTextures.add(newTexture);
                    FiguraMod.doTask(() -> newTexture.readNbt((class_2487)element));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long getFileSize() {
        try {
            class_2487 writtenNbt = new class_2487();
            this.writeNbt(writtenNbt);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream w = new DataOutputStream(out);
            class_2507.method_10634((class_2487)writtenNbt, (OutputStream)w);
            return w.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void tick() {
        if (this.entityId == null) {
            return;
        }
        if (this.isInvalidated) {
            AvatarDataManager.clearPlayer(this.entityId);
        }
        this.lastEntity = class_310.method_1551().field_1687 != null ? class_310.method_1551().field_1687.method_18470(this.entityId) : null;
        NewFiguraNetworkManager.subscribe(this.entityId);
        if (this.lastEntity != null) {
            this.name = this.lastEntity.method_5477();
            if (this.script != null) {
                try {
                    this.script.setPlayerEntity();
                    this.script.tick();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void loadFromNbt(class_2487 tag) {
        this.readNbt(tag);
        this.getFileSize();
    }

    public TrustContainer getTrustContainer() {
        return PlayerTrustManager.getContainer(this.getTrustIdentifier());
    }

    public void saveToCache() {
        FiguraMod.doTask(() -> {
            String id = "cache-" + new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss").format(new Date());
            Path rootFolder = FiguraMod.getModContentDirectory().resolve("model_files/[\u00a79Figura\u00a7r] Cached Avatars");
            Path dest = rootFolder.resolve(Path.of(id + ".moon", new String[0]));
            try {
                if (!Files.exists(rootFolder, new LinkOption[0])) {
                    Files.createDirectories(rootFolder, new FileAttribute[0]);
                }
                class_2487 targetTag = new class_2487();
                this.writeNbt(targetTag);
                class_2507.method_10634((class_2487)targetTag, (OutputStream)new FileOutputStream(dest.toFile()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public boolean hasAvatar() {
        return this.model != null || this.script != null;
    }

    public boolean isAvatarLoaded() {
        return !(this.model != null && !this.model.isDone || this.script != null && !this.script.isDone || this.texture != null && !this.texture.isDone);
    }

    private class_2520 writeCustomSoundsNBT() {
        class_2487 nbt = new class_2487();
        for (String key : this.script.customSounds.keySet()) {
            this.script.customSounds.get(key).writeNbt(nbt);
        }
        return nbt;
    }

    private void readCustomSoundsNBT(class_2487 nbt) {
        nbt.method_10541().forEach(key -> FiguraSoundManager.registerCustomSound(this.script, key, nbt.method_10547(key), false));
    }

    public void clearData() {
        this.extraTextures.clear();
        if (this.script != null) {
            this.script.clearSounds();
        } else {
            FiguraSoundManager.getChannel().stopSound(this.entityId);
        }
    }
}

